/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.eclipselink.core.tests.internal.context.orm;

import org.eclipse.jpt.core.context.orm.OrmJoinColumn;
import org.eclipse.jpt.core.context.orm.OrmJoinTable;
import org.eclipse.jpt.core.context.orm.OrmOneToManyMapping;
import org.eclipse.jpt.core.context.orm.OrmPersistentAttribute;
import org.eclipse.jpt.core.context.orm.OrmPersistentType;
import org.eclipse.jpt.core.tests.internal.projects.TestJavaProject;
import org.eclipse.jpt.eclipselink.core.context.EclipseLinkOneToManyMapping;
import org.eclipse.jpt.eclipselink.core.context.EclipseLinkRelationshipMapping;
import org.eclipse.jpt.eclipselink.core.context.JoinFetchType;
import org.eclipse.jpt.eclipselink.core.internal.context.orm.EclipseLinkOrmOneToManyMapping;
import org.eclipse.jpt.eclipselink.core.resource.orm.XmlEntity;
import org.eclipse.jpt.eclipselink.core.resource.orm.XmlJoinFetchType;
import org.eclipse.jpt.eclipselink.core.resource.orm.XmlOneToMany;
import org.eclipse.jpt.eclipselink.core.tests.internal.context.orm.EclipseLinkOrmContextModelTestCase;

public class EclipseLinkOrmOneToManyMappingTests
extends EclipseLinkOrmContextModelTestCase {
    public EclipseLinkOrmOneToManyMappingTests(String name) {
        super(name);
    }

    private void createTestDepartment() throws Exception {
        TestJavaProject.SourceWriter sourceWriter = new TestJavaProject.SourceWriter(){

            public void appendSourceTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("import ").append("javax.persistence.Entity").append(";");
                sb.append(CR);
                sb.append("import ").append("javax.persistence.Id").append(";");
                sb.append(CR);
                sb.append("import java.util.Collection;");
                sb.append(CR);
                sb.append("import ").append("javax.persistence.JoinTable").append(";");
                sb.append(CR);
                sb.append("import ").append("javax.persistence.JoinColumn").append(";");
                sb.append("@Entity");
                sb.append(CR);
                sb.append("public class ").append("Department").append(" ");
                sb.append("{").append(CR);
                sb.append(CR);
                sb.append("    @Id").append(CR);
                sb.append("    private int id;").append(CR);
                sb.append(CR);
                sb.append("    @JoinTable(name=\"DEP_EMP\", joinColumns=@JoinColumn(name=\"DEPT_ID\"), inverseJoinColumns=@JoinColumn(name=\"EMP_ID\"))").append(CR);
                sb.append("    private Collection<Employee> employees;").append(CR);
                sb.append(CR);
                sb.append("}").append(CR);
            }
        };
        this.javaProject.createCompilationUnit("test", "Department.java", sourceWriter);
    }

    private void createTestEmployee() throws Exception {
        TestJavaProject.SourceWriter sourceWriter = new TestJavaProject.SourceWriter(){

            public void appendSourceTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("import ").append("javax.persistence.Entity").append(";");
                sb.append(CR);
                sb.append("import ").append("javax.persistence.Id").append(";");
                sb.append(CR);
                sb.append("@Entity");
                sb.append(CR);
                sb.append("public class ").append("Employee").append(" ");
                sb.append("{").append(CR);
                sb.append(CR);
                sb.append("    @Id").append(CR);
                sb.append("    private int empId;").append(CR);
                sb.append(CR);
                sb.append("}").append(CR);
            }
        };
        this.javaProject.createCompilationUnit("test", "Employee.java", sourceWriter);
    }

    public void testUpdatePrivateOwned() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedPersistentAttribute("oneToMany", "oneToMany");
        EclipseLinkOneToManyMapping contextOneToMany = (EclipseLinkOneToManyMapping)ormPersistentAttribute.getMapping();
        XmlEntity resourceEntity = (XmlEntity)this.getXmlEntityMappings().getEntities().get(0);
        XmlOneToMany resourceOneToMany = (XmlOneToMany)resourceEntity.getAttributes().getOneToManys().get(0);
        EclipseLinkOrmOneToManyMappingTests.assertFalse((boolean)resourceOneToMany.isPrivateOwned());
        EclipseLinkOrmOneToManyMappingTests.assertFalse((boolean)contextOneToMany.getPrivateOwned().isPrivateOwned());
        resourceOneToMany.setPrivateOwned(true);
        EclipseLinkOrmOneToManyMappingTests.assertTrue((boolean)resourceOneToMany.isPrivateOwned());
        EclipseLinkOrmOneToManyMappingTests.assertTrue((boolean)contextOneToMany.getPrivateOwned().isPrivateOwned());
        resourceOneToMany.setPrivateOwned(false);
        EclipseLinkOrmOneToManyMappingTests.assertFalse((boolean)resourceOneToMany.isPrivateOwned());
        EclipseLinkOrmOneToManyMappingTests.assertFalse((boolean)contextOneToMany.getPrivateOwned().isPrivateOwned());
    }

    public void testModifyPrivateOwned() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedPersistentAttribute("oneToMany", "oneToMany");
        EclipseLinkOneToManyMapping contextOneToMany = (EclipseLinkOneToManyMapping)ormPersistentAttribute.getMapping();
        XmlEntity resourceEntity = (XmlEntity)this.getXmlEntityMappings().getEntities().get(0);
        XmlOneToMany resourceOneToMany = (XmlOneToMany)resourceEntity.getAttributes().getOneToManys().get(0);
        EclipseLinkOrmOneToManyMappingTests.assertFalse((boolean)resourceOneToMany.isPrivateOwned());
        EclipseLinkOrmOneToManyMappingTests.assertFalse((boolean)contextOneToMany.getPrivateOwned().isPrivateOwned());
        contextOneToMany.getPrivateOwned().setPrivateOwned(true);
        EclipseLinkOrmOneToManyMappingTests.assertTrue((boolean)resourceOneToMany.isPrivateOwned());
        EclipseLinkOrmOneToManyMappingTests.assertTrue((boolean)contextOneToMany.getPrivateOwned().isPrivateOwned());
        contextOneToMany.getPrivateOwned().setPrivateOwned(false);
        EclipseLinkOrmOneToManyMappingTests.assertFalse((boolean)resourceOneToMany.isPrivateOwned());
        EclipseLinkOrmOneToManyMappingTests.assertFalse((boolean)contextOneToMany.getPrivateOwned().isPrivateOwned());
    }

    public void testUpdateJoinFetch() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedPersistentAttribute("oneToMany", "oneToMany");
        EclipseLinkOneToManyMapping contextOneToMany = (EclipseLinkOneToManyMapping)ormPersistentAttribute.getMapping();
        XmlEntity resourceEntity = (XmlEntity)this.getXmlEntityMappings().getEntities().get(0);
        XmlOneToMany resourceOneToMany = (XmlOneToMany)resourceEntity.getAttributes().getOneToManys().get(0);
        EclipseLinkOrmOneToManyMappingTests.assertNull((Object)resourceOneToMany.getJoinFetch());
        EclipseLinkOrmOneToManyMappingTests.assertNull((Object)contextOneToMany.getJoinFetch().getValue());
        resourceOneToMany.setJoinFetch(XmlJoinFetchType.INNER);
        EclipseLinkOrmOneToManyMappingTests.assertEquals((Object)XmlJoinFetchType.INNER, (Object)resourceOneToMany.getJoinFetch());
        EclipseLinkOrmOneToManyMappingTests.assertEquals((Object)JoinFetchType.INNER, (Object)contextOneToMany.getJoinFetch().getValue());
        resourceOneToMany.setJoinFetch(XmlJoinFetchType.OUTER);
        EclipseLinkOrmOneToManyMappingTests.assertEquals((Object)XmlJoinFetchType.OUTER, (Object)resourceOneToMany.getJoinFetch());
        EclipseLinkOrmOneToManyMappingTests.assertEquals((Object)JoinFetchType.OUTER, (Object)contextOneToMany.getJoinFetch().getValue());
        resourceOneToMany.setJoinFetch(null);
        EclipseLinkOrmOneToManyMappingTests.assertNull((Object)resourceOneToMany.getJoinFetch());
        EclipseLinkOrmOneToManyMappingTests.assertNull((Object)contextOneToMany.getJoinFetch().getValue());
    }

    public void testModifyJoinFetch() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedPersistentAttribute("oneToMany", "oneToMany");
        EclipseLinkOneToManyMapping contextOneToMany = (EclipseLinkOneToManyMapping)ormPersistentAttribute.getMapping();
        XmlEntity resourceEntity = (XmlEntity)this.getXmlEntityMappings().getEntities().get(0);
        XmlOneToMany resourceOneToMany = (XmlOneToMany)resourceEntity.getAttributes().getOneToManys().get(0);
        EclipseLinkOrmOneToManyMappingTests.assertNull((Object)resourceOneToMany.getJoinFetch());
        EclipseLinkOrmOneToManyMappingTests.assertNull((Object)contextOneToMany.getJoinFetch().getValue());
        contextOneToMany.getJoinFetch().setValue(JoinFetchType.INNER);
        EclipseLinkOrmOneToManyMappingTests.assertEquals((Object)XmlJoinFetchType.INNER, (Object)resourceOneToMany.getJoinFetch());
        EclipseLinkOrmOneToManyMappingTests.assertEquals((Object)JoinFetchType.INNER, (Object)contextOneToMany.getJoinFetch().getValue());
        contextOneToMany.getJoinFetch().setValue(JoinFetchType.OUTER);
        EclipseLinkOrmOneToManyMappingTests.assertEquals((Object)XmlJoinFetchType.OUTER, (Object)resourceOneToMany.getJoinFetch());
        EclipseLinkOrmOneToManyMappingTests.assertEquals((Object)JoinFetchType.OUTER, (Object)contextOneToMany.getJoinFetch().getValue());
        contextOneToMany.getJoinFetch().setValue(null);
        EclipseLinkOrmOneToManyMappingTests.assertNull((Object)resourceOneToMany.getJoinFetch());
        EclipseLinkOrmOneToManyMappingTests.assertNull((Object)contextOneToMany.getJoinFetch().getValue());
    }

    public void testJoinFetchDefault() throws Exception {
        this.createTestEmployee();
        this.createTestDepartment();
        this.getEntityMappings().addPersistentType("entity", "test.Department");
        this.getEntityMappings().addPersistentType("entity", "test.Employee");
        OrmPersistentType departmentPersistentType = (OrmPersistentType)this.getEntityMappings().persistentTypes().next();
        EclipseLinkOrmOneToManyMapping oneToMany = (EclipseLinkOrmOneToManyMapping)departmentPersistentType.getAttributeNamed("employees").getMapping();
        EclipseLinkOrmOneToManyMappingTests.assertNull((Object)oneToMany.getJoinFetch().getValue());
        this.getEntityMappings().getPersistenceUnitMetadata().setXmlMappingMetadataComplete(true);
        oneToMany = (EclipseLinkOrmOneToManyMapping)departmentPersistentType.getAttributeNamed("employees").getMapping();
        EclipseLinkOrmOneToManyMappingTests.assertNull((Object)oneToMany.getJoinFetch().getValue());
        EclipseLinkRelationshipMapping javaRelationshipMapping = (EclipseLinkRelationshipMapping)departmentPersistentType.getJavaPersistentType().getAttributeNamed("employees").getMapping();
        javaRelationshipMapping.getJoinFetch().setValue(JoinFetchType.OUTER);
        EclipseLinkOrmOneToManyMappingTests.assertNull((Object)oneToMany.getJoinFetch().getValue());
        this.getEntityMappings().getPersistenceUnitMetadata().setXmlMappingMetadataComplete(false);
        oneToMany = (EclipseLinkOrmOneToManyMapping)departmentPersistentType.getAttributeNamed("employees").getMapping();
        EclipseLinkOrmOneToManyMappingTests.assertEquals((Object)JoinFetchType.OUTER, (Object)oneToMany.getJoinFetch().getValue());
    }

    public void testDefaultJoinTable() throws Exception {
        this.createTestEmployee();
        this.createTestDepartment();
        this.getEntityMappings().addPersistentType("entity", "test.Department");
        this.getEntityMappings().addPersistentType("entity", "test.Employee");
        OrmPersistentType departmentPersistentType = (OrmPersistentType)this.getEntityMappings().persistentTypes().next();
        OrmOneToManyMapping oneToMany = (OrmOneToManyMapping)departmentPersistentType.getAttributeNamed("employees").getMapping();
        EclipseLinkOrmOneToManyMappingTests.assertEquals((boolean)true, (boolean)oneToMany.getPersistentAttribute().isVirtual());
        OrmJoinTable ormJoinTable = oneToMany.getRelationshipReference().getJoinTableJoiningStrategy().getJoinTable();
        EclipseLinkOrmOneToManyMappingTests.assertEquals((String)"DEP_EMP", (String)ormJoinTable.getName());
        EclipseLinkOrmOneToManyMappingTests.assertEquals((String)"DEPT_ID", (String)((OrmJoinColumn)ormJoinTable.specifiedJoinColumns().next()).getName());
        EclipseLinkOrmOneToManyMappingTests.assertEquals((String)"id", (String)((OrmJoinColumn)ormJoinTable.specifiedJoinColumns().next()).getReferencedColumnName());
        EclipseLinkOrmOneToManyMappingTests.assertEquals((String)"EMP_ID", (String)((OrmJoinColumn)ormJoinTable.specifiedInverseJoinColumns().next()).getName());
        EclipseLinkOrmOneToManyMappingTests.assertEquals((String)"empId", (String)((OrmJoinColumn)ormJoinTable.specifiedInverseJoinColumns().next()).getReferencedColumnName());
        departmentPersistentType.getMapping().setSpecifiedMetadataComplete(Boolean.TRUE);
        departmentPersistentType.addSpecifiedPersistentAttribute("id", "id");
        oneToMany = (OrmOneToManyMapping)departmentPersistentType.getAttributeNamed("employees").getMapping();
        EclipseLinkOrmOneToManyMappingTests.assertEquals((boolean)true, (boolean)oneToMany.getPersistentAttribute().isVirtual());
        ormJoinTable = oneToMany.getRelationshipReference().getJoinTableJoiningStrategy().getJoinTable();
        EclipseLinkOrmOneToManyMappingTests.assertEquals((String)"Department_Employee", (String)ormJoinTable.getName());
        EclipseLinkOrmOneToManyMappingTests.assertEquals((String)"Department_id", (String)((OrmJoinColumn)ormJoinTable.specifiedJoinColumns().next()).getName());
        EclipseLinkOrmOneToManyMappingTests.assertEquals((String)"id", (String)((OrmJoinColumn)ormJoinTable.specifiedJoinColumns().next()).getReferencedColumnName());
        EclipseLinkOrmOneToManyMappingTests.assertEquals((String)"employees_empId", (String)((OrmJoinColumn)ormJoinTable.specifiedInverseJoinColumns().next()).getName());
        EclipseLinkOrmOneToManyMappingTests.assertEquals((String)"empId", (String)((OrmJoinColumn)ormJoinTable.specifiedInverseJoinColumns().next()).getReferencedColumnName());
        departmentPersistentType.getMapping().setSpecifiedMetadataComplete(Boolean.FALSE);
        oneToMany = (OrmOneToManyMapping)departmentPersistentType.getAttributeNamed("employees").getMapping();
        EclipseLinkOrmOneToManyMappingTests.assertEquals((boolean)true, (boolean)oneToMany.getPersistentAttribute().isVirtual());
        ormJoinTable = oneToMany.getRelationshipReference().getJoinTableJoiningStrategy().getJoinTable();
        EclipseLinkOrmOneToManyMappingTests.assertEquals((String)"DEP_EMP", (String)ormJoinTable.getName());
        EclipseLinkOrmOneToManyMappingTests.assertEquals((String)"DEPT_ID", (String)((OrmJoinColumn)ormJoinTable.specifiedJoinColumns().next()).getName());
        EclipseLinkOrmOneToManyMappingTests.assertEquals((String)"id", (String)((OrmJoinColumn)ormJoinTable.specifiedJoinColumns().next()).getReferencedColumnName());
        EclipseLinkOrmOneToManyMappingTests.assertEquals((String)"EMP_ID", (String)((OrmJoinColumn)ormJoinTable.specifiedInverseJoinColumns().next()).getName());
        EclipseLinkOrmOneToManyMappingTests.assertEquals((String)"empId", (String)((OrmJoinColumn)ormJoinTable.specifiedInverseJoinColumns().next()).getReferencedColumnName());
        departmentPersistentType.addSpecifiedPersistentAttribute("oneToMany", "employees");
        oneToMany = (OrmOneToManyMapping)departmentPersistentType.getAttributeNamed("employees").getMapping();
        EclipseLinkOrmOneToManyMappingTests.assertEquals((boolean)false, (boolean)oneToMany.getPersistentAttribute().isVirtual());
        ormJoinTable = oneToMany.getRelationshipReference().getJoinTableJoiningStrategy().getJoinTable();
        EclipseLinkOrmOneToManyMappingTests.assertEquals((String)"Department_Employee", (String)ormJoinTable.getName());
        EclipseLinkOrmOneToManyMappingTests.assertEquals((int)0, (int)ormJoinTable.specifiedJoinColumnsSize());
        EclipseLinkOrmOneToManyMappingTests.assertEquals((String)"Department_id", (String)ormJoinTable.getDefaultJoinColumn().getName());
        EclipseLinkOrmOneToManyMappingTests.assertEquals((String)"id", (String)ormJoinTable.getDefaultJoinColumn().getReferencedColumnName());
        EclipseLinkOrmOneToManyMappingTests.assertEquals((int)0, (int)ormJoinTable.specifiedInverseJoinColumnsSize());
        EclipseLinkOrmOneToManyMappingTests.assertEquals((String)"employees_empId", (String)ormJoinTable.getDefaultInverseJoinColumn().getName());
        EclipseLinkOrmOneToManyMappingTests.assertEquals((String)"empId", (String)ormJoinTable.getDefaultInverseJoinColumn().getReferencedColumnName());
    }
}

