/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.resource.java;

import org.eclipse.jpt.utility.internal.CollectionTools;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum CascadeType {
    ALL("javax.persistence.CascadeType.ALL"),
    PERSIST("javax.persistence.CascadeType.PERSIST"),
    MERGE("javax.persistence.CascadeType.MERGE"),
    REMOVE("javax.persistence.CascadeType.REMOVE"),
    REFRESH("javax.persistence.CascadeType.REFRESH");

    private String javaAnnotationValue;
    private static final CascadeType[] EMPTY_CASCADE_TYPE_ARRAY;
    private static final String[] EMPTY_STRING_ARRAY;

    static {
        EMPTY_CASCADE_TYPE_ARRAY = new CascadeType[0];
        EMPTY_STRING_ARRAY = new String[0];
    }

    private CascadeType(String javaAnnotationValue) {
        if (javaAnnotationValue == null) {
            throw new NullPointerException();
        }
        this.javaAnnotationValue = javaAnnotationValue;
    }

    public String getJavaAnnotationValue() {
        return this.javaAnnotationValue;
    }

    public static CascadeType[] fromJavaAnnotationValues(Object[] javaAnnotationValues) {
        if (javaAnnotationValues == null) {
            return EMPTY_CASCADE_TYPE_ARRAY;
        }
        if (javaAnnotationValues.length == 0) {
            return EMPTY_CASCADE_TYPE_ARRAY;
        }
        javaAnnotationValues = CollectionTools.removeAllOccurrences((Object[])javaAnnotationValues, null);
        int len = javaAnnotationValues.length;
        CascadeType[] cascadeTypes = new CascadeType[len];
        int i = 0;
        while (i < len) {
            cascadeTypes[i] = CascadeType.fromJavaAnnotationValue(javaAnnotationValues[i]);
            ++i;
        }
        return cascadeTypes;
    }

    public static CascadeType fromJavaAnnotationValue(Object javaAnnotationValue) {
        return javaAnnotationValue == null ? null : CascadeType.fromJavaAnnotationValue_(javaAnnotationValue);
    }

    private static CascadeType fromJavaAnnotationValue_(Object javaAnnotationValue) {
        CascadeType[] cascadeTypeArray = CascadeType.values();
        int n = cascadeTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            CascadeType cascadeType = cascadeTypeArray[n2];
            if (cascadeType.getJavaAnnotationValue().equals(javaAnnotationValue)) {
                return cascadeType;
            }
            ++n2;
        }
        return null;
    }

    public static String[] toJavaAnnotationValues(CascadeType[] cascadeTypes) {
        if (cascadeTypes == null) {
            return EMPTY_STRING_ARRAY;
        }
        int len = cascadeTypes.length;
        if (len == 0) {
            return EMPTY_STRING_ARRAY;
        }
        String[] javaAnnotationValues = new String[len];
        int i = 0;
        while (i < len) {
            javaAnnotationValues[i] = CascadeType.toJavaAnnotationValue(cascadeTypes[i]);
            ++i;
        }
        return javaAnnotationValues;
    }

    public static String toJavaAnnotationValue(CascadeType cascadeType) {
        return cascadeType == null ? null : cascadeType.getJavaAnnotationValue();
    }
}

