/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.platform;

import java.util.ListIterator;
import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jpt.core.JpaAnnotationDefinitionProvider;
import org.eclipse.jpt.core.JpaAnnotationProvider;
import org.eclipse.jpt.core.resource.java.Annotation;
import org.eclipse.jpt.core.resource.java.AnnotationDefinition;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentAttribute;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentMember;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentType;
import org.eclipse.jpt.core.utility.jdt.Attribute;
import org.eclipse.jpt.core.utility.jdt.Type;
import org.eclipse.jpt.utility.internal.iterators.ArrayListIterator;
import org.eclipse.jpt.utility.internal.iterators.CompositeListIterator;
import org.eclipse.jpt.utility.internal.iterators.TransformationListIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericJpaAnnotationProvider
implements JpaAnnotationProvider {
    private final JpaAnnotationDefinitionProvider[] annotationDefinitionProviders;

    public GenericJpaAnnotationProvider(JpaAnnotationDefinitionProvider ... annotationDefinitionProviders) {
        this.annotationDefinitionProviders = annotationDefinitionProviders;
    }

    protected ListIterator<JpaAnnotationDefinitionProvider> annotationDefinitionProviders() {
        return new ArrayListIterator((Object[])this.annotationDefinitionProviders);
    }

    @Override
    public ListIterator<String> typeMappingAnnotationNames() {
        return new CompositeListIterator(new ListIterator[]{GenericJpaAnnotationProvider.annotationNames(this.typeMappingAnnotationDefinitions())});
    }

    protected ListIterator<AnnotationDefinition> typeMappingAnnotationDefinitions() {
        return new CompositeListIterator((ListIterator)new TransformationListIterator<JpaAnnotationDefinitionProvider, ListIterator<AnnotationDefinition>>(this.annotationDefinitionProviders()){

            protected ListIterator<AnnotationDefinition> transform(JpaAnnotationDefinitionProvider annotationDefinitionProvider) {
                return annotationDefinitionProvider.typeMappingAnnotationDefinitions();
            }
        });
    }

    @Override
    public Annotation buildTypeMappingAnnotation(JavaResourcePersistentType parent, Type type, String annotationName) {
        return this.getTypeMappingAnnotationDefinition(annotationName).buildAnnotation((JavaResourcePersistentMember)parent, type);
    }

    @Override
    public Annotation buildTypeMappingAnnotation(JavaResourcePersistentType parent, IAnnotation jdtAnnotation) {
        return this.getTypeMappingAnnotationDefinition(jdtAnnotation.getElementName()).buildAnnotation((JavaResourcePersistentMember)parent, jdtAnnotation);
    }

    protected AnnotationDefinition getTypeMappingAnnotationDefinition(String annotationName) {
        AnnotationDefinition annotationDefinition = GenericJpaAnnotationProvider.getAnnotationDefinition(annotationName, this.typeMappingAnnotationDefinitions());
        if (annotationDefinition == null) {
            throw new IllegalArgumentException("unsupported type mapping annotation: " + annotationName);
        }
        return annotationDefinition;
    }

    @Override
    public ListIterator<String> typeSupportingAnnotationNames() {
        return new CompositeListIterator(new ListIterator[]{GenericJpaAnnotationProvider.annotationNames(this.typeSupportingAnnotationDefinitions())});
    }

    protected ListIterator<AnnotationDefinition> typeSupportingAnnotationDefinitions() {
        return new CompositeListIterator((ListIterator)new TransformationListIterator<JpaAnnotationDefinitionProvider, ListIterator<AnnotationDefinition>>(this.annotationDefinitionProviders()){

            protected ListIterator<AnnotationDefinition> transform(JpaAnnotationDefinitionProvider annotationDefinitionProvider) {
                return annotationDefinitionProvider.typeSupportingAnnotationDefinitions();
            }
        });
    }

    @Override
    public Annotation buildTypeSupportingAnnotation(JavaResourcePersistentType parent, Type type, String annotationName) {
        return this.getTypeSupportingAnnotationDefinition(annotationName).buildAnnotation((JavaResourcePersistentMember)parent, type);
    }

    @Override
    public Annotation buildTypeSupportingAnnotation(JavaResourcePersistentType parent, IAnnotation jdtAnnotation) {
        return this.getTypeSupportingAnnotationDefinition(jdtAnnotation.getElementName()).buildAnnotation((JavaResourcePersistentMember)parent, jdtAnnotation);
    }

    @Override
    public Annotation buildNullTypeSupportingAnnotation(JavaResourcePersistentType parent, String annotationName) {
        return this.getTypeSupportingAnnotationDefinition(annotationName).buildNullAnnotation(parent);
    }

    protected AnnotationDefinition getTypeSupportingAnnotationDefinition(String annotationName) {
        AnnotationDefinition annotationDefinition = GenericJpaAnnotationProvider.getAnnotationDefinition(annotationName, this.typeSupportingAnnotationDefinitions());
        if (annotationDefinition == null) {
            throw new IllegalArgumentException("unsupported type supporting annotation: " + annotationName);
        }
        return annotationDefinition;
    }

    @Override
    public ListIterator<String> attributeMappingAnnotationNames() {
        return new CompositeListIterator(new ListIterator[]{GenericJpaAnnotationProvider.annotationNames(this.attributeMappingAnnotationDefinitions())});
    }

    protected ListIterator<AnnotationDefinition> attributeMappingAnnotationDefinitions() {
        return new CompositeListIterator((ListIterator)new TransformationListIterator<JpaAnnotationDefinitionProvider, ListIterator<AnnotationDefinition>>(this.annotationDefinitionProviders()){

            protected ListIterator<AnnotationDefinition> transform(JpaAnnotationDefinitionProvider annotationDefinitionProvider) {
                return annotationDefinitionProvider.attributeMappingAnnotationDefinitions();
            }
        });
    }

    @Override
    public Annotation buildAttributeMappingAnnotation(JavaResourcePersistentAttribute parent, Attribute attribute, String annotationName) {
        return this.getAttributeMappingAnnotationDefinition(annotationName).buildAnnotation((JavaResourcePersistentMember)parent, attribute);
    }

    @Override
    public Annotation buildAttributeMappingAnnotation(JavaResourcePersistentAttribute parent, IAnnotation jdtAnnotation) {
        return this.getAttributeMappingAnnotationDefinition(jdtAnnotation.getElementName()).buildAnnotation((JavaResourcePersistentMember)parent, jdtAnnotation);
    }

    @Override
    public Annotation buildNullAttributeMappingAnnotation(JavaResourcePersistentAttribute parent, String annotationName) {
        return this.getAttributeMappingAnnotationDefinition(annotationName).buildNullAnnotation(parent);
    }

    protected AnnotationDefinition getAttributeMappingAnnotationDefinition(String annotationName) {
        AnnotationDefinition annotationDefinition = GenericJpaAnnotationProvider.getAnnotationDefinition(annotationName, this.attributeMappingAnnotationDefinitions());
        if (annotationDefinition == null) {
            throw new IllegalArgumentException("unsupported attribute mapping annotation: " + annotationName);
        }
        return annotationDefinition;
    }

    @Override
    public ListIterator<String> attributeSupportingAnnotationNames() {
        return new CompositeListIterator(new ListIterator[]{GenericJpaAnnotationProvider.annotationNames(this.attributeSupportingAnnotationDefinitions())});
    }

    protected ListIterator<AnnotationDefinition> attributeSupportingAnnotationDefinitions() {
        return new CompositeListIterator((ListIterator)new TransformationListIterator<JpaAnnotationDefinitionProvider, ListIterator<AnnotationDefinition>>(this.annotationDefinitionProviders()){

            protected ListIterator<AnnotationDefinition> transform(JpaAnnotationDefinitionProvider annotationDefinitionProvider) {
                return annotationDefinitionProvider.attributeSupportingAnnotationDefinitions();
            }
        });
    }

    @Override
    public Annotation buildAttributeSupportingAnnotation(JavaResourcePersistentAttribute parent, Attribute attribute, String annotationName) {
        return this.getAttributeSupportingAnnotationDefinition(annotationName).buildAnnotation((JavaResourcePersistentMember)parent, attribute);
    }

    @Override
    public Annotation buildAttributeSupportingAnnotation(JavaResourcePersistentAttribute parent, IAnnotation jdtAnnotation) {
        return this.getAttributeSupportingAnnotationDefinition(jdtAnnotation.getElementName()).buildAnnotation((JavaResourcePersistentMember)parent, jdtAnnotation);
    }

    @Override
    public Annotation buildNullAttributeSupportingAnnotation(JavaResourcePersistentAttribute parent, String annotationName) {
        return this.getAttributeSupportingAnnotationDefinition(annotationName).buildNullAnnotation(parent);
    }

    protected AnnotationDefinition getAttributeSupportingAnnotationDefinition(String annotationName) {
        AnnotationDefinition annotationDefinition = GenericJpaAnnotationProvider.getAnnotationDefinition(annotationName, this.attributeSupportingAnnotationDefinitions());
        if (annotationDefinition == null) {
            throw new IllegalArgumentException("unsupported attribute supporting annotation: " + annotationName);
        }
        return annotationDefinition;
    }

    protected static ListIterator<String> annotationNames(ListIterator<AnnotationDefinition> annotationDefinitions) {
        return new TransformationListIterator<AnnotationDefinition, String>(annotationDefinitions){

            protected String transform(AnnotationDefinition annotationDefinition) {
                return annotationDefinition.getAnnotationName();
            }
        };
    }

    protected static AnnotationDefinition getAnnotationDefinition(String annotationName, ListIterator<AnnotationDefinition> annotationDefinitions) {
        while (annotationDefinitions.hasNext()) {
            AnnotationDefinition annotationDefinition = annotationDefinitions.next();
            if (!annotationDefinition.getAnnotationName().equals(annotationName)) continue;
            return annotationDefinition;
        }
        return null;
    }
}

