/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.context.orm;

import java.util.List;
import org.eclipse.jpt.core.context.PersistentAttribute;
import org.eclipse.jpt.core.context.orm.OrmAttributeMapping;
import org.eclipse.jpt.core.context.orm.OrmColumn;
import org.eclipse.jpt.core.context.orm.OrmColumnMapping;
import org.eclipse.jpt.core.context.orm.OrmConverter;
import org.eclipse.jpt.core.context.orm.OrmPersistentAttribute;
import org.eclipse.jpt.core.context.orm.OrmVersionMapping;
import org.eclipse.jpt.core.internal.context.orm.AbstractOrmAttributeMapping;
import org.eclipse.jpt.core.internal.context.orm.GenericOrmNullConverter;
import org.eclipse.jpt.core.internal.context.orm.GenericOrmTemporalConverter;
import org.eclipse.jpt.core.internal.validation.DefaultJpaValidationMessages;
import org.eclipse.jpt.core.resource.orm.Attributes;
import org.eclipse.jpt.core.resource.orm.OrmFactory;
import org.eclipse.jpt.core.resource.orm.XmlColumn;
import org.eclipse.jpt.core.resource.orm.XmlConvertibleMapping;
import org.eclipse.jpt.core.resource.orm.XmlVersion;
import org.eclipse.jpt.db.Table;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericOrmVersionMapping<T extends XmlVersion>
extends AbstractOrmAttributeMapping<T>
implements OrmVersionMapping {
    protected final OrmColumn column = this.getJpaFactory().buildOrmColumn(this, this);
    protected OrmConverter defaultConverter;
    protected OrmConverter specifiedConverter;

    public GenericOrmVersionMapping(OrmPersistentAttribute parent, T resourceMapping) {
        super(parent, resourceMapping);
        this.column.initialize(this.getResourceColumn());
        this.defaultConverter = new GenericOrmNullConverter(this);
        this.specifiedConverter = this.buildSpecifiedConverter(this.getResourceConverterType());
    }

    @Override
    public int getXmlSequence() {
        return 30;
    }

    @Override
    public String getKey() {
        return "version";
    }

    @Override
    public void initializeOn(OrmAttributeMapping newMapping) {
        newMapping.initializeFromOrmVersionMapping(this);
    }

    @Override
    public void initializeFromOrmColumnMapping(OrmColumnMapping oldMapping) {
        super.initializeFromOrmColumnMapping(oldMapping);
        this.getColumn().initializeFrom(oldMapping.getColumn());
    }

    @Override
    public OrmColumn getColumn() {
        return this.column;
    }

    @Override
    public OrmConverter getConverter() {
        return this.getSpecifiedConverter() == null ? this.getDefaultConverter() : this.getSpecifiedConverter();
    }

    @Override
    public OrmConverter getDefaultConverter() {
        return this.defaultConverter;
    }

    @Override
    public OrmConverter getSpecifiedConverter() {
        return this.specifiedConverter;
    }

    protected String getSpecifedConverterType() {
        if (this.specifiedConverter == null) {
            return "noConverter";
        }
        return this.specifiedConverter.getType();
    }

    @Override
    public void setSpecifiedConverter(String converterType) {
        if (this.getSpecifedConverterType() == converterType) {
            return;
        }
        OrmConverter oldConverter = this.specifiedConverter;
        OrmConverter newConverter = this.buildSpecifiedConverter(converterType);
        this.specifiedConverter = null;
        if (oldConverter != null) {
            oldConverter.removeFromResourceModel();
        }
        this.specifiedConverter = newConverter;
        if (newConverter != null) {
            newConverter.addToResourceModel();
        }
        this.firePropertyChanged("specifiedConverter", oldConverter, newConverter);
    }

    protected void setSpecifiedConverter(OrmConverter newConverter) {
        OrmConverter oldConverter = this.specifiedConverter;
        this.specifiedConverter = newConverter;
        this.firePropertyChanged("specifiedConverter", oldConverter, newConverter);
    }

    @Override
    public void addToResourceModel(Attributes resourceAttributes) {
        resourceAttributes.getVersions().add((Object)((XmlVersion)this.resourceAttributeMapping));
    }

    @Override
    public void removeFromResourceModel(Attributes resourceAttributes) {
        resourceAttributes.getVersions().remove((Object)this.resourceAttributeMapping);
    }

    @Override
    public String getDefaultColumnName() {
        return this.getName();
    }

    @Override
    public String getDefaultTableName() {
        return this.getTypeMapping().getPrimaryTableName();
    }

    @Override
    public Table getDbTable(String tableName) {
        return this.getTypeMapping().getDbTable(tableName);
    }

    @Override
    public void update() {
        super.update();
        this.column.update(this.getResourceColumn());
        if (this.getResourceConverterType() == this.getSpecifedConverterType()) {
            this.getSpecifiedConverter().update();
        } else {
            this.setSpecifiedConverter(this.buildSpecifiedConverter(this.getResourceConverterType()));
        }
    }

    protected OrmConverter buildSpecifiedConverter(String converterType) {
        if (converterType == "temporalConverter") {
            return new GenericOrmTemporalConverter(this, (XmlConvertibleMapping)((Object)this.resourceAttributeMapping));
        }
        return null;
    }

    protected String getResourceConverterType() {
        if (((XmlVersion)this.resourceAttributeMapping).getTemporal() != null) {
            return "temporalConverter";
        }
        return null;
    }

    @Override
    public XmlColumn getResourceColumn() {
        return ((XmlVersion)this.resourceAttributeMapping).getColumn();
    }

    @Override
    public void addResourceColumn() {
        ((XmlVersion)this.resourceAttributeMapping).setColumn(OrmFactory.eINSTANCE.createXmlColumnImpl());
    }

    @Override
    public void removeResourceColumn() {
        ((XmlVersion)this.resourceAttributeMapping).setColumn(null);
    }

    @Override
    public void validate(List<IMessage> messages, IReporter reporter) {
        super.validate(messages, reporter);
        if (this.shouldValidateAgainstDatabase()) {
            this.validateColumn(messages);
        }
    }

    protected void validateColumn(List<IMessage> messages) {
        PersistentAttribute pa = this.getPersistentAttribute();
        String tableName = this.column.getTable();
        if (this.getTypeMapping().tableNameIsInvalid(tableName)) {
            if (pa.isVirtual()) {
                messages.add(DefaultJpaValidationMessages.buildMessage(1, "VIRTUAL_ATTRIBUTE_COLUMN_UNRESOLVED_TABLE", new String[]{pa.getName(), tableName, this.column.getName()}, this.column, this.column.getTableTextRange()));
            } else {
                messages.add(DefaultJpaValidationMessages.buildMessage(1, "COLUMN_UNRESOLVED_TABLE", new String[]{tableName, this.column.getName()}, this.column, this.column.getTableTextRange()));
            }
            return;
        }
        if (!this.column.isResolved() && this.column.getDbTable() != null) {
            if (pa.isVirtual()) {
                messages.add(DefaultJpaValidationMessages.buildMessage(1, "VIRTUAL_ATTRIBUTE_COLUMN_UNRESOLVED_NAME", new String[]{pa.getName(), this.column.getName()}, this.column, this.column.getNameTextRange()));
            } else {
                messages.add(DefaultJpaValidationMessages.buildMessage(1, "COLUMN_UNRESOLVED_NAME", new String[]{this.column.getName()}, this.column, this.column.getNameTextRange()));
            }
        }
    }
}

