/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.context.orm;

import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jpt.core.JpaStructureNode;
import org.eclipse.jpt.core.JptCorePlugin;
import org.eclipse.jpt.core.context.MappingFileRoot;
import org.eclipse.jpt.core.context.orm.EntityMappings;
import org.eclipse.jpt.core.context.orm.OrmPersistentType;
import org.eclipse.jpt.core.context.orm.OrmXml;
import org.eclipse.jpt.core.context.persistence.MappingFileRef;
import org.eclipse.jpt.core.internal.context.AbstractXmlContextNode;
import org.eclipse.jpt.core.resource.orm.XmlEntityMappings;
import org.eclipse.jpt.core.resource.xml.JpaXmlResource;
import org.eclipse.jpt.core.utility.TextRange;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractOrmXml
extends AbstractXmlContextNode
implements OrmXml {
    protected JpaXmlResource xmlResource;
    protected EntityMappings entityMappings;

    public AbstractOrmXml(MappingFileRef parent, JpaXmlResource resource) {
        super(parent);
        if (!resource.getContentType().isKindOf(JptCorePlugin.MAPPING_FILE_CONTENT_TYPE)) {
            throw new IllegalArgumentException(resource + " does not have mapping file content type");
        }
        this.xmlResource = resource;
        XmlEntityMappings xmlEntityMappings = (XmlEntityMappings)this.xmlResource.getRootObject();
        if (xmlEntityMappings != null) {
            this.entityMappings = this.buildEntityMappings(xmlEntityMappings);
        }
    }

    @Override
    public MappingFileRef getParent() {
        return (MappingFileRef)super.getParent();
    }

    @Override
    public IResource getResource() {
        return this.xmlResource.getFile();
    }

    @Override
    public MappingFileRoot getMappingFileRoot() {
        return this.getEntityMappings();
    }

    @Override
    public String getId() {
        return null;
    }

    @Override
    public IContentType getContentType() {
        return this.xmlResource.getContentType();
    }

    @Override
    public JpaXmlResource getXmlResource() {
        return this.xmlResource;
    }

    @Override
    public MappingFileRoot getRoot() {
        return this.getEntityMappings();
    }

    @Override
    public OrmPersistentType getPersistentType(String fullyQualifiedTypeName) {
        return this.entityMappings == null ? null : this.entityMappings.getPersistentType(fullyQualifiedTypeName);
    }

    @Override
    public EntityMappings getEntityMappings() {
        return this.entityMappings;
    }

    protected void setEntityMappings(EntityMappings entityMappings) {
        EntityMappings old = this.entityMappings;
        this.entityMappings = entityMappings;
        this.firePropertyChanged("entityMappings", old, entityMappings);
    }

    @Override
    public EntityMappings addEntityMappings() {
        if (this.entityMappings != null) {
            throw new IllegalStateException();
        }
        XmlEntityMappings xmlEntityMappings = this.buildEntityMappingsResource();
        this.entityMappings = this.buildEntityMappings(xmlEntityMappings);
        this.xmlResource.getContents().add((Object)xmlEntityMappings);
        this.firePropertyChanged("entityMappings", null, this.entityMappings);
        return this.entityMappings;
    }

    protected abstract XmlEntityMappings buildEntityMappingsResource();

    @Override
    public void removeEntityMappings() {
        if (this.entityMappings == null) {
            throw new IllegalStateException();
        }
        this.getJpaFile(this.xmlResource.getFile()).removeRootStructureNode(this.xmlResource);
        this.entityMappings.dispose();
        EntityMappings old = this.entityMappings;
        this.entityMappings = null;
        EObject xmlEntityMappings = this.xmlResource.getRootObject();
        this.xmlResource.getContents().remove((Object)xmlEntityMappings);
        this.firePropertyChanged("entityMappings", old, null);
    }

    @Override
    public void update(JpaXmlResource resource) {
        if (!resource.getContentType().isKindOf(JptCorePlugin.MAPPING_FILE_CONTENT_TYPE)) {
            throw new IllegalArgumentException(resource + " does not have mapping file content type");
        }
        this.xmlResource = resource;
        this.update();
    }

    protected void update() {
        XmlEntityMappings newXmlEntityMappings;
        XmlEntityMappings oldXmlEntityMappings = this.entityMappings == null ? null : this.entityMappings.getXmlEntityMappings();
        if (oldXmlEntityMappings != (newXmlEntityMappings = (XmlEntityMappings)this.xmlResource.getRootObject()) && this.entityMappings != null) {
            this.getJpaFile(this.xmlResource.getFile()).removeRootStructureNode(this.xmlResource);
            this.entityMappings.dispose();
            this.setEntityMappings(null);
        }
        if (newXmlEntityMappings != null) {
            if (this.entityMappings != null) {
                this.getJpaFile(this.xmlResource.getFile()).addRootStructureNode(this.xmlResource, this.entityMappings);
                this.entityMappings.update();
            } else {
                this.setEntityMappings(this.buildEntityMappings(newXmlEntityMappings));
            }
        }
    }

    protected abstract EntityMappings buildEntityMappings(XmlEntityMappings var1);

    @Override
    public void postUpdate() {
        super.postUpdate();
        if (this.entityMappings != null) {
            this.entityMappings.postUpdate();
        }
    }

    @Override
    public JpaStructureNode getStructureNode(int textOffset) {
        if (this.entityMappings.containsOffset(textOffset)) {
            return this.entityMappings.getStructureNode(textOffset);
        }
        return this;
    }

    @Override
    public TextRange getSelectionTextRange() {
        return TextRange.Empty.instance();
    }

    @Override
    public TextRange getValidationTextRange() {
        return TextRange.Empty.instance();
    }

    @Override
    public void validate(List<IMessage> messages, IReporter reporter) {
        super.validate(messages, reporter);
        if (this.entityMappings != null) {
            this.entityMappings.validate(messages, reporter);
        }
    }

    @Override
    public void dispose() {
        if (this.entityMappings != null) {
            this.entityMappings.dispose();
        }
    }
}

