/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.context.java;

import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.core.context.java.JavaColumn;
import org.eclipse.jpt.core.context.java.JavaJpaContextNode;
import org.eclipse.jpt.core.internal.context.java.AbstractJavaBaseColumn;
import org.eclipse.jpt.core.resource.java.ColumnAnnotation;
import org.eclipse.jpt.core.utility.TextRange;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericJavaColumn
extends AbstractJavaBaseColumn<ColumnAnnotation>
implements JavaColumn {
    protected Integer specifiedLength;
    protected Integer specifiedPrecision;
    protected Integer specifiedScale;

    public GenericJavaColumn(JavaJpaContextNode parent, JavaColumn.Owner owner) {
        super(parent, owner);
    }

    @Override
    public void initialize(ColumnAnnotation column) {
        super.initialize(column);
        this.specifiedLength = this.specifiedLength(column);
        this.specifiedPrecision = this.specifiedPrecision(column);
        this.specifiedScale = this.specifiedScale(column);
    }

    @Override
    public JavaColumn.Owner getOwner() {
        return (JavaColumn.Owner)super.getOwner();
    }

    @Override
    protected ColumnAnnotation getResourceColumn() {
        return this.getOwner().getResourceColumn();
    }

    @Override
    public int getLength() {
        return this.getSpecifiedLength() == null ? this.getDefaultLength() : this.getSpecifiedLength().intValue();
    }

    @Override
    public int getDefaultLength() {
        return 255;
    }

    @Override
    public Integer getSpecifiedLength() {
        return this.specifiedLength;
    }

    @Override
    public void setSpecifiedLength(Integer newSpecifiedLength) {
        Integer oldSpecifiedLength = this.specifiedLength;
        this.specifiedLength = newSpecifiedLength;
        this.getResourceColumn().setLength(newSpecifiedLength);
        this.firePropertyChanged("specifiedLength", oldSpecifiedLength, newSpecifiedLength);
    }

    protected void setSpecifiedLength_(Integer newSpecifiedLength) {
        Integer oldSpecifiedLength = this.specifiedLength;
        this.specifiedLength = newSpecifiedLength;
        this.firePropertyChanged("specifiedLength", oldSpecifiedLength, newSpecifiedLength);
    }

    @Override
    public int getPrecision() {
        return this.getSpecifiedPrecision() == null ? this.getDefaultPrecision() : this.getSpecifiedPrecision().intValue();
    }

    @Override
    public int getDefaultPrecision() {
        return 0;
    }

    @Override
    public Integer getSpecifiedPrecision() {
        return this.specifiedPrecision;
    }

    @Override
    public void setSpecifiedPrecision(Integer newSpecifiedPrecision) {
        Integer oldSpecifiedPrecision = this.specifiedPrecision;
        this.specifiedPrecision = newSpecifiedPrecision;
        this.getResourceColumn().setPrecision(newSpecifiedPrecision);
        this.firePropertyChanged("specifiedPrecision", oldSpecifiedPrecision, newSpecifiedPrecision);
    }

    protected void setSpecifiedPrecision_(Integer newSpecifiedPrecision) {
        Integer oldSpecifiedPrecision = this.specifiedPrecision;
        this.specifiedPrecision = newSpecifiedPrecision;
        this.firePropertyChanged("specifiedPrecision", oldSpecifiedPrecision, newSpecifiedPrecision);
    }

    @Override
    public int getScale() {
        return this.getSpecifiedScale() == null ? this.getDefaultScale() : this.getSpecifiedScale().intValue();
    }

    @Override
    public int getDefaultScale() {
        return 0;
    }

    @Override
    public Integer getSpecifiedScale() {
        return this.specifiedScale;
    }

    @Override
    public void setSpecifiedScale(Integer newSpecifiedScale) {
        Integer oldSpecifiedScale = this.specifiedScale;
        this.specifiedScale = newSpecifiedScale;
        this.getResourceColumn().setScale(newSpecifiedScale);
        this.firePropertyChanged("specifiedScale", oldSpecifiedScale, newSpecifiedScale);
    }

    protected void setSpecifiedScale_(Integer newSpecifiedScale) {
        Integer oldSpecifiedScale = this.specifiedScale;
        this.specifiedScale = newSpecifiedScale;
        this.firePropertyChanged("specifiedScale", oldSpecifiedScale, newSpecifiedScale);
    }

    @Override
    public boolean tableIsAllowed() {
        return true;
    }

    @Override
    public TextRange getValidationTextRange(CompilationUnit astRoot) {
        TextRange textRange = this.getResourceColumn().getTextRange(astRoot);
        return textRange != null ? textRange : this.getOwner().getValidationTextRange(astRoot);
    }

    @Override
    public void update(ColumnAnnotation column) {
        super.update(column);
        this.setSpecifiedLength_(this.specifiedLength(column));
        this.setSpecifiedPrecision_(this.specifiedPrecision(column));
        this.setSpecifiedScale_(this.specifiedScale(column));
    }

    protected Integer specifiedLength(ColumnAnnotation column) {
        return column.getLength();
    }

    protected Integer specifiedPrecision(ColumnAnnotation column) {
        return column.getPrecision();
    }

    protected Integer specifiedScale(ColumnAnnotation column) {
        return column.getScale();
    }
}

