/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.context.java;

import java.util.List;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.core.context.RelationshipMapping;
import org.eclipse.jpt.core.context.TypeMapping;
import org.eclipse.jpt.core.context.java.JavaAttributeMapping;
import org.eclipse.jpt.core.context.java.JavaPersistentAttribute;
import org.eclipse.jpt.core.internal.context.java.AbstractJavaJpaContextNode;
import org.eclipse.jpt.core.internal.validation.DefaultJpaValidationMessages;
import org.eclipse.jpt.core.resource.java.Annotation;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentAttribute;
import org.eclipse.jpt.core.utility.TextRange;
import org.eclipse.jpt.db.Table;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractJavaAttributeMapping<T extends Annotation>
extends AbstractJavaJpaContextNode
implements JavaAttributeMapping {
    protected final JavaResourcePersistentAttribute resourcePersistentAttribute;
    protected T mappingAnnotation;

    protected AbstractJavaAttributeMapping(JavaPersistentAttribute parent) {
        super(parent);
        this.resourcePersistentAttribute = parent.getResourcePersistentAttribute();
    }

    @Override
    public JavaPersistentAttribute getParent() {
        return (JavaPersistentAttribute)super.getParent();
    }

    @Override
    public JavaPersistentAttribute getPersistentAttribute() {
        return this.getParent();
    }

    protected JavaResourcePersistentAttribute getResourcePersistentAttribute() {
        return this.resourcePersistentAttribute;
    }

    public T getMappingAnnotation() {
        return this.mappingAnnotation;
    }

    @Override
    public boolean isDefault() {
        return this.getPersistentAttribute().mappingIsDefault(this);
    }

    @Override
    public boolean shouldValidateAgainstDatabase() {
        return this.getTypeMapping().shouldValidateAgainstDatabase();
    }

    @Override
    public TypeMapping getTypeMapping() {
        return this.getPersistentAttribute().getTypeMapping();
    }

    @Override
    public String getName() {
        return this.getPersistentAttribute().getName();
    }

    public Table getDbTable(String tableName) {
        return this.getTypeMapping().getDbTable(tableName);
    }

    @Override
    public String getPrimaryKeyColumnName() {
        return null;
    }

    @Override
    public boolean isOverridableAttributeMapping() {
        return false;
    }

    @Override
    public boolean isOverridableAssociationMapping() {
        return false;
    }

    @Override
    public boolean isIdMapping() {
        return false;
    }

    @Override
    public boolean isOwnedBy(RelationshipMapping mapping) {
        return false;
    }

    @Override
    public void initialize(Annotation annotation) {
        this.mappingAnnotation = annotation;
        this.initialize();
    }

    protected void initialize() {
    }

    @Override
    public void update(Annotation annotation) {
        this.mappingAnnotation = annotation;
        this.update();
    }

    protected void update() {
    }

    @Override
    public void validate(List<IMessage> messages, IReporter reporter, CompilationUnit astRoot) {
        super.validate(messages, reporter, astRoot);
        this.validateMappingType(messages, astRoot);
    }

    protected void validateMappingType(List<IMessage> messages, CompilationUnit astRoot) {
        if (!this.getTypeMapping().attributeMappingKeyAllowed(this.getKey())) {
            messages.add(DefaultJpaValidationMessages.buildMessage(1, "PERSISTENT_ATTRIBUTE_INVALID_MAPPING", new String[]{this.getName()}, this, this.getValidationTextRange(astRoot)));
        }
    }

    @Override
    public TextRange getValidationTextRange(CompilationUnit astRoot) {
        TextRange textRange = this.getResourceMappingTextRange(astRoot);
        return textRange != null ? textRange : this.getParent().getValidationTextRange(astRoot);
    }

    protected TextRange getResourceMappingTextRange(CompilationUnit astRoot) {
        return this.mappingAnnotation == null ? null : this.mappingAnnotation.getTextRange(astRoot);
    }

    public void toString(StringBuilder sb) {
        sb.append(this.getName());
    }
}

