/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.tests.internal.resource.java;

import java.util.Iterator;
import java.util.ListIterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentType;
import org.eclipse.jpt.core.resource.java.NamedQueriesAnnotation;
import org.eclipse.jpt.core.resource.java.NamedQueryAnnotation;
import org.eclipse.jpt.core.tests.internal.resource.java.JavaResourceModelTestCase;
import org.eclipse.jpt.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.utility.internal.CollectionTools;
import org.eclipse.jpt.utility.internal.iterators.ArrayIterator;

public class NamedQueriesTests
extends JavaResourceModelTestCase {
    private static final String QUERY_NAME = "myQuery";
    private static final String QUERY_QUERY = "SELECT name FROM Employee";

    public NamedQueriesTests(String name) {
        super(name);
    }

    private ICompilationUnit createTestNamedQueries() throws Exception {
        return this.createTestType(new AnnotationTestCase.DefaultAnnotationWriter(){

            @Override
            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.NamedQueries", "javax.persistence.NamedQuery"});
            }

            @Override
            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@NamedQueries(@NamedQuery)");
            }
        });
    }

    private ICompilationUnit createTestNamedQueryWithName() throws Exception {
        return this.createTestNamedQueryWithStringElement("name", QUERY_NAME);
    }

    private ICompilationUnit createTestNamedQueryWithQuery() throws Exception {
        return this.createTestNamedQueryWithStringElement("query", QUERY_QUERY);
    }

    private ICompilationUnit createTestNamedQueryWithStringElement(final String elementName, final String value) throws Exception {
        return this.createTestType(new AnnotationTestCase.DefaultAnnotationWriter(){

            @Override
            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.NamedQueries", "javax.persistence.NamedQuery"});
            }

            @Override
            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@NamedQueries(@NamedQuery(" + elementName + " = \"" + value + "\"))");
            }
        });
    }

    private ICompilationUnit createTestNamedQueryWithQueryHints() throws Exception {
        return this.createTestType(new AnnotationTestCase.DefaultAnnotationWriter(){

            @Override
            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.NamedQueries", "javax.persistence.NamedQuery", "javax.persistence.QueryHint"});
            }

            @Override
            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@NamedQueries(@NamedQuery(hints = {@QueryHint(name = \"BAR\", value = \"FOO\"), @QueryHint}))");
            }
        });
    }

    private ICompilationUnit createTestNamedQuery() throws Exception {
        return this.createTestType(new AnnotationTestCase.DefaultAnnotationWriter(){

            @Override
            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.NamedQuery", "javax.persistence.QueryHint"});
            }

            @Override
            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@NamedQuery(name = \"foo\", query = \"bar\", hints = @QueryHint(name = \"BAR\", value = \"FOO\"))");
            }
        });
    }

    public void testNamedQuery() throws Exception {
        ICompilationUnit cu = this.createTestNamedQueries();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        NamedQueriesAnnotation namedQueries = (NamedQueriesAnnotation)typeResource.getSupportingAnnotation("javax.persistence.NamedQueries");
        NamedQueryAnnotation namedQuery = (NamedQueryAnnotation)namedQueries.nestedAnnotations().next();
        NamedQueriesTests.assertNotNull((Object)namedQuery);
    }

    public void testGetName() throws Exception {
        ICompilationUnit cu = this.createTestNamedQueryWithName();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        NamedQueriesAnnotation namedQueries = (NamedQueriesAnnotation)typeResource.getSupportingAnnotation("javax.persistence.NamedQueries");
        NamedQueryAnnotation namedQuery = (NamedQueryAnnotation)namedQueries.nestedAnnotations().next();
        NamedQueriesTests.assertEquals((String)QUERY_NAME, (String)namedQuery.getName());
    }

    public void testSetName() throws Exception {
        ICompilationUnit cu = this.createTestNamedQueryWithName();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        NamedQueriesAnnotation namedQueries = (NamedQueriesAnnotation)typeResource.getSupportingAnnotation("javax.persistence.NamedQueries");
        NamedQueryAnnotation namedQuery = (NamedQueryAnnotation)namedQueries.nestedAnnotations().next();
        NamedQueriesTests.assertEquals((String)QUERY_NAME, (String)namedQuery.getName());
        namedQuery.setName("foo");
        NamedQueriesTests.assertEquals((String)"foo", (String)namedQuery.getName());
        this.assertSourceContains("@NamedQuery(name = \"foo\")", cu);
        namedQuery.setName(null);
        NamedQueriesTests.assertNull((Object)namedQuery.getName());
        this.assertSourceDoesNotContain("@NamedQuery", cu);
    }

    public void testGetQuery() throws Exception {
        ICompilationUnit cu = this.createTestNamedQueryWithQuery();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        NamedQueriesAnnotation namedQueries = (NamedQueriesAnnotation)typeResource.getSupportingAnnotation("javax.persistence.NamedQueries");
        NamedQueryAnnotation namedQuery = (NamedQueryAnnotation)namedQueries.nestedAnnotations().next();
        NamedQueriesTests.assertEquals((String)QUERY_QUERY, (String)namedQuery.getQuery());
    }

    public void testSetQuery() throws Exception {
        ICompilationUnit cu = this.createTestNamedQueryWithQuery();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        NamedQueriesAnnotation namedQueries = (NamedQueriesAnnotation)typeResource.getSupportingAnnotation("javax.persistence.NamedQueries");
        NamedQueryAnnotation namedQuery = (NamedQueryAnnotation)namedQueries.nestedAnnotations().next();
        NamedQueriesTests.assertEquals((String)QUERY_QUERY, (String)namedQuery.getQuery());
        namedQuery.setQuery("foo");
        NamedQueriesTests.assertEquals((String)"foo", (String)namedQuery.getQuery());
        this.assertSourceContains("@NamedQuery(query = \"foo\")", cu);
        namedQuery.setQuery(null);
        NamedQueriesTests.assertNull((Object)namedQuery.getQuery());
        this.assertSourceDoesNotContain("@NamedQuery", cu);
    }

    public void testHints() throws Exception {
        ICompilationUnit cu = this.createTestNamedQueries();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        NamedQueriesAnnotation namedQueries = (NamedQueriesAnnotation)typeResource.getSupportingAnnotation("javax.persistence.NamedQueries");
        NamedQueryAnnotation namedQuery = (NamedQueryAnnotation)namedQueries.nestedAnnotations().next();
        NamedQueriesTests.assertEquals((int)0, (int)namedQuery.hintsSize());
    }

    public void testHints2() throws Exception {
        ICompilationUnit cu = this.createTestNamedQueries();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        NamedQueriesAnnotation namedQueries = (NamedQueriesAnnotation)typeResource.getSupportingAnnotation("javax.persistence.NamedQueries");
        NamedQueryAnnotation namedQuery = (NamedQueryAnnotation)namedQueries.nestedAnnotations().next();
        namedQuery.addHint(0);
        namedQuery.addHint(1);
        NamedQueriesTests.assertEquals((int)2, (int)namedQuery.hintsSize());
    }

    public void testHints3() throws Exception {
        ICompilationUnit cu = this.createTestNamedQueryWithQueryHints();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        NamedQueriesAnnotation namedQueries = (NamedQueriesAnnotation)typeResource.getSupportingAnnotation("javax.persistence.NamedQueries");
        NamedQueryAnnotation namedQuery = (NamedQueryAnnotation)namedQueries.nestedAnnotations().next();
        NamedQueriesTests.assertEquals((int)2, (int)namedQuery.hintsSize());
    }

    public void testAddHint() throws Exception {
        ICompilationUnit cu = this.createTestNamedQueries();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        NamedQueriesAnnotation namedQueries = (NamedQueriesAnnotation)typeResource.getSupportingAnnotation("javax.persistence.NamedQueries");
        NamedQueryAnnotation namedQuery = (NamedQueryAnnotation)namedQueries.nestedAnnotations().next();
        namedQuery.addHint(0).setName("FOO");
        namedQuery.addHint(1);
        namedQuery.addHint(0).setName("BAR");
        NamedQueriesTests.assertEquals((String)"BAR", (String)namedQuery.hintAt(0).getName());
        NamedQueriesTests.assertEquals((String)"FOO", (String)namedQuery.hintAt(1).getName());
        NamedQueriesTests.assertNull((Object)namedQuery.hintAt(2).getName());
        this.assertSourceContains("@NamedQuery(hints = {@QueryHint(name = \"BAR\"),@QueryHint(name = \"FOO\"), @QueryHint})", cu);
    }

    public void testRemoveHint() throws Exception {
        ICompilationUnit cu = this.createTestNamedQueryWithQueryHints();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        NamedQueriesAnnotation namedQueries = (NamedQueriesAnnotation)typeResource.getSupportingAnnotation("javax.persistence.NamedQueries");
        NamedQueryAnnotation namedQuery = (NamedQueryAnnotation)namedQueries.nestedAnnotations().next();
        namedQuery.addHint(0).setName("BAZ");
        NamedQueriesTests.assertEquals((String)"BAZ", (String)namedQuery.hintAt(0).getName());
        NamedQueriesTests.assertEquals((String)"BAR", (String)namedQuery.hintAt(1).getName());
        NamedQueriesTests.assertNull((Object)namedQuery.hintAt(2).getName());
        NamedQueriesTests.assertEquals((int)3, (int)namedQuery.hintsSize());
        namedQuery.removeHint(2);
        NamedQueriesTests.assertEquals((String)"BAZ", (String)namedQuery.hintAt(0).getName());
        NamedQueriesTests.assertEquals((String)"BAR", (String)namedQuery.hintAt(1).getName());
        NamedQueriesTests.assertEquals((int)2, (int)namedQuery.hintsSize());
        this.assertSourceContains("@NamedQueries(@NamedQuery(hints = {@QueryHint(name = \"BAZ\"), @QueryHint(name = \"BAR\", value = \"FOO\")}))", cu);
        namedQuery.removeHint(0);
        NamedQueriesTests.assertEquals((String)"BAR", (String)namedQuery.hintAt(0).getName());
        NamedQueriesTests.assertEquals((int)1, (int)namedQuery.hintsSize());
        this.assertSourceContains("@NamedQueries(@NamedQuery(hints = @QueryHint(name = \"BAR\", value = \"FOO\")))", cu);
        namedQuery.removeHint(0);
        NamedQueriesTests.assertEquals((int)0, (int)namedQuery.hintsSize());
        this.assertSourceDoesNotContain("@NamedQueries", cu);
    }

    public void testMoveHint() throws Exception {
        ICompilationUnit cu = this.createTestNamedQueryWithQueryHints();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        NamedQueriesAnnotation namedQueries = (NamedQueriesAnnotation)typeResource.getSupportingAnnotation("javax.persistence.NamedQueries");
        NamedQueryAnnotation namedQuery = (NamedQueryAnnotation)namedQueries.nestedAnnotations().next();
        namedQuery.addHint(0).setName("BAZ");
        NamedQueriesTests.assertEquals((String)"BAZ", (String)namedQuery.hintAt(0).getName());
        NamedQueriesTests.assertEquals((String)"BAR", (String)namedQuery.hintAt(1).getName());
        NamedQueriesTests.assertNull((Object)namedQuery.hintAt(2).getName());
        NamedQueriesTests.assertEquals((int)3, (int)namedQuery.hintsSize());
        namedQuery.moveHint(2, 0);
        NamedQueriesTests.assertEquals((String)"BAR", (String)namedQuery.hintAt(0).getName());
        NamedQueriesTests.assertNull((Object)namedQuery.hintAt(1).getName());
        NamedQueriesTests.assertEquals((String)"BAZ", (String)namedQuery.hintAt(2).getName());
        NamedQueriesTests.assertEquals((int)3, (int)namedQuery.hintsSize());
        this.assertSourceContains("@NamedQueries(@NamedQuery(hints = {@QueryHint(name = \"BAR\", value = \"FOO\"), @QueryHint, @QueryHint(name = \"BAZ\")}))", cu);
    }

    public void testMoveHint2() throws Exception {
        ICompilationUnit cu = this.createTestNamedQueryWithQueryHints();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        NamedQueriesAnnotation namedQueries = (NamedQueriesAnnotation)typeResource.getSupportingAnnotation("javax.persistence.NamedQueries");
        NamedQueryAnnotation namedQuery = (NamedQueryAnnotation)namedQueries.nestedAnnotations().next();
        namedQuery.addHint(0).setName("BAZ");
        NamedQueriesTests.assertEquals((String)"BAZ", (String)namedQuery.hintAt(0).getName());
        NamedQueriesTests.assertEquals((String)"BAR", (String)namedQuery.hintAt(1).getName());
        NamedQueriesTests.assertNull((Object)namedQuery.hintAt(2).getName());
        NamedQueriesTests.assertEquals((int)3, (int)namedQuery.hintsSize());
        namedQuery.moveHint(0, 2);
        NamedQueriesTests.assertNull((Object)namedQuery.hintAt(0).getName());
        NamedQueriesTests.assertEquals((String)"BAZ", (String)namedQuery.hintAt(1).getName());
        NamedQueriesTests.assertEquals((String)"BAR", (String)namedQuery.hintAt(2).getName());
        NamedQueriesTests.assertEquals((int)3, (int)namedQuery.hintsSize());
        this.assertSourceContains("@NamedQueries(@NamedQuery(hints = {@QueryHint, @QueryHint(name = \"BAZ\"), @QueryHint(name = \"BAR\", value = \"FOO\")}))", cu);
    }

    public void testAddNamedQueryCopyExisting() throws Exception {
        ICompilationUnit cu = this.createTestNamedQuery();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        NamedQueryAnnotation namedQuery = (NamedQueryAnnotation)typeResource.addSupportingAnnotation(1, "javax.persistence.NamedQuery", "javax.persistence.NamedQueries");
        namedQuery.setName("BAR");
        this.assertSourceContains("@NamedQueries({@NamedQuery(name = \"foo\", query = \"bar\", hints = @QueryHint(name = \"BAR\", value = \"FOO\")),@NamedQuery(name = \"BAR\")})", cu);
        NamedQueriesTests.assertNull((Object)typeResource.getSupportingAnnotation("javax.persistence.NamedQuery"));
        NamedQueriesTests.assertNotNull((Object)typeResource.getSupportingAnnotation("javax.persistence.NamedQueries"));
        NamedQueriesTests.assertEquals((int)2, (int)CollectionTools.size((Iterator)typeResource.supportingAnnotations("javax.persistence.NamedQuery", "javax.persistence.NamedQueries")));
    }

    public void testAddNamedQueryToBeginningOfList() throws Exception {
        ICompilationUnit cu = this.createTestNamedQuery();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        NamedQueryAnnotation namedQuery = (NamedQueryAnnotation)typeResource.addSupportingAnnotation(1, "javax.persistence.NamedQuery", "javax.persistence.NamedQueries");
        namedQuery.setName("BAR");
        this.assertSourceContains("@NamedQueries({@NamedQuery(name = \"foo\", query = \"bar\", hints = @QueryHint(name = \"BAR\", value = \"FOO\")),@NamedQuery(name = \"BAR\")})", cu);
        namedQuery = (NamedQueryAnnotation)typeResource.addSupportingAnnotation(0, "javax.persistence.NamedQuery", "javax.persistence.NamedQueries");
        namedQuery.setName("BAZ");
        this.assertSourceContains("@NamedQueries({@NamedQuery(name = \"BAZ\"),@NamedQuery(name = \"foo\", query = \"bar\", hints = @QueryHint(name = \"BAR\", value = \"FOO\")), @NamedQuery(name = \"BAR\")})", cu);
        ListIterator namedQueries = typeResource.supportingAnnotations("javax.persistence.NamedQuery", "javax.persistence.NamedQueries");
        NamedQueriesTests.assertEquals((String)"BAZ", (String)((NamedQueryAnnotation)namedQueries.next()).getName());
        NamedQueriesTests.assertEquals((String)"foo", (String)((NamedQueryAnnotation)namedQueries.next()).getName());
        NamedQueriesTests.assertEquals((String)"BAR", (String)((NamedQueryAnnotation)namedQueries.next()).getName());
        NamedQueriesTests.assertNull((Object)typeResource.getSupportingAnnotation("javax.persistence.NamedQuery"));
        NamedQueriesTests.assertNotNull((Object)typeResource.getSupportingAnnotation("javax.persistence.NamedQueries"));
        NamedQueriesTests.assertEquals((int)3, (int)CollectionTools.size((Iterator)typeResource.supportingAnnotations("javax.persistence.NamedQuery", "javax.persistence.NamedQueries")));
    }

    public void testRemoveNamedQueryCopyExisting() throws Exception {
        ICompilationUnit cu = this.createTestNamedQuery();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        NamedQueryAnnotation namedQuery = (NamedQueryAnnotation)typeResource.addSupportingAnnotation(1, "javax.persistence.NamedQuery", "javax.persistence.NamedQueries");
        namedQuery.setName("BAR");
        this.assertSourceContains("@NamedQueries({@NamedQuery(name = \"foo\", query = \"bar\", hints = @QueryHint(name = \"BAR\", value = \"FOO\")),@NamedQuery(name = \"BAR\")})", cu);
        typeResource.removeSupportingAnnotation(1, "javax.persistence.NamedQuery", "javax.persistence.NamedQueries");
        this.assertSourceContains("@NamedQuery(name = \"foo\", query = \"bar\", hints = @QueryHint(name = \"BAR\", value = \"FOO\"))", cu);
    }
}

