/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.tests.internal.context.orm;

import org.eclipse.jpt.core.context.orm.OrmXml;
import org.eclipse.jpt.core.context.persistence.MappingFileRef;
import org.eclipse.jpt.core.resource.orm.OrmFactory;
import org.eclipse.jpt.core.resource.persistence.PersistenceFactory;
import org.eclipse.jpt.core.resource.persistence.XmlMappingFileRef;
import org.eclipse.jpt.core.resource.xml.JpaXmlResource;
import org.eclipse.jpt.core.tests.internal.context.ContextModelTestCase;

public class OrmXmlTests
extends ContextModelTestCase {
    public OrmXmlTests(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.getXmlPersistenceUnit().setName("foo");
        XmlMappingFileRef mappingFileRef = PersistenceFactory.eINSTANCE.createXmlMappingFileRef();
        mappingFileRef.setFileName("META-INF/orm.xml");
        this.getXmlPersistenceUnit().getMappingFiles().add((Object)mappingFileRef);
        this.getPersistenceXmlResource().save(null);
    }

    protected OrmXml getOrmXml() {
        return (OrmXml)((MappingFileRef)this.getPersistenceUnit().mappingFileRefs().next()).getMappingFile();
    }

    public void testUpdateAddEntityMappings() throws Exception {
        OrmXmlTests.assertEquals((int)2, (int)this.getJpaProject().jpaFilesSize());
        JpaXmlResource ormResource = this.getOrmXmlResource();
        ormResource.getContents().clear();
        ormResource.save(null);
        OrmXmlTests.assertNull((Object)this.getOrmXml());
        OrmXmlTests.assertEquals((int)1, (int)this.getJpaProject().jpaFilesSize());
        ormResource.getContents().add((Object)OrmFactory.eINSTANCE.createXmlEntityMappings());
        ormResource.save(null);
        OrmXmlTests.assertNotNull((Object)this.getOrmXml().getEntityMappings());
        OrmXmlTests.assertEquals((int)2, (int)this.getJpaProject().jpaFilesSize());
    }

    public void testModifyAddEntityMappings() {
        JpaXmlResource ormResource = this.getOrmXmlResource();
        ormResource.getContents().remove((Object)this.getXmlEntityMappings());
        OrmXmlTests.assertNull((Object)this.getXmlEntityMappings());
        OrmXml ormXml = this.getOrmXml();
        OrmXmlTests.assertNull((Object)ormXml.getRoot());
        ormXml.addEntityMappings();
        OrmXmlTests.assertNotNull((Object)ormXml.getRoot());
        boolean exceptionThrown = false;
        try {
            ormXml.addEntityMappings();
        }
        catch (IllegalStateException illegalStateException) {
            exceptionThrown = true;
        }
        OrmXmlTests.assertTrue((String)"IllegalStateException was not thrown", (boolean)exceptionThrown);
    }

    public void testUpdateRemoveEntityMappings() throws Exception {
        JpaXmlResource ormResource = this.getOrmXmlResource();
        OrmXmlTests.assertNotNull((Object)this.getOrmXml().getRoot());
        ormResource.getContents().clear();
        OrmXmlTests.assertNull((Object)this.getOrmXml().getRoot());
    }

    public void testModifyRemoveEntityMappings() {
        OrmXml ormXml = this.getOrmXml();
        OrmXmlTests.assertNotNull((Object)ormXml.getRoot());
        ormXml.removeEntityMappings();
        OrmXmlTests.assertNull((Object)ormXml.getRoot());
        boolean exceptionThrown = false;
        try {
            ormXml.removeEntityMappings();
        }
        catch (IllegalStateException illegalStateException) {
            exceptionThrown = true;
        }
        OrmXmlTests.assertTrue((String)"IllegalStateException was not thrown", (boolean)exceptionThrown);
    }
}

