/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.tests.internal.context.orm;

import java.util.ListIterator;
import org.eclipse.jpt.core.context.orm.OrmAssociationOverride;
import org.eclipse.jpt.core.context.orm.OrmEntity;
import org.eclipse.jpt.core.context.orm.OrmJoinColumn;
import org.eclipse.jpt.core.context.orm.OrmPersistentType;
import org.eclipse.jpt.core.resource.orm.OrmFactory;
import org.eclipse.jpt.core.resource.orm.XmlAssociationOverride;
import org.eclipse.jpt.core.resource.orm.XmlEntity;
import org.eclipse.jpt.core.resource.orm.XmlJoinColumn;
import org.eclipse.jpt.core.resource.persistence.PersistenceFactory;
import org.eclipse.jpt.core.resource.persistence.XmlMappingFileRef;
import org.eclipse.jpt.core.tests.internal.context.ContextModelTestCase;

public class OrmAssociationOverrideTests
extends ContextModelTestCase {
    public OrmAssociationOverrideTests(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        XmlMappingFileRef mappingFileRef = PersistenceFactory.eINSTANCE.createXmlMappingFileRef();
        mappingFileRef.setFileName("META-INF/orm.xml");
        this.getXmlPersistenceUnit().getMappingFiles().add((Object)mappingFileRef);
        this.getPersistenceXmlResource().save(null);
    }

    public void testUpdateName() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "model.foo");
        OrmEntity ormEntity = (OrmEntity)ormPersistentType.getMapping();
        XmlEntity entityResource = (XmlEntity)this.getXmlEntityMappings().getEntities().get(0);
        entityResource.getAssociationOverrides().add((Object)OrmFactory.eINSTANCE.createXmlAssociationOverrideImpl());
        XmlAssociationOverride xmlAssociationOverride = (XmlAssociationOverride)entityResource.getAssociationOverrides().get(0);
        OrmAssociationOverride ormAssociationOverride = (OrmAssociationOverride)ormEntity.specifiedAssociationOverrides().next();
        OrmAssociationOverrideTests.assertNull((Object)ormAssociationOverride.getName());
        OrmAssociationOverrideTests.assertNull((Object)xmlAssociationOverride.getName());
        OrmAssociationOverrideTests.assertTrue((boolean)ormEntity.associationOverrides().hasNext());
        OrmAssociationOverrideTests.assertFalse((boolean)entityResource.getAssociationOverrides().isEmpty());
        xmlAssociationOverride.setName("FOO");
        OrmAssociationOverrideTests.assertEquals((String)"FOO", (String)ormAssociationOverride.getName());
        OrmAssociationOverrideTests.assertEquals((String)"FOO", (String)xmlAssociationOverride.getName());
        xmlAssociationOverride.setName(null);
        OrmAssociationOverrideTests.assertNull((Object)ormAssociationOverride.getName());
        OrmAssociationOverrideTests.assertNull((Object)xmlAssociationOverride.getName());
        xmlAssociationOverride.setName("FOO");
        OrmAssociationOverrideTests.assertEquals((String)"FOO", (String)ormAssociationOverride.getName());
        OrmAssociationOverrideTests.assertEquals((String)"FOO", (String)xmlAssociationOverride.getName());
        entityResource.getAssociationOverrides().remove(0);
        OrmAssociationOverrideTests.assertFalse((boolean)ormEntity.associationOverrides().hasNext());
        OrmAssociationOverrideTests.assertTrue((boolean)entityResource.getAssociationOverrides().isEmpty());
    }

    public void testModifyName() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "model.foo");
        OrmEntity ormEntity = (OrmEntity)ormPersistentType.getMapping();
        XmlEntity entityResource = (XmlEntity)this.getXmlEntityMappings().getEntities().get(0);
        entityResource.getAssociationOverrides().add((Object)OrmFactory.eINSTANCE.createXmlAssociationOverrideImpl());
        XmlAssociationOverride xmlAssociationOverride = (XmlAssociationOverride)entityResource.getAssociationOverrides().get(0);
        OrmAssociationOverride ormAssociationOverride = (OrmAssociationOverride)ormEntity.specifiedAssociationOverrides().next();
        OrmAssociationOverrideTests.assertNull((Object)ormAssociationOverride.getName());
        OrmAssociationOverrideTests.assertNull((Object)xmlAssociationOverride.getName());
        ormAssociationOverride.setName("foo");
        OrmAssociationOverrideTests.assertEquals((String)"foo", (String)ormAssociationOverride.getName());
        OrmAssociationOverrideTests.assertEquals((String)"foo", (String)xmlAssociationOverride.getName());
        ormAssociationOverride.setName(null);
        OrmAssociationOverrideTests.assertNull((Object)ormAssociationOverride.getName());
        OrmAssociationOverrideTests.assertNull((Object)((XmlAssociationOverride)entityResource.getAssociationOverrides().get(0)).getName());
    }

    public void testAddSpecifiedJoinColumn() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "model.Foo");
        OrmEntity ormEntity = (OrmEntity)ormPersistentType.getMapping();
        XmlEntity entityResource = (XmlEntity)this.getXmlEntityMappings().getEntities().get(0);
        entityResource.getAssociationOverrides().add((Object)OrmFactory.eINSTANCE.createXmlAssociationOverrideImpl());
        OrmAssociationOverride ormAssociationOverride = (OrmAssociationOverride)ormEntity.specifiedAssociationOverrides().next();
        XmlAssociationOverride xmlAssociationOverride = (XmlAssociationOverride)entityResource.getAssociationOverrides().get(0);
        OrmJoinColumn joinColumn = ormAssociationOverride.addSpecifiedJoinColumn(0);
        joinColumn.setSpecifiedName("FOO");
        OrmAssociationOverrideTests.assertEquals((String)"FOO", (String)((XmlJoinColumn)xmlAssociationOverride.getJoinColumns().get(0)).getName());
        OrmJoinColumn joinColumn2 = ormAssociationOverride.addSpecifiedJoinColumn(0);
        joinColumn2.setSpecifiedName("BAR");
        OrmAssociationOverrideTests.assertEquals((String)"BAR", (String)((XmlJoinColumn)xmlAssociationOverride.getJoinColumns().get(0)).getName());
        OrmAssociationOverrideTests.assertEquals((String)"FOO", (String)((XmlJoinColumn)xmlAssociationOverride.getJoinColumns().get(1)).getName());
        OrmJoinColumn joinColumn3 = ormAssociationOverride.addSpecifiedJoinColumn(1);
        joinColumn3.setSpecifiedName("BAZ");
        OrmAssociationOverrideTests.assertEquals((String)"BAR", (String)((XmlJoinColumn)xmlAssociationOverride.getJoinColumns().get(0)).getName());
        OrmAssociationOverrideTests.assertEquals((String)"BAZ", (String)((XmlJoinColumn)xmlAssociationOverride.getJoinColumns().get(1)).getName());
        OrmAssociationOverrideTests.assertEquals((String)"FOO", (String)((XmlJoinColumn)xmlAssociationOverride.getJoinColumns().get(2)).getName());
        ListIterator joinColumns = ormAssociationOverride.specifiedJoinColumns();
        OrmAssociationOverrideTests.assertEquals((Object)joinColumn2, joinColumns.next());
        OrmAssociationOverrideTests.assertEquals((Object)joinColumn3, joinColumns.next());
        OrmAssociationOverrideTests.assertEquals((Object)joinColumn, joinColumns.next());
        joinColumns = ormAssociationOverride.specifiedJoinColumns();
        OrmAssociationOverrideTests.assertEquals((String)"BAR", (String)((OrmJoinColumn)joinColumns.next()).getName());
        OrmAssociationOverrideTests.assertEquals((String)"BAZ", (String)((OrmJoinColumn)joinColumns.next()).getName());
        OrmAssociationOverrideTests.assertEquals((String)"FOO", (String)((OrmJoinColumn)joinColumns.next()).getName());
    }

    public void testRemoveSpecifiedJoinColumn() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "model.Foo");
        OrmEntity ormEntity = (OrmEntity)ormPersistentType.getMapping();
        XmlEntity entityResource = (XmlEntity)this.getXmlEntityMappings().getEntities().get(0);
        entityResource.getAssociationOverrides().add((Object)OrmFactory.eINSTANCE.createXmlAssociationOverrideImpl());
        OrmAssociationOverride ormAssociationOverride = (OrmAssociationOverride)ormEntity.specifiedAssociationOverrides().next();
        XmlAssociationOverride xmlAssociationOverride = (XmlAssociationOverride)entityResource.getAssociationOverrides().get(0);
        ormAssociationOverride.addSpecifiedJoinColumn(0).setSpecifiedName("FOO");
        ormAssociationOverride.addSpecifiedJoinColumn(1).setSpecifiedName("BAR");
        ormAssociationOverride.addSpecifiedJoinColumn(2).setSpecifiedName("BAZ");
        OrmAssociationOverrideTests.assertEquals((int)3, (int)xmlAssociationOverride.getJoinColumns().size());
        ormAssociationOverride.removeSpecifiedJoinColumn(0);
        OrmAssociationOverrideTests.assertEquals((int)2, (int)xmlAssociationOverride.getJoinColumns().size());
        OrmAssociationOverrideTests.assertEquals((String)"BAR", (String)((XmlJoinColumn)xmlAssociationOverride.getJoinColumns().get(0)).getName());
        OrmAssociationOverrideTests.assertEquals((String)"BAZ", (String)((XmlJoinColumn)xmlAssociationOverride.getJoinColumns().get(1)).getName());
        ormAssociationOverride.removeSpecifiedJoinColumn(0);
        OrmAssociationOverrideTests.assertEquals((int)1, (int)xmlAssociationOverride.getJoinColumns().size());
        OrmAssociationOverrideTests.assertEquals((String)"BAZ", (String)((XmlJoinColumn)xmlAssociationOverride.getJoinColumns().get(0)).getName());
        ormAssociationOverride.removeSpecifiedJoinColumn(0);
        OrmAssociationOverrideTests.assertEquals((int)0, (int)xmlAssociationOverride.getJoinColumns().size());
    }

    public void testMoveSpecifiedJoinColumn() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "model.Foo");
        OrmEntity ormEntity = (OrmEntity)ormPersistentType.getMapping();
        XmlEntity entityResource = (XmlEntity)this.getXmlEntityMappings().getEntities().get(0);
        entityResource.getAssociationOverrides().add((Object)OrmFactory.eINSTANCE.createXmlAssociationOverrideImpl());
        OrmAssociationOverride ormAssociationOverride = (OrmAssociationOverride)ormEntity.specifiedAssociationOverrides().next();
        XmlAssociationOverride xmlAssociationOverride = (XmlAssociationOverride)entityResource.getAssociationOverrides().get(0);
        ormAssociationOverride.addSpecifiedJoinColumn(0).setSpecifiedName("FOO");
        ormAssociationOverride.addSpecifiedJoinColumn(1).setSpecifiedName("BAR");
        ormAssociationOverride.addSpecifiedJoinColumn(2).setSpecifiedName("BAZ");
        OrmAssociationOverrideTests.assertEquals((int)3, (int)xmlAssociationOverride.getJoinColumns().size());
        ormAssociationOverride.moveSpecifiedJoinColumn(2, 0);
        ListIterator joinColumns = ormAssociationOverride.specifiedJoinColumns();
        OrmAssociationOverrideTests.assertEquals((String)"BAR", (String)((OrmJoinColumn)joinColumns.next()).getName());
        OrmAssociationOverrideTests.assertEquals((String)"BAZ", (String)((OrmJoinColumn)joinColumns.next()).getName());
        OrmAssociationOverrideTests.assertEquals((String)"FOO", (String)((OrmJoinColumn)joinColumns.next()).getName());
        OrmAssociationOverrideTests.assertEquals((String)"BAR", (String)((XmlJoinColumn)xmlAssociationOverride.getJoinColumns().get(0)).getName());
        OrmAssociationOverrideTests.assertEquals((String)"BAZ", (String)((XmlJoinColumn)xmlAssociationOverride.getJoinColumns().get(1)).getName());
        OrmAssociationOverrideTests.assertEquals((String)"FOO", (String)((XmlJoinColumn)xmlAssociationOverride.getJoinColumns().get(2)).getName());
        ormAssociationOverride.moveSpecifiedJoinColumn(0, 1);
        joinColumns = ormAssociationOverride.specifiedJoinColumns();
        OrmAssociationOverrideTests.assertEquals((String)"BAZ", (String)((OrmJoinColumn)joinColumns.next()).getName());
        OrmAssociationOverrideTests.assertEquals((String)"BAR", (String)((OrmJoinColumn)joinColumns.next()).getName());
        OrmAssociationOverrideTests.assertEquals((String)"FOO", (String)((OrmJoinColumn)joinColumns.next()).getName());
        OrmAssociationOverrideTests.assertEquals((String)"BAZ", (String)((XmlJoinColumn)xmlAssociationOverride.getJoinColumns().get(0)).getName());
        OrmAssociationOverrideTests.assertEquals((String)"BAR", (String)((XmlJoinColumn)xmlAssociationOverride.getJoinColumns().get(1)).getName());
        OrmAssociationOverrideTests.assertEquals((String)"FOO", (String)((XmlJoinColumn)xmlAssociationOverride.getJoinColumns().get(2)).getName());
    }

    public void testUpdateJoinColumns() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "model.Foo");
        OrmEntity ormEntity = (OrmEntity)ormPersistentType.getMapping();
        XmlEntity entityResource = (XmlEntity)this.getXmlEntityMappings().getEntities().get(0);
        entityResource.getAssociationOverrides().add((Object)OrmFactory.eINSTANCE.createXmlAssociationOverrideImpl());
        OrmAssociationOverride ormAssociationOverride = (OrmAssociationOverride)ormEntity.specifiedAssociationOverrides().next();
        XmlAssociationOverride xmlAssociationOverride = (XmlAssociationOverride)entityResource.getAssociationOverrides().get(0);
        xmlAssociationOverride.getJoinColumns().add((Object)OrmFactory.eINSTANCE.createXmlJoinColumnImpl());
        xmlAssociationOverride.getJoinColumns().add((Object)OrmFactory.eINSTANCE.createXmlJoinColumnImpl());
        xmlAssociationOverride.getJoinColumns().add((Object)OrmFactory.eINSTANCE.createXmlJoinColumnImpl());
        ((XmlJoinColumn)xmlAssociationOverride.getJoinColumns().get(0)).setName("FOO");
        ((XmlJoinColumn)xmlAssociationOverride.getJoinColumns().get(1)).setName("BAR");
        ((XmlJoinColumn)xmlAssociationOverride.getJoinColumns().get(2)).setName("BAZ");
        ListIterator joinColumns = ormAssociationOverride.specifiedJoinColumns();
        OrmAssociationOverrideTests.assertEquals((String)"FOO", (String)((OrmJoinColumn)joinColumns.next()).getName());
        OrmAssociationOverrideTests.assertEquals((String)"BAR", (String)((OrmJoinColumn)joinColumns.next()).getName());
        OrmAssociationOverrideTests.assertEquals((String)"BAZ", (String)((OrmJoinColumn)joinColumns.next()).getName());
        OrmAssociationOverrideTests.assertFalse((boolean)joinColumns.hasNext());
        xmlAssociationOverride.getJoinColumns().move(2, 0);
        joinColumns = ormAssociationOverride.specifiedJoinColumns();
        OrmAssociationOverrideTests.assertEquals((String)"BAR", (String)((OrmJoinColumn)joinColumns.next()).getName());
        OrmAssociationOverrideTests.assertEquals((String)"BAZ", (String)((OrmJoinColumn)joinColumns.next()).getName());
        OrmAssociationOverrideTests.assertEquals((String)"FOO", (String)((OrmJoinColumn)joinColumns.next()).getName());
        OrmAssociationOverrideTests.assertFalse((boolean)joinColumns.hasNext());
        xmlAssociationOverride.getJoinColumns().move(0, 1);
        joinColumns = ormAssociationOverride.specifiedJoinColumns();
        OrmAssociationOverrideTests.assertEquals((String)"BAZ", (String)((OrmJoinColumn)joinColumns.next()).getName());
        OrmAssociationOverrideTests.assertEquals((String)"BAR", (String)((OrmJoinColumn)joinColumns.next()).getName());
        OrmAssociationOverrideTests.assertEquals((String)"FOO", (String)((OrmJoinColumn)joinColumns.next()).getName());
        OrmAssociationOverrideTests.assertFalse((boolean)joinColumns.hasNext());
        xmlAssociationOverride.getJoinColumns().remove(1);
        joinColumns = ormAssociationOverride.specifiedJoinColumns();
        OrmAssociationOverrideTests.assertEquals((String)"BAZ", (String)((OrmJoinColumn)joinColumns.next()).getName());
        OrmAssociationOverrideTests.assertEquals((String)"FOO", (String)((OrmJoinColumn)joinColumns.next()).getName());
        OrmAssociationOverrideTests.assertFalse((boolean)joinColumns.hasNext());
        xmlAssociationOverride.getJoinColumns().remove(1);
        joinColumns = ormAssociationOverride.specifiedJoinColumns();
        OrmAssociationOverrideTests.assertEquals((String)"BAZ", (String)((OrmJoinColumn)joinColumns.next()).getName());
        OrmAssociationOverrideTests.assertFalse((boolean)joinColumns.hasNext());
        xmlAssociationOverride.getJoinColumns().remove(0);
        OrmAssociationOverrideTests.assertFalse((boolean)ormAssociationOverride.specifiedJoinColumns().hasNext());
    }
}

