/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.consumption.ui.extension;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jst.ws.internal.consumption.command.common.AddModuleToServerCommand;
import org.eclipse.jst.ws.internal.consumption.command.common.CreateServerCommand;
import org.eclipse.wst.common.environment.IEnvironment;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelOperation;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.ServerCore;
import org.eclipse.wst.ws.internal.wsrt.IContext;
import org.eclipse.wst.ws.internal.wsrt.IWebServiceClient;

public class PreClientInstallCommand
extends AbstractDataModelOperation {
    private IWebServiceClient webServiceClient_;
    private String project_;
    private String module_;
    private String earProject_;
    private String ear_;
    private IContext context_;

    public IStatus execute(IProgressMonitor monitor, IAdaptable adaptable) {
        if (this.context_ != null && this.context_.getInstall()) {
            IEnvironment environment = this.getEnvironment();
            if (this.webServiceClient_.getWebServiceClientInfo().getServerInstanceId() == null) {
                IServer[] allServers = ServerCore.getServers();
                if (allServers != null && allServers.length > 0) {
                    int i = 0;
                    while (i < allServers.length) {
                        IServer oneServer = allServers[i];
                        if (oneServer.getServerType().getId().equals(this.webServiceClient_.getWebServiceClientInfo().getServerFactoryId())) {
                            this.webServiceClient_.getWebServiceClientInfo().setServerInstanceId(oneServer.getId());
                            this.webServiceClient_.getWebServiceClientInfo().setServerCreated(true);
                        }
                        ++i;
                    }
                }
                if (this.webServiceClient_.getWebServiceClientInfo().getServerInstanceId() == null) {
                    CreateServerCommand createServerCommand = new CreateServerCommand();
                    createServerCommand.setServerFactoryid(this.webServiceClient_.getWebServiceClientInfo().getServerFactoryId());
                    createServerCommand.setServerRuntimeId(this.webServiceClient_.getWebServiceClientInfo().getServerRuntimeId());
                    createServerCommand.setEnvironment(environment);
                    IStatus createServerStatus = createServerCommand.execute(null, null);
                    if (createServerStatus.getSeverity() == 0) {
                        this.webServiceClient_.getWebServiceClientInfo().setServerInstanceId(createServerCommand.getServerInstanceId());
                        this.webServiceClient_.getWebServiceClientInfo().setServerCreated(true);
                    } else {
                        if (createServerStatus.getSeverity() == 4) {
                            environment.getStatusHandler().reportError(createServerStatus);
                        }
                        return createServerStatus;
                    }
                }
            }
            AddModuleToServerCommand command = new AddModuleToServerCommand();
            command.setServerInstanceId(this.webServiceClient_.getWebServiceClientInfo().getServerInstanceId());
            command.setEarProject(this.earProject_);
            command.setEarModule(this.ear_);
            command.setProject(this.project_);
            command.setModule(this.module_);
            command.setEnvironment(environment);
            IStatus status = command.execute(null, null);
            if (status.getSeverity() == 4) {
                environment.getStatusHandler().reportError(status);
            }
            return status;
        }
        return Status.OK_STATUS;
    }

    public void setProject(String project) {
        this.project_ = project;
    }

    public boolean getCanRunTestClient() {
        return this.webServiceClient_.getWebServiceClientInfo().getServerInstanceId() != null;
    }

    public void setModule(String module) {
        this.module_ = module;
    }

    public void setEarProject(String earProject) {
        this.earProject_ = earProject;
    }

    public void setEar(String ear) {
        this.ear_ = ear;
    }

    public void setWebService(IWebServiceClient webServiceClient) {
        this.webServiceClient_ = webServiceClient;
    }

    public void setContext(IContext context) {
        this.context_ = context;
    }
}

