/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.ui.internal.contentassist;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.link.LinkedModeModel;
import org.eclipse.jface.text.link.LinkedModeUI;
import org.eclipse.jface.text.link.LinkedPosition;
import org.eclipse.jface.text.link.LinkedPositionGroup;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.ui.texteditor.link.EditorLinkedModeUI;
import org.eclipse.wst.sse.ui.internal.contentassist.CustomCompletionProposal;
import org.eclipse.wst.xml.ui.internal.Logger;

public class MarkupCompletionProposal
extends CustomCompletionProposal {
    private IRegion fSelectedRegion = null;

    public MarkupCompletionProposal(String replacementString, int replacementOffset, int replacementLength, int cursorPosition, Image image, String displayString, IContextInformation contextInformation, String additionalProposalInfo, int relevance) {
        super(replacementString, replacementOffset, replacementLength, cursorPosition, image, displayString, contextInformation, additionalProposalInfo, relevance);
    }

    public MarkupCompletionProposal(String replacementString, int replacementOffset, int replacementLength, int cursorPosition, Image image, String displayString, IContextInformation contextInformation, String additionalProposalInfo, int relevance, boolean updateReplacementLengthOnValidate) {
        super(replacementString, replacementOffset, replacementLength, cursorPosition, image, displayString, null, contextInformation, additionalProposalInfo, relevance, updateReplacementLengthOnValidate);
    }

    public MarkupCompletionProposal(String replacementString, int replacementOffset, int replacementLength, int cursorPosition, Image image, String displayString, String alternateMatch, IContextInformation contextInformation, String additionalProposalInfo, int relevance, boolean updateReplacementLengthOnValidate) {
        super(replacementString, replacementOffset, replacementLength, cursorPosition, image, displayString, alternateMatch, contextInformation, additionalProposalInfo, relevance, updateReplacementLengthOnValidate);
    }

    public void apply(ITextViewer viewer, char trigger, int stateMask, int offset) {
        super.apply(viewer, trigger, stateMask, offset);
        this.getLinkedPositions(viewer);
    }

    protected void getLinkedPositions(ITextViewer viewer) {
        String replacement = this.getReplacementString();
        IDocument document = viewer.getDocument();
        int length = replacement.length();
        boolean inAttribute = false;
        boolean hasGroup = false;
        int offset = 0;
        char attType = '\u0000';
        int exitPosition = -1;
        LinkedModeModel model = new LinkedModeModel();
        try {
            int i = 0;
            while (i < length) {
                char c = replacement.charAt(i);
                switch (c) {
                    case '=': {
                        break;
                    }
                    case '\"': 
                    case '\'': {
                        if (!inAttribute) {
                            offset = i;
                            attType = c;
                            inAttribute = true;
                            break;
                        }
                        if (attType != c || replacement.charAt(i - 1) == '\\') break;
                        inAttribute = false;
                        this.addPosition(model, document, this.getReplacementOffset() + offset + 1, i - offset - 1);
                        hasGroup = true;
                        break;
                    }
                    case '>': {
                        if (inAttribute || exitPosition != -1) break;
                        exitPosition = this.getReplacementOffset() + i + 1;
                    }
                }
                ++i;
            }
            if (hasGroup) {
                model.forceInstall();
                EditorLinkedModeUI ui = new EditorLinkedModeUI(model, viewer);
                ui.setExitPosition(viewer, exitPosition < 0 ? this.getReplacementOffset() + this.getReplacementLength() + replacement.length() - 1 : exitPosition, 0, Integer.MAX_VALUE);
                ui.setCyclingMode(LinkedModeUI.CYCLE_WHEN_NO_PARENT);
                ui.setDoContextInfo(true);
                ui.enter();
                this.fSelectedRegion = ui.getSelectedRegion();
            }
        }
        catch (BadLocationException e) {
            Logger.logException(e);
        }
    }

    private void addPosition(LinkedModeModel model, IDocument document, int offset, int length) throws BadLocationException {
        LinkedPositionGroup group = new LinkedPositionGroup();
        group.addPosition(new LinkedPosition(document, offset, length, -1));
        model.addGroup(group);
    }

    public Point getSelection(IDocument document) {
        if (this.fSelectedRegion == null) {
            return super.getSelection(document);
        }
        return new Point(this.fSelectedRegion.getOffset(), this.fSelectedRegion.getLength());
    }
}

