/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.internal.validation;

import java.util.ArrayList;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jem.workbench.utility.JemProjectUtilities;
import org.eclipse.jst.j2ee.internal.project.J2EEProjectUtilities;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.validation.internal.IProjectValidationHelper;

public class ProjectValidationHelper
implements IProjectValidationHelper {
    private static IContainer[] EMPTY_RESULT = new IContainer[0];
    private static ProjectValidationHelper INSTANCE;
    private IContainer[] outputs;
    private IContainer[] sources;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ProjectValidationHelper getInstance() {
        if (INSTANCE != null) return INSTANCE;
        Class<ProjectValidationHelper> clazz = ProjectValidationHelper.class;
        synchronized (ProjectValidationHelper.class) {
            if (INSTANCE != null) return INSTANCE;
            INSTANCE = new ProjectValidationHelper();
            // ** MonitorExit[var0] (shouldn't be in output)
            return INSTANCE;
        }
    }

    public void disposeInstance() {
        INSTANCE = null;
    }

    private IContainer[] getCachedOutputContainers(IProject project) {
        if (this.outputs != null) {
            return this.outputs;
        }
        if (project == null || JemProjectUtilities.getJavaProject((IProject)project) == null) {
            this.outputs = EMPTY_RESULT;
            return EMPTY_RESULT;
        }
        IVirtualComponent comp = ComponentCore.createComponent((IProject)project);
        if (comp == null || !comp.exists()) {
            this.outputs = EMPTY_RESULT;
            return EMPTY_RESULT;
        }
        this.outputs = J2EEProjectUtilities.getOutputContainers(project);
        return this.outputs;
    }

    public IContainer[] getOutputContainers(IProject project) {
        ProjectValidationHelper inst = ProjectValidationHelper.getInstance();
        if (inst == null) {
            return null;
        }
        return ProjectValidationHelper.getInstance().getCachedOutputContainers(project);
    }

    private IContainer[] getCachedSourceContainers(IProject project) {
        if (this.sources != null) {
            return this.sources;
        }
        if (project == null || JemProjectUtilities.getJavaProject((IProject)project) == null) {
            this.sources = EMPTY_RESULT;
            return EMPTY_RESULT;
        }
        IVirtualComponent comp = ComponentCore.createComponent((IProject)project);
        if (comp == null || !comp.exists()) {
            this.sources = EMPTY_RESULT;
            return EMPTY_RESULT;
        }
        IPackageFragmentRoot[] roots = J2EEProjectUtilities.getSourceContainers(project);
        ArrayList<IResource> result = new ArrayList<IResource>();
        int i = 0;
        while (i < roots.length) {
            if (roots[i].getResource() != null && roots[i].getResource() instanceof IContainer) {
                result.add(roots[i].getResource());
            }
            ++i;
        }
        this.sources = result.toArray(new IContainer[result.size()]);
        return this.sources;
    }

    public IContainer[] getSourceContainers(IProject project) {
        return ProjectValidationHelper.getInstance().getCachedSourceContainers(project);
    }
}

