/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.jaxws.core.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaConventions;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jst.ws.internal.jaxws.core.JAXWSCorePlugin;

public final class JDTUtils {
    private JDTUtils() {
    }

    public static void addToClasspath(IJavaProject javaProject, IClasspathEntry classpathEntry) {
        try {
            List<IClasspathEntry> currentEntries = Arrays.asList(javaProject.getRawClasspath());
            ArrayList<IClasspathEntry> newEntries = new ArrayList<IClasspathEntry>();
            newEntries.addAll(currentEntries);
            if (classpathEntry != null && !newEntries.contains(classpathEntry)) {
                newEntries.add(classpathEntry);
            }
            javaProject.setRawClasspath(newEntries.toArray(new IClasspathEntry[newEntries.size()]), (IProgressMonitor)new NullProgressMonitor());
        }
        catch (JavaModelException jme) {
            JAXWSCorePlugin.log(jme.getStatus());
        }
    }

    public static void removeFromClasspath(IJavaProject javaProject, IClasspathEntry classpathEntry) {
        try {
            List<IClasspathEntry> currentEntries = Arrays.asList(javaProject.getRawClasspath());
            ArrayList<IClasspathEntry> newEntries = new ArrayList<IClasspathEntry>();
            newEntries.addAll(currentEntries);
            if (classpathEntry != null && newEntries.contains(classpathEntry)) {
                newEntries.remove(classpathEntry);
            }
            javaProject.setRawClasspath(newEntries.toArray(new IClasspathEntry[newEntries.size()]), (IProgressMonitor)new NullProgressMonitor());
        }
        catch (JavaModelException jme) {
            JAXWSCorePlugin.log(jme.getStatus());
        }
    }

    public static IJavaProject getJavaProject(String projectName) {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        return JavaCore.create((IProject)project);
    }

    public static IPath getJavaProjectOutputDirectoryPath(IJavaProject javaProject) {
        try {
            return ResourcesPlugin.getWorkspace().getRoot().findMember(javaProject.getOutputLocation()).getLocation();
        }
        catch (JavaModelException jme) {
            JAXWSCorePlugin.log(jme.getStatus());
            return ResourcesPlugin.getWorkspace().getRoot().findMember(javaProject.getPath()).getLocation();
        }
    }

    public static IPath getJavaProjectOutputDirectoryPath(String projectName) {
        return JDTUtils.getJavaProjectOutputDirectoryPath(JDTUtils.getJavaProject(projectName));
    }

    public static IPath getJavaProjectSourceDirectoryPath(IType type) {
        IPackageFragment packageFragment = type.getPackageFragment();
        IPackageFragmentRoot packageFragmentRoot = (IPackageFragmentRoot)packageFragment.getParent();
        IResource srcDirectoryResource = packageFragmentRoot.getResource();
        return srcDirectoryResource.getFullPath();
    }

    public static IPath getJavaProjectSourceDirectoryPath(String projectName) {
        return JDTUtils.getJavaProjectSourceDirectoryPath(JDTUtils.getJavaProject(projectName));
    }

    public static IPath getJavaProjectSourceDirectoryPath(IJavaProject javaProject) {
        try {
            IPackageFragmentRoot[] packageFragmentRoots = javaProject.getAllPackageFragmentRoots();
            IPackageFragmentRoot packageFragmentRoot = packageFragmentRoots[0];
            IResource srcDirectoryResource = packageFragmentRoot.getResource();
            return srcDirectoryResource.getFullPath();
        }
        catch (JavaModelException jme) {
            JAXWSCorePlugin.log(jme.getStatus());
            return new Path("");
        }
    }

    public static IMethod[] getPublicMethods(IType type) {
        ArrayList<IMethod> publicMethods = new ArrayList<IMethod>();
        try {
            IMethod[] allMethods = type.getMethods();
            if (type.isInterface()) {
                return allMethods;
            }
            int i = 0;
            while (i < allMethods.length) {
                IMethod method = allMethods[i];
                if (Flags.isPublic((int)method.getFlags()) && !method.isConstructor() && !method.isMainMethod()) {
                    publicMethods.add(method);
                }
                ++i;
            }
        }
        catch (JavaModelException jme) {
            JAXWSCorePlugin.log(jme.getStatus());
        }
        return publicMethods.toArray(new IMethod[publicMethods.size()]);
    }

    public static String getTargetNamespaceFromPackageName(String packageName) {
        if (packageName == null || packageName.length() == 0) {
            return "http://default_package/";
        }
        List<String> namespaceElements = Arrays.asList(packageName.split("\\."));
        Collections.reverse(namespaceElements);
        String targetNamespace = "http://";
        Iterator<String> namespaceIterator = namespaceElements.iterator();
        while (namespaceIterator.hasNext()) {
            String element = namespaceIterator.next();
            if (element.trim().length() <= 0) continue;
            targetNamespace = String.valueOf(targetNamespace) + element;
            if (!namespaceIterator.hasNext()) continue;
            targetNamespace = String.valueOf(targetNamespace) + ".";
        }
        targetNamespace = String.valueOf(targetNamespace) + "/";
        return targetNamespace;
    }

    public static IType findType(IJavaProject javaProject, String fullyQualifiedClassName) {
        try {
            return javaProject.findType(fullyQualifiedClassName);
        }
        catch (JavaModelException jme) {
            JAXWSCorePlugin.log(jme.getStatus());
            return null;
        }
    }

    public static IType findType(String projectName, String fullyQualifiedClassName) {
        return JDTUtils.findType(JDTUtils.getJavaProject(projectName), fullyQualifiedClassName);
    }

    public static boolean isJavaProject(IProject project) {
        try {
            return project.hasNature("org.eclipse.jdt.core.javanature");
        }
        catch (CoreException ce) {
            JAXWSCorePlugin.log(ce.getStatus());
            return false;
        }
    }

    public static boolean isPublicMethod(IMethod method) {
        try {
            return Flags.isPublic((int)method.getFlags()) && !method.isConstructor() && !method.isMainMethod();
        }
        catch (JavaModelException jme) {
            JAXWSCorePlugin.log(jme.getStatus());
            return false;
        }
    }

    public static IStatus validateJavaTypeName(String name) {
        String sourceLevel = JavaCore.getOption((String)"org.eclipse.jdt.core.compiler.source");
        String complianceLevel = JavaCore.getOption((String)"org.eclipse.jdt.core.compiler.compliance");
        return JavaConventions.validateJavaTypeName((String)name, (String)sourceLevel, (String)complianceLevel);
    }

    public static IStatus validateJavaTypeName(String projectName, String name) {
        IJavaProject javaProject = JDTUtils.getJavaProject(projectName);
        String sourceLevel = javaProject.getOption("org.eclipse.jdt.core.compiler.source", true);
        String complianceLevel = javaProject.getOption("org.eclipse.jdt.core.compiler.compliance", true);
        return JavaConventions.validateJavaTypeName((String)name, (String)sourceLevel, (String)complianceLevel);
    }

    public static IStatus validatePackageName(String projectName, String packageName) {
        IJavaProject javaProject = JDTUtils.getJavaProject(projectName);
        String sourceLevel = javaProject.getOption("org.eclipse.jdt.core.compiler.source", true);
        String complianceLevel = javaProject.getOption("org.eclipse.jdt.core.compiler.compliance", true);
        return JavaConventions.validatePackageName((String)packageName, (String)sourceLevel, (String)complianceLevel);
    }

    public static IStatus validateIdentifier(String id) {
        String sourceLevel = JavaCore.getOption((String)"org.eclipse.jdt.core.compiler.source");
        String complianceLevel = JavaCore.getOption((String)"org.eclipse.jdt.core.compiler.compliance");
        return JavaConventions.validateIdentifier((String)id, (String)sourceLevel, (String)complianceLevel);
    }
}

