/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.server.ui.internal.view.servers;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.SelectionProviderAction;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.ServerCore;
import org.eclipse.wst.server.ui.internal.DeleteServerDialog;
import org.eclipse.wst.server.ui.internal.Messages;
import org.eclipse.wst.server.ui.internal.Trace;
import org.eclipse.wst.server.ui.internal.view.servers.ModuleServer;
import org.eclipse.wst.server.ui.internal.view.servers.RemoveModuleAction;

public class GlobalDeleteAction
extends SelectionProviderAction {
    protected IServer[] servers;
    protected IFolder[] configs;
    private Shell shell;

    public GlobalDeleteAction(Shell shell, ISelectionProvider selectionProvider) {
        super(selectionProvider, Messages.actionDelete);
        this.shell = shell;
        ISharedImages sharedImages = PlatformUI.getWorkbench().getSharedImages();
        this.setImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_DELETE"));
        this.setDisabledImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_DELETE_DISABLED"));
        this.setActionDefinitionId("org.eclipse.ui.edit.delete");
    }

    public void selectionChanged(IStructuredSelection sel) {
        if (sel.isEmpty()) {
            this.setEnabled(false);
            return;
        }
        boolean enabled = false;
        for (Object obj : sel) {
            if (obj instanceof IServer) {
                IServer server = (IServer)obj;
                if (!this.accept(server)) continue;
                enabled = true;
                continue;
            }
            if (obj instanceof ModuleServer) {
                ModuleServer ms = (ModuleServer)obj;
                if (!this.accept(ms)) continue;
                enabled = true;
                continue;
            }
            this.setEnabled(false);
            return;
        }
        this.setEnabled(enabled);
    }

    public boolean accept(ModuleServer ms) {
        if (ms.getServer() == null) {
            return false;
        }
        IStatus status = ms.getServer().canModifyModules(null, ms.module, null);
        return status.isOK();
    }

    public boolean accept(IServer server) {
        this.servers = new IServer[]{server};
        ArrayList<IFolder> list = new ArrayList<IFolder>();
        int size = this.servers.length;
        int i = 0;
        while (i < size) {
            if (this.servers[i].isReadOnly()) {
                return false;
            }
            if (this.servers[i].getServerConfiguration() != null) {
                list.add(this.servers[i].getServerConfiguration());
            }
            ++i;
        }
        IServer[] servers2 = ServerCore.getServers();
        if (servers2 != null) {
            int size2 = servers2.length;
            int j = 0;
            while (j < size2) {
                IFolder folder;
                boolean found = false;
                int i2 = 0;
                while (i2 < size) {
                    if (this.servers[i2].equals(servers2[j])) {
                        found = true;
                    }
                    ++i2;
                }
                if (!found && (folder = servers2[j].getServerConfiguration()) != null && list.contains(folder)) {
                    list.remove(folder);
                }
                ++j;
            }
        }
        this.configs = new IFolder[list.size()];
        list.toArray(this.configs);
        return true;
    }

    public void run() {
        IServer server = null;
        IModule[] moduleArray = null;
        IStructuredSelection sel = this.getStructuredSelection();
        if (!sel.isEmpty()) {
            Iterator iterator = sel.iterator();
            Object obj = iterator.next();
            if (obj instanceof IServer) {
                server = (IServer)obj;
            }
            if (obj instanceof ModuleServer) {
                ModuleServer ms = (ModuleServer)obj;
                server = ms.server;
                moduleArray = ms.module;
            }
            if (iterator.hasNext()) {
                server = null;
                moduleArray = null;
            }
        }
        if (server != null && moduleArray == null) {
            this.deleteServer(server);
        }
        if (moduleArray != null && moduleArray.length == 1) {
            new RemoveModuleAction(this.shell, server, (IModule)moduleArray[0]).run();
        }
    }

    protected void deleteServer(IServer server) {
        if (this.servers == null) {
            IStructuredSelection sel;
            if (Trace.FINEST) {
                Trace.trace("/finest", "Delete server called when servers is null");
            }
            if ((sel = this.getStructuredSelection()) != null) {
                this.selectionChanged(sel);
            }
        }
        if (Trace.FINEST) {
            Trace.trace("/finest", "Opening delete server dialog with parameters shell=" + this.shell + " servers=" + this.servers + " configs=" + this.configs);
        }
        DeleteServerDialog dsd = new DeleteServerDialog(this.shell, this.servers, this.configs);
        dsd.open();
    }
}

