/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.internal.common.classpath;

import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.core.IAccessRule;
import org.eclipse.jdt.core.IClasspathAttribute;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jst.common.jdt.internal.classpath.ClasspathDecorations;
import org.eclipse.jst.common.jdt.internal.classpath.ClasspathDecorationsManager;
import org.eclipse.jst.common.jdt.internal.javalite.IJavaProjectLite;
import org.eclipse.jst.common.jdt.internal.javalite.JavaCoreLite;
import org.eclipse.jst.j2ee.componentcore.J2EEModuleVirtualComponent;
import org.eclipse.jst.j2ee.internal.common.ClasspathLibraryExpander;
import org.eclipse.jst.j2ee.internal.common.J2EECommonMessages;
import org.eclipse.jst.j2ee.internal.common.classpath.J2EEComponentClasspathContainerStore;
import org.eclipse.jst.j2ee.internal.common.classpath.J2EEComponentClasspathContainerUtils;
import org.eclipse.jst.j2ee.internal.common.classpath.J2EEComponentClasspathUpdater;
import org.eclipse.jst.j2ee.internal.common.classpath.Messages;
import org.eclipse.jst.j2ee.internal.plugin.J2EEPlugin;
import org.eclipse.jst.j2ee.project.EarUtilities;
import org.eclipse.jst.j2ee.project.JavaEEProjectUtilities;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.internal.StructureEdit;
import org.eclipse.wst.common.componentcore.internal.builder.IDependencyGraph;
import org.eclipse.wst.common.componentcore.internal.flat.IFlatFolder;
import org.eclipse.wst.common.componentcore.internal.flat.IFlatResource;
import org.eclipse.wst.common.componentcore.internal.resources.VirtualArchiveComponent;
import org.eclipse.wst.common.componentcore.internal.resources.VirtualReference;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class J2EEComponentClasspathContainer
implements IClasspathContainer {
    public static final String CONTAINER_ID = "org.eclipse.jst.j2ee.internal.module.container";
    public static final IPath CONTAINER_PATH = new Path("org.eclipse.jst.j2ee.internal.module.container");
    private static IPath WEBLIB = new Path("/WEB-INF/lib");
    private static ClasspathDecorationsManager decorationsManager = new ClasspathDecorationsManager("org.eclipse.jst.j2ee");
    private static Map<String, Object> onlyManifestRefs = new HashMap<String, Object>();
    private IPath containerPath;
    private IJavaProject javaProject;
    private IJavaProjectLite javaProjectLite;
    private IClasspathEntry[] entries = new IClasspathEntry[0];
    private static Map<Integer, Integer> keys;
    private static int MAX_RETRIES;
    private static Map<Integer, Integer> retries;
    private LastUpdate lastUpdate = new LastUpdate();

    static {
        onlyManifestRefs.put("REQUESTED_REFERENCE_TYPE", J2EEModuleVirtualComponent.ONLY_MANIFEST_REFERENCES);
        keys = new Hashtable<Integer, Integer>();
        MAX_RETRIES = 10;
        retries = new Hashtable<Integer, Integer>();
    }

    public static ClasspathDecorationsManager getDecorationsManager() {
        return decorationsManager;
    }

    public J2EEComponentClasspathContainer(IPath path, IJavaProject javaProject) {
        this.containerPath = path;
        this.javaProject = javaProject;
        this.javaProjectLite = JavaCoreLite.create((IJavaProject)javaProject);
    }

    private boolean requiresUpdate() {
        IVirtualComponent component = ComponentCore.createComponent((IProject)this.javaProjectLite.getProject());
        if (component == null) {
            return false;
        }
        IVirtualReference[] refs = component.getReferences(onlyManifestRefs);
        if (refs.length == this.lastUpdate.baseRefCount) {
            int i = 0;
            while (i < this.lastUpdate.baseRefCount) {
                IVirtualComponent comp = null;
                comp = refs[i].getReferencedComponent();
                if (!this.lastUpdate.areSame(comp, i)) {
                    return true;
                }
                ++i;
            }
            List<IVirtualReference> earRefs = this.getBaseEARLibRefs(component);
            if (earRefs.size() != this.lastUpdate.baseLibRefCount) {
                return true;
            }
            ArrayList<IVirtualReference> refsList = new ArrayList<IVirtualReference>();
            HashSet<IVirtualComponent> refedComps = new HashSet<IVirtualComponent>();
            refedComps.add(component);
            int i2 = 0;
            while (i2 < refs.length) {
                refsList.add(refs[i2]);
                refedComps.add(refs[i2].getReferencedComponent());
                ++i2;
            }
            i2 = this.lastUpdate.baseRefCount;
            for (IVirtualReference earRef : earRefs) {
                IVirtualComponent comp = earRef.getReferencedComponent();
                if (refedComps.contains(comp)) continue;
                if (i2 == this.lastUpdate.refCount) {
                    return true;
                }
                refsList.add(earRef);
                refedComps.add(comp);
                if (!this.lastUpdate.areSame(comp, i2)) {
                    return true;
                }
                ++i2;
            }
            return i2 != this.lastUpdate.refCount;
        }
        return true;
    }

    /*
     * Unable to fully structure code
     */
    private void update(LastUpdate restoreState) {
        if (restoreState != null) {
            this.lastUpdate = restoreState;
            entriesList = new ArrayList<IClasspathEntry>();
            i = 0;
            while (i < LastUpdate.access$4(this.lastUpdate).length) {
                if (LastUpdate.access$4(this.lastUpdate)[i] != null) {
                    newEntry = this.createEntry(restoreState, i);
                    entriesList.add(newEntry);
                }
                ++i;
            }
            this.entries = new IClasspathEntry[entriesList.size()];
            i = 0;
            while (i < this.entries.length) {
                this.entries[i] = (IClasspathEntry)entriesList.get(i);
                ++i;
            }
            return;
        }
        component = ComponentCore.createComponent((IProject)this.javaProjectLite.getProject());
        if (component == null) {
            return;
        }
        key = null;
        if (!this.javaProjectLite.getProject().getFile(StructureEdit.MODULE_META_FILE_NAME).exists()) {
            hashCode = new Integer(this.javaProjectLite.getProject().hashCode());
            key = J2EEComponentClasspathContainer.keys.get(hashCode);
            if (key == null) {
                J2EEComponentClasspathContainer.keys.put(hashCode, hashCode);
                key = hashCode;
            }
            if ((retryCount = J2EEComponentClasspathContainer.retries.get(key)) == null) {
                retryCount = new Integer(1);
            } else {
                if (retryCount > J2EEComponentClasspathContainer.MAX_RETRIES) {
                    return;
                }
                retryCount = new Integer(retryCount + 1);
            }
            J2EEComponentClasspathContainer.retries.put(key, retryCount);
            J2EEComponentClasspathUpdater.getInstance().queueUpdate(this.javaProjectLite.getProject());
            return;
        }
        refs = component.getReferences(J2EEComponentClasspathContainer.onlyManifestRefs);
        refsList = new ArrayList<IVirtualReference>();
        refedComps = new HashSet<IVirtualComponent>();
        refedComps.add(component);
        var10_12 = refs;
        var9_13 = refs.length;
        var8_16 = 0;
        while (var8_16 < var9_13) {
            ref = var10_12[var8_16];
            if (ref.getDependencyType() == 0) {
                refsList.add(ref);
                refedComps.add(ref.getReferencedComponent());
            }
            ++var8_16;
        }
        LastUpdate.access$5(this.lastUpdate, refsList.size());
        earLibReferences = this.getBaseEARLibRefs(component);
        LastUpdate.access$6(this.lastUpdate, earLibReferences.size());
        for (IVirtualReference earRef : earLibReferences) {
            earRefComp = earRef.getReferencedComponent();
            if (refedComps.contains(earRefComp)) continue;
            refsList.add(earRef);
            refedComps.add(earRefComp);
        }
        i = 0;
        while (i < refsList.size()) {
            comp = ((IVirtualReference)refsList.get(i)).getReferencedComponent();
            if (comp.isBinary()) {
                binaryRefs = comp.getReferences();
                j = 0;
                while (j < binaryRefs.length) {
                    if (!refedComps.contains(binaryRefs[j].getReferencedComponent())) {
                        refsList.add(binaryRefs[j]);
                        refedComps.add(binaryRefs[j].getReferencedComponent());
                    }
                    ++j;
                }
            }
            ++i;
        }
        LastUpdate.access$7(this.lastUpdate, refsList.size());
        LastUpdate.access$8(this.lastUpdate, new boolean[LastUpdate.access$3(this.lastUpdate)]);
        LastUpdate.access$9(this.lastUpdate, new IPath[LastUpdate.access$3(this.lastUpdate)]);
        isWeb = JavaEEProjectUtilities.isDynamicWebProject(component.getProject());
        shouldAdd = true;
        entriesList = new ArrayList<IClasspathEntry>();
        try {
            useJDTToControlExport = J2EEComponentClasspathContainerUtils.getDefaultUseEARLibrariesJDTExport();
            if (useJDTToControlExport) {
                rawEntries = this.javaProjectLite.readRawClasspath();
                i = 0;
                while (i < rawEntries.length) {
                    entry = rawEntries[i];
                    if (entry.getEntryKind() == 5 && entry.getPath().equals((Object)J2EEComponentClasspathContainer.CONTAINER_PATH)) {
                        LastUpdate.access$10(this.lastUpdate, entry.isExported());
                        break;
                    }
                    ++i;
                }
            }
            ref = null;
            comp = null;
            i = 0;
            while (i < refsList.size()) {
                ref = (IVirtualReference)refsList.get(i);
                comp = ref.getReferencedComponent();
                LastUpdate.access$11((LastUpdate)this.lastUpdate)[i] = comp.isBinary();
                v0 = shouldAdd = isWeb == false || ref.getRuntimePath().equals((Object)J2EEComponentClasspathContainer.WEBLIB) == false;
                if (shouldAdd) {
                    if (LastUpdate.access$11(this.lastUpdate)[i]) {
                        if (!(comp instanceof VirtualArchiveComponent) || !(archiveComp = (VirtualArchiveComponent)comp).getArchiveType().equals("cpe")) {
                            LastUpdate.access$4((LastUpdate)this.lastUpdate)[i] = (IPath)comp.getAdapter(IPath.class);
                            newEntry = this.createEntry(this.lastUpdate, i);
                            entriesList.add(newEntry);
                        }
                    } else {
                        project = comp.getProject();
                        LastUpdate.access$4((LastUpdate)this.lastUpdate)[i] = project.getFullPath();
                        newEntry = this.createEntry(this.lastUpdate, i);
                        entriesList.add(newEntry);
                    }
                }
                ++i;
            }
        }
        finally {
            this.entries = new IClasspathEntry[entriesList.size()];
            i = 0;
            ** while (i < this.entries.length)
        }
lbl-1000:
        // 1 sources

        {
            this.entries[i] = (IClasspathEntry)entriesList.get(i);
            ++i;
            continue;
        }
lbl133:
        // 1 sources

        J2EEComponentClasspathContainerStore.saveState(this.javaProjectLite.getProject().getName(), this.lastUpdate);
    }

    private IClasspathEntry createEntry(LastUpdate lastUpdate, int index) {
        if (lastUpdate.isBinary[index]) {
            ClasspathDecorations dec = decorationsManager.getDecorations(this.getPath().toString(), lastUpdate.paths[index].toString());
            IPath srcpath = null;
            IPath srcrootpath = null;
            IClasspathAttribute[] attrs = new IClasspathAttribute[]{};
            IAccessRule[] access = new IAccessRule[]{};
            if (dec != null) {
                srcpath = dec.getSourceAttachmentPath();
                srcrootpath = dec.getSourceAttachmentRootPath();
                attrs = dec.getExtraAttributes();
            }
            IClasspathEntry newEntry = JavaCoreLite.newLibraryEntry((IPath)lastUpdate.paths[index], (IPath)srcpath, (IPath)srcrootpath, (IAccessRule[])access, (IClasspathAttribute[])attrs, (boolean)lastUpdate.exportEntries);
            return newEntry;
        }
        IClasspathEntry newEntry = JavaCoreLite.newProjectEntry((IPath)lastUpdate.paths[index], (boolean)lastUpdate.exportEntries);
        return newEntry;
    }

    private List<IVirtualReference> getBaseEARLibRefs(IVirtualComponent component) {
        IVirtualComponent[] referencingList;
        ArrayList<IVirtualReference> libRefs = new ArrayList<IVirtualReference>();
        IVirtualComponent[] iVirtualComponentArray = referencingList = component.getReferencingComponents();
        int n = referencingList.length;
        int n2 = 0;
        while (n2 < n) {
            IVirtualComponent earComp;
            String libDir;
            IVirtualComponent referencingComp = iVirtualComponentArray[n2];
            if (EarUtilities.isEARProject(referencingComp.getProject()) && (libDir = EarUtilities.getEARLibDir(earComp = referencingComp)) != null && libDir.trim().length() != 0) {
                IPath libDirPath = new Path(libDir).makeRelative();
                IVirtualReference ref = earComp.getReference(component.getName());
                if (ref != null) {
                    IVirtualReference[] earRefs;
                    IPath refPath = ref.getRuntimePath();
                    String archiveName = ref.getArchiveName();
                    if (archiveName != null && (refPath = refPath.append(archiveName)).segmentCount() > 0) {
                        refPath = refPath.removeLastSegments(1);
                    }
                    refPath = refPath.makeRelative();
                    boolean onlyBinary = false;
                    if (libDirPath.equals((Object)refPath)) {
                        onlyBinary = true;
                    }
                    IVirtualReference[] iVirtualReferenceArray = earRefs = earComp.getReferences();
                    int n3 = earRefs.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IVirtualReference earRef = iVirtualReferenceArray[n4];
                        if (earRef.getDependencyType() == 0) {
                            IPath runtimePath = earRef.getRuntimePath().makeRelative();
                            boolean isInLibDir = libDirPath.equals((Object)runtimePath);
                            if (!isInLibDir) {
                                IPath fullPath = earRef.getRuntimePath().append(earRef.getArchiveName());
                                isInLibDir = fullPath.removeLastSegments(1).makeRelative().equals((Object)libDirPath);
                            }
                            if (isInLibDir && (!onlyBinary || onlyBinary && earRef.getReferencedComponent().isBinary())) {
                                libRefs.add(earRef);
                            }
                        }
                        ++n4;
                    }
                    try {
                        ClasspathLibraryExpander classpathLibExpander = new ClasspathLibraryExpander(earComp);
                        IFlatResource flatLibResource = classpathLibExpander.fetchResource(libDirPath);
                        if (flatLibResource instanceof IFlatFolder) {
                            IFlatResource[] flatLibs;
                            IFlatFolder flatLibFolder = (IFlatFolder)flatLibResource;
                            IFlatResource[] iFlatResourceArray = flatLibs = flatLibFolder.members();
                            int n5 = flatLibs.length;
                            int n6 = 0;
                            while (n6 < n5) {
                                IFlatResource flatResource = iFlatResourceArray[n6];
                                File file = (File)flatResource.getAdapter(File.class);
                                if (file != null) {
                                    VirtualArchiveComponent dynamicComponent = new VirtualArchiveComponent(earComp.getProject(), "lib/" + file.getAbsolutePath(), (IPath)new Path(libDir));
                                    IVirtualReference dynamicRef = ComponentCore.createReference((IVirtualComponent)earComp, (IVirtualComponent)dynamicComponent);
                                    ((VirtualReference)dynamicRef).setDerived(true);
                                    dynamicRef.setArchiveName(file.getName());
                                    libRefs.add(dynamicRef);
                                }
                                ++n6;
                            }
                        }
                    }
                    catch (CoreException e) {
                        J2EEPlugin.logError(e);
                    }
                }
            }
            ++n2;
        }
        return libRefs;
    }

    public static J2EEComponentClasspathContainer install(IPath containerPath, IJavaProject javaProject, LastUpdate restoreState) {
        try {
            J2EEComponentClasspathUpdater.getInstance().pauseUpdates();
            IJavaProject[] projects = new IJavaProject[]{javaProject};
            J2EEComponentClasspathContainer container = new J2EEComponentClasspathContainer(containerPath, javaProject);
            container.update(restoreState);
            IClasspathContainer[] conts = new IClasspathContainer[]{container};
            try {
                JavaCore.setClasspathContainer((IPath)containerPath, (IJavaProject[])projects, (IClasspathContainer[])conts, null);
            }
            catch (JavaModelException e) {
                J2EEPlugin.logError((CoreException)((Object)e));
            }
            J2EEComponentClasspathContainer j2EEComponentClasspathContainer = container;
            return j2EEComponentClasspathContainer;
        }
        finally {
            J2EEComponentClasspathUpdater.getInstance().resumeUpdates();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void install(IPath containerPath, IJavaProject javaProject) {
        String projectName = javaProject.getProject().getName();
        LastUpdate restoreState = J2EEComponentClasspathContainerStore.getRestoreState(projectName);
        boolean needToVerify = false;
        if (restoreState != null) {
            LastUpdate lastUpdate = restoreState;
            synchronized (lastUpdate) {
                needToVerify = restoreState.needToVerify;
                restoreState.needToVerify = false;
            }
        }
        final J2EEComponentClasspathContainer container = J2EEComponentClasspathContainer.install(containerPath, javaProject, restoreState);
        if (needToVerify) {
            Job verifyJob = new Job(Messages.J2EEComponentClasspathUpdater_Verify_EAR_Libraries){

                protected IStatus run(IProgressMonitor monitor) {
                    container.refresh();
                    return Status.OK_STATUS;
                }
            };
            verifyJob.setSystem(true);
            verifyJob.setRule((ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot());
            verifyJob.schedule();
        }
    }

    public void refresh(boolean force) {
        if (!force && IDependencyGraph.INSTANCE.isStale()) {
            J2EEComponentClasspathUpdater.getInstance().queueUpdate(this.javaProject.getProject());
            return;
        }
        if (force || this.requiresUpdate()) {
            J2EEComponentClasspathContainer.install(this.containerPath, this.javaProject, null);
        }
    }

    public void refresh() {
        this.refresh(false);
    }

    public IClasspathEntry[] getClasspathEntries() {
        return this.entries;
    }

    public String getDescription() {
        return J2EECommonMessages.J2EE_MODULE_CLASSPATH_CONTAINER_NAME;
    }

    public int getKind() {
        return 1;
    }

    public IPath getPath() {
        return this.containerPath;
    }

    static class LastUpdate
    implements Serializable {
        private static final long serialVersionUID = 362498820763181265L;
        private boolean exportEntries = true;
        private int baseRefCount = 0;
        private int baseLibRefCount = 0;
        private int refCount = 0;
        private boolean[] isBinary = new boolean[this.refCount];
        private transient IPath[] paths = new IPath[this.refCount];
        transient boolean needToVerify = true;
        private String[] pathStrings = null;

        LastUpdate() {
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null) {
                return false;
            }
            if (o instanceof LastUpdate) {
                LastUpdate other = (LastUpdate)o;
                if (this.exportEntries != other.exportEntries) {
                    return false;
                }
                if (this.baseRefCount != other.baseRefCount) {
                    return false;
                }
                if (this.baseLibRefCount != other.baseLibRefCount) {
                    return false;
                }
                if (this.refCount != other.refCount) {
                    return false;
                }
                if (this.isBinary.length != other.isBinary.length) {
                    return false;
                }
                if (this.paths.length != other.paths.length) {
                    return false;
                }
                int i = 0;
                while (i < this.isBinary.length) {
                    if (this.isBinary[i] != other.isBinary[i]) {
                        return false;
                    }
                    ++i;
                }
                i = 0;
                while (i < this.paths.length) {
                    if (this.paths[i] == null && other.paths[i] != null) {
                        return false;
                    }
                    if (!this.paths[i].equals((Object)other.paths[i])) {
                        return false;
                    }
                    ++i;
                }
                return true;
            }
            return false;
        }

        public int hashCode() {
            return 3 * this.baseRefCount + 5 * this.baseLibRefCount + 7 * this.refCount + 11 * this.isBinary.length;
        }

        private void writeObject(ObjectOutputStream out) throws IOException {
            this.pathStrings = new String[this.refCount];
            int i = 0;
            while (i < this.paths.length) {
                if (this.paths[i] != null) {
                    this.pathStrings[i] = this.paths[i].toString();
                }
                ++i;
            }
            out.defaultWriteObject();
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            in.defaultReadObject();
            this.needToVerify = true;
            this.paths = new IPath[this.refCount];
            int i = 0;
            while (i < this.pathStrings.length) {
                if (this.pathStrings[i] != null) {
                    this.paths[i] = new Path(this.pathStrings[i]);
                }
                ++i;
            }
        }

        private boolean areSame(IVirtualComponent comp, int i) {
            if (comp.isBinary() != this.isBinary[i]) {
                return false;
            }
            IPath path = null;
            path = comp.isBinary() ? (IPath)comp.getAdapter(IPath.class) : comp.getProject().getFullPath();
            return path.equals((Object)this.paths[i]);
        }

        static /* synthetic */ void access$5(LastUpdate lastUpdate, int n) {
            lastUpdate.baseRefCount = n;
        }

        static /* synthetic */ void access$6(LastUpdate lastUpdate, int n) {
            lastUpdate.baseLibRefCount = n;
        }

        static /* synthetic */ void access$7(LastUpdate lastUpdate, int n) {
            lastUpdate.refCount = n;
        }

        static /* synthetic */ void access$8(LastUpdate lastUpdate, boolean[] blArray) {
            lastUpdate.isBinary = blArray;
        }

        static /* synthetic */ void access$9(LastUpdate lastUpdate, IPath[] iPathArray) {
            lastUpdate.paths = iPathArray;
        }

        static /* synthetic */ void access$10(LastUpdate lastUpdate, boolean bl) {
            lastUpdate.exportEntries = bl;
        }
    }
}

