/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.ws.internal.explorer.platform.engine.transformer;

import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.wst.ws.internal.explorer.platform.engine.transformer.NodeIdTransformer;
import org.eclipse.wst.ws.internal.explorer.platform.perspective.Controller;

public class MassNodeIdTransformer
extends NodeIdTransformer {
    protected String massNodeIdKey;

    public MassNodeIdTransformer(Controller controller, String massNodeIdKey) {
        super(controller);
        this.massNodeIdKey = massNodeIdKey;
    }

    public Hashtable normalize(Hashtable properties) {
        if (!properties.containsKey(this.massNodeIdKey)) {
            return super.normalize(properties);
        }
        Object origNodeId = properties.get("nodeId");
        String[] massNodeIds = this.getValueAsStringArray(properties, this.massNodeIdKey);
        int i = 0;
        while (i < massNodeIds.length) {
            properties.put("nodeId", massNodeIds[i]);
            properties = super.normalize(properties);
            String[] rels = this.getValueAsStringArray(properties, "relationshipId");
            if (rels.length > 0) {
                StringBuffer sb = new StringBuffer("relationshipId");
                sb.append("#");
                sb.append(massNodeIds[i]);
                properties.put(sb.toString(), rels);
            }
            properties.remove("nodeId");
            properties.remove("relationshipId");
            ++i;
        }
        if (origNodeId != null) {
            properties.put("nodeId", origNodeId);
        }
        return properties;
    }

    public Hashtable deNormalize(Hashtable properties) {
        int size;
        if (!properties.containsKey(this.massNodeIdKey)) {
            return super.deNormalize(properties);
        }
        Vector massNodeIdVector = new Vector();
        Object origNodeId = properties.get("nodeId");
        properties.remove("nodeId");
        String[] massNodeIds = this.getValueAsStringArray(properties, this.massNodeIdKey);
        int i = 0;
        while (i < massNodeIds.length) {
            StringBuffer sb = new StringBuffer("relationshipId");
            sb.append("#");
            sb.append(massNodeIds[i]);
            Object rels = properties.get(sb.toString());
            if (rels != null) {
                properties.put("relationshipId", rels);
                properties = super.deNormalize(properties);
                Object nodeId = properties.get("nodeId");
                if (nodeId != null) {
                    massNodeIdVector.add(nodeId);
                    properties.remove("nodeId");
                }
                properties.remove("relationshipId");
            }
            ++i;
        }
        if (origNodeId != null) {
            properties.put("nodeId", origNodeId);
        }
        if ((size = massNodeIdVector.size()) == 1) {
            properties.put(this.massNodeIdKey, massNodeIdVector.get(0));
        } else if (size > 1) {
            properties.put(this.massNodeIdKey, massNodeIdVector.toArray(new String[0]));
        } else {
            properties.remove(this.massNodeIdKey);
        }
        return properties;
    }

    private String[] getValueAsStringArray(Hashtable properties, String key) {
        Object values = properties.get(key);
        if (values == null) {
            return new String[0];
        }
        if (values instanceof String[]) {
            return (String[])values;
        }
        return new String[]{values.toString()};
    }
}

