/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.internal.emfworkbench.integration;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jem.util.logger.proxy.Logger;
import org.eclipse.wst.common.internal.emfworkbench.integration.ModifierHelper;
import org.eclipse.wst.common.internal.emfworkbench.integration.ModifierHelperFactory;

public class ModifierHelperRegistry {
    private static final String PLUGIN_ID = "org.eclipse.wst.common.internal.emfworkbench.integration";
    private static final String EXTENSION_POINT = "ModifierHelperFactory";
    private static final String FACTORY_CLASS = "class";
    private static final String PACKAGE = "package";
    private static final String PACKAGE_URI = "uri";
    private static final String NAME = "name";
    private static final String TYPE = "type";
    private static final String FEATURE = "feature";
    private static final String FEATURE_ACTION = "action";
    private static final String FEATURE_ACTION_SET = "set";
    private static final String FEATURE_ACTION_UNSET = "unset";
    private static final String FEATURE_ACTION_BOTH = "both";
    private static ModifierHelperRegistry INSTANCE = null;
    private Hashtable featureHash = new Hashtable();
    private Hashtable factoryHash = new Hashtable();

    private ModifierHelperRegistry() {
        this.readExtensions();
    }

    private void readExtensions() {
        IExtensionPoint point = Platform.getExtensionRegistry().getExtensionPoint(PLUGIN_ID, EXTENSION_POINT);
        if (point == null) {
            return;
        }
        IConfigurationElement[] elements = point.getConfigurationElements();
        int i = 0;
        while (i < elements.length) {
            this.readFactory(elements[i]);
            ++i;
        }
    }

    private void readFactory(IConfigurationElement element) {
        IConfigurationElement[] packages;
        String factoryClassName = element.getAttribute(FACTORY_CLASS);
        if (factoryClassName == null) {
            ModifierHelperRegistry.logError(element, "No class defined.");
        }
        if ((packages = element.getChildren(PACKAGE)).length == 0) {
            ModifierHelperRegistry.logError(element, "No package defined.");
        }
        int j = 0;
        while (j < packages.length) {
            this.readPackage(element, packages[j]);
            ++j;
        }
    }

    private void readPackage(IConfigurationElement factoryElement, IConfigurationElement element) {
        String packageURI = element.getAttribute(PACKAGE_URI);
        if (packageURI == null) {
            ModifierHelperRegistry.logError(element, "No uri defined.");
            return;
        }
        EPackage ePackage = EPackage.Registry.INSTANCE.getEPackage(packageURI);
        if (ePackage == null) {
            ModifierHelperRegistry.logError(element, "package " + packageURI + " can not be found.");
            return;
        }
        IConfigurationElement[] types = element.getChildren(TYPE);
        if (types.length == 0) {
            ModifierHelperRegistry.logError(element, "No type defined.");
        }
        int i = 0;
        while (i < types.length) {
            this.readType(factoryElement, ePackage, types[i]);
            ++i;
        }
    }

    private void readType(IConfigurationElement factoryElement, EPackage ePackage, IConfigurationElement element) {
        String typeName = element.getAttribute(NAME);
        if (typeName == null) {
            ModifierHelperRegistry.logError(element, "No name defined.");
            return;
        }
        EClassifier eClassifier = ePackage.getEClassifier(typeName);
        if (eClassifier == null) {
            ModifierHelperRegistry.logError(element, "type " + typeName + " can not be found in " + PACKAGE + " " + ePackage.getName());
            return;
        }
        EClass eClass = (EClass)eClassifier;
        IConfigurationElement[] features = element.getChildren(FEATURE);
        if (features.length == 0) {
            ModifierHelperRegistry.logError(element, "No feature defined.");
            return;
        }
        int i = 0;
        while (i < features.length) {
            this.readFeature(factoryElement, eClass, features[i]);
            ++i;
        }
    }

    private void readFeature(IConfigurationElement factoryElement, EClass eClass, IConfigurationElement element) {
        FactoryHolder factoryHolder;
        String featureName = element.getAttribute(NAME);
        if (featureName == null) {
            ModifierHelperRegistry.logError(element, "No name defined.");
            return;
        }
        String action = element.getAttribute(FEATURE_ACTION);
        if (action == null) {
            action = FEATURE_ACTION_BOTH;
        }
        int actionType = -1;
        if (action.equalsIgnoreCase(FEATURE_ACTION_BOTH)) {
            actionType = 2;
        } else if (action.equalsIgnoreCase(FEATURE_ACTION_SET)) {
            actionType = 0;
        } else if (action.equalsIgnoreCase(FEATURE_ACTION_UNSET)) {
            actionType = 1;
        }
        if (actionType == -1) {
            ModifierHelperRegistry.logError(element, "Invalid action=" + action + " defined.  Valid values are: " + FEATURE_ACTION_BOTH + ", " + FEATURE_ACTION_SET + ", or " + FEATURE_ACTION_UNSET);
            return;
        }
        EStructuralFeature feature = null;
        EList allFeatures = eClass.getEAllStructuralFeatures();
        EStructuralFeature tempFeature = null;
        Iterator iterator = allFeatures.iterator();
        while (feature == null && iterator.hasNext()) {
            tempFeature = (EStructuralFeature)iterator.next();
            if (!tempFeature.getName().equals(featureName)) continue;
            feature = tempFeature;
        }
        if (feature == null) {
            ModifierHelperRegistry.logError(element, "feature " + featureName + " can not be found in " + TYPE + " " + eClass.getName());
            return;
        }
        ArrayList<FactoryHolder> factoryHolderList = (ArrayList<FactoryHolder>)this.featureHash.get(feature);
        if (factoryHolderList == null) {
            factoryHolderList = new ArrayList<FactoryHolder>();
            this.featureHash.put(feature, factoryHolderList);
        }
        if (factoryHolderList.contains(factoryHolder = new FactoryHolder(factoryElement, actionType))) {
            ModifierHelperRegistry.logError(element, "Duplicatefeature:" + featureName + " defined for " + FACTORY_CLASS + ":" + factoryElement.getAttribute(FACTORY_CLASS));
            return;
        }
        factoryHolderList.add(factoryHolder);
    }

    private String getFactoryHash(IConfigurationElement factoryElement) {
        return String.valueOf(factoryElement.getDeclaringExtension().getNamespace()) + factoryElement.getAttribute(FACTORY_CLASS);
    }

    public static void logError(IConfigurationElement element, String text) {
        IExtension extension = element.getDeclaringExtension();
        StringBuffer buf = new StringBuffer();
        buf.append("Plugin " + extension.getNamespace() + ", extension " + extension.getExtensionPointUniqueIdentifier());
        buf.append("\n" + text);
        Logger.getLogger().logError(buf.toString());
    }

    public static ModifierHelperRegistry getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new ModifierHelperRegistry();
        }
        return INSTANCE;
    }

    public List getHelpers(ModifierHelper baseHelper) {
        int actionFlag = baseHelper.shouldUnsetValue() ? 1 : 0;
        EStructuralFeature feature = baseHelper.getFeature();
        List factoryList = this.getFactories(feature, actionFlag);
        if (factoryList == null) {
            return null;
        }
        ArrayList<ModifierHelper> helpers = new ArrayList<ModifierHelper>();
        Iterator it = factoryList.iterator();
        ModifierHelperFactory factory = null;
        while (it.hasNext()) {
            factory = (ModifierHelperFactory)it.next();
            ModifierHelper helper = factory.getHelper(baseHelper, actionFlag);
            if (helper == null) continue;
            helpers.add(helper);
        }
        return helpers;
    }

    private List getFactories(EStructuralFeature feature, int actionFlag) {
        List factoryHolderList = (List)this.featureHash.get(feature);
        if (factoryHolderList == null) {
            return null;
        }
        ArrayList<ModifierHelperFactory> factoryList = new ArrayList<ModifierHelperFactory>();
        ModifierHelperFactory factory = null;
        int i = 0;
        while (i < factoryHolderList.size()) {
            factory = ((FactoryHolder)factoryHolderList.get(i)).getFactory(actionFlag);
            if (factory != null) {
                factoryList.add(factory);
            }
            ++i;
        }
        return factoryList;
    }

    private class FactoryHolder {
        private int actionType;
        private IConfigurationElement element;

        public FactoryHolder(IConfigurationElement element, int actionType) {
            this.element = element;
            this.actionType = actionType;
        }

        public ModifierHelperFactory getFactory(int actionTypeArg) {
            if (this.actionType == actionTypeArg || this.actionType == 2) {
                String hashKey = ModifierHelperRegistry.this.getFactoryHash(this.element);
                ModifierHelperFactory factory = (ModifierHelperFactory)ModifierHelperRegistry.this.factoryHash.get(hashKey);
                if (factory == null) {
                    try {
                        factory = (ModifierHelperFactory)this.element.createExecutableExtension(ModifierHelperRegistry.FACTORY_CLASS);
                        ModifierHelperRegistry.this.factoryHash.put(hashKey, factory);
                    }
                    catch (CoreException e) {
                        Logger.getLogger().logError((Throwable)e);
                    }
                }
                return factory;
            }
            return null;
        }

        public boolean equals(Object obj) {
            if (super.equals(obj)) {
                return true;
            }
            FactoryHolder holder = (FactoryHolder)obj;
            return ModifierHelperRegistry.this.getFactoryHash(this.element).equals(ModifierHelperRegistry.this.getFactoryHash(holder.element));
        }
    }
}

