/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jem.util.logger.proxy;

import java.util.logging.Level;
import org.eclipse.jem.util.logger.proxy.ILogRenderer2;
import org.eclipse.jem.util.logger.proxy.Logger;

public class JDKConsoleRenderer
implements ILogRenderer2 {
    private boolean fTraceMode = false;
    private boolean fSettingTrace = false;
    private Logger fMyLogger = null;

    public JDKConsoleRenderer(Logger logger) {
        this.fMyLogger = logger;
        this.fTraceMode = this.fMyLogger.getTraceMode();
    }

    public String log(String msg, int type) {
        if (type == 1 && !this.fTraceMode) {
            return null;
        }
        if (type == 0) {
            System.err.println(msg);
        } else {
            System.out.println(msg);
        }
        return "console";
    }

    public void setTraceMode(boolean flag) {
        if (this.fSettingTrace) {
            return;
        }
        this.fSettingTrace = true;
        this.fTraceMode = flag;
        this.fMyLogger.setTraceMode(flag);
        this.fSettingTrace = false;
    }

    protected String log(String msg, Level level) {
        if (level == Level.SEVERE) {
            System.err.println(msg);
        } else {
            System.out.println(msg);
        }
        return "console";
    }

    protected boolean isLogging(Level logLevel) {
        return this.fTraceMode || this.fMyLogger.isLoggingLevel(logLevel);
    }

    public String log(boolean b, Level level) {
        if (level == DEFAULT) {
            level = Level.FINEST;
        }
        if (this.isLogging(level)) {
            return this.log(this.fMyLogger.getGenericMsg(String.valueOf(b), level), level);
        }
        return "";
    }

    public String log(byte b, Level level) {
        if (level == DEFAULT) {
            level = Level.FINEST;
        }
        if (this.isLogging(level)) {
            return this.log(this.fMyLogger.getGenericMsg(String.valueOf(b), level), level);
        }
        return "";
    }

    public String log(char c, Level level) {
        if (level == DEFAULT) {
            level = Level.FINEST;
        }
        if (this.isLogging(level)) {
            return this.log(this.fMyLogger.getGenericMsg(String.valueOf(c), level), level);
        }
        return "";
    }

    public String log(double d, Level level) {
        if (level == DEFAULT) {
            level = Level.FINEST;
        }
        if (this.isLogging(level)) {
            return this.log(this.fMyLogger.getGenericMsg(String.valueOf(d), level), level);
        }
        return "";
    }

    public String log(float f, Level level) {
        if (level == DEFAULT) {
            level = Level.FINEST;
        }
        if (this.isLogging(level)) {
            return this.log(this.fMyLogger.getGenericMsg(String.valueOf(f), level), level);
        }
        return "";
    }

    public String log(int i, Level level) {
        if (level == DEFAULT) {
            level = Level.FINEST;
        }
        if (this.isLogging(level)) {
            return this.log(this.fMyLogger.getGenericMsg(String.valueOf(i), level), level);
        }
        return "";
    }

    public String log(long l, Level level) {
        if (level == DEFAULT) {
            level = Level.FINEST;
        }
        if (this.isLogging(level)) {
            return this.log(this.fMyLogger.getGenericMsg(String.valueOf(l), level), level);
        }
        return "";
    }

    public String log(Object o, Level level) {
        if (level == DEFAULT) {
            level = Level.FINEST;
        }
        if (this.isLogging(level)) {
            return this.log(this.fMyLogger.getGenericMsg(String.valueOf(o), level), level);
        }
        return "";
    }

    public String log(short s, Level level) {
        if (level == DEFAULT) {
            level = Level.FINEST;
        }
        if (this.isLogging(level)) {
            return this.log(this.fMyLogger.getGenericMsg(String.valueOf(s), level), level);
        }
        return "";
    }

    public String log(Throwable t, Level level) {
        if (level == DEFAULT) {
            level = Level.SEVERE;
        }
        if (this.isLogging(level)) {
            return this.log(this.fMyLogger.getGenericMsg(this.fMyLogger.exceptionToString(t), level), level);
        }
        return "";
    }
}

