/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.ws.internal.explorer.platform.wsdl.datamodel;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import javax.wsdl.Binding;
import javax.wsdl.Input;
import javax.wsdl.Operation;
import javax.wsdl.Output;
import javax.wsdl.PortType;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.http.HTTPBinding;
import javax.wsdl.extensions.soap.SOAPBinding;
import javax.xml.namespace.QName;
import org.eclipse.wst.ws.internal.datamodel.Element;
import org.eclipse.wst.ws.internal.datamodel.Model;
import org.eclipse.wst.ws.internal.explorer.platform.wsdl.datamodel.Endpoint;
import org.eclipse.wst.ws.internal.explorer.platform.wsdl.datamodel.WSDLCommonElement;
import org.eclipse.wst.ws.internal.explorer.platform.wsdl.datamodel.WSDLOperationElement;
import org.eclipse.wst.ws.internal.explorer.platform.wsdl.datamodel.WSDLServiceElement;

public class WSDLBindingElement
extends WSDLCommonElement {
    private int bindingType_;
    private Binding binding_;
    private ExtensibilityElement bindingExtensibilityElement_;
    private Vector endPoints_;

    private final void setBindingExtensibilityElement() {
        this.bindingExtensibilityElement_ = null;
        this.bindingType_ = -1;
        List extensibilityElements = this.binding_.getExtensibilityElements();
        for (ExtensibilityElement e : extensibilityElements) {
            if (e instanceof HTTPBinding) {
                HTTPBinding binding = (HTTPBinding)e;
                String verb = binding.getVerb();
                if ("GET".equals(verb)) {
                    this.bindingType_ = 1;
                } else if ("POST".equals(verb)) {
                    this.bindingType_ = 2;
                }
            } else if (e instanceof SOAPBinding) {
                this.bindingType_ = 0;
            }
            if (this.bindingType_ == -1) continue;
            this.bindingExtensibilityElement_ = e;
            break;
        }
    }

    public WSDLBindingElement(String name, Model model, Binding binding) {
        super(name, model);
        this.setBinding(binding);
        this.endPoints_ = new Vector();
    }

    public void setBinding(Binding binding) {
        this.binding_ = binding;
        this.setDocumentation(binding.getDocumentationElement());
        this.setBindingExtensibilityElement();
    }

    public Binding getBinding() {
        return this.binding_;
    }

    public ExtensibilityElement getBindingExtensibilityElement() {
        return this.bindingExtensibilityElement_;
    }

    public int getBindingType() {
        return this.bindingType_;
    }

    private void resetEndPoints() {
        WSDLServiceElement serviceElement = (WSDLServiceElement)this.getParentElement();
        String fixedEndpointString = serviceElement.getAddressLocation(this.binding_);
        Endpoint fixedEndpoint = this.getEndpoint(fixedEndpointString);
        if (fixedEndpoint == null) {
            fixedEndpoint = new Endpoint();
            fixedEndpoint.setEndpoint(fixedEndpointString);
        }
        this.endPoints_.clear();
        this.endPoints_.add(fixedEndpoint);
    }

    public String[] getEndPoints() {
        String[] endPoints = new String[this.endPoints_.size()];
        int i = 0;
        while (i < endPoints.length) {
            endPoints[i] = ((Endpoint)this.endPoints_.get(i)).getEndpoint();
            ++i;
        }
        return endPoints;
    }

    public Endpoint getEndpoint(String endpointString) {
        if (endpointString != null && endpointString.length() > 0) {
            for (Endpoint endpoint : this.endPoints_) {
                if (!endpointString.equals(endpoint.getEndpoint())) continue;
                return endpoint;
            }
        }
        return null;
    }

    public void setEndPoints(String[] endpoints) {
        Vector<Endpoint> endpointVector = new Vector<Endpoint>();
        int i = 0;
        while (i < endpoints.length) {
            Endpoint endpoint = this.getEndpoint(endpoints[i]);
            if (endpoint == null) {
                endpoint = new Endpoint();
                endpoint.setEndpoint(endpoints[i]);
            }
            endpointVector.add(endpoint);
            ++i;
        }
        this.resetEndPoints();
        this.endPoints_.addAll(endpointVector);
    }

    public void addEndPoint(String endpointString) {
        if (endpointString != null && endpointString.length() > 0) {
            Endpoint endpoint = new Endpoint();
            endpoint.setEndpoint(endpointString);
            this.endPoints_.add(endpoint);
        }
    }

    public void removeEndPoint(String endpointString) {
        WSDLServiceElement serviceElement;
        String fixedEndpointString;
        if (!(endpointString == null || endpointString.length() <= 0 || (fixedEndpointString = (serviceElement = (WSDLServiceElement)this.getParentElement()).getAddressLocation(this.binding_)) != null && fixedEndpointString.equals(endpointString))) {
            int i = 0;
            while (i < this.endPoints_.size()) {
                if (endpointString.equals(((Endpoint)this.endPoints_.get(i)).getEndpoint())) {
                    this.endPoints_.remove(i);
                    break;
                }
                ++i;
            }
        }
    }

    public void buildModel() {
        PortType pt;
        this.resetEndPoints();
        if (this.binding_ != null && (pt = this.binding_.getPortType()) != null) {
            List operations = pt.getOperations();
            HashMap<String, Operation> operationsMap = new HashMap<String, Operation>();
            for (Operation operation : operations) {
                operationsMap.put(this.createOperationUniqueName(operation), operation);
            }
            WSDLOperationElement[] wsdlOperationElements = new WSDLOperationElement[this.getNumberOfElements("relWSDLOperation")];
            Enumeration e = this.getElements("relWSDLOperation");
            int i = 0;
            while (i < wsdlOperationElements.length) {
                wsdlOperationElements[i] = (WSDLOperationElement)((Object)e.nextElement());
                ++i;
            }
            int j = 0;
            while (j < wsdlOperationElements.length) {
                String operationName = this.createOperationUniqueName(wsdlOperationElements[j].getOperation());
                Operation operation = (Operation)operationsMap.get(operationName);
                if (operation != null) {
                    operationsMap.remove(operationName);
                    wsdlOperationElements[j].setOperation(this, operation);
                } else {
                    this.disconnect((Element)wsdlOperationElements[j], "relWSDLOperation");
                }
                ++j;
            }
            for (Operation oper : operationsMap.values()) {
                WSDLOperationElement wsdlOperationElement = new WSDLOperationElement(oper.getName(), this, oper);
                this.connect((Element)wsdlOperationElement, "relWSDLOperation", "owner");
            }
        }
    }

    private String createOperationUniqueName(Operation operation) {
        Output outputMsg;
        StringBuffer name = new StringBuffer();
        name.append(operation.getName());
        Input inputMsg = operation.getInput();
        if (inputMsg != null) {
            QName qname = inputMsg.getMessage().getQName();
            name.append(qname.getNamespaceURI());
            name.append(":");
            name.append(qname.getLocalPart());
        }
        if ((outputMsg = operation.getOutput()) != null) {
            QName qname = outputMsg.getMessage().getQName();
            name.append(qname.getNamespaceURI());
            name.append(":");
            name.append(qname.getLocalPart());
        }
        return name.toString();
    }
}

