/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.ui.internal.mappings.details;

import java.util.Collection;
import org.eclipse.jpt.core.context.DiscriminatorColumn;
import org.eclipse.jpt.core.context.DiscriminatorType;
import org.eclipse.jpt.core.context.Entity;
import org.eclipse.jpt.core.context.InheritanceType;
import org.eclipse.jpt.db.Table;
import org.eclipse.jpt.ui.WidgetFactory;
import org.eclipse.jpt.ui.internal.mappings.JptUiMappingsMessages;
import org.eclipse.jpt.ui.internal.mappings.db.ColumnCombo;
import org.eclipse.jpt.ui.internal.util.LabeledControlUpdater;
import org.eclipse.jpt.ui.internal.util.LabeledLabel;
import org.eclipse.jpt.ui.internal.widgets.AbstractPane;
import org.eclipse.jpt.ui.internal.widgets.EnumFormComboViewer;
import org.eclipse.jpt.utility.internal.StringConverter;
import org.eclipse.jpt.utility.internal.model.value.PropertyAspectAdapter;
import org.eclipse.jpt.utility.internal.model.value.PropertyListValueModelAdapter;
import org.eclipse.jpt.utility.internal.model.value.SimplePropertyValueModel;
import org.eclipse.jpt.utility.internal.model.value.TransformationPropertyValueModel;
import org.eclipse.jpt.utility.model.value.ListValueModel;
import org.eclipse.jpt.utility.model.value.PropertyValueModel;
import org.eclipse.jpt.utility.model.value.WritablePropertyValueModel;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Spinner;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractInheritanceComposite<T extends Entity>
extends AbstractPane<T> {
    protected static String DEFAULT_KEY = "?!#!?#?#?default?#?!#?!#?";

    public AbstractInheritanceComposite(AbstractPane<? extends T> parentPane, Composite parent) {
        super(parentPane, parent, false);
    }

    public AbstractInheritanceComposite(PropertyValueModel<? extends T> subjectHolder, Composite parent, WidgetFactory widgetFactory) {
        super(subjectHolder, parent, widgetFactory);
    }

    private WritablePropertyValueModel<String> buildColumnDefinitionHolder(PropertyValueModel<DiscriminatorColumn> discriminatorColumnHolder) {
        return new PropertyAspectAdapter<DiscriminatorColumn, String>(discriminatorColumnHolder, new String[]{"columnDefinitionProperty"}){

            protected String buildValue_() {
                return ((DiscriminatorColumn)this.subject).getColumnDefinition();
            }

            protected void setValue_(String value) {
                if (value.length() == 0) {
                    value = null;
                }
                ((DiscriminatorColumn)this.subject).setColumnDefinition(value);
            }
        };
    }

    private ListValueModel<String> buildDefaultDiscriminatorListValueHolder() {
        return new PropertyListValueModelAdapter(this.buildDefaultDiscriminatorValueHolder());
    }

    private WritablePropertyValueModel<String> buildDefaultDiscriminatorValueHolder() {
        return new PropertyAspectAdapter<Entity, String>(this.getSubjectHolder(), new String[]{"defaultDiscriminatorValueProperty"}){

            protected String buildValue_() {
                String name = ((Entity)this.subject).getDefaultDiscriminatorValue();
                name = name == null ? DEFAULT_KEY : String.valueOf(DEFAULT_KEY) + name;
                return name;
            }
        };
    }

    private WritablePropertyValueModel<Integer> buildDefaultLengthHolder() {
        return new PropertyAspectAdapter<DiscriminatorColumn, Integer>(this.buildDiscriminatorColumnHolder(), new String[]{"defaultLengthProperty"}){

            protected Integer buildValue_() {
                return ((DiscriminatorColumn)this.subject).getDefaultLength();
            }

            protected void subjectChanged() {
                Object oldValue = this.getValue();
                super.subjectChanged();
                Object newValue = this.getValue();
                if (oldValue == newValue && newValue == null) {
                    this.fireAspectChange(Integer.MIN_VALUE, newValue);
                }
            }
        };
    }

    private Control buildDefaultLengthLabel(Composite container) {
        Label label = this.buildLabel(container, JptUiMappingsMessages.DefaultWithoutValue);
        new LabeledControlUpdater(new LabeledLabel(label), this.buildDefaultLengthLabelHolder());
        return label;
    }

    private PropertyValueModel<String> buildDefaultLengthLabelHolder() {
        return new TransformationPropertyValueModel<Integer, String>(this.buildDefaultLengthHolder()){

            protected String transform(Integer value) {
                Integer defaultValue = AbstractInheritanceComposite.this.subject() != null ? ((Entity)AbstractInheritanceComposite.this.subject()).getDiscriminatorColumn().getDefaultLength() : DiscriminatorColumn.DEFAULT_LENGTH;
                return NLS.bind((String)JptUiMappingsMessages.DefaultWithValue, (Object)defaultValue);
            }
        };
    }

    private ColumnCombo<DiscriminatorColumn> buildDiscriminatorColumnCombo(Composite container, PropertyValueModel<DiscriminatorColumn> discriminatorColumnHolder) {
        return new ColumnCombo<DiscriminatorColumn>((AbstractPane)this, discriminatorColumnHolder, container){

            @Override
            protected void addPropertyNames(Collection<String> propertyNames) {
                super.addPropertyNames(propertyNames);
                propertyNames.add("specifiedNameProperty");
                propertyNames.add("defaultNameProperty");
            }

            @Override
            protected String defaultValue() {
                return ((DiscriminatorColumn)this.subject()).getDefaultName();
            }

            @Override
            protected void setValue(String value) {
                ((DiscriminatorColumn)this.subject()).setSpecifiedName(value);
            }

            @Override
            protected Table table() {
                return ((DiscriminatorColumn)this.subject()).getDbTable();
            }

            @Override
            protected String value() {
                return ((DiscriminatorColumn)this.subject()).getSpecifiedName();
            }
        };
    }

    private PropertyValueModel<DiscriminatorColumn> buildDiscriminatorColumnHolder() {
        return new TransformationPropertyValueModel<Entity, DiscriminatorColumn>(this.getSubjectHolder()){

            protected DiscriminatorColumn transform_(Entity value) {
                return value.getDiscriminatorColumn();
            }
        };
    }

    private EnumFormComboViewer<DiscriminatorColumn, DiscriminatorType> buildDiscriminatorTypeCombo(Composite container, PropertyValueModel<DiscriminatorColumn> discriminatorColumnHolder) {
        return new EnumFormComboViewer<DiscriminatorColumn, DiscriminatorType>((AbstractPane)this, discriminatorColumnHolder, container){

            @Override
            protected void addPropertyNames(Collection<String> propertyNames) {
                super.addPropertyNames(propertyNames);
                propertyNames.add("defaultDiscriminatorTypeProperty");
                propertyNames.add("specifiedDiscriminatorTypeProperty");
            }

            protected DiscriminatorType[] choices() {
                return DiscriminatorType.values();
            }

            @Override
            protected DiscriminatorType defaultValue() {
                return ((DiscriminatorColumn)this.subject()).getDefaultDiscriminatorType();
            }

            @Override
            protected String displayString(DiscriminatorType value) {
                return this.buildDisplayString(JptUiMappingsMessages.class, AbstractInheritanceComposite.class, (Object)value);
            }

            @Override
            protected DiscriminatorType getValue() {
                return ((DiscriminatorColumn)this.subject()).getSpecifiedDiscriminatorType();
            }

            @Override
            protected void setValue(DiscriminatorType value) {
                ((DiscriminatorColumn)this.subject()).setSpecifiedDiscriminatorType(value);
            }
        };
    }

    private StringConverter<String> buildDiscriminatorValueConverter() {
        return new StringConverter<String>(){

            public String convertToString(String value) {
                if (AbstractInheritanceComposite.this.subject() == null) {
                    return null;
                }
                if (value == null) {
                    value = ((Entity)AbstractInheritanceComposite.this.subject()).getDefaultDiscriminatorValue();
                    value = value != null ? String.valueOf(DEFAULT_KEY) + value : DEFAULT_KEY;
                }
                if (value.startsWith(DEFAULT_KEY)) {
                    String defaultName = value.substring(DEFAULT_KEY.length());
                    value = defaultName.length() > 0 ? NLS.bind((String)JptUiMappingsMessages.DefaultWithValue, (Object)defaultName) : JptUiMappingsMessages.DefaultWithoutValue;
                }
                return value;
            }
        };
    }

    private WritablePropertyValueModel<String> buildDiscriminatorValueHolder() {
        return new PropertyAspectAdapter<Entity, String>(this.getSubjectHolder(), new String[]{"specifiedDiscriminatorValueProperty"}){

            protected String buildValue_() {
                return ((Entity)this.subject).getSpecifiedDiscriminatorValue();
            }

            protected void setValue_(String value) {
                if (value != null && (value.length() == 0 || value.startsWith(DEFAULT_KEY))) {
                    value = null;
                }
                ((Entity)this.subject).setSpecifiedDiscriminatorValue(value);
            }
        };
    }

    private ListValueModel<String> buildDiscriminatorValueListHolder() {
        return this.buildDefaultDiscriminatorListValueHolder();
    }

    private WritablePropertyValueModel<Integer> buildLengthHolder(PropertyValueModel<DiscriminatorColumn> discriminatorColumnHolder) {
        return new PropertyAspectAdapter<DiscriminatorColumn, Integer>(discriminatorColumnHolder, new String[]{"spcifiedLengthProperty"}){

            protected Integer buildValue_() {
                return ((DiscriminatorColumn)this.subject).getSpecifiedLength();
            }

            protected void setValue_(Integer value) {
                if (value == -1) {
                    value = null;
                }
                ((DiscriminatorColumn)this.subject).setSpecifiedLength(value);
            }
        };
    }

    private EnumFormComboViewer<Entity, InheritanceType> buildStrategyCombo(Composite container) {
        return new EnumFormComboViewer<Entity, InheritanceType>((AbstractPane)this, container){

            @Override
            protected void addPropertyNames(Collection<String> propertyNames) {
                super.addPropertyNames(propertyNames);
                propertyNames.add("defaultInheritanceStrategyProperty");
                propertyNames.add("specifiedInheritanceStrategyProperty");
            }

            protected InheritanceType[] choices() {
                return InheritanceType.values();
            }

            @Override
            protected InheritanceType defaultValue() {
                return ((Entity)this.subject()).getDefaultInheritanceStrategy();
            }

            @Override
            protected String displayString(InheritanceType value) {
                return this.buildDisplayString(JptUiMappingsMessages.class, AbstractInheritanceComposite.class, (Object)value);
            }

            @Override
            protected InheritanceType getValue() {
                return ((Entity)this.subject()).getSpecifiedInheritanceStrategy();
            }

            @Override
            protected void setValue(InheritanceType value) {
                ((Entity)this.subject()).setSpecifiedInheritanceStrategy(value);
            }
        };
    }

    private void initializeDiscriminatorColumnPane(Composite container) {
        PropertyValueModel<DiscriminatorColumn> discriminatorColumnHolder = this.buildDiscriminatorColumnHolder();
        this.buildLabeledComposite(container, JptUiMappingsMessages.DiscriminatorColumnComposite_name, this.buildDiscriminatorColumnCombo(container, discriminatorColumnHolder), "org.eclipse.jpt.ui.entity_inheritanceDiscriminatorColumn");
        this.buildLabeledComposite(container, JptUiMappingsMessages.DiscriminatorColumnComposite_discriminatorType, this.buildDiscriminatorTypeCombo(container, discriminatorColumnHolder), "org.eclipse.jpt.ui.entity_inheritanceDiscriminatorType");
        container = this.buildCollapsableSubSection(this.buildSubPane(container, 10), JptUiMappingsMessages.InheritanceComposite_detailsGroupBox, (PropertyValueModel<Boolean>)new SimplePropertyValueModel((Object)Boolean.FALSE));
        Spinner lengthSpinner = this.buildLabeledSpinner(container, JptUiMappingsMessages.ColumnComposite_length, this.buildLengthHolder(discriminatorColumnHolder), -1, -1, Integer.MAX_VALUE, this.buildDefaultLengthLabel(container), "org.eclipse.jpt.ui.mapping_columnLength");
        this.updateGridData(container, lengthSpinner);
        this.buildLabeledText(container, JptUiMappingsMessages.ColumnComposite_columnDefinition, this.buildColumnDefinitionHolder(discriminatorColumnHolder));
    }

    @Override
    protected void initializeLayout(Composite container) {
        int groupBoxMargin = this.groupBoxMargin();
        Composite subPane = this.buildSubPane(container, 0, groupBoxMargin, 0, groupBoxMargin);
        this.buildLabeledComposite(subPane, JptUiMappingsMessages.InheritanceComposite_strategy, this.buildStrategyCombo(subPane), "org.eclipse.jpt.ui.entity_inheritanceStrategy");
        this.buildLabeledEditableCCombo(subPane, JptUiMappingsMessages.InheritanceComposite_discriminatorValue, this.buildDiscriminatorValueListHolder(), this.buildDiscriminatorValueHolder(), this.buildDiscriminatorValueConverter(), "org.eclipse.jpt.ui.entity_inheritanceDiscriminatorValue");
        Group discriminatorColumnContainer = this.buildTitledPane(this.buildSubPane(container, 10), JptUiMappingsMessages.InheritanceComposite_discriminatorColumnGroupBox);
        this.initializeDiscriminatorColumnPane((Composite)discriminatorColumnContainer);
        this.buildPrimaryKeyJoinColumnsComposite(this.buildSubPane(container, 5));
    }

    protected abstract void buildPrimaryKeyJoinColumnsComposite(Composite var1);

    private void updateGridData(Composite container, Spinner spinner) {
        Composite paneContainer = spinner.getParent();
        while (container != paneContainer.getParent()) {
            paneContainer = paneContainer.getParent();
        }
        Control[] controls = paneContainer.getChildren();
        GridData gridData = new GridData();
        gridData.grabExcessHorizontalSpace = false;
        gridData.horizontalAlignment = 1;
        controls[1].setLayoutData((Object)gridData);
        controls[2].setLayoutData((Object)new GridData(768));
        this.removeAlignRight(controls[2]);
    }
}

