/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints;

import org.eclipse.core.runtime.Assert;
import org.eclipse.wst.jsdt.core.IJavaScriptUnit;
import org.eclipse.wst.jsdt.core.ISourceRange;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.ASTVisitor;
import org.eclipse.wst.jsdt.core.dom.JavaScriptUnit;
import org.eclipse.wst.jsdt.internal.corext.SourceRange;
import org.eclipse.wst.jsdt.internal.corext.dom.NodeFinder;

public final class CompilationUnitRange {
    private final IJavaScriptUnit fCompilationUnit;
    private final ISourceRange fSourceRange;

    public CompilationUnitRange(IJavaScriptUnit unit, ISourceRange range) {
        Assert.isNotNull((Object)unit);
        Assert.isNotNull((Object)range);
        this.fCompilationUnit = unit;
        this.fSourceRange = range;
    }

    public CompilationUnitRange(IJavaScriptUnit unit, ASTNode node) {
        this(unit, new SourceRange(node));
    }

    public IJavaScriptUnit getCompilationUnit() {
        return this.fCompilationUnit;
    }

    public ISourceRange getSourceRange() {
        return this.fSourceRange;
    }

    public ASTNode getNode(JavaScriptUnit rootNode) {
        NodeFinder finder = new NodeFinder(this.fSourceRange.getOffset(), this.fSourceRange.getLength());
        rootNode.accept((ASTVisitor)finder);
        ASTNode result = finder.getCoveringNode();
        if (result != null) {
            return result;
        }
        return finder.getCoveredNode();
    }

    public String toString() {
        return "(" + this.fSourceRange.toString() + " in " + this.fCompilationUnit.getElementName() + ")";
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof CompilationUnitRange)) {
            return false;
        }
        CompilationUnitRange other = (CompilationUnitRange)obj;
        return this.fCompilationUnit.equals(other.fCompilationUnit) && this.fSourceRange.equals(other.fSourceRange);
    }

    public int hashCode() {
        return 37 * this.fCompilationUnit.hashCode() ^ this.fSourceRange.hashCode();
    }
}

