/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.nosql.eclipselink.ui.internal.ddlgen.wizards;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jpt.common.core.gen.JptGenerator;
import org.eclipse.jpt.common.ui.gen.AbstractJptGenerateJob;
import org.eclipse.jpt.common.ui.internal.dialogs.OptionalMessageDialog;
import org.eclipse.jpt.common.utility.internal.StringTools;
import org.eclipse.jpt.jpa.core.JpaProject;
import org.eclipse.jpt.jpa.db.ConnectionProfile;
import org.eclipse.jpt.jpa.ui.JptJpaUiMessages;
import org.eclipse.jpt.jpa.ui.internal.wizards.DatabaseSchemaWizardPage;
import org.eclipse.jpt.nosql.eclipselink.core.context.persistence.OutputMode;
import org.eclipse.jpt.nosql.eclipselink.core.internal.ddlgen.EclipseLinkDDLGenerator;
import org.eclipse.jpt.nosql.eclipselink.ui.internal.EclipseLinkUiMessages;
import org.eclipse.jpt.nosql.eclipselink.ui.internal.ddlgen.wizards.GenerationOutputModeWizardPage;
import org.eclipse.jpt.nosql.eclipselink.ui.internal.plugin.JptNoSQLEclipseLinkUiPlugin;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class GenerateDDLWizard
extends Wizard {
    private static final String CR = StringTools.CR;
    private JpaProject jpaProject;
    private String puName;
    private JptGenerator ddlGenerator;
    private DatabaseSchemaWizardPage dbSettingsPage;
    private GenerationOutputModeWizardPage generationOutputModePage;

    public GenerateDDLWizard(JpaProject jpaProject, String puName) {
        this.jpaProject = jpaProject;
        this.puName = puName;
        this.setWindowTitle(JptJpaUiMessages.GenerateDDLWizard_title);
    }

    public void addPages() {
        super.addPages();
        if (this.getJpaProjectConnectionProfile() == null) {
            this.dbSettingsPage = new DatabaseSchemaWizardPage(this.jpaProject);
            this.addPage((IWizardPage)this.dbSettingsPage);
        }
        this.generationOutputModePage = new GenerationOutputModeWizardPage();
        this.addPage((IWizardPage)this.generationOutputModePage);
    }

    public boolean performFinish() {
        OutputMode outputMode = this.getOutputMode();
        if (outputMode != OutputMode.sql_script && !this.displayGeneratingDDLWarning()) {
            return false;
        }
        this.scheduleGenerateDDLJob(outputMode);
        return true;
    }

    public boolean canFinish() {
        return this.dbSettingsPageCanFinish() && this.generationOutputModePageCanFinish();
    }

    protected void scheduleGenerateDDLJob(OutputMode outputMode) {
        WorkspaceJob generateDDLJob = this.buildGenerateDDLJob(this.puName, this.jpaProject, outputMode);
        generateDDLJob.schedule();
    }

    protected WorkspaceJob buildGenerateDDLJob(String puName, JpaProject project, OutputMode outputMode) {
        return new GenerateDDLJob(puName, project, outputMode);
    }

    public OutputMode getOutputMode() {
        return this.generationOutputModePage.getOutputMode();
    }

    private boolean dbSettingsPageCanFinish() {
        return this.dbSettingsPage != null ? this.dbSettingsPage.isPageComplete() : true;
    }

    private boolean generationOutputModePageCanFinish() {
        return this.generationOutputModePage.isPageComplete();
    }

    private ConnectionProfile getJpaProjectConnectionProfile() {
        return this.jpaProject.getConnectionProfile();
    }

    private boolean displayGeneratingDDLWarning() {
        if (!OptionalMessageDialog.isDialogEnabled((String)"dontShowOverwriteExistingTablesFromClasses.warning")) {
            return true;
        }
        OverwriteConfirmerDialog dialog = new OverwriteConfirmerDialog(this.getCurrentShell());
        return dialog.open() == 2;
    }

    private Shell getCurrentShell() {
        return Display.getCurrent().getActiveShell();
    }

    private JptGenerator getDDLGenerator() {
        return this.ddlGenerator;
    }

    protected void setDDLGenerator(JptGenerator ddlGenerator) {
        this.ddlGenerator = ddlGenerator;
    }

    protected static class GenerateDDLJob
    extends AbstractJptGenerateJob {
        protected final String puName;
        protected final JpaProject jpaProject;
        protected final OutputMode outputMode;

        protected GenerateDDLJob(String puName, JpaProject jpaProject, OutputMode outputMode) {
            super(EclipseLinkUiMessages.ECLIPSELINK_GENERATE_TABLES_JOB, jpaProject.getJavaProject());
            this.puName = puName;
            this.jpaProject = jpaProject;
            this.outputMode = outputMode;
        }

        protected JptGenerator buildGenerator() {
            return new EclipseLinkDDLGenerator(this.puName, this.jpaProject, this.outputMode);
        }

        protected void postGenerate() {
            if (this.outputMode != OutputMode.database) {
                this.refreshProject();
                this.openGeneratedSqlFile();
            }
        }

        protected String getJobName() {
            return EclipseLinkUiMessages.ECLIPSELINK_GENERATE_TABLES_TASK;
        }

        protected void jptPluginLogException(Exception exception) {
            JptNoSQLEclipseLinkUiPlugin.instance().logError(exception);
        }

        private void openGeneratedSqlFile() {
            Path projecName = new Path(this.getJavaProject().getProject().getName());
            IContainer container = (IContainer)ResourcesPlugin.getWorkspace().getRoot().findMember((IPath)projecName);
            IFile sqlFile = container.getFile((IPath)new Path("createDDL.sql"));
            this.openEditor(sqlFile);
        }
    }

    static class OverwriteConfirmerDialog
    extends OptionalMessageDialog {
        private static final String ID = "dontShowOverwriteExistingTablesFromClasses.warning";

        OverwriteConfirmerDialog(Shell parent) {
            super(ID, parent, EclipseLinkUiMessages.EclipseLinkDDLGeneratorUi_generatingDDLWarningTitle, NLS.bind((String)EclipseLinkUiMessages.EclipseLinkDDLGeneratorUi_generatingDDLWarningMessage, (Object)CR, (Object)(String.valueOf(CR) + CR)), 4, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL}, 1);
        }

        protected void createButtonsForButtonBar(Composite parent) {
            this.createButton(parent, 2, IDialogConstants.YES_LABEL, false);
            this.createButton(parent, 3, IDialogConstants.NO_LABEL, true);
        }
    }
}

