/*******************************************************************************
 * Copyright (c) 2014 Bosch Software Innovations GmbH and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * and Eclipse Distribution License v1.0 which accompany this distribution.
 *
 * The Eclipse Public License is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * The Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 *
 * Contributors:
 * Bosch Software Innovations GmbH - Please refer to git log
 *
 *******************************************************************************/
/*
 * generated by Xtext
 */
grammar InternalInformationModel;

options {
	superClass=AbstractInternalAntlrParser;
}

@lexer::header {
package org.eclipse.vorto.editor.infomodel.parser.antlr.internal;

// Hack: Use our own Lexer superclass by means of import. 
// Currently there is no other way to specify the superclass for the lexer.
import org.eclipse.xtext.parser.antlr.Lexer;
}

@parser::header {
package org.eclipse.vorto.editor.infomodel.parser.antlr.internal;

import org.eclipse.xtext.*;
import org.eclipse.xtext.parser.*;
import org.eclipse.xtext.parser.impl.*;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.common.util.Enumerator;
import org.eclipse.xtext.parser.antlr.AbstractInternalAntlrParser;
import org.eclipse.xtext.parser.antlr.XtextTokenStream;
import org.eclipse.xtext.parser.antlr.XtextTokenStream.HiddenTokens;
import org.eclipse.xtext.parser.antlr.AntlrDatatypeRuleToken;
import org.eclipse.vorto.editor.infomodel.services.InformationModelGrammarAccess;

}

@parser::members {

 	private InformationModelGrammarAccess grammarAccess;

    public InternalInformationModelParser(TokenStream input, InformationModelGrammarAccess grammarAccess) {
        this(input);
        this.grammarAccess = grammarAccess;
        registerRules(grammarAccess.getGrammar());
    }

    @Override
    protected String getFirstRuleName() {
    	return "InformationModel";
   	}

   	@Override
   	protected InformationModelGrammarAccess getGrammarAccess() {
   		return grammarAccess;
   	}

}

@rulecatch {
    catch (RecognitionException re) {
        recover(input,re);
        appendSkippedTokens();
    }
}

// Entry rule entryRuleInformationModel
entryRuleInformationModel returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getInformationModelRule()); }
	iv_ruleInformationModel=ruleInformationModel
	{ $current=$iv_ruleInformationModel.current; }
	EOF;

// Rule InformationModel
ruleInformationModel returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			{
				$current = forceCreateModelElement(
					grammarAccess.getInformationModelAccess().getInformationModelAction_0(),
					$current);
			}
		)
		otherlv_1='vortolang'
		{
			newLeafNode(otherlv_1, grammarAccess.getInformationModelAccess().getVortolangKeyword_1());
		}
		(
			(
				{
					newCompositeNode(grammarAccess.getInformationModelAccess().getLangVortoLangVersionEnumRuleCall_2_0());
				}
				lv_lang_2_0=ruleVortoLangVersion
				{
					if ($current==null) {
						$current = createModelElementForParent(grammarAccess.getInformationModelRule());
					}
					set(
						$current,
						"lang",
						lv_lang_2_0,
						"org.eclipse.vorto.editor.datatype.Datatype.VortoLangVersion");
					afterParserOrEnumRuleCall();
				}
			)
		)
		otherlv_3='namespace'
		{
			newLeafNode(otherlv_3, grammarAccess.getInformationModelAccess().getNamespaceKeyword_3());
		}
		(
			(
				{
					newCompositeNode(grammarAccess.getInformationModelAccess().getNamespaceQualifiedNameParserRuleCall_4_0());
				}
				lv_namespace_4_0=ruleQualifiedName
				{
					if ($current==null) {
						$current = createModelElementForParent(grammarAccess.getInformationModelRule());
					}
					set(
						$current,
						"namespace",
						lv_namespace_4_0,
						"org.eclipse.vorto.editor.datatype.Datatype.QualifiedName");
					afterParserOrEnumRuleCall();
				}
			)
		)
		otherlv_5='version'
		{
			newLeafNode(otherlv_5, grammarAccess.getInformationModelAccess().getVersionKeyword_5());
		}
		(
			(
				lv_version_6_0=RULE_VERSION
				{
					newLeafNode(lv_version_6_0, grammarAccess.getInformationModelAccess().getVersionVERSIONTerminalRuleCall_6_0());
				}
				{
					if ($current==null) {
						$current = createModelElement(grammarAccess.getInformationModelRule());
					}
					setWithLastConsumed(
						$current,
						"version",
						lv_version_6_0,
						"org.eclipse.vorto.editor.datatype.Datatype.VERSION");
				}
			)
		)
		(
			(
				{ 
				  getUnorderedGroupHelper().enter(grammarAccess.getInformationModelAccess().getUnorderedGroup_7());
				}
				(
					(
			(
				{getUnorderedGroupHelper().canSelect(grammarAccess.getInformationModelAccess().getUnorderedGroup_7(), 0)}?=>(
					{
						getUnorderedGroupHelper().select(grammarAccess.getInformationModelAccess().getUnorderedGroup_7(), 0);
					}
								({true}?=>(otherlv_8='displayname'
								{
									newLeafNode(otherlv_8, grammarAccess.getInformationModelAccess().getDisplaynameKeyword_7_0_0());
								}
								(
									(
										lv_displayname_9_0=RULE_STRING
										{
											newLeafNode(lv_displayname_9_0, grammarAccess.getInformationModelAccess().getDisplaynameSTRINGTerminalRuleCall_7_0_1_0());
										}
										{
											if ($current==null) {
												$current = createModelElement(grammarAccess.getInformationModelRule());
											}
											setWithLastConsumed(
												$current,
												"displayname",
												lv_displayname_9_0,
												"org.eclipse.xtext.common.Terminals.STRING");
										}
									)
								)
								))
					{ 
						getUnorderedGroupHelper().returnFromSelection(grammarAccess.getInformationModelAccess().getUnorderedGroup_7());
					}
				)
			)|
			(
				{getUnorderedGroupHelper().canSelect(grammarAccess.getInformationModelAccess().getUnorderedGroup_7(), 1)}?=>(
					{
						getUnorderedGroupHelper().select(grammarAccess.getInformationModelAccess().getUnorderedGroup_7(), 1);
					}
								({true}?=>(otherlv_10='description'
								{
									newLeafNode(otherlv_10, grammarAccess.getInformationModelAccess().getDescriptionKeyword_7_1_0());
								}
								(
									(
										lv_description_11_0=RULE_STRING
										{
											newLeafNode(lv_description_11_0, grammarAccess.getInformationModelAccess().getDescriptionSTRINGTerminalRuleCall_7_1_1_0());
										}
										{
											if ($current==null) {
												$current = createModelElement(grammarAccess.getInformationModelRule());
											}
											setWithLastConsumed(
												$current,
												"description",
												lv_description_11_0,
												"org.eclipse.xtext.common.Terminals.STRING");
										}
									)
								)
								))
					{ 
						getUnorderedGroupHelper().returnFromSelection(grammarAccess.getInformationModelAccess().getUnorderedGroup_7());
					}
				)
			)|
			(
				{getUnorderedGroupHelper().canSelect(grammarAccess.getInformationModelAccess().getUnorderedGroup_7(), 2)}?=>(
					{
						getUnorderedGroupHelper().select(grammarAccess.getInformationModelAccess().getUnorderedGroup_7(), 2);
					}
								({true}?=>(otherlv_12='category'
								{
									newLeafNode(otherlv_12, grammarAccess.getInformationModelAccess().getCategoryKeyword_7_2_0());
								}
								(
									(
										{
											newCompositeNode(grammarAccess.getInformationModelAccess().getCategoryCATEGORYParserRuleCall_7_2_1_0());
										}
										lv_category_13_0=ruleCATEGORY
										{
											if ($current==null) {
												$current = createModelElementForParent(grammarAccess.getInformationModelRule());
											}
											set(
												$current,
												"category",
												lv_category_13_0,
												"org.eclipse.vorto.editor.datatype.Datatype.CATEGORY");
											afterParserOrEnumRuleCall();
										}
									)
								)
								))
					{ 
						getUnorderedGroupHelper().returnFromSelection(grammarAccess.getInformationModelAccess().getUnorderedGroup_7());
					}
				)
			)
					)*
				)
			)
				{ 
				  getUnorderedGroupHelper().leave(grammarAccess.getInformationModelAccess().getUnorderedGroup_7());
				}
		)
		(
			(
				{
					newCompositeNode(grammarAccess.getInformationModelAccess().getReferencesModelReferenceParserRuleCall_8_0());
				}
				lv_references_14_0=ruleModelReference
				{
					if ($current==null) {
						$current = createModelElementForParent(grammarAccess.getInformationModelRule());
					}
					add(
						$current,
						"references",
						lv_references_14_0,
						"org.eclipse.vorto.editor.datatype.Datatype.ModelReference");
					afterParserOrEnumRuleCall();
				}
			)
		)*
		otherlv_15='infomodel'
		{
			newLeafNode(otherlv_15, grammarAccess.getInformationModelAccess().getInfomodelKeyword_9());
		}
		(
			(
				lv_name_16_0=RULE_ID
				{
					newLeafNode(lv_name_16_0, grammarAccess.getInformationModelAccess().getNameIDTerminalRuleCall_10_0());
				}
				{
					if ($current==null) {
						$current = createModelElement(grammarAccess.getInformationModelRule());
					}
					setWithLastConsumed(
						$current,
						"name",
						lv_name_16_0,
						"org.eclipse.xtext.common.Terminals.ID");
				}
			)
		)
		otherlv_17='{'
		{
			newLeafNode(otherlv_17, grammarAccess.getInformationModelAccess().getLeftCurlyBracketKeyword_11());
		}
		(
			otherlv_18='functionblocks'
			{
				newLeafNode(otherlv_18, grammarAccess.getInformationModelAccess().getFunctionblocksKeyword_12_0());
			}
			otherlv_19='{'
			{
				newLeafNode(otherlv_19, grammarAccess.getInformationModelAccess().getLeftCurlyBracketKeyword_12_1());
			}
			(
				(
					{
						newCompositeNode(grammarAccess.getInformationModelAccess().getPropertiesFunctionblockPropertyParserRuleCall_12_2_0());
					}
					lv_properties_20_0=ruleFunctionblockProperty
					{
						if ($current==null) {
							$current = createModelElementForParent(grammarAccess.getInformationModelRule());
						}
						add(
							$current,
							"properties",
							lv_properties_20_0,
							"org.eclipse.vorto.editor.infomodel.InformationModel.FunctionblockProperty");
						afterParserOrEnumRuleCall();
					}
				)
			)*
			otherlv_21='}'
			{
				newLeafNode(otherlv_21, grammarAccess.getInformationModelAccess().getRightCurlyBracketKeyword_12_3());
			}
		)?
		otherlv_22='}'
		{
			newLeafNode(otherlv_22, grammarAccess.getInformationModelAccess().getRightCurlyBracketKeyword_13());
		}
	)
;

// Entry rule entryRuleFunctionblockProperty
entryRuleFunctionblockProperty returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getFunctionblockPropertyRule()); }
	iv_ruleFunctionblockProperty=ruleFunctionblockProperty
	{ $current=$iv_ruleFunctionblockProperty.current; }
	EOF;

// Rule FunctionblockProperty
ruleFunctionblockProperty returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			(
				{
					newCompositeNode(grammarAccess.getFunctionblockPropertyAccess().getPresencePresenceParserRuleCall_0_0());
				}
				lv_presence_0_0=rulePresence
				{
					if ($current==null) {
						$current = createModelElementForParent(grammarAccess.getFunctionblockPropertyRule());
					}
					set(
						$current,
						"presence",
						lv_presence_0_0,
						"org.eclipse.vorto.editor.datatype.Datatype.Presence");
					afterParserOrEnumRuleCall();
				}
			)
		)?
		(
			(
				lv_multiplicity_1_0='multiple'
				{
					newLeafNode(lv_multiplicity_1_0, grammarAccess.getFunctionblockPropertyAccess().getMultiplicityMultipleKeyword_1_0());
				}
				{
					if ($current==null) {
						$current = createModelElement(grammarAccess.getFunctionblockPropertyRule());
					}
					setWithLastConsumed($current, "multiplicity", true, "multiple");
				}
			)
		)?
		(
			(
				lv_name_2_0=RULE_ID
				{
					newLeafNode(lv_name_2_0, grammarAccess.getFunctionblockPropertyAccess().getNameIDTerminalRuleCall_2_0());
				}
				{
					if ($current==null) {
						$current = createModelElement(grammarAccess.getFunctionblockPropertyRule());
					}
					setWithLastConsumed(
						$current,
						"name",
						lv_name_2_0,
						"org.eclipse.xtext.common.Terminals.ID");
				}
			)
		)
		otherlv_3='as'
		{
			newLeafNode(otherlv_3, grammarAccess.getFunctionblockPropertyAccess().getAsKeyword_3());
		}
		(
			(
				{
					if ($current==null) {
						$current = createModelElement(grammarAccess.getFunctionblockPropertyRule());
					}
				}
				{
					newCompositeNode(grammarAccess.getFunctionblockPropertyAccess().getTypeFunctionblockModelCrossReference_4_0());
				}
				ruleQualifiedName
				{
					afterParserOrEnumRuleCall();
				}
			)
		)
		(
			otherlv_5='extends'
			{
				newLeafNode(otherlv_5, grammarAccess.getFunctionblockPropertyAccess().getExtendsKeyword_5_0());
			}
			otherlv_6='{'
			{
				newLeafNode(otherlv_6, grammarAccess.getFunctionblockPropertyAccess().getLeftCurlyBracketKeyword_5_1());
			}
			(
				(
					{
						newCompositeNode(grammarAccess.getFunctionblockPropertyAccess().getExtendedFunctionBlockFunctionBlockParserRuleCall_5_2_0());
					}
					lv_extendedFunctionBlock_7_0=ruleFunctionBlock
					{
						if ($current==null) {
							$current = createModelElementForParent(grammarAccess.getFunctionblockPropertyRule());
						}
						set(
							$current,
							"extendedFunctionBlock",
							lv_extendedFunctionBlock_7_0,
							"org.eclipse.vorto.editor.functionblock.Functionblock.FunctionBlock");
						afterParserOrEnumRuleCall();
					}
				)
			)
			otherlv_8='}'
			{
				newLeafNode(otherlv_8, grammarAccess.getFunctionblockPropertyAccess().getRightCurlyBracketKeyword_5_3());
			}
		)?
		(
			(
				lv_description_9_0=RULE_STRING
				{
					newLeafNode(lv_description_9_0, grammarAccess.getFunctionblockPropertyAccess().getDescriptionSTRINGTerminalRuleCall_6_0());
				}
				{
					if ($current==null) {
						$current = createModelElement(grammarAccess.getFunctionblockPropertyRule());
					}
					setWithLastConsumed(
						$current,
						"description",
						lv_description_9_0,
						"org.eclipse.xtext.common.Terminals.STRING");
				}
			)
		)?
	)
;

// Entry rule entryRuleFunctionBlock
entryRuleFunctionBlock returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getFunctionBlockRule()); }
	iv_ruleFunctionBlock=ruleFunctionBlock
	{ $current=$iv_ruleFunctionBlock.current; }
	EOF;

// Rule FunctionBlock
ruleFunctionBlock returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			{
				$current = forceCreateModelElement(
					grammarAccess.getFunctionBlockAccess().getFunctionBlockAction_0(),
					$current);
			}
		)
		(
			(
				{ 
				  getUnorderedGroupHelper().enter(grammarAccess.getFunctionBlockAccess().getUnorderedGroup_1());
				}
				(
					(
			(
				{getUnorderedGroupHelper().canSelect(grammarAccess.getFunctionBlockAccess().getUnorderedGroup_1(), 0)}?=>(
					{
						getUnorderedGroupHelper().select(grammarAccess.getFunctionBlockAccess().getUnorderedGroup_1(), 0);
					}
								({true}?=>((
									{
										newCompositeNode(grammarAccess.getFunctionBlockAccess().getConfigurationConfigurationParserRuleCall_1_0_0());
									}
									lv_configuration_2_0=ruleConfiguration
									{
										if ($current==null) {
											$current = createModelElementForParent(grammarAccess.getFunctionBlockRule());
										}
										set(
											$current,
											"configuration",
											lv_configuration_2_0,
											"org.eclipse.vorto.editor.functionblock.Functionblock.Configuration");
										afterParserOrEnumRuleCall();
									}
								)
								))
					{ 
						getUnorderedGroupHelper().returnFromSelection(grammarAccess.getFunctionBlockAccess().getUnorderedGroup_1());
					}
				)
			)|
			(
				{getUnorderedGroupHelper().canSelect(grammarAccess.getFunctionBlockAccess().getUnorderedGroup_1(), 1)}?=>(
					{
						getUnorderedGroupHelper().select(grammarAccess.getFunctionBlockAccess().getUnorderedGroup_1(), 1);
					}
								({true}?=>((
									{
										newCompositeNode(grammarAccess.getFunctionBlockAccess().getStatusStatusParserRuleCall_1_1_0());
									}
									lv_status_3_0=ruleStatus
									{
										if ($current==null) {
											$current = createModelElementForParent(grammarAccess.getFunctionBlockRule());
										}
										set(
											$current,
											"status",
											lv_status_3_0,
											"org.eclipse.vorto.editor.functionblock.Functionblock.Status");
										afterParserOrEnumRuleCall();
									}
								)
								))
					{ 
						getUnorderedGroupHelper().returnFromSelection(grammarAccess.getFunctionBlockAccess().getUnorderedGroup_1());
					}
				)
			)|
			(
				{getUnorderedGroupHelper().canSelect(grammarAccess.getFunctionBlockAccess().getUnorderedGroup_1(), 2)}?=>(
					{
						getUnorderedGroupHelper().select(grammarAccess.getFunctionBlockAccess().getUnorderedGroup_1(), 2);
					}
								({true}?=>((
									{
										newCompositeNode(grammarAccess.getFunctionBlockAccess().getFaultFaultParserRuleCall_1_2_0());
									}
									lv_fault_4_0=ruleFault
									{
										if ($current==null) {
											$current = createModelElementForParent(grammarAccess.getFunctionBlockRule());
										}
										set(
											$current,
											"fault",
											lv_fault_4_0,
											"org.eclipse.vorto.editor.functionblock.Functionblock.Fault");
										afterParserOrEnumRuleCall();
									}
								)
								))
					{ 
						getUnorderedGroupHelper().returnFromSelection(grammarAccess.getFunctionBlockAccess().getUnorderedGroup_1());
					}
				)
			)|
			(
				{getUnorderedGroupHelper().canSelect(grammarAccess.getFunctionBlockAccess().getUnorderedGroup_1(), 3)}?=>(
					{
						getUnorderedGroupHelper().select(grammarAccess.getFunctionBlockAccess().getUnorderedGroup_1(), 3);
					}
								({true}?=>(otherlv_5='events'
								{
									newLeafNode(otherlv_5, grammarAccess.getFunctionBlockAccess().getEventsKeyword_1_3_0());
								}
								otherlv_6='{'
								{
									newLeafNode(otherlv_6, grammarAccess.getFunctionBlockAccess().getLeftCurlyBracketKeyword_1_3_1());
								}
								(
									(
										{
											newCompositeNode(grammarAccess.getFunctionBlockAccess().getEventsEventParserRuleCall_1_3_2_0());
										}
										lv_events_7_0=ruleEvent
										{
											if ($current==null) {
												$current = createModelElementForParent(grammarAccess.getFunctionBlockRule());
											}
											add(
												$current,
												"events",
												lv_events_7_0,
												"org.eclipse.vorto.editor.functionblock.Functionblock.Event");
											afterParserOrEnumRuleCall();
										}
									)
								)*
								otherlv_8='}'
								{
									newLeafNode(otherlv_8, grammarAccess.getFunctionBlockAccess().getRightCurlyBracketKeyword_1_3_3());
								}
								))
					{ 
						getUnorderedGroupHelper().returnFromSelection(grammarAccess.getFunctionBlockAccess().getUnorderedGroup_1());
					}
				)
			)|
			(
				{getUnorderedGroupHelper().canSelect(grammarAccess.getFunctionBlockAccess().getUnorderedGroup_1(), 4)}?=>(
					{
						getUnorderedGroupHelper().select(grammarAccess.getFunctionBlockAccess().getUnorderedGroup_1(), 4);
					}
								({true}?=>(otherlv_9='operations'
								{
									newLeafNode(otherlv_9, grammarAccess.getFunctionBlockAccess().getOperationsKeyword_1_4_0());
								}
								otherlv_10='{'
								{
									newLeafNode(otherlv_10, grammarAccess.getFunctionBlockAccess().getLeftCurlyBracketKeyword_1_4_1());
								}
								(
									(
										{
											newCompositeNode(grammarAccess.getFunctionBlockAccess().getOperationsOperationParserRuleCall_1_4_2_0());
										}
										lv_operations_11_0=ruleOperation
										{
											if ($current==null) {
												$current = createModelElementForParent(grammarAccess.getFunctionBlockRule());
											}
											add(
												$current,
												"operations",
												lv_operations_11_0,
												"org.eclipse.vorto.editor.functionblock.Functionblock.Operation");
											afterParserOrEnumRuleCall();
										}
									)
								)*
								otherlv_12='}'
								{
									newLeafNode(otherlv_12, grammarAccess.getFunctionBlockAccess().getRightCurlyBracketKeyword_1_4_3());
								}
								))
					{ 
						getUnorderedGroupHelper().returnFromSelection(grammarAccess.getFunctionBlockAccess().getUnorderedGroup_1());
					}
				)
			)
					)*
				)
			)
				{ 
				  getUnorderedGroupHelper().leave(grammarAccess.getFunctionBlockAccess().getUnorderedGroup_1());
				}
		)
	)
;

// Entry rule entryRuleConfiguration
entryRuleConfiguration returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getConfigurationRule()); }
	iv_ruleConfiguration=ruleConfiguration
	{ $current=$iv_ruleConfiguration.current; }
	EOF;

// Rule Configuration
ruleConfiguration returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			{
				$current = forceCreateModelElement(
					grammarAccess.getConfigurationAccess().getConfigurationAction_0(),
					$current);
			}
		)
		otherlv_1='configuration'
		{
			newLeafNode(otherlv_1, grammarAccess.getConfigurationAccess().getConfigurationKeyword_1());
		}
		otherlv_2='{'
		{
			newLeafNode(otherlv_2, grammarAccess.getConfigurationAccess().getLeftCurlyBracketKeyword_2());
		}
		(
			(
				{
					newCompositeNode(grammarAccess.getConfigurationAccess().getPropertiesPropertyParserRuleCall_3_0());
				}
				lv_properties_3_0=ruleProperty
				{
					if ($current==null) {
						$current = createModelElementForParent(grammarAccess.getConfigurationRule());
					}
					add(
						$current,
						"properties",
						lv_properties_3_0,
						"org.eclipse.vorto.editor.datatype.Datatype.Property");
					afterParserOrEnumRuleCall();
				}
			)
		)*
		otherlv_4='}'
		{
			newLeafNode(otherlv_4, grammarAccess.getConfigurationAccess().getRightCurlyBracketKeyword_4());
		}
	)
;

// Entry rule entryRuleStatus
entryRuleStatus returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getStatusRule()); }
	iv_ruleStatus=ruleStatus
	{ $current=$iv_ruleStatus.current; }
	EOF;

// Rule Status
ruleStatus returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			{
				$current = forceCreateModelElement(
					grammarAccess.getStatusAccess().getStatusAction_0(),
					$current);
			}
		)
		otherlv_1='status'
		{
			newLeafNode(otherlv_1, grammarAccess.getStatusAccess().getStatusKeyword_1());
		}
		otherlv_2='{'
		{
			newLeafNode(otherlv_2, grammarAccess.getStatusAccess().getLeftCurlyBracketKeyword_2());
		}
		(
			(
				{
					newCompositeNode(grammarAccess.getStatusAccess().getPropertiesPropertyParserRuleCall_3_0());
				}
				lv_properties_3_0=ruleProperty
				{
					if ($current==null) {
						$current = createModelElementForParent(grammarAccess.getStatusRule());
					}
					add(
						$current,
						"properties",
						lv_properties_3_0,
						"org.eclipse.vorto.editor.datatype.Datatype.Property");
					afterParserOrEnumRuleCall();
				}
			)
		)*
		otherlv_4='}'
		{
			newLeafNode(otherlv_4, grammarAccess.getStatusAccess().getRightCurlyBracketKeyword_4());
		}
	)
;

// Entry rule entryRuleFault
entryRuleFault returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getFaultRule()); }
	iv_ruleFault=ruleFault
	{ $current=$iv_ruleFault.current; }
	EOF;

// Rule Fault
ruleFault returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			{
				$current = forceCreateModelElement(
					grammarAccess.getFaultAccess().getFaultAction_0(),
					$current);
			}
		)
		otherlv_1='fault'
		{
			newLeafNode(otherlv_1, grammarAccess.getFaultAccess().getFaultKeyword_1());
		}
		otherlv_2='{'
		{
			newLeafNode(otherlv_2, grammarAccess.getFaultAccess().getLeftCurlyBracketKeyword_2());
		}
		(
			(
				{
					newCompositeNode(grammarAccess.getFaultAccess().getPropertiesPropertyParserRuleCall_3_0());
				}
				lv_properties_3_0=ruleProperty
				{
					if ($current==null) {
						$current = createModelElementForParent(grammarAccess.getFaultRule());
					}
					add(
						$current,
						"properties",
						lv_properties_3_0,
						"org.eclipse.vorto.editor.datatype.Datatype.Property");
					afterParserOrEnumRuleCall();
				}
			)
		)*
		otherlv_4='}'
		{
			newLeafNode(otherlv_4, grammarAccess.getFaultAccess().getRightCurlyBracketKeyword_4());
		}
	)
;

// Entry rule entryRuleOperation
entryRuleOperation returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getOperationRule()); }
	iv_ruleOperation=ruleOperation
	{ $current=$iv_ruleOperation.current; }
	EOF;

// Rule Operation
ruleOperation returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			(
				lv_extension_0_0='extension'
				{
					newLeafNode(lv_extension_0_0, grammarAccess.getOperationAccess().getExtensionExtensionKeyword_0_0());
				}
				{
					if ($current==null) {
						$current = createModelElement(grammarAccess.getOperationRule());
					}
					setWithLastConsumed($current, "extension", true, "extension");
				}
			)
		)?
		(
			(
				{
					newCompositeNode(grammarAccess.getOperationAccess().getPresencePresenceParserRuleCall_1_0());
				}
				lv_presence_1_0=rulePresence
				{
					if ($current==null) {
						$current = createModelElementForParent(grammarAccess.getOperationRule());
					}
					set(
						$current,
						"presence",
						lv_presence_1_0,
						"org.eclipse.vorto.editor.datatype.Datatype.Presence");
					afterParserOrEnumRuleCall();
				}
			)
		)?
		(
			(
				lv_breakable_2_0='breakable'
				{
					newLeafNode(lv_breakable_2_0, grammarAccess.getOperationAccess().getBreakableBreakableKeyword_2_0());
				}
				{
					if ($current==null) {
						$current = createModelElement(grammarAccess.getOperationRule());
					}
					setWithLastConsumed($current, "breakable", true, "breakable");
				}
			)
		)?
		(
			(
				{
					newCompositeNode(grammarAccess.getOperationAccess().getNameValidIDParserRuleCall_3_0());
				}
				lv_name_3_0=ruleValidID
				{
					if ($current==null) {
						$current = createModelElementForParent(grammarAccess.getOperationRule());
					}
					set(
						$current,
						"name",
						lv_name_3_0,
						"org.eclipse.vorto.editor.datatype.Datatype.ValidID");
					afterParserOrEnumRuleCall();
				}
			)
		)
		otherlv_4='('
		{
			newLeafNode(otherlv_4, grammarAccess.getOperationAccess().getLeftParenthesisKeyword_4());
		}
		(
			(
				(
					{
						newCompositeNode(grammarAccess.getOperationAccess().getParamsParamParserRuleCall_5_0_0());
					}
					lv_params_5_0=ruleParam
					{
						if ($current==null) {
							$current = createModelElementForParent(grammarAccess.getOperationRule());
						}
						add(
							$current,
							"params",
							lv_params_5_0,
							"org.eclipse.vorto.editor.functionblock.Functionblock.Param");
						afterParserOrEnumRuleCall();
					}
				)
			)
			(
				otherlv_6=','
				{
					newLeafNode(otherlv_6, grammarAccess.getOperationAccess().getCommaKeyword_5_1_0());
				}
				(
					(
						{
							newCompositeNode(grammarAccess.getOperationAccess().getParamsParamParserRuleCall_5_1_1_0());
						}
						lv_params_7_0=ruleParam
						{
							if ($current==null) {
								$current = createModelElementForParent(grammarAccess.getOperationRule());
							}
							add(
								$current,
								"params",
								lv_params_7_0,
								"org.eclipse.vorto.editor.functionblock.Functionblock.Param");
							afterParserOrEnumRuleCall();
						}
					)
				)
			)*
		)?
		otherlv_8=')'
		{
			newLeafNode(otherlv_8, grammarAccess.getOperationAccess().getRightParenthesisKeyword_6());
		}
		(
			otherlv_9='returns'
			{
				newLeafNode(otherlv_9, grammarAccess.getOperationAccess().getReturnsKeyword_7_0());
			}
			(
				(
					{
						newCompositeNode(grammarAccess.getOperationAccess().getReturnTypeReturnTypeParserRuleCall_7_1_0());
					}
					lv_returnType_10_0=ruleReturnType
					{
						if ($current==null) {
							$current = createModelElementForParent(grammarAccess.getOperationRule());
						}
						set(
							$current,
							"returnType",
							lv_returnType_10_0,
							"org.eclipse.vorto.editor.functionblock.Functionblock.ReturnType");
						afterParserOrEnumRuleCall();
					}
				)
			)
		)?
		(
			(
				lv_description_11_0=RULE_STRING
				{
					newLeafNode(lv_description_11_0, grammarAccess.getOperationAccess().getDescriptionSTRINGTerminalRuleCall_8_0());
				}
				{
					if ($current==null) {
						$current = createModelElement(grammarAccess.getOperationRule());
					}
					setWithLastConsumed(
						$current,
						"description",
						lv_description_11_0,
						"org.eclipse.xtext.common.Terminals.STRING");
				}
			)
		)?
	)
;

// Entry rule entryRuleReturnType
entryRuleReturnType returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getReturnTypeRule()); }
	iv_ruleReturnType=ruleReturnType
	{ $current=$iv_ruleReturnType.current; }
	EOF;

// Rule ReturnType
ruleReturnType returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		{
			newCompositeNode(grammarAccess.getReturnTypeAccess().getReturnDictonaryTypeParserRuleCall_0());
		}
		this_ReturnDictonaryType_0=ruleReturnDictonaryType
		{
			$current = $this_ReturnDictonaryType_0.current;
			afterParserOrEnumRuleCall();
		}
		    |
		{
			newCompositeNode(grammarAccess.getReturnTypeAccess().getReturnObjectTypeParserRuleCall_1());
		}
		this_ReturnObjectType_1=ruleReturnObjectType
		{
			$current = $this_ReturnObjectType_1.current;
			afterParserOrEnumRuleCall();
		}
		    |
		{
			newCompositeNode(grammarAccess.getReturnTypeAccess().getReturnPrimitiveTypeParserRuleCall_2());
		}
		this_ReturnPrimitiveType_2=ruleReturnPrimitiveType
		{
			$current = $this_ReturnPrimitiveType_2.current;
			afterParserOrEnumRuleCall();
		}
	)
;

// Entry rule entryRuleReturnDictonaryType
entryRuleReturnDictonaryType returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getReturnDictonaryTypeRule()); }
	iv_ruleReturnDictonaryType=ruleReturnDictonaryType
	{ $current=$iv_ruleReturnDictonaryType.current; }
	EOF;

// Rule ReturnDictonaryType
ruleReturnDictonaryType returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			(
				lv_multiplicity_0_0='multiple'
				{
					newLeafNode(lv_multiplicity_0_0, grammarAccess.getReturnDictonaryTypeAccess().getMultiplicityMultipleKeyword_0_0());
				}
				{
					if ($current==null) {
						$current = createModelElement(grammarAccess.getReturnDictonaryTypeRule());
					}
					setWithLastConsumed($current, "multiplicity", true, "multiple");
				}
			)
		)?
		(
			(
				{
					newCompositeNode(grammarAccess.getReturnDictonaryTypeAccess().getReturnTypeDictionaryPropertyTypeParserRuleCall_1_0());
				}
				lv_returnType_1_0=ruleDictionaryPropertyType
				{
					if ($current==null) {
						$current = createModelElementForParent(grammarAccess.getReturnDictonaryTypeRule());
					}
					set(
						$current,
						"returnType",
						lv_returnType_1_0,
						"org.eclipse.vorto.editor.datatype.Datatype.DictionaryPropertyType");
					afterParserOrEnumRuleCall();
				}
			)
		)
		(
			otherlv_2='<'
			{
				newLeafNode(otherlv_2, grammarAccess.getReturnDictonaryTypeAccess().getLessThanSignKeyword_2_0());
			}
			(
				(
					{
						newCompositeNode(grammarAccess.getReturnDictonaryTypeAccess().getConstraintRuleConstraintRuleParserRuleCall_2_1_0());
					}
					lv_constraintRule_3_0=ruleConstraintRule
					{
						if ($current==null) {
							$current = createModelElementForParent(grammarAccess.getReturnDictonaryTypeRule());
						}
						set(
							$current,
							"constraintRule",
							lv_constraintRule_3_0,
							"org.eclipse.vorto.editor.datatype.Datatype.ConstraintRule");
						afterParserOrEnumRuleCall();
					}
				)
			)
			otherlv_4='>'
			{
				newLeafNode(otherlv_4, grammarAccess.getReturnDictonaryTypeAccess().getGreaterThanSignKeyword_2_2());
			}
		)?
	)
;

// Entry rule entryRuleReturnObjectType
entryRuleReturnObjectType returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getReturnObjectTypeRule()); }
	iv_ruleReturnObjectType=ruleReturnObjectType
	{ $current=$iv_ruleReturnObjectType.current; }
	EOF;

// Rule ReturnObjectType
ruleReturnObjectType returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			(
				lv_multiplicity_0_0='multiple'
				{
					newLeafNode(lv_multiplicity_0_0, grammarAccess.getReturnObjectTypeAccess().getMultiplicityMultipleKeyword_0_0());
				}
				{
					if ($current==null) {
						$current = createModelElement(grammarAccess.getReturnObjectTypeRule());
					}
					setWithLastConsumed($current, "multiplicity", true, "multiple");
				}
			)
		)?
		(
			(
				{
					if ($current==null) {
						$current = createModelElement(grammarAccess.getReturnObjectTypeRule());
					}
				}
				{
					newCompositeNode(grammarAccess.getReturnObjectTypeAccess().getReturnTypeTypeCrossReference_1_0());
				}
				ruleQualifiedName
				{
					afterParserOrEnumRuleCall();
				}
			)
		)
		(
			otherlv_2='<'
			{
				newLeafNode(otherlv_2, grammarAccess.getReturnObjectTypeAccess().getLessThanSignKeyword_2_0());
			}
			(
				(
					{
						newCompositeNode(grammarAccess.getReturnObjectTypeAccess().getConstraintRuleConstraintRuleParserRuleCall_2_1_0());
					}
					lv_constraintRule_3_0=ruleConstraintRule
					{
						if ($current==null) {
							$current = createModelElementForParent(grammarAccess.getReturnObjectTypeRule());
						}
						set(
							$current,
							"constraintRule",
							lv_constraintRule_3_0,
							"org.eclipse.vorto.editor.datatype.Datatype.ConstraintRule");
						afterParserOrEnumRuleCall();
					}
				)
			)
			otherlv_4='>'
			{
				newLeafNode(otherlv_4, grammarAccess.getReturnObjectTypeAccess().getGreaterThanSignKeyword_2_2());
			}
		)?
	)
;

// Entry rule entryRuleReturnPrimitiveType
entryRuleReturnPrimitiveType returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getReturnPrimitiveTypeRule()); }
	iv_ruleReturnPrimitiveType=ruleReturnPrimitiveType
	{ $current=$iv_ruleReturnPrimitiveType.current; }
	EOF;

// Rule ReturnPrimitiveType
ruleReturnPrimitiveType returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			(
				lv_multiplicity_0_0='multiple'
				{
					newLeafNode(lv_multiplicity_0_0, grammarAccess.getReturnPrimitiveTypeAccess().getMultiplicityMultipleKeyword_0_0());
				}
				{
					if ($current==null) {
						$current = createModelElement(grammarAccess.getReturnPrimitiveTypeRule());
					}
					setWithLastConsumed($current, "multiplicity", true, "multiple");
				}
			)
		)?
		(
			(
				{
					newCompositeNode(grammarAccess.getReturnPrimitiveTypeAccess().getReturnTypePrimitiveTypeEnumRuleCall_1_0());
				}
				lv_returnType_1_0=rulePrimitiveType
				{
					if ($current==null) {
						$current = createModelElementForParent(grammarAccess.getReturnPrimitiveTypeRule());
					}
					set(
						$current,
						"returnType",
						lv_returnType_1_0,
						"org.eclipse.vorto.editor.datatype.Datatype.PrimitiveType");
					afterParserOrEnumRuleCall();
				}
			)
		)
		(
			otherlv_2='<'
			{
				newLeafNode(otherlv_2, grammarAccess.getReturnPrimitiveTypeAccess().getLessThanSignKeyword_2_0());
			}
			(
				(
					{
						newCompositeNode(grammarAccess.getReturnPrimitiveTypeAccess().getConstraintRuleConstraintRuleParserRuleCall_2_1_0());
					}
					lv_constraintRule_3_0=ruleConstraintRule
					{
						if ($current==null) {
							$current = createModelElementForParent(grammarAccess.getReturnPrimitiveTypeRule());
						}
						set(
							$current,
							"constraintRule",
							lv_constraintRule_3_0,
							"org.eclipse.vorto.editor.datatype.Datatype.ConstraintRule");
						afterParserOrEnumRuleCall();
					}
				)
			)
			otherlv_4='>'
			{
				newLeafNode(otherlv_4, grammarAccess.getReturnPrimitiveTypeAccess().getGreaterThanSignKeyword_2_2());
			}
		)?
	)
;

// Entry rule entryRuleDictonaryParam
entryRuleDictonaryParam returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getDictonaryParamRule()); }
	iv_ruleDictonaryParam=ruleDictonaryParam
	{ $current=$iv_ruleDictonaryParam.current; }
	EOF;

// Rule DictonaryParam
ruleDictonaryParam returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			(
				lv_multiplicity_0_0='multiple'
				{
					newLeafNode(lv_multiplicity_0_0, grammarAccess.getDictonaryParamAccess().getMultiplicityMultipleKeyword_0_0());
				}
				{
					if ($current==null) {
						$current = createModelElement(grammarAccess.getDictonaryParamRule());
					}
					setWithLastConsumed($current, "multiplicity", true, "multiple");
				}
			)
		)?
		(
			(
				{
					newCompositeNode(grammarAccess.getDictonaryParamAccess().getNameValidIDParserRuleCall_1_0());
				}
				lv_name_1_0=ruleValidID
				{
					if ($current==null) {
						$current = createModelElementForParent(grammarAccess.getDictonaryParamRule());
					}
					set(
						$current,
						"name",
						lv_name_1_0,
						"org.eclipse.vorto.editor.datatype.Datatype.ValidID");
					afterParserOrEnumRuleCall();
				}
			)
		)
		otherlv_2='as'
		{
			newLeafNode(otherlv_2, grammarAccess.getDictonaryParamAccess().getAsKeyword_2());
		}
		(
			(
				{
					newCompositeNode(grammarAccess.getDictonaryParamAccess().getTypeDictionaryPropertyTypeParserRuleCall_3_0());
				}
				lv_type_3_0=ruleDictionaryPropertyType
				{
					if ($current==null) {
						$current = createModelElementForParent(grammarAccess.getDictonaryParamRule());
					}
					set(
						$current,
						"type",
						lv_type_3_0,
						"org.eclipse.vorto.editor.datatype.Datatype.DictionaryPropertyType");
					afterParserOrEnumRuleCall();
				}
			)
		)
		(
			otherlv_4='<'
			{
				newLeafNode(otherlv_4, grammarAccess.getDictonaryParamAccess().getLessThanSignKeyword_4_0());
			}
			(
				(
					{
						newCompositeNode(grammarAccess.getDictonaryParamAccess().getConstraintRuleConstraintRuleParserRuleCall_4_1_0());
					}
					lv_constraintRule_5_0=ruleConstraintRule
					{
						if ($current==null) {
							$current = createModelElementForParent(grammarAccess.getDictonaryParamRule());
						}
						set(
							$current,
							"constraintRule",
							lv_constraintRule_5_0,
							"org.eclipse.vorto.editor.datatype.Datatype.ConstraintRule");
						afterParserOrEnumRuleCall();
					}
				)
			)
			otherlv_6='>'
			{
				newLeafNode(otherlv_6, grammarAccess.getDictonaryParamAccess().getGreaterThanSignKeyword_4_2());
			}
		)?
		(
			(
				lv_description_7_0=RULE_STRING
				{
					newLeafNode(lv_description_7_0, grammarAccess.getDictonaryParamAccess().getDescriptionSTRINGTerminalRuleCall_5_0());
				}
				{
					if ($current==null) {
						$current = createModelElement(grammarAccess.getDictonaryParamRule());
					}
					setWithLastConsumed(
						$current,
						"description",
						lv_description_7_0,
						"org.eclipse.xtext.common.Terminals.STRING");
				}
			)
		)?
	)
;

// Entry rule entryRulePrimitiveParam
entryRulePrimitiveParam returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getPrimitiveParamRule()); }
	iv_rulePrimitiveParam=rulePrimitiveParam
	{ $current=$iv_rulePrimitiveParam.current; }
	EOF;

// Rule PrimitiveParam
rulePrimitiveParam returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			(
				lv_multiplicity_0_0='multiple'
				{
					newLeafNode(lv_multiplicity_0_0, grammarAccess.getPrimitiveParamAccess().getMultiplicityMultipleKeyword_0_0());
				}
				{
					if ($current==null) {
						$current = createModelElement(grammarAccess.getPrimitiveParamRule());
					}
					setWithLastConsumed($current, "multiplicity", true, "multiple");
				}
			)
		)?
		(
			(
				{
					newCompositeNode(grammarAccess.getPrimitiveParamAccess().getNameValidIDParserRuleCall_1_0());
				}
				lv_name_1_0=ruleValidID
				{
					if ($current==null) {
						$current = createModelElementForParent(grammarAccess.getPrimitiveParamRule());
					}
					set(
						$current,
						"name",
						lv_name_1_0,
						"org.eclipse.vorto.editor.datatype.Datatype.ValidID");
					afterParserOrEnumRuleCall();
				}
			)
		)
		otherlv_2='as'
		{
			newLeafNode(otherlv_2, grammarAccess.getPrimitiveParamAccess().getAsKeyword_2());
		}
		(
			(
				{
					newCompositeNode(grammarAccess.getPrimitiveParamAccess().getTypePrimitiveTypeEnumRuleCall_3_0());
				}
				lv_type_3_0=rulePrimitiveType
				{
					if ($current==null) {
						$current = createModelElementForParent(grammarAccess.getPrimitiveParamRule());
					}
					set(
						$current,
						"type",
						lv_type_3_0,
						"org.eclipse.vorto.editor.datatype.Datatype.PrimitiveType");
					afterParserOrEnumRuleCall();
				}
			)
		)
		(
			otherlv_4='<'
			{
				newLeafNode(otherlv_4, grammarAccess.getPrimitiveParamAccess().getLessThanSignKeyword_4_0());
			}
			(
				(
					{
						newCompositeNode(grammarAccess.getPrimitiveParamAccess().getConstraintRuleConstraintRuleParserRuleCall_4_1_0());
					}
					lv_constraintRule_5_0=ruleConstraintRule
					{
						if ($current==null) {
							$current = createModelElementForParent(grammarAccess.getPrimitiveParamRule());
						}
						set(
							$current,
							"constraintRule",
							lv_constraintRule_5_0,
							"org.eclipse.vorto.editor.datatype.Datatype.ConstraintRule");
						afterParserOrEnumRuleCall();
					}
				)
			)
			otherlv_6='>'
			{
				newLeafNode(otherlv_6, grammarAccess.getPrimitiveParamAccess().getGreaterThanSignKeyword_4_2());
			}
		)?
		(
			(
				lv_description_7_0=RULE_STRING
				{
					newLeafNode(lv_description_7_0, grammarAccess.getPrimitiveParamAccess().getDescriptionSTRINGTerminalRuleCall_5_0());
				}
				{
					if ($current==null) {
						$current = createModelElement(grammarAccess.getPrimitiveParamRule());
					}
					setWithLastConsumed(
						$current,
						"description",
						lv_description_7_0,
						"org.eclipse.xtext.common.Terminals.STRING");
				}
			)
		)?
	)
;

// Entry rule entryRuleRefParam
entryRuleRefParam returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getRefParamRule()); }
	iv_ruleRefParam=ruleRefParam
	{ $current=$iv_ruleRefParam.current; }
	EOF;

// Rule RefParam
ruleRefParam returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			(
				lv_multiplicity_0_0='multiple'
				{
					newLeafNode(lv_multiplicity_0_0, grammarAccess.getRefParamAccess().getMultiplicityMultipleKeyword_0_0());
				}
				{
					if ($current==null) {
						$current = createModelElement(grammarAccess.getRefParamRule());
					}
					setWithLastConsumed($current, "multiplicity", true, "multiple");
				}
			)
		)?
		(
			(
				{
					newCompositeNode(grammarAccess.getRefParamAccess().getNameValidIDParserRuleCall_1_0());
				}
				lv_name_1_0=ruleValidID
				{
					if ($current==null) {
						$current = createModelElementForParent(grammarAccess.getRefParamRule());
					}
					set(
						$current,
						"name",
						lv_name_1_0,
						"org.eclipse.vorto.editor.datatype.Datatype.ValidID");
					afterParserOrEnumRuleCall();
				}
			)
		)
		otherlv_2='as'
		{
			newLeafNode(otherlv_2, grammarAccess.getRefParamAccess().getAsKeyword_2());
		}
		(
			(
				{
					if ($current==null) {
						$current = createModelElement(grammarAccess.getRefParamRule());
					}
				}
				{
					newCompositeNode(grammarAccess.getRefParamAccess().getTypeTypeCrossReference_3_0());
				}
				ruleQualifiedName
				{
					afterParserOrEnumRuleCall();
				}
			)
		)
		(
			(
				lv_description_4_0=RULE_STRING
				{
					newLeafNode(lv_description_4_0, grammarAccess.getRefParamAccess().getDescriptionSTRINGTerminalRuleCall_4_0());
				}
				{
					if ($current==null) {
						$current = createModelElement(grammarAccess.getRefParamRule());
					}
					setWithLastConsumed(
						$current,
						"description",
						lv_description_4_0,
						"org.eclipse.xtext.common.Terminals.STRING");
				}
			)
		)?
	)
;

// Entry rule entryRuleParam
entryRuleParam returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getParamRule()); }
	iv_ruleParam=ruleParam
	{ $current=$iv_ruleParam.current; }
	EOF;

// Rule Param
ruleParam returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		{
			newCompositeNode(grammarAccess.getParamAccess().getDictonaryParamParserRuleCall_0());
		}
		this_DictonaryParam_0=ruleDictonaryParam
		{
			$current = $this_DictonaryParam_0.current;
			afterParserOrEnumRuleCall();
		}
		    |
		{
			newCompositeNode(grammarAccess.getParamAccess().getPrimitiveParamParserRuleCall_1());
		}
		this_PrimitiveParam_1=rulePrimitiveParam
		{
			$current = $this_PrimitiveParam_1.current;
			afterParserOrEnumRuleCall();
		}
		    |
		{
			newCompositeNode(grammarAccess.getParamAccess().getRefParamParserRuleCall_2());
		}
		this_RefParam_2=ruleRefParam
		{
			$current = $this_RefParam_2.current;
			afterParserOrEnumRuleCall();
		}
	)
;

// Entry rule entryRuleEvent
entryRuleEvent returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getEventRule()); }
	iv_ruleEvent=ruleEvent
	{ $current=$iv_ruleEvent.current; }
	EOF;

// Rule Event
ruleEvent returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			(
				lv_name_0_0=RULE_ID
				{
					newLeafNode(lv_name_0_0, grammarAccess.getEventAccess().getNameIDTerminalRuleCall_0_0());
				}
				{
					if ($current==null) {
						$current = createModelElement(grammarAccess.getEventRule());
					}
					setWithLastConsumed(
						$current,
						"name",
						lv_name_0_0,
						"org.eclipse.xtext.common.Terminals.ID");
				}
			)
		)
		otherlv_1='{'
		{
			newLeafNode(otherlv_1, grammarAccess.getEventAccess().getLeftCurlyBracketKeyword_1());
		}
		(
			(
				{
					newCompositeNode(grammarAccess.getEventAccess().getPropertiesPropertyParserRuleCall_2_0());
				}
				lv_properties_2_0=ruleProperty
				{
					if ($current==null) {
						$current = createModelElementForParent(grammarAccess.getEventRule());
					}
					add(
						$current,
						"properties",
						lv_properties_2_0,
						"org.eclipse.vorto.editor.datatype.Datatype.Property");
					afterParserOrEnumRuleCall();
				}
			)
		)*
		otherlv_3='}'
		{
			newLeafNode(otherlv_3, grammarAccess.getEventAccess().getRightCurlyBracketKeyword_3());
		}
	)
;

// Entry rule entryRuleModelReference
entryRuleModelReference returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getModelReferenceRule()); }
	iv_ruleModelReference=ruleModelReference
	{ $current=$iv_ruleModelReference.current; }
	EOF;

// Rule ModelReference
ruleModelReference returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		otherlv_0='using'
		{
			newLeafNode(otherlv_0, grammarAccess.getModelReferenceAccess().getUsingKeyword_0());
		}
		(
			(
				{
					newCompositeNode(grammarAccess.getModelReferenceAccess().getImportedNamespaceQualifiedNameParserRuleCall_1_0());
				}
				lv_importedNamespace_1_0=ruleQualifiedName
				{
					if ($current==null) {
						$current = createModelElementForParent(grammarAccess.getModelReferenceRule());
					}
					set(
						$current,
						"importedNamespace",
						lv_importedNamespace_1_0,
						"org.eclipse.vorto.editor.datatype.Datatype.QualifiedName");
					afterParserOrEnumRuleCall();
				}
			)
		)
		otherlv_2=';'
		{
			newLeafNode(otherlv_2, grammarAccess.getModelReferenceAccess().getSemicolonKeyword_2());
		}
		(
			(
				lv_version_3_0=RULE_VERSION
				{
					newLeafNode(lv_version_3_0, grammarAccess.getModelReferenceAccess().getVersionVERSIONTerminalRuleCall_3_0());
				}
				{
					if ($current==null) {
						$current = createModelElement(grammarAccess.getModelReferenceRule());
					}
					setWithLastConsumed(
						$current,
						"version",
						lv_version_3_0,
						"org.eclipse.vorto.editor.datatype.Datatype.VERSION");
				}
			)
		)
	)
;

// Entry rule entryRuleQualifiedName
entryRuleQualifiedName returns [String current=null]:
	{ newCompositeNode(grammarAccess.getQualifiedNameRule()); }
	iv_ruleQualifiedName=ruleQualifiedName
	{ $current=$iv_ruleQualifiedName.current.getText(); }
	EOF;

// Rule QualifiedName
ruleQualifiedName returns [AntlrDatatypeRuleToken current=new AntlrDatatypeRuleToken()]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		this_ID_0=RULE_ID
		{
			$current.merge(this_ID_0);
		}
		{
			newLeafNode(this_ID_0, grammarAccess.getQualifiedNameAccess().getIDTerminalRuleCall_0());
		}
		(
			kw='.'
			{
				$current.merge(kw);
				newLeafNode(kw, grammarAccess.getQualifiedNameAccess().getFullStopKeyword_1_0());
			}
			this_ID_2=RULE_ID
			{
				$current.merge(this_ID_2);
			}
			{
				newLeafNode(this_ID_2, grammarAccess.getQualifiedNameAccess().getIDTerminalRuleCall_1_1());
			}
		)*
	)
;

// Entry rule entryRuleType
entryRuleType returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getTypeRule()); }
	iv_ruleType=ruleType
	{ $current=$iv_ruleType.current; }
	EOF;

// Rule Type
ruleType returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		{
			newCompositeNode(grammarAccess.getTypeAccess().getEntityParserRuleCall_0());
		}
		this_Entity_0=ruleEntity
		{
			$current = $this_Entity_0.current;
			afterParserOrEnumRuleCall();
		}
		    |
		{
			newCompositeNode(grammarAccess.getTypeAccess().getEnumParserRuleCall_1());
		}
		this_Enum_1=ruleEnum
		{
			$current = $this_Enum_1.current;
			afterParserOrEnumRuleCall();
		}
	)
;

// Entry rule entryRuleEntity
entryRuleEntity returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getEntityRule()); }
	iv_ruleEntity=ruleEntity
	{ $current=$iv_ruleEntity.current; }
	EOF;

// Rule Entity
ruleEntity returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		otherlv_0='vortolang'
		{
			newLeafNode(otherlv_0, grammarAccess.getEntityAccess().getVortolangKeyword_0());
		}
		(
			(
				{
					newCompositeNode(grammarAccess.getEntityAccess().getLangVortoLangVersionEnumRuleCall_1_0());
				}
				lv_lang_1_0=ruleVortoLangVersion
				{
					if ($current==null) {
						$current = createModelElementForParent(grammarAccess.getEntityRule());
					}
					set(
						$current,
						"lang",
						lv_lang_1_0,
						"org.eclipse.vorto.editor.datatype.Datatype.VortoLangVersion");
					afterParserOrEnumRuleCall();
				}
			)
		)
		otherlv_2='namespace'
		{
			newLeafNode(otherlv_2, grammarAccess.getEntityAccess().getNamespaceKeyword_2());
		}
		(
			(
				{
					newCompositeNode(grammarAccess.getEntityAccess().getNamespaceQualifiedNameParserRuleCall_3_0());
				}
				lv_namespace_3_0=ruleQualifiedName
				{
					if ($current==null) {
						$current = createModelElementForParent(grammarAccess.getEntityRule());
					}
					set(
						$current,
						"namespace",
						lv_namespace_3_0,
						"org.eclipse.vorto.editor.datatype.Datatype.QualifiedName");
					afterParserOrEnumRuleCall();
				}
			)
		)
		otherlv_4='version'
		{
			newLeafNode(otherlv_4, grammarAccess.getEntityAccess().getVersionKeyword_4());
		}
		(
			(
				lv_version_5_0=RULE_VERSION
				{
					newLeafNode(lv_version_5_0, grammarAccess.getEntityAccess().getVersionVERSIONTerminalRuleCall_5_0());
				}
				{
					if ($current==null) {
						$current = createModelElement(grammarAccess.getEntityRule());
					}
					setWithLastConsumed(
						$current,
						"version",
						lv_version_5_0,
						"org.eclipse.vorto.editor.datatype.Datatype.VERSION");
				}
			)
		)
		(
			(
				{ 
				  getUnorderedGroupHelper().enter(grammarAccess.getEntityAccess().getUnorderedGroup_6());
				}
				(
					(
			(
				{getUnorderedGroupHelper().canSelect(grammarAccess.getEntityAccess().getUnorderedGroup_6(), 0)}?=>(
					{
						getUnorderedGroupHelper().select(grammarAccess.getEntityAccess().getUnorderedGroup_6(), 0);
					}
								({true}?=>(otherlv_7='displayname'
								{
									newLeafNode(otherlv_7, grammarAccess.getEntityAccess().getDisplaynameKeyword_6_0_0());
								}
								(
									(
										lv_displayname_8_0=RULE_STRING
										{
											newLeafNode(lv_displayname_8_0, grammarAccess.getEntityAccess().getDisplaynameSTRINGTerminalRuleCall_6_0_1_0());
										}
										{
											if ($current==null) {
												$current = createModelElement(grammarAccess.getEntityRule());
											}
											setWithLastConsumed(
												$current,
												"displayname",
												lv_displayname_8_0,
												"org.eclipse.xtext.common.Terminals.STRING");
										}
									)
								)
								))
					{ 
						getUnorderedGroupHelper().returnFromSelection(grammarAccess.getEntityAccess().getUnorderedGroup_6());
					}
				)
			)|
			(
				{getUnorderedGroupHelper().canSelect(grammarAccess.getEntityAccess().getUnorderedGroup_6(), 1)}?=>(
					{
						getUnorderedGroupHelper().select(grammarAccess.getEntityAccess().getUnorderedGroup_6(), 1);
					}
								({true}?=>(otherlv_9='description'
								{
									newLeafNode(otherlv_9, grammarAccess.getEntityAccess().getDescriptionKeyword_6_1_0());
								}
								(
									(
										lv_description_10_0=RULE_STRING
										{
											newLeafNode(lv_description_10_0, grammarAccess.getEntityAccess().getDescriptionSTRINGTerminalRuleCall_6_1_1_0());
										}
										{
											if ($current==null) {
												$current = createModelElement(grammarAccess.getEntityRule());
											}
											setWithLastConsumed(
												$current,
												"description",
												lv_description_10_0,
												"org.eclipse.xtext.common.Terminals.STRING");
										}
									)
								)
								))
					{ 
						getUnorderedGroupHelper().returnFromSelection(grammarAccess.getEntityAccess().getUnorderedGroup_6());
					}
				)
			)|
			(
				{getUnorderedGroupHelper().canSelect(grammarAccess.getEntityAccess().getUnorderedGroup_6(), 2)}?=>(
					{
						getUnorderedGroupHelper().select(grammarAccess.getEntityAccess().getUnorderedGroup_6(), 2);
					}
								({true}?=>(otherlv_11='category'
								{
									newLeafNode(otherlv_11, grammarAccess.getEntityAccess().getCategoryKeyword_6_2_0());
								}
								(
									(
										{
											newCompositeNode(grammarAccess.getEntityAccess().getCategoryCATEGORYParserRuleCall_6_2_1_0());
										}
										lv_category_12_0=ruleCATEGORY
										{
											if ($current==null) {
												$current = createModelElementForParent(grammarAccess.getEntityRule());
											}
											set(
												$current,
												"category",
												lv_category_12_0,
												"org.eclipse.vorto.editor.datatype.Datatype.CATEGORY");
											afterParserOrEnumRuleCall();
										}
									)
								)
								))
					{ 
						getUnorderedGroupHelper().returnFromSelection(grammarAccess.getEntityAccess().getUnorderedGroup_6());
					}
				)
			)
					)*
				)
			)
				{ 
				  getUnorderedGroupHelper().leave(grammarAccess.getEntityAccess().getUnorderedGroup_6());
				}
		)
		(
			(
				{
					newCompositeNode(grammarAccess.getEntityAccess().getReferencesModelReferenceParserRuleCall_7_0());
				}
				lv_references_13_0=ruleModelReference
				{
					if ($current==null) {
						$current = createModelElementForParent(grammarAccess.getEntityRule());
					}
					add(
						$current,
						"references",
						lv_references_13_0,
						"org.eclipse.vorto.editor.datatype.Datatype.ModelReference");
					afterParserOrEnumRuleCall();
				}
			)
		)*
		otherlv_14='entity'
		{
			newLeafNode(otherlv_14, grammarAccess.getEntityAccess().getEntityKeyword_8());
		}
		(
			(
				lv_name_15_0=RULE_ID
				{
					newLeafNode(lv_name_15_0, grammarAccess.getEntityAccess().getNameIDTerminalRuleCall_9_0());
				}
				{
					if ($current==null) {
						$current = createModelElement(grammarAccess.getEntityRule());
					}
					setWithLastConsumed(
						$current,
						"name",
						lv_name_15_0,
						"org.eclipse.xtext.common.Terminals.ID");
				}
			)
		)
		(
			otherlv_16='extends'
			{
				newLeafNode(otherlv_16, grammarAccess.getEntityAccess().getExtendsKeyword_10_0());
			}
			(
				(
					{
						if ($current==null) {
							$current = createModelElement(grammarAccess.getEntityRule());
						}
					}
					{
						newCompositeNode(grammarAccess.getEntityAccess().getSuperTypeEntityCrossReference_10_1_0());
					}
					ruleQualifiedName
					{
						afterParserOrEnumRuleCall();
					}
				)
			)
		)?
		otherlv_18='{'
		{
			newLeafNode(otherlv_18, grammarAccess.getEntityAccess().getLeftCurlyBracketKeyword_11());
		}
		(
			(
				{
					newCompositeNode(grammarAccess.getEntityAccess().getPropertiesPropertyParserRuleCall_12_0());
				}
				lv_properties_19_0=ruleProperty
				{
					if ($current==null) {
						$current = createModelElementForParent(grammarAccess.getEntityRule());
					}
					add(
						$current,
						"properties",
						lv_properties_19_0,
						"org.eclipse.vorto.editor.datatype.Datatype.Property");
					afterParserOrEnumRuleCall();
				}
			)
		)*
		otherlv_20='}'
		{
			newLeafNode(otherlv_20, grammarAccess.getEntityAccess().getRightCurlyBracketKeyword_13());
		}
	)
;

// Entry rule entryRuleEnum
entryRuleEnum returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getEnumRule()); }
	iv_ruleEnum=ruleEnum
	{ $current=$iv_ruleEnum.current; }
	EOF;

// Rule Enum
ruleEnum returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		otherlv_0='vortolang'
		{
			newLeafNode(otherlv_0, grammarAccess.getEnumAccess().getVortolangKeyword_0());
		}
		(
			(
				{
					newCompositeNode(grammarAccess.getEnumAccess().getLangVortoLangVersionEnumRuleCall_1_0());
				}
				lv_lang_1_0=ruleVortoLangVersion
				{
					if ($current==null) {
						$current = createModelElementForParent(grammarAccess.getEnumRule());
					}
					set(
						$current,
						"lang",
						lv_lang_1_0,
						"org.eclipse.vorto.editor.datatype.Datatype.VortoLangVersion");
					afterParserOrEnumRuleCall();
				}
			)
		)
		otherlv_2='namespace'
		{
			newLeafNode(otherlv_2, grammarAccess.getEnumAccess().getNamespaceKeyword_2());
		}
		(
			(
				{
					newCompositeNode(grammarAccess.getEnumAccess().getNamespaceQualifiedNameParserRuleCall_3_0());
				}
				lv_namespace_3_0=ruleQualifiedName
				{
					if ($current==null) {
						$current = createModelElementForParent(grammarAccess.getEnumRule());
					}
					set(
						$current,
						"namespace",
						lv_namespace_3_0,
						"org.eclipse.vorto.editor.datatype.Datatype.QualifiedName");
					afterParserOrEnumRuleCall();
				}
			)
		)
		otherlv_4='version'
		{
			newLeafNode(otherlv_4, grammarAccess.getEnumAccess().getVersionKeyword_4());
		}
		(
			(
				lv_version_5_0=RULE_VERSION
				{
					newLeafNode(lv_version_5_0, grammarAccess.getEnumAccess().getVersionVERSIONTerminalRuleCall_5_0());
				}
				{
					if ($current==null) {
						$current = createModelElement(grammarAccess.getEnumRule());
					}
					setWithLastConsumed(
						$current,
						"version",
						lv_version_5_0,
						"org.eclipse.vorto.editor.datatype.Datatype.VERSION");
				}
			)
		)
		(
			(
				{ 
				  getUnorderedGroupHelper().enter(grammarAccess.getEnumAccess().getUnorderedGroup_6());
				}
				(
					(
			(
				{getUnorderedGroupHelper().canSelect(grammarAccess.getEnumAccess().getUnorderedGroup_6(), 0)}?=>(
					{
						getUnorderedGroupHelper().select(grammarAccess.getEnumAccess().getUnorderedGroup_6(), 0);
					}
								({true}?=>(otherlv_7='displayname'
								{
									newLeafNode(otherlv_7, grammarAccess.getEnumAccess().getDisplaynameKeyword_6_0_0());
								}
								(
									(
										lv_displayname_8_0=RULE_STRING
										{
											newLeafNode(lv_displayname_8_0, grammarAccess.getEnumAccess().getDisplaynameSTRINGTerminalRuleCall_6_0_1_0());
										}
										{
											if ($current==null) {
												$current = createModelElement(grammarAccess.getEnumRule());
											}
											setWithLastConsumed(
												$current,
												"displayname",
												lv_displayname_8_0,
												"org.eclipse.xtext.common.Terminals.STRING");
										}
									)
								)
								))
					{ 
						getUnorderedGroupHelper().returnFromSelection(grammarAccess.getEnumAccess().getUnorderedGroup_6());
					}
				)
			)|
			(
				{getUnorderedGroupHelper().canSelect(grammarAccess.getEnumAccess().getUnorderedGroup_6(), 1)}?=>(
					{
						getUnorderedGroupHelper().select(grammarAccess.getEnumAccess().getUnorderedGroup_6(), 1);
					}
								({true}?=>(otherlv_9='description'
								{
									newLeafNode(otherlv_9, grammarAccess.getEnumAccess().getDescriptionKeyword_6_1_0());
								}
								(
									(
										lv_description_10_0=RULE_STRING
										{
											newLeafNode(lv_description_10_0, grammarAccess.getEnumAccess().getDescriptionSTRINGTerminalRuleCall_6_1_1_0());
										}
										{
											if ($current==null) {
												$current = createModelElement(grammarAccess.getEnumRule());
											}
											setWithLastConsumed(
												$current,
												"description",
												lv_description_10_0,
												"org.eclipse.xtext.common.Terminals.STRING");
										}
									)
								)
								))
					{ 
						getUnorderedGroupHelper().returnFromSelection(grammarAccess.getEnumAccess().getUnorderedGroup_6());
					}
				)
			)|
			(
				{getUnorderedGroupHelper().canSelect(grammarAccess.getEnumAccess().getUnorderedGroup_6(), 2)}?=>(
					{
						getUnorderedGroupHelper().select(grammarAccess.getEnumAccess().getUnorderedGroup_6(), 2);
					}
								({true}?=>(otherlv_11='category'
								{
									newLeafNode(otherlv_11, grammarAccess.getEnumAccess().getCategoryKeyword_6_2_0());
								}
								(
									(
										{
											newCompositeNode(grammarAccess.getEnumAccess().getCategoryCATEGORYParserRuleCall_6_2_1_0());
										}
										lv_category_12_0=ruleCATEGORY
										{
											if ($current==null) {
												$current = createModelElementForParent(grammarAccess.getEnumRule());
											}
											set(
												$current,
												"category",
												lv_category_12_0,
												"org.eclipse.vorto.editor.datatype.Datatype.CATEGORY");
											afterParserOrEnumRuleCall();
										}
									)
								)
								))
					{ 
						getUnorderedGroupHelper().returnFromSelection(grammarAccess.getEnumAccess().getUnorderedGroup_6());
					}
				)
			)
					)*
				)
			)
				{ 
				  getUnorderedGroupHelper().leave(grammarAccess.getEnumAccess().getUnorderedGroup_6());
				}
		)
		(
			(
				{
					newCompositeNode(grammarAccess.getEnumAccess().getReferencesModelReferenceParserRuleCall_7_0());
				}
				lv_references_13_0=ruleModelReference
				{
					if ($current==null) {
						$current = createModelElementForParent(grammarAccess.getEnumRule());
					}
					add(
						$current,
						"references",
						lv_references_13_0,
						"org.eclipse.vorto.editor.datatype.Datatype.ModelReference");
					afterParserOrEnumRuleCall();
				}
			)
		)*
		otherlv_14='enum'
		{
			newLeafNode(otherlv_14, grammarAccess.getEnumAccess().getEnumKeyword_8());
		}
		(
			(
				lv_name_15_0=RULE_ID
				{
					newLeafNode(lv_name_15_0, grammarAccess.getEnumAccess().getNameIDTerminalRuleCall_9_0());
				}
				{
					if ($current==null) {
						$current = createModelElement(grammarAccess.getEnumRule());
					}
					setWithLastConsumed(
						$current,
						"name",
						lv_name_15_0,
						"org.eclipse.xtext.common.Terminals.ID");
				}
			)
		)
		otherlv_16='{'
		{
			newLeafNode(otherlv_16, grammarAccess.getEnumAccess().getLeftCurlyBracketKeyword_10());
		}
		(
			(
				(
					{
						newCompositeNode(grammarAccess.getEnumAccess().getEnumsEnumLiteralParserRuleCall_11_0_0());
					}
					lv_enums_17_0=ruleEnumLiteral
					{
						if ($current==null) {
							$current = createModelElementForParent(grammarAccess.getEnumRule());
						}
						add(
							$current,
							"enums",
							lv_enums_17_0,
							"org.eclipse.vorto.editor.datatype.Datatype.EnumLiteral");
						afterParserOrEnumRuleCall();
					}
				)
			)
			(
				otherlv_18=','
				{
					newLeafNode(otherlv_18, grammarAccess.getEnumAccess().getCommaKeyword_11_1_0());
				}
				(
					(
						{
							newCompositeNode(grammarAccess.getEnumAccess().getEnumsEnumLiteralParserRuleCall_11_1_1_0());
						}
						lv_enums_19_0=ruleEnumLiteral
						{
							if ($current==null) {
								$current = createModelElementForParent(grammarAccess.getEnumRule());
							}
							add(
								$current,
								"enums",
								lv_enums_19_0,
								"org.eclipse.vorto.editor.datatype.Datatype.EnumLiteral");
							afterParserOrEnumRuleCall();
						}
					)
				)
			)*
		)?
		otherlv_20='}'
		{
			newLeafNode(otherlv_20, grammarAccess.getEnumAccess().getRightCurlyBracketKeyword_12());
		}
	)
;

// Entry rule entryRuleEnumLiteral
entryRuleEnumLiteral returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getEnumLiteralRule()); }
	iv_ruleEnumLiteral=ruleEnumLiteral
	{ $current=$iv_ruleEnumLiteral.current; }
	EOF;

// Rule EnumLiteral
ruleEnumLiteral returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			(
				lv_name_0_0=RULE_ID
				{
					newLeafNode(lv_name_0_0, grammarAccess.getEnumLiteralAccess().getNameIDTerminalRuleCall_0_0());
				}
				{
					if ($current==null) {
						$current = createModelElement(grammarAccess.getEnumLiteralRule());
					}
					setWithLastConsumed(
						$current,
						"name",
						lv_name_0_0,
						"org.eclipse.xtext.common.Terminals.ID");
				}
			)
		)
		(
			(
				lv_description_1_0=RULE_STRING
				{
					newLeafNode(lv_description_1_0, grammarAccess.getEnumLiteralAccess().getDescriptionSTRINGTerminalRuleCall_1_0());
				}
				{
					if ($current==null) {
						$current = createModelElement(grammarAccess.getEnumLiteralRule());
					}
					setWithLastConsumed(
						$current,
						"description",
						lv_description_1_0,
						"org.eclipse.xtext.common.Terminals.STRING");
				}
			)
		)?
	)
;

// Entry rule entryRuleProperty
entryRuleProperty returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getPropertyRule()); }
	iv_ruleProperty=ruleProperty
	{ $current=$iv_ruleProperty.current; }
	EOF;

// Rule Property
ruleProperty returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			(
				lv_extension_0_0='extension'
				{
					newLeafNode(lv_extension_0_0, grammarAccess.getPropertyAccess().getExtensionExtensionKeyword_0_0());
				}
				{
					if ($current==null) {
						$current = createModelElement(grammarAccess.getPropertyRule());
					}
					setWithLastConsumed($current, "extension", true, "extension");
				}
			)
		)?
		(
			(
				{
					newCompositeNode(grammarAccess.getPropertyAccess().getPresencePresenceParserRuleCall_1_0());
				}
				lv_presence_1_0=rulePresence
				{
					if ($current==null) {
						$current = createModelElementForParent(grammarAccess.getPropertyRule());
					}
					set(
						$current,
						"presence",
						lv_presence_1_0,
						"org.eclipse.vorto.editor.datatype.Datatype.Presence");
					afterParserOrEnumRuleCall();
				}
			)
		)?
		(
			(
				lv_multiplicity_2_0='multiple'
				{
					newLeafNode(lv_multiplicity_2_0, grammarAccess.getPropertyAccess().getMultiplicityMultipleKeyword_2_0());
				}
				{
					if ($current==null) {
						$current = createModelElement(grammarAccess.getPropertyRule());
					}
					setWithLastConsumed($current, "multiplicity", true, "multiple");
				}
			)
		)?
		(
			(
				{
					newCompositeNode(grammarAccess.getPropertyAccess().getNameValidIDParserRuleCall_3_0());
				}
				lv_name_3_0=ruleValidID
				{
					if ($current==null) {
						$current = createModelElementForParent(grammarAccess.getPropertyRule());
					}
					set(
						$current,
						"name",
						lv_name_3_0,
						"org.eclipse.vorto.editor.datatype.Datatype.ValidID");
					afterParserOrEnumRuleCall();
				}
			)
		)
		otherlv_4='as'
		{
			newLeafNode(otherlv_4, grammarAccess.getPropertyAccess().getAsKeyword_4());
		}
		(
			(
				{
					newCompositeNode(grammarAccess.getPropertyAccess().getTypePropertyTypeParserRuleCall_5_0());
				}
				lv_type_5_0=rulePropertyType
				{
					if ($current==null) {
						$current = createModelElementForParent(grammarAccess.getPropertyRule());
					}
					set(
						$current,
						"type",
						lv_type_5_0,
						"org.eclipse.vorto.editor.datatype.Datatype.PropertyType");
					afterParserOrEnumRuleCall();
				}
			)
		)
		(
			otherlv_6='with'
			{
				newLeafNode(otherlv_6, grammarAccess.getPropertyAccess().getWithKeyword_6_0());
			}
			otherlv_7='{'
			{
				newLeafNode(otherlv_7, grammarAccess.getPropertyAccess().getLeftCurlyBracketKeyword_6_1());
			}
			(
				(
					{
						newCompositeNode(grammarAccess.getPropertyAccess().getPropertyAttributesPropertyAttributeParserRuleCall_6_2_0());
					}
					lv_propertyAttributes_8_0=rulePropertyAttribute
					{
						if ($current==null) {
							$current = createModelElementForParent(grammarAccess.getPropertyRule());
						}
						add(
							$current,
							"propertyAttributes",
							lv_propertyAttributes_8_0,
							"org.eclipse.vorto.editor.datatype.Datatype.PropertyAttribute");
						afterParserOrEnumRuleCall();
					}
				)
			)
			(
				otherlv_9=','
				{
					newLeafNode(otherlv_9, grammarAccess.getPropertyAccess().getCommaKeyword_6_3_0());
				}
				(
					(
						{
							newCompositeNode(grammarAccess.getPropertyAccess().getPropertyAttributesPropertyAttributeParserRuleCall_6_3_1_0());
						}
						lv_propertyAttributes_10_0=rulePropertyAttribute
						{
							if ($current==null) {
								$current = createModelElementForParent(grammarAccess.getPropertyRule());
							}
							add(
								$current,
								"propertyAttributes",
								lv_propertyAttributes_10_0,
								"org.eclipse.vorto.editor.datatype.Datatype.PropertyAttribute");
							afterParserOrEnumRuleCall();
						}
					)
				)
			)*
			otherlv_11='}'
			{
				newLeafNode(otherlv_11, grammarAccess.getPropertyAccess().getRightCurlyBracketKeyword_6_4());
			}
		)?
		(
			otherlv_12='<'
			{
				newLeafNode(otherlv_12, grammarAccess.getPropertyAccess().getLessThanSignKeyword_7_0());
			}
			(
				(
					{
						newCompositeNode(grammarAccess.getPropertyAccess().getConstraintRuleConstraintRuleParserRuleCall_7_1_0());
					}
					lv_constraintRule_13_0=ruleConstraintRule
					{
						if ($current==null) {
							$current = createModelElementForParent(grammarAccess.getPropertyRule());
						}
						set(
							$current,
							"constraintRule",
							lv_constraintRule_13_0,
							"org.eclipse.vorto.editor.datatype.Datatype.ConstraintRule");
						afterParserOrEnumRuleCall();
					}
				)
			)
			otherlv_14='>'
			{
				newLeafNode(otherlv_14, grammarAccess.getPropertyAccess().getGreaterThanSignKeyword_7_2());
			}
		)?
		(
			(
				lv_description_15_0=RULE_STRING
				{
					newLeafNode(lv_description_15_0, grammarAccess.getPropertyAccess().getDescriptionSTRINGTerminalRuleCall_8_0());
				}
				{
					if ($current==null) {
						$current = createModelElement(grammarAccess.getPropertyRule());
					}
					setWithLastConsumed(
						$current,
						"description",
						lv_description_15_0,
						"org.eclipse.xtext.common.Terminals.STRING");
				}
			)
		)?
	)
;

// Entry rule entryRuleConstraintRule
entryRuleConstraintRule returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getConstraintRuleRule()); }
	iv_ruleConstraintRule=ruleConstraintRule
	{ $current=$iv_ruleConstraintRule.current; }
	EOF;

// Rule ConstraintRule
ruleConstraintRule returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			{
				$current = forceCreateModelElement(
					grammarAccess.getConstraintRuleAccess().getConstraintRuleAction_0(),
					$current);
			}
		)
		(
			(
				(
					{
						newCompositeNode(grammarAccess.getConstraintRuleAccess().getConstraintsConstraintParserRuleCall_1_0_0());
					}
					lv_Constraints_1_0=ruleConstraint
					{
						if ($current==null) {
							$current = createModelElementForParent(grammarAccess.getConstraintRuleRule());
						}
						add(
							$current,
							"Constraints",
							lv_Constraints_1_0,
							"org.eclipse.vorto.editor.datatype.Datatype.Constraint");
						afterParserOrEnumRuleCall();
					}
				)
			)
			(
				otherlv_2=','
				{
					newLeafNode(otherlv_2, grammarAccess.getConstraintRuleAccess().getCommaKeyword_1_1_0());
				}
				(
					(
						{
							newCompositeNode(grammarAccess.getConstraintRuleAccess().getConstraintsConstraintParserRuleCall_1_1_1_0());
						}
						lv_Constraints_3_0=ruleConstraint
						{
							if ($current==null) {
								$current = createModelElementForParent(grammarAccess.getConstraintRuleRule());
							}
							add(
								$current,
								"Constraints",
								lv_Constraints_3_0,
								"org.eclipse.vorto.editor.datatype.Datatype.Constraint");
							afterParserOrEnumRuleCall();
						}
					)
				)
			)*
		)?
	)
;

// Entry rule entryRulePropertyAttribute
entryRulePropertyAttribute returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getPropertyAttributeRule()); }
	iv_rulePropertyAttribute=rulePropertyAttribute
	{ $current=$iv_rulePropertyAttribute.current; }
	EOF;

// Rule PropertyAttribute
rulePropertyAttribute returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		{
			newCompositeNode(grammarAccess.getPropertyAttributeAccess().getBooleanPropertyAttributeParserRuleCall_0());
		}
		this_BooleanPropertyAttribute_0=ruleBooleanPropertyAttribute
		{
			$current = $this_BooleanPropertyAttribute_0.current;
			afterParserOrEnumRuleCall();
		}
		    |
		{
			newCompositeNode(grammarAccess.getPropertyAttributeAccess().getEnumLiteralPropertyAttributeParserRuleCall_1());
		}
		this_EnumLiteralPropertyAttribute_1=ruleEnumLiteralPropertyAttribute
		{
			$current = $this_EnumLiteralPropertyAttribute_1.current;
			afterParserOrEnumRuleCall();
		}
	)
;

// Entry rule entryRuleBooleanPropertyAttribute
entryRuleBooleanPropertyAttribute returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getBooleanPropertyAttributeRule()); }
	iv_ruleBooleanPropertyAttribute=ruleBooleanPropertyAttribute
	{ $current=$iv_ruleBooleanPropertyAttribute.current; }
	EOF;

// Rule BooleanPropertyAttribute
ruleBooleanPropertyAttribute returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			(
				{
					newCompositeNode(grammarAccess.getBooleanPropertyAttributeAccess().getTypeBooleanPropertyAttributeTypeEnumRuleCall_0_0());
				}
				lv_type_0_0=ruleBooleanPropertyAttributeType
				{
					if ($current==null) {
						$current = createModelElementForParent(grammarAccess.getBooleanPropertyAttributeRule());
					}
					set(
						$current,
						"type",
						lv_type_0_0,
						"org.eclipse.vorto.editor.datatype.Datatype.BooleanPropertyAttributeType");
					afterParserOrEnumRuleCall();
				}
			)
		)
		otherlv_1=':'
		{
			newLeafNode(otherlv_1, grammarAccess.getBooleanPropertyAttributeAccess().getColonKeyword_1());
		}
		(
			(
				(
					lv_value_2_0='true'
					{
						newLeafNode(lv_value_2_0, grammarAccess.getBooleanPropertyAttributeAccess().getValueTrueKeyword_2_0_0());
					}
					{
						if ($current==null) {
							$current = createModelElement(grammarAccess.getBooleanPropertyAttributeRule());
						}
						setWithLastConsumed($current, "value", true, "true");
					}
				)
			)
			    |
			otherlv_3='false'
			{
				newLeafNode(otherlv_3, grammarAccess.getBooleanPropertyAttributeAccess().getFalseKeyword_2_1());
			}
		)
	)
;

// Entry rule entryRuleEnumLiteralPropertyAttribute
entryRuleEnumLiteralPropertyAttribute returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getEnumLiteralPropertyAttributeRule()); }
	iv_ruleEnumLiteralPropertyAttribute=ruleEnumLiteralPropertyAttribute
	{ $current=$iv_ruleEnumLiteralPropertyAttribute.current; }
	EOF;

// Rule EnumLiteralPropertyAttribute
ruleEnumLiteralPropertyAttribute returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			(
				{
					newCompositeNode(grammarAccess.getEnumLiteralPropertyAttributeAccess().getTypeEnumLiteralPropertyAttributeTypeEnumRuleCall_0_0());
				}
				lv_type_0_0=ruleEnumLiteralPropertyAttributeType
				{
					if ($current==null) {
						$current = createModelElementForParent(grammarAccess.getEnumLiteralPropertyAttributeRule());
					}
					set(
						$current,
						"type",
						lv_type_0_0,
						"org.eclipse.vorto.editor.datatype.Datatype.EnumLiteralPropertyAttributeType");
					afterParserOrEnumRuleCall();
				}
			)
		)
		otherlv_1=':'
		{
			newLeafNode(otherlv_1, grammarAccess.getEnumLiteralPropertyAttributeAccess().getColonKeyword_1());
		}
		(
			(
				{
					if ($current==null) {
						$current = createModelElement(grammarAccess.getEnumLiteralPropertyAttributeRule());
					}
				}
				{
					newCompositeNode(grammarAccess.getEnumLiteralPropertyAttributeAccess().getValueEnumLiteralCrossReference_2_0());
				}
				ruleQualifiedName
				{
					afterParserOrEnumRuleCall();
				}
			)
		)
	)
;

// Entry rule entryRulePropertyType
entryRulePropertyType returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getPropertyTypeRule()); }
	iv_rulePropertyType=rulePropertyType
	{ $current=$iv_rulePropertyType.current; }
	EOF;

// Rule PropertyType
rulePropertyType returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		{
			newCompositeNode(grammarAccess.getPropertyTypeAccess().getObjectPropertyTypeParserRuleCall_0());
		}
		this_ObjectPropertyType_0=ruleObjectPropertyType
		{
			$current = $this_ObjectPropertyType_0.current;
			afterParserOrEnumRuleCall();
		}
		    |
		{
			newCompositeNode(grammarAccess.getPropertyTypeAccess().getPrimitivePropertyTypeParserRuleCall_1());
		}
		this_PrimitivePropertyType_1=rulePrimitivePropertyType
		{
			$current = $this_PrimitivePropertyType_1.current;
			afterParserOrEnumRuleCall();
		}
		    |
		{
			newCompositeNode(grammarAccess.getPropertyTypeAccess().getComplexPrimitivePropertyTypeParserRuleCall_2());
		}
		this_ComplexPrimitivePropertyType_2=ruleComplexPrimitivePropertyType
		{
			$current = $this_ComplexPrimitivePropertyType_2.current;
			afterParserOrEnumRuleCall();
		}
	)
;

// Entry rule entryRulePrimitivePropertyType
entryRulePrimitivePropertyType returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getPrimitivePropertyTypeRule()); }
	iv_rulePrimitivePropertyType=rulePrimitivePropertyType
	{ $current=$iv_rulePrimitivePropertyType.current; }
	EOF;

// Rule PrimitivePropertyType
rulePrimitivePropertyType returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			{
				newCompositeNode(grammarAccess.getPrimitivePropertyTypeAccess().getTypePrimitiveTypeEnumRuleCall_0());
			}
			lv_type_0_0=rulePrimitiveType
			{
				if ($current==null) {
					$current = createModelElementForParent(grammarAccess.getPrimitivePropertyTypeRule());
				}
				set(
					$current,
					"type",
					lv_type_0_0,
					"org.eclipse.vorto.editor.datatype.Datatype.PrimitiveType");
				afterParserOrEnumRuleCall();
			}
		)
	)
;

// Entry rule entryRuleObjectPropertyType
entryRuleObjectPropertyType returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getObjectPropertyTypeRule()); }
	iv_ruleObjectPropertyType=ruleObjectPropertyType
	{ $current=$iv_ruleObjectPropertyType.current; }
	EOF;

// Rule ObjectPropertyType
ruleObjectPropertyType returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			{
				if ($current==null) {
					$current = createModelElement(grammarAccess.getObjectPropertyTypeRule());
				}
			}
			{
				newCompositeNode(grammarAccess.getObjectPropertyTypeAccess().getTypeTypeCrossReference_0());
			}
			ruleQualifiedName
			{
				afterParserOrEnumRuleCall();
			}
		)
	)
;

// Entry rule entryRuleComplexPrimitivePropertyType
entryRuleComplexPrimitivePropertyType returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getComplexPrimitivePropertyTypeRule()); }
	iv_ruleComplexPrimitivePropertyType=ruleComplexPrimitivePropertyType
	{ $current=$iv_ruleComplexPrimitivePropertyType.current; }
	EOF;

// Rule ComplexPrimitivePropertyType
ruleComplexPrimitivePropertyType returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	{
		newCompositeNode(grammarAccess.getComplexPrimitivePropertyTypeAccess().getDictionaryPropertyTypeParserRuleCall());
	}
	this_DictionaryPropertyType_0=ruleDictionaryPropertyType
	{
		$current = $this_DictionaryPropertyType_0.current;
		afterParserOrEnumRuleCall();
	}
;

// Entry rule entryRuleDictionaryPropertyType
entryRuleDictionaryPropertyType returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getDictionaryPropertyTypeRule()); }
	iv_ruleDictionaryPropertyType=ruleDictionaryPropertyType
	{ $current=$iv_ruleDictionaryPropertyType.current; }
	EOF;

// Rule DictionaryPropertyType
ruleDictionaryPropertyType returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			{
				$current = forceCreateModelElement(
					grammarAccess.getDictionaryPropertyTypeAccess().getDictionaryPropertyTypeAction_0(),
					$current);
			}
		)
		otherlv_1='dictionary'
		{
			newLeafNode(otherlv_1, grammarAccess.getDictionaryPropertyTypeAccess().getDictionaryKeyword_1());
		}
		(
			otherlv_2='['
			{
				newLeafNode(otherlv_2, grammarAccess.getDictionaryPropertyTypeAccess().getLeftSquareBracketKeyword_2_0());
			}
			(
				(
					{
						newCompositeNode(grammarAccess.getDictionaryPropertyTypeAccess().getKeyTypePropertyTypeParserRuleCall_2_1_0());
					}
					lv_keyType_3_0=rulePropertyType
					{
						if ($current==null) {
							$current = createModelElementForParent(grammarAccess.getDictionaryPropertyTypeRule());
						}
						set(
							$current,
							"keyType",
							lv_keyType_3_0,
							"org.eclipse.vorto.editor.datatype.Datatype.PropertyType");
						afterParserOrEnumRuleCall();
					}
				)
			)
			otherlv_4=','
			{
				newLeafNode(otherlv_4, grammarAccess.getDictionaryPropertyTypeAccess().getCommaKeyword_2_2());
			}
			(
				(
					{
						newCompositeNode(grammarAccess.getDictionaryPropertyTypeAccess().getValueTypePropertyTypeParserRuleCall_2_3_0());
					}
					lv_valueType_5_0=rulePropertyType
					{
						if ($current==null) {
							$current = createModelElementForParent(grammarAccess.getDictionaryPropertyTypeRule());
						}
						set(
							$current,
							"valueType",
							lv_valueType_5_0,
							"org.eclipse.vorto.editor.datatype.Datatype.PropertyType");
						afterParserOrEnumRuleCall();
					}
				)
			)
			otherlv_6=']'
			{
				newLeafNode(otherlv_6, grammarAccess.getDictionaryPropertyTypeAccess().getRightSquareBracketKeyword_2_4());
			}
		)?
	)
;

// Entry rule entryRulePresence
entryRulePresence returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getPresenceRule()); }
	iv_rulePresence=rulePresence
	{ $current=$iv_rulePresence.current; }
	EOF;

// Rule Presence
rulePresence returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			{
				$current = forceCreateModelElement(
					grammarAccess.getPresenceAccess().getPresenceAction_0(),
					$current);
			}
		)
		(
			(
				(
					lv_mandatory_1_0='mandatory'
					{
						newLeafNode(lv_mandatory_1_0, grammarAccess.getPresenceAccess().getMandatoryMandatoryKeyword_1_0_0());
					}
					{
						if ($current==null) {
							$current = createModelElement(grammarAccess.getPresenceRule());
						}
						setWithLastConsumed($current, "mandatory", true, "mandatory");
					}
				)
			)
			    |
			otherlv_2='optional'
			{
				newLeafNode(otherlv_2, grammarAccess.getPresenceAccess().getOptionalKeyword_1_1());
			}
		)
	)
;

// Entry rule entryRuleConstraint
entryRuleConstraint returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getConstraintRule()); }
	iv_ruleConstraint=ruleConstraint
	{ $current=$iv_ruleConstraint.current; }
	EOF;

// Rule Constraint
ruleConstraint returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			(
				{
					newCompositeNode(grammarAccess.getConstraintAccess().getTypeConstraintIntervalTypeEnumRuleCall_0_0());
				}
				lv_type_0_0=ruleConstraintIntervalType
				{
					if ($current==null) {
						$current = createModelElementForParent(grammarAccess.getConstraintRule());
					}
					set(
						$current,
						"type",
						lv_type_0_0,
						"org.eclipse.vorto.editor.datatype.Datatype.ConstraintIntervalType");
					afterParserOrEnumRuleCall();
				}
			)
		)
		(
			(
				{
					newCompositeNode(grammarAccess.getConstraintAccess().getConstraintValuesIntervalTypeParserRuleCall_1_0());
				}
				lv_constraintValues_1_0=ruleIntervalType
				{
					if ($current==null) {
						$current = createModelElementForParent(grammarAccess.getConstraintRule());
					}
					set(
						$current,
						"constraintValues",
						lv_constraintValues_1_0,
						"org.eclipse.vorto.editor.datatype.Datatype.IntervalType");
					afterParserOrEnumRuleCall();
				}
			)
		)
	)
;

// Entry rule entryRuleIntervalType
entryRuleIntervalType returns [String current=null]:
	{ newCompositeNode(grammarAccess.getIntervalTypeRule()); }
	iv_ruleIntervalType=ruleIntervalType
	{ $current=$iv_ruleIntervalType.current.getText(); }
	EOF;

// Rule IntervalType
ruleIntervalType returns [AntlrDatatypeRuleToken current=new AntlrDatatypeRuleToken()]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		this_INT_0=RULE_INT
		{
			$current.merge(this_INT_0);
		}
		{
			newLeafNode(this_INT_0, grammarAccess.getIntervalTypeAccess().getINTTerminalRuleCall_0());
		}
		    |
		this_SIGNEDINT_1=RULE_SIGNEDINT
		{
			$current.merge(this_SIGNEDINT_1);
		}
		{
			newLeafNode(this_SIGNEDINT_1, grammarAccess.getIntervalTypeAccess().getSIGNEDINTTerminalRuleCall_1());
		}
		    |
		this_FLOAT_2=RULE_FLOAT
		{
			$current.merge(this_FLOAT_2);
		}
		{
			newLeafNode(this_FLOAT_2, grammarAccess.getIntervalTypeAccess().getFLOATTerminalRuleCall_2());
		}
		    |
		this_DATETIME_3=RULE_DATETIME
		{
			$current.merge(this_DATETIME_3);
		}
		{
			newLeafNode(this_DATETIME_3, grammarAccess.getIntervalTypeAccess().getDATETIMETerminalRuleCall_3());
		}
		    |
		this_STRING_4=RULE_STRING
		{
			$current.merge(this_STRING_4);
		}
		{
			newLeafNode(this_STRING_4, grammarAccess.getIntervalTypeAccess().getSTRINGTerminalRuleCall_4());
		}
		    |
		{
			newCompositeNode(grammarAccess.getIntervalTypeAccess().getBOOLEANParserRuleCall_5());
		}
		this_BOOLEAN_5=ruleBOOLEAN
		{
			$current.merge(this_BOOLEAN_5);
		}
		{
			afterParserOrEnumRuleCall();
		}
	)
;

// Entry rule entryRuleBOOLEAN
entryRuleBOOLEAN returns [String current=null]:
	{ newCompositeNode(grammarAccess.getBOOLEANRule()); }
	iv_ruleBOOLEAN=ruleBOOLEAN
	{ $current=$iv_ruleBOOLEAN.current.getText(); }
	EOF;

// Rule BOOLEAN
ruleBOOLEAN returns [AntlrDatatypeRuleToken current=new AntlrDatatypeRuleToken()]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		kw='true'
		{
			$current.merge(kw);
			newLeafNode(kw, grammarAccess.getBOOLEANAccess().getTrueKeyword_0());
		}
		    |
		kw='false'
		{
			$current.merge(kw);
			newLeafNode(kw, grammarAccess.getBOOLEANAccess().getFalseKeyword_1());
		}
	)
;

// Entry rule entryRuleCATEGORY
entryRuleCATEGORY returns [String current=null]:
	{ newCompositeNode(grammarAccess.getCATEGORYRule()); }
	iv_ruleCATEGORY=ruleCATEGORY
	{ $current=$iv_ruleCATEGORY.current.getText(); }
	EOF;

// Rule CATEGORY
ruleCATEGORY returns [AntlrDatatypeRuleToken current=new AntlrDatatypeRuleToken()]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		this_ID_0=RULE_ID
		{
			$current.merge(this_ID_0);
		}
		{
			newLeafNode(this_ID_0, grammarAccess.getCATEGORYAccess().getIDTerminalRuleCall_0());
		}
		(
			kw='/'
			{
				$current.merge(kw);
				newLeafNode(kw, grammarAccess.getCATEGORYAccess().getSolidusKeyword_1_0());
			}
			this_ID_2=RULE_ID
			{
				$current.merge(this_ID_2);
			}
			{
				newLeafNode(this_ID_2, grammarAccess.getCATEGORYAccess().getIDTerminalRuleCall_1_1());
			}
		)*
	)
;

// Entry rule entryRuleValidID
entryRuleValidID returns [String current=null]:
	{ newCompositeNode(grammarAccess.getValidIDRule()); }
	iv_ruleValidID=ruleValidID
	{ $current=$iv_ruleValidID.current.getText(); }
	EOF;

// Rule ValidID
ruleValidID returns [AntlrDatatypeRuleToken current=new AntlrDatatypeRuleToken()]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		this_ID_0=RULE_ID
		{
			$current.merge(this_ID_0);
		}
		{
			newLeafNode(this_ID_0, grammarAccess.getValidIDAccess().getIDTerminalRuleCall_0());
		}
		    |
		{
			newCompositeNode(grammarAccess.getValidIDAccess().getKEYWORDParserRuleCall_1());
		}
		this_KEYWORD_1=ruleKEYWORD
		{
			$current.merge(this_KEYWORD_1);
		}
		{
			afterParserOrEnumRuleCall();
		}
	)
;

// Entry rule entryRuleKEYWORD
entryRuleKEYWORD returns [String current=null]:
	{ newCompositeNode(grammarAccess.getKEYWORDRule()); }
	iv_ruleKEYWORD=ruleKEYWORD
	{ $current=$iv_ruleKEYWORD.current.getText(); }
	EOF;

// Rule KEYWORD
ruleKEYWORD returns [AntlrDatatypeRuleToken current=new AntlrDatatypeRuleToken()]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		kw='breakable'
		{
			$current.merge(kw);
			newLeafNode(kw, grammarAccess.getKEYWORDAccess().getBreakableKeyword_0());
		}
		    |
		kw='category'
		{
			$current.merge(kw);
			newLeafNode(kw, grammarAccess.getKEYWORDAccess().getCategoryKeyword_1());
		}
		    |
		kw='configuration'
		{
			$current.merge(kw);
			newLeafNode(kw, grammarAccess.getKEYWORDAccess().getConfigurationKeyword_2());
		}
		    |
		kw='dateTime'
		{
			$current.merge(kw);
			newLeafNode(kw, grammarAccess.getKEYWORDAccess().getDateTimeKeyword_3());
		}
		    |
		kw='description'
		{
			$current.merge(kw);
			newLeafNode(kw, grammarAccess.getKEYWORDAccess().getDescriptionKeyword_4());
		}
		    |
		kw='dictionary'
		{
			$current.merge(kw);
			newLeafNode(kw, grammarAccess.getKEYWORDAccess().getDictionaryKeyword_5());
		}
		    |
		kw='displayname'
		{
			$current.merge(kw);
			newLeafNode(kw, grammarAccess.getKEYWORDAccess().getDisplaynameKeyword_6());
		}
		    |
		kw='events'
		{
			$current.merge(kw);
			newLeafNode(kw, grammarAccess.getKEYWORDAccess().getEventsKeyword_7());
		}
		    |
		kw='extension'
		{
			$current.merge(kw);
			newLeafNode(kw, grammarAccess.getKEYWORDAccess().getExtensionKeyword_8());
		}
		    |
		kw='fault'
		{
			$current.merge(kw);
			newLeafNode(kw, grammarAccess.getKEYWORDAccess().getFaultKeyword_9());
		}
		    |
		kw='functionblock'
		{
			$current.merge(kw);
			newLeafNode(kw, grammarAccess.getKEYWORDAccess().getFunctionblockKeyword_10());
		}
		    |
		kw='functionblocks'
		{
			$current.merge(kw);
			newLeafNode(kw, grammarAccess.getKEYWORDAccess().getFunctionblocksKeyword_11());
		}
		    |
		kw='infomodel'
		{
			$current.merge(kw);
			newLeafNode(kw, grammarAccess.getKEYWORDAccess().getInfomodelKeyword_12());
		}
		    |
		kw='mandatory'
		{
			$current.merge(kw);
			newLeafNode(kw, grammarAccess.getKEYWORDAccess().getMandatoryKeyword_13());
		}
		    |
		kw='namespace'
		{
			$current.merge(kw);
			newLeafNode(kw, grammarAccess.getKEYWORDAccess().getNamespaceKeyword_14());
		}
		    |
		kw='operations'
		{
			$current.merge(kw);
			newLeafNode(kw, grammarAccess.getKEYWORDAccess().getOperationsKeyword_15());
		}
		    |
		kw='optional'
		{
			$current.merge(kw);
			newLeafNode(kw, grammarAccess.getKEYWORDAccess().getOptionalKeyword_16());
		}
		    |
		kw='status'
		{
			$current.merge(kw);
			newLeafNode(kw, grammarAccess.getKEYWORDAccess().getStatusKeyword_17());
		}
		    |
		kw='version'
		{
			$current.merge(kw);
			newLeafNode(kw, grammarAccess.getKEYWORDAccess().getVersionKeyword_18());
		}
	)
;

// Rule BooleanPropertyAttributeType
ruleBooleanPropertyAttributeType returns [Enumerator current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			enumLiteral_0='readable'
			{
				$current = grammarAccess.getBooleanPropertyAttributeTypeAccess().getReadableEnumLiteralDeclaration_0().getEnumLiteral().getInstance();
				newLeafNode(enumLiteral_0, grammarAccess.getBooleanPropertyAttributeTypeAccess().getReadableEnumLiteralDeclaration_0());
			}
		)
		    |
		(
			enumLiteral_1='writable'
			{
				$current = grammarAccess.getBooleanPropertyAttributeTypeAccess().getWritableEnumLiteralDeclaration_1().getEnumLiteral().getInstance();
				newLeafNode(enumLiteral_1, grammarAccess.getBooleanPropertyAttributeTypeAccess().getWritableEnumLiteralDeclaration_1());
			}
		)
		    |
		(
			enumLiteral_2='eventable'
			{
				$current = grammarAccess.getBooleanPropertyAttributeTypeAccess().getEventableEnumLiteralDeclaration_2().getEnumLiteral().getInstance();
				newLeafNode(enumLiteral_2, grammarAccess.getBooleanPropertyAttributeTypeAccess().getEventableEnumLiteralDeclaration_2());
			}
		)
	)
;

// Rule VortoLangVersion
ruleVortoLangVersion returns [Enumerator current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		enumLiteral_0='1.0'
		{
			$current = grammarAccess.getVortoLangVersionAccess().getVersion1EnumLiteralDeclaration().getEnumLiteral().getInstance();
			newLeafNode(enumLiteral_0, grammarAccess.getVortoLangVersionAccess().getVersion1EnumLiteralDeclaration());
		}
	)
;

// Rule EnumLiteralPropertyAttributeType
ruleEnumLiteralPropertyAttributeType returns [Enumerator current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		enumLiteral_0='measurementUnit'
		{
			$current = grammarAccess.getEnumLiteralPropertyAttributeTypeAccess().getMeasurementUnitEnumLiteralDeclaration().getEnumLiteral().getInstance();
			newLeafNode(enumLiteral_0, grammarAccess.getEnumLiteralPropertyAttributeTypeAccess().getMeasurementUnitEnumLiteralDeclaration());
		}
	)
;

// Rule PrimitiveType
rulePrimitiveType returns [Enumerator current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			enumLiteral_0='string'
			{
				$current = grammarAccess.getPrimitiveTypeAccess().getStringEnumLiteralDeclaration_0().getEnumLiteral().getInstance();
				newLeafNode(enumLiteral_0, grammarAccess.getPrimitiveTypeAccess().getStringEnumLiteralDeclaration_0());
			}
		)
		    |
		(
			enumLiteral_1='int'
			{
				$current = grammarAccess.getPrimitiveTypeAccess().getIntEnumLiteralDeclaration_1().getEnumLiteral().getInstance();
				newLeafNode(enumLiteral_1, grammarAccess.getPrimitiveTypeAccess().getIntEnumLiteralDeclaration_1());
			}
		)
		    |
		(
			enumLiteral_2='float'
			{
				$current = grammarAccess.getPrimitiveTypeAccess().getFloatEnumLiteralDeclaration_2().getEnumLiteral().getInstance();
				newLeafNode(enumLiteral_2, grammarAccess.getPrimitiveTypeAccess().getFloatEnumLiteralDeclaration_2());
			}
		)
		    |
		(
			enumLiteral_3='boolean'
			{
				$current = grammarAccess.getPrimitiveTypeAccess().getBooleanEnumLiteralDeclaration_3().getEnumLiteral().getInstance();
				newLeafNode(enumLiteral_3, grammarAccess.getPrimitiveTypeAccess().getBooleanEnumLiteralDeclaration_3());
			}
		)
		    |
		(
			enumLiteral_4='dateTime'
			{
				$current = grammarAccess.getPrimitiveTypeAccess().getDatetimeEnumLiteralDeclaration_4().getEnumLiteral().getInstance();
				newLeafNode(enumLiteral_4, grammarAccess.getPrimitiveTypeAccess().getDatetimeEnumLiteralDeclaration_4());
			}
		)
		    |
		(
			enumLiteral_5='double'
			{
				$current = grammarAccess.getPrimitiveTypeAccess().getDoubleEnumLiteralDeclaration_5().getEnumLiteral().getInstance();
				newLeafNode(enumLiteral_5, grammarAccess.getPrimitiveTypeAccess().getDoubleEnumLiteralDeclaration_5());
			}
		)
		    |
		(
			enumLiteral_6='long'
			{
				$current = grammarAccess.getPrimitiveTypeAccess().getLongEnumLiteralDeclaration_6().getEnumLiteral().getInstance();
				newLeafNode(enumLiteral_6, grammarAccess.getPrimitiveTypeAccess().getLongEnumLiteralDeclaration_6());
			}
		)
		    |
		(
			enumLiteral_7='short'
			{
				$current = grammarAccess.getPrimitiveTypeAccess().getShortEnumLiteralDeclaration_7().getEnumLiteral().getInstance();
				newLeafNode(enumLiteral_7, grammarAccess.getPrimitiveTypeAccess().getShortEnumLiteralDeclaration_7());
			}
		)
		    |
		(
			enumLiteral_8='base64Binary'
			{
				$current = grammarAccess.getPrimitiveTypeAccess().getBase64BinaryEnumLiteralDeclaration_8().getEnumLiteral().getInstance();
				newLeafNode(enumLiteral_8, grammarAccess.getPrimitiveTypeAccess().getBase64BinaryEnumLiteralDeclaration_8());
			}
		)
		    |
		(
			enumLiteral_9='byte'
			{
				$current = grammarAccess.getPrimitiveTypeAccess().getByteEnumLiteralDeclaration_9().getEnumLiteral().getInstance();
				newLeafNode(enumLiteral_9, grammarAccess.getPrimitiveTypeAccess().getByteEnumLiteralDeclaration_9());
			}
		)
	)
;

// Rule ConstraintIntervalType
ruleConstraintIntervalType returns [Enumerator current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			enumLiteral_0='MIN'
			{
				$current = grammarAccess.getConstraintIntervalTypeAccess().getMinEnumLiteralDeclaration_0().getEnumLiteral().getInstance();
				newLeafNode(enumLiteral_0, grammarAccess.getConstraintIntervalTypeAccess().getMinEnumLiteralDeclaration_0());
			}
		)
		    |
		(
			enumLiteral_1='MAX'
			{
				$current = grammarAccess.getConstraintIntervalTypeAccess().getMaxEnumLiteralDeclaration_1().getEnumLiteral().getInstance();
				newLeafNode(enumLiteral_1, grammarAccess.getConstraintIntervalTypeAccess().getMaxEnumLiteralDeclaration_1());
			}
		)
		    |
		(
			enumLiteral_2='STRLEN'
			{
				$current = grammarAccess.getConstraintIntervalTypeAccess().getStrlenEnumLiteralDeclaration_2().getEnumLiteral().getInstance();
				newLeafNode(enumLiteral_2, grammarAccess.getConstraintIntervalTypeAccess().getStrlenEnumLiteralDeclaration_2());
			}
		)
		    |
		(
			enumLiteral_3='REGEX'
			{
				$current = grammarAccess.getConstraintIntervalTypeAccess().getRegexEnumLiteralDeclaration_3().getEnumLiteral().getInstance();
				newLeafNode(enumLiteral_3, grammarAccess.getConstraintIntervalTypeAccess().getRegexEnumLiteralDeclaration_3());
			}
		)
		    |
		(
			enumLiteral_4='MIMETYPE'
			{
				$current = grammarAccess.getConstraintIntervalTypeAccess().getMimetypeEnumLiteralDeclaration_4().getEnumLiteral().getInstance();
				newLeafNode(enumLiteral_4, grammarAccess.getConstraintIntervalTypeAccess().getMimetypeEnumLiteralDeclaration_4());
			}
		)
		    |
		(
			enumLiteral_5='SCALING'
			{
				$current = grammarAccess.getConstraintIntervalTypeAccess().getScalingEnumLiteralDeclaration_5().getEnumLiteral().getInstance();
				newLeafNode(enumLiteral_5, grammarAccess.getConstraintIntervalTypeAccess().getScalingEnumLiteralDeclaration_5());
			}
		)
		    |
		(
			enumLiteral_6='DEFAULT'
			{
				$current = grammarAccess.getConstraintIntervalTypeAccess().getDefaultEnumLiteralDeclaration_6().getEnumLiteral().getInstance();
				newLeafNode(enumLiteral_6, grammarAccess.getConstraintIntervalTypeAccess().getDefaultEnumLiteralDeclaration_6());
			}
		)
		    |
		(
			enumLiteral_7='NULLABLE'
			{
				$current = grammarAccess.getConstraintIntervalTypeAccess().getNullableEnumLiteralDeclaration_7().getEnumLiteral().getInstance();
				newLeafNode(enumLiteral_7, grammarAccess.getConstraintIntervalTypeAccess().getNullableEnumLiteralDeclaration_7());
			}
		)
	)
;

RULE_SIGNEDINT : '-' RULE_INT;

RULE_FLOAT : '-'? RULE_INT '.' RULE_INT;

fragment RULE_DATE : '0'..'9' '0'..'9' '0'..'9' '0'..'9' '-' '0'..'9' '0'..'9' '-' '0'..'9' '0'..'9';

fragment RULE_TIME : '0'..'9' '0'..'9' ':' '0'..'9' '0'..'9' ':' '0'..'9' '0'..'9' RULE_TIMEZONE?;

fragment RULE_TIMEZONE : ('Z'|('+'|'-') '0'..'9' '0'..'9' ':' '0'..'9' '0'..'9');

RULE_DATETIME : RULE_DATE 'T' RULE_TIME;

RULE_VERSION : ('0'..'9')* '.' ('0'..'9')* '.' ('0'..'9')* ('-' RULE_ID)?;

RULE_ID : '^'? ('a'..'z'|'A'..'Z'|'_') ('a'..'z'|'A'..'Z'|'_'|'0'..'9')*;

RULE_INT : ('0'..'9')+;

RULE_STRING : ('"' ('\\' .|~(('\\'|'"')))* '"'|'\'' ('\\' .|~(('\\'|'\'')))* '\'');

RULE_ML_COMMENT : '/*' ( options {greedy=false;} : . )*'*/';

RULE_SL_COMMENT : '//' ~(('\n'|'\r'))* ('\r'? '\n')?;

RULE_WS : (' '|'\t'|'\r'|'\n')+;

RULE_ANY_OTHER : .;
