/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.core.entity;

import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.List;
import org.apache.openejb.BeanContext;
import org.apache.openejb.Container;
import org.apache.openejb.InterfaceType;
import org.apache.openejb.core.ivm.EjbObjectProxyHandler;
import org.apache.openejb.util.proxy.ProxyManager;

public class EntityEjbObjectHandler
extends EjbObjectProxyHandler {
    private Object registryId;

    public EntityEjbObjectHandler(BeanContext beanContext, Object pk, InterfaceType interfaceType, List<Class> interfaces, Class mainInterface) {
        super(beanContext, pk, interfaceType, interfaces, mainInterface);
    }

    public static Object getRegistryId(Container container, Object deploymentId, Object primaryKey) {
        return new RegistryId(container, deploymentId, primaryKey);
    }

    @Override
    public Object getRegistryId() {
        if (this.registryId == null) {
            this.registryId = EntityEjbObjectHandler.getRegistryId(this.container, this.deploymentID, this.primaryKey);
        }
        return this.registryId;
    }

    @Override
    protected Object getPrimaryKey(Method method, Object[] args, Object proxy) throws Throwable {
        return this.primaryKey;
    }

    @Override
    protected Object isIdentical(Method method, Object[] args, Object proxy) throws Throwable {
        this.checkAuthorization(method);
        if (args.length != 1) {
            throw new IllegalArgumentException("Expected one argument to isIdentical, but received " + args.length);
        }
        Object that = args[0];
        InvocationHandler invocationHandler = ProxyManager.getInvocationHandler(that);
        if (invocationHandler instanceof EntityEjbObjectHandler) {
            EntityEjbObjectHandler handler = (EntityEjbObjectHandler)invocationHandler;
            return this.getRegistryId().equals(handler.getRegistryId());
        }
        return false;
    }

    @Override
    protected Object remove(Class interfce, Method method, Object[] args, Object proxy) throws Throwable {
        this.checkAuthorization(method);
        Object value = this.container.invoke(this.deploymentID, this.interfaceType, interfce, method, args, this.primaryKey);
        this.invalidateAllHandlers(this.getRegistryId());
        return value;
    }

    @Override
    public void invalidateReference() {
    }

    private static class RegistryId
    implements Serializable {
        private static final long serialVersionUID = -6009230402616418827L;
        private final Object containerId;
        private final Object deploymentId;
        private final Object primaryKey;

        public RegistryId(Container container, Object deploymentId, Object primaryKey) {
            if (container == null) {
                throw new NullPointerException("container is null");
            }
            if (deploymentId == null) {
                throw new NullPointerException("deploymentId is null");
            }
            this.containerId = container.getContainerID();
            this.deploymentId = deploymentId;
            this.primaryKey = primaryKey;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            RegistryId that = (RegistryId)o;
            return this.containerId.equals(that.containerId) && this.deploymentId.equals(that.deploymentId) && !(this.primaryKey == null ? that.primaryKey != null : !this.primaryKey.equals(that.primaryKey));
        }

        public int hashCode() {
            int result = this.containerId.hashCode();
            result = 31 * result + this.deploymentId.hashCode();
            result = 31 * result + (this.primaryKey != null ? this.primaryKey.hashCode() : 0);
            return result;
        }

        public String toString() {
            return "[" + this.containerId + ", " + this.deploymentId + ", " + this.primaryKey + "]";
        }
    }
}

