/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.core.interceptor;

import java.io.PrintStream;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import javax.interceptor.InvocationContext;
import javax.xml.rpc.handler.MessageContext;
import org.apache.openejb.core.Operation;
import org.apache.openejb.core.ThreadContext;
import org.apache.openejb.core.interceptor.Interceptor;
import org.apache.openejb.core.interceptor.InterceptorData;
import org.apache.openejb.core.interceptor.JaxRpcInvocationContext;
import org.apache.openejb.core.interceptor.JaxWsInvocationContext;
import org.apache.openejb.core.interceptor.ReflectionInvocationContext;
import org.apache.openejb.util.Classes;
import org.apache.openejb.util.Join;
import org.apache.openejb.util.LogCategory;
import org.apache.openejb.util.Logger;
import org.apache.openejb.util.proxy.DynamicProxyImplFactory;

public class InterceptorStack {
    private static final Logger logger = Logger.getInstance(LogCategory.OPENEJB, "org.apache.openejb.util.resources");
    private final Object beanInstance;
    private final List<Interceptor> interceptors;
    private final Method targetMethod;
    private final Operation operation;
    private static final ThreadLocal<Stack> stack = new ThreadLocal();

    public InterceptorStack(Object beanInstance, Method targetMethod, Operation operation, List<InterceptorData> interceptorDatas, Map<String, Object> interceptorInstances) {
        if (interceptorDatas == null) {
            throw new NullPointerException("interceptorDatas is null");
        }
        if (interceptorInstances == null) {
            throw new NullPointerException("interceptorInstances is null");
        }
        this.beanInstance = beanInstance;
        this.targetMethod = targetMethod;
        this.operation = operation;
        this.interceptors = new ArrayList<Interceptor>(interceptorDatas.size());
        for (InterceptorData interceptorData : interceptorDatas) {
            Class interceptorClass = interceptorData.getInterceptorClass();
            Object interceptorInstance = interceptorInstances.get(interceptorClass.getName());
            if (interceptorInstance == null) {
                throw new IllegalArgumentException("No interceptor of type " + interceptorClass.getName());
            }
            Set<Method> methods = interceptorData.getMethods(operation);
            for (Method method : methods) {
                Object handler = DynamicProxyImplFactory.realHandler(interceptorInstance);
                Interceptor interceptor = handler != null && method.getDeclaringClass().equals(handler.getClass()) ? new Interceptor(handler, method) : new Interceptor(interceptorInstance, method);
                this.interceptors.add(interceptor);
            }
        }
    }

    public InvocationContext createInvocationContext(Object ... parameters) {
        ReflectionInvocationContext invocationContext = new ReflectionInvocationContext(this.operation, this.interceptors, this.beanInstance, this.targetMethod, parameters);
        return invocationContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(Object ... parameters) throws Exception {
        try {
            Object value;
            InvocationContext invocationContext = this.createInvocationContext(parameters);
            if (ThreadContext.getThreadContext() != null) {
                ThreadContext.getThreadContext().set(InvocationContext.class, invocationContext);
            }
            Object object = value = invocationContext.proceed();
            return object;
        }
        finally {
            if (ThreadContext.getThreadContext() != null) {
                ThreadContext.getThreadContext().remove(InvocationContext.class);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(javax.xml.ws.handler.MessageContext messageContext, Object ... parameters) throws Exception {
        try {
            Object value;
            JaxWsInvocationContext invocationContext = new JaxWsInvocationContext(this.operation, this.interceptors, this.beanInstance, this.targetMethod, messageContext, parameters);
            ThreadContext.getThreadContext().set(InvocationContext.class, invocationContext);
            Object object = value = invocationContext.proceed();
            return object;
        }
        finally {
            ThreadContext.getThreadContext().remove(InvocationContext.class);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(MessageContext messageContext, Object ... parameters) throws Exception {
        try {
            Object value;
            JaxRpcInvocationContext invocationContext = new JaxRpcInvocationContext(this.operation, this.interceptors, this.beanInstance, this.targetMethod, messageContext, parameters);
            ThreadContext.getThreadContext().set(InvocationContext.class, invocationContext);
            Object object = value = invocationContext.proceed();
            return object;
        }
        finally {
            ThreadContext.getThreadContext().remove(InvocationContext.class);
        }
    }

    private class Debug {
        private Debug() {
        }

        private Stack stack() {
            Stack s = (Stack)stack.get();
            if (s == null) {
                s = new Stack();
                stack.set(s);
            }
            return s;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object invoke(InvocationContext context) throws Exception {
            try {
                StringBuilder sb = new StringBuilder();
                ThreadContext threadContext = ThreadContext.getThreadContext();
                String txPolicy = threadContext.getTransactionPolicy().getClass().getSimpleName();
                String ejbName = threadContext.getBeanContext().getEjbName();
                String methodName = InterceptorStack.this.targetMethod.getName() + "(" + Join.join(", ", Classes.getSimpleNames(InterceptorStack.this.targetMethod.getParameterTypes())) + ")";
                sb.append(Join.join("", this.stack()));
                sb.append(ejbName).append(".");
                sb.append(methodName).append(" <").append(txPolicy).append("> {");
                PrintStream printStream = System.out;
                synchronized (printStream) {
                    System.out.println(sb.toString());
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                this.stack().push("  ");
                Object object = context.proceed();
                return object;
            }
            finally {
                this.stack().pop();
                StringBuilder sb = new StringBuilder();
                sb.append(Join.join("", this.stack()));
                sb.append("}");
                PrintStream printStream = System.out;
                synchronized (printStream) {
                    System.out.println(sb.toString());
                }
            }
        }
    }
}

