/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.oxm.record;

import java.util.ArrayList;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLStreamException;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class DomToXMLEventWriter {
    private XMLEventFactory xmlEventFactory;

    public DomToXMLEventWriter() {
        this.xmlEventFactory = XMLEventFactory.newInstance();
    }

    public DomToXMLEventWriter(XMLEventFactory xmlEventFactory) {
        this.xmlEventFactory = xmlEventFactory;
    }

    public void writeToEventWriter(Node dom, XMLEventWriter xew) throws XMLStreamException {
        Node currentNode = dom;
        if (dom.getNodeType() == 9) {
            Document doc = (Document)dom;
            xew.add(this.xmlEventFactory.createStartDocument(doc.getXmlEncoding(), doc.getXmlVersion()));
            currentNode = doc.getDocumentElement();
        }
        if (currentNode.getNodeType() == 1) {
            this.writeElement((Element)currentNode, xew);
        } else if (currentNode.getNodeType() == 2) {
            Attr attribute = (Attr)currentNode;
            if (attribute.getPrefix() != null && attribute.getPrefix().equals("xmlns")) {
                xew.add(this.xmlEventFactory.createNamespace(attribute.getLocalName(), attribute.getValue()));
            } else if (attribute.getPrefix() == null) {
                xew.add(this.xmlEventFactory.createAttribute(attribute.getName(), attribute.getValue()));
            } else {
                xew.add(this.xmlEventFactory.createAttribute(attribute.getPrefix(), attribute.getNamespaceURI(), attribute.getLocalName(), attribute.getValue()));
            }
        } else if (currentNode.getNodeType() == 3) {
            xew.add(this.xmlEventFactory.createCharacters(((Text)currentNode).getNodeValue()));
        }
        if (dom.getNodeType() == 9) {
            xew.add(this.xmlEventFactory.createEndDocument());
        }
    }

    /*
     * WARNING - void declaration
     */
    private void writeElement(Element elem, XMLEventWriter xew) throws XMLStreamException {
        void var6_10;
        Object next;
        void var6_7;
        if (elem.getPrefix() != null && elem.getPrefix().length() > 0) {
            String namespaceURI = xew.getNamespaceContext().getNamespaceURI(elem.getPrefix());
            xew.add(this.xmlEventFactory.createStartElement(elem.getPrefix(), elem.getNamespaceURI(), elem.getLocalName()));
            if (!elem.getNamespaceURI().equals(namespaceURI)) {
                xew.add(this.xmlEventFactory.createNamespace(elem.getPrefix(), elem.getNamespaceURI()));
            }
        } else {
            elem.getLocalName();
            elem.getNodeName();
            if (elem.getNamespaceURI() == null || elem.getNamespaceURI().length() == 0) {
                String defaultNamespace = xew.getNamespaceContext().getNamespaceURI("");
                xew.add(this.xmlEventFactory.createStartElement("", "", elem.getNodeName()));
                if (defaultNamespace != null && defaultNamespace.length() > 0) {
                    xew.add(this.xmlEventFactory.createNamespace(""));
                }
            } else {
                xew.add(this.xmlEventFactory.createStartElement("", elem.getNamespaceURI(), elem.getLocalName()));
            }
        }
        NodeList childNodes = elem.getChildNodes();
        NamedNodeMap attrs = elem.getAttributes();
        ArrayList<Object> nonNamespaceDeclAttrs = new ArrayList<Object>();
        boolean bl = false;
        while (var6_7 < attrs.getLength()) {
            next = (Attr)attrs.item((int)var6_7);
            if (next.getNodeType() == 2) {
                Object attribute = next;
                if (next.getPrefix() != null && next.getPrefix().equals("xmlns")) {
                    String currentUri = xew.getNamespaceContext().getNamespaceURI(next.getLocalName());
                    if (currentUri == null || !currentUri.equals(next.getValue())) {
                        xew.add(this.xmlEventFactory.createNamespace(next.getLocalName(), next.getValue()));
                    }
                } else {
                    nonNamespaceDeclAttrs.add(attribute);
                }
            }
            ++var6_7;
        }
        for (Attr attr : nonNamespaceDeclAttrs) {
            if (attr.getPrefix() == null) {
                xew.add(this.xmlEventFactory.createAttribute(attr.getName(), attr.getValue()));
                continue;
            }
            xew.add(this.xmlEventFactory.createAttribute(attr.getPrefix(), attr.getNamespaceURI(), attr.getLocalName(), attr.getValue()));
        }
        boolean bl2 = false;
        while (var6_10 < childNodes.getLength()) {
            next = childNodes.item((int)var6_10);
            if (next.getNodeType() == 3) {
                xew.add(this.xmlEventFactory.createCharacters(((Text)next).getNodeValue()));
            } else if (next.getNodeType() == 4) {
                xew.add(this.xmlEventFactory.createCData(next.getNodeValue()));
            } else if (next.getNodeType() == 8) {
                xew.add(this.xmlEventFactory.createComment(next.getNodeValue()));
            } else if (next.getNodeType() == 1) {
                this.writeElement((Element)next, xew);
            }
            ++var6_10;
        }
        if (elem.getPrefix() != null && elem.getPrefix().length() > 0) {
            xew.add(this.xmlEventFactory.createEndElement(elem.getPrefix(), elem.getNamespaceURI(), elem.getLocalName()));
        } else if (elem.getNamespaceURI() != null && elem.getNamespaceURI().length() > 0) {
            xew.add(this.xmlEventFactory.createEndElement("", elem.getNamespaceURI(), elem.getLocalName()));
        } else {
            xew.add(this.xmlEventFactory.createEndElement("", "", elem.getNodeName()));
        }
    }
}

