/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.util;

import javax.naming.Context;
import javax.naming.NamingException;

public class Contexts {
    private Contexts() {
    }

    public static void unbindLeaf(Context context, String path) {
        if (path == null) {
            return;
        }
        String[] parts = path.split("/");
        String name = parts[parts.length - 1];
        if (parts.length > 1 && parts[0].startsWith("java:")) {
            parts[0] = parts[0].substring("java:".length());
        }
        Context lastContext = context;
        for (int i = 0; i < parts.length - 1; ++i) {
            try {
                lastContext = (Context)lastContext.lookup(parts[i]);
                continue;
            }
            catch (NamingException e) {
                return;
            }
        }
        try {
            lastContext.unbind(name);
        }
        catch (NamingException e) {
            // empty catch block
        }
    }

    public static Context createSubcontexts(Context context, String key) {
        String[] parts = key.split("/");
        int i = 0;
        Context lastContext = context;
        for (String part : parts) {
            if (++i == parts.length) {
                return lastContext;
            }
            try {
                lastContext = lastContext.createSubcontext(part);
            }
            catch (NamingException e) {
                try {
                    lastContext = (Context)lastContext.lookup(part);
                }
                catch (NamingException e1) {
                    return lastContext;
                }
            }
        }
        return lastContext;
    }
}

