/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jpa.jpql.parser;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.persistence.jpa.jpql.parser.AbstractExpression;
import org.eclipse.persistence.jpa.jpql.parser.Expression;

public final class QueryPosition {
    private Expression expression;
    private int position;
    private Map<Expression, Integer> positions;

    QueryPosition(int position) {
        this.position = position;
        this.positions = new HashMap<Expression, Integer>();
    }

    void addPosition(Expression expression, int position) {
        this.positions.put(expression, position);
    }

    void adjustPosition(AbstractExpression parent, Expression expression, int adjustedPosition) {
        if (parent == null) {
            this.addPosition(expression, adjustedPosition);
            return;
        }
        int length = 0;
        for (Expression child : parent.orderedChildren()) {
            if (child == expression) {
                length += adjustedPosition;
                break;
            }
            length += child.getLength();
        }
        this.addPosition(parent, length);
        this.adjustPosition(parent.getParent(), parent, length);
    }

    QueryPosition adjustPosition(Expression expression, int newPosition) {
        QueryPosition queryPosition = new QueryPosition(newPosition);
        queryPosition.expression = expression;
        queryPosition.adjustPosition((AbstractExpression)expression.getParent(), expression, newPosition);
        return queryPosition;
    }

    public Expression getExpression() {
        return this.expression;
    }

    public int getPosition() {
        return this.position;
    }

    public int getPosition(Expression expression) {
        Integer position = this.positions.get(expression);
        return position == null ? -1 : position;
    }

    void removePosition(Expression expression) {
        this.positions.remove(expression);
    }

    void setExpression(Expression expression) {
        this.expression = expression;
    }

    QueryPosition transform(Expression leafExpression) {
        QueryPosition queryPosition = new QueryPosition(this.position + 1);
        queryPosition.expression = leafExpression;
        this.transform(queryPosition, leafExpression);
        return queryPosition;
    }

    private void transform(QueryPosition position, Expression expression) {
        if (expression != null) {
            position.addPosition(expression, this.getPosition(expression) + 1);
            this.transform(position, expression.getParent());
        }
    }
}

