/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.repository.internal;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.virgo.medic.log.EntryExitTrace;
import org.eclipse.virgo.repository.ArtifactDescriptor;
import org.eclipse.virgo.util.osgi.manifest.VersionRange;
import org.osgi.framework.Version;

public final class RepositoryUtils {
    private static transient /* synthetic */ EntryExitTrace ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance;

    public static <T extends ArtifactDescriptor> T selectHighestVersion(Set<T> artifactDescriptors) {
        return RepositoryUtils.selectHighestVersionInRange(artifactDescriptors, null);
    }

    public static <T extends ArtifactDescriptor> T selectHighestVersionInRange(Set<T> artifactDescriptors, VersionRange versionRange) {
        ArtifactDescriptor highest = null;
        for (ArtifactDescriptor artifactDescriptor : artifactDescriptors) {
            Version version = artifactDescriptor.getVersion();
            if (versionRange != null && !versionRange.includes(version) || highest != null && version.compareTo(highest.getVersion()) <= 0) continue;
            highest = artifactDescriptor;
        }
        return (T)highest;
    }

    public static <T extends ArtifactDescriptor> T selectLowestVersionInRange(Set<T> artifactDescriptors, VersionRange versionRange) {
        ArtifactDescriptor lowest = null;
        for (ArtifactDescriptor artifactDescriptor : artifactDescriptors) {
            Version version = artifactDescriptor.getVersion();
            if (versionRange != null && !versionRange.includes(version) || lowest != null && version.compareTo(lowest.getVersion()) >= 0) continue;
            lowest = artifactDescriptor;
        }
        return (T)lowest;
    }

    public static <T extends ArtifactDescriptor> Set<Set<T>> groupByTypeAndName(Set<T> artifactDescriptors) {
        if (artifactDescriptors == null || artifactDescriptors.isEmpty()) {
            return Collections.emptySet();
        }
        HashMap<String, HashSet<ArtifactDescriptor>> groups = new HashMap<String, HashSet<ArtifactDescriptor>>();
        for (ArtifactDescriptor artifact : artifactDescriptors) {
            String groupKey = String.format("%s-%s", artifact.getType(), artifact.getName());
            HashSet<ArtifactDescriptor> group = (HashSet<ArtifactDescriptor>)groups.get(groupKey);
            if (group == null) {
                group = new HashSet<ArtifactDescriptor>();
                groups.put(groupKey, group);
            }
            group.add(artifact);
        }
        return new HashSet<Set<T>>(groups.values());
    }

    public static /* synthetic */ EntryExitTrace ajc$org_eclipse_virgo_medic_log_EntryExitTrace$localAspectOf() {
        return ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance;
    }

    static {
        ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance = EntryExitTrace.ajc$createAspectInstance((String)"org.eclipse.virgo.repository.internal.RepositoryUtils");
    }
}

