/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.web.enterprise.services.accessor;

import java.util.Dictionary;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.felix.service.command.Descriptor;
import org.eclipse.virgo.web.enterprise.services.accessor.WebAppBundleClassLoaderDelegateHook;
import org.eclipse.virgo.web.enterprise.services.accessor.WebAppBundleClassloaderCustomizer;
import org.eclipse.virgo.web.enterprise.services.accessor.WebAppBundleTrackerCustomizer;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class ServicesAccessorCommandProvider {
    private final String CMD_HELP_MSG = "Shows exposed content in the framework\r\n   list_exposed_content <option> - display information about apis, which will be transparently added to applications, apis' implementations and JNDI consumption of services\r\n      Options:\r\n      -api - display all API bundles\r\n      -impl - display all Implementation bundles\r\n      -clash - display all clashing API/Implementation bundles and which one is chosen\r\n";
    private static String API_OPTION = "-api";
    private static String IMPL_OPTION = "-impl";
    private static String CLASH_OPTION = "-clash";
    private static String API_BUNDLE_TYPE = "API";
    private static String IMPL_BUNDLE_TYPE = "Implementation";
    private WebAppBundleTrackerCustomizer webAppBundleTrackerCustomizer;
    private WebAppBundleClassLoaderDelegateHook wabClassLoaderDelegateHook;
    private String bundleType;
    private final Object monitor = new Object();

    public void activate(BundleContext context) {
        Hashtable<String, Object> properties = new Hashtable<String, Object>();
        ((Dictionary)properties).put("osgi.command.scope", "enterprise");
        ((Dictionary)properties).put("osgi.command.function", new String[]{"list_exposed_content"});
        context.registerService(ServicesAccessorCommandProvider.class, (Object)this, properties);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Descriptor(value="Shows exposed content in the framework\r\n   list_exposed_content <option> - display information about apis, which will be transparently added to applications, apis' implementations and JNDI consumption of services\r\n      Options:\r\n      -api - display all API bundles\r\n      -impl - display all Implementation bundles\r\n      -clash - display all clashing API/Implementation bundles and which one is chosen\r\n")
    public void list_exposed_content(String ... option) {
        if (option != null && option.length == 1) {
            Object object = this.monitor;
            synchronized (object) {
                if (this.wabClassLoaderDelegateHook != null) {
                    if (API_OPTION.equalsIgnoreCase(option[0])) {
                        this.bundleType = API_BUNDLE_TYPE;
                        this.displayBundles(this.wabClassLoaderDelegateHook.getApiBundles());
                    } else if (IMPL_OPTION.equalsIgnoreCase(option[0])) {
                        this.bundleType = IMPL_BUNDLE_TYPE;
                        this.displayBundles(this.wabClassLoaderDelegateHook.getImplBundles());
                    } else if (CLASH_OPTION.equalsIgnoreCase(option[0])) {
                        this.findClashes();
                    }
                }
            }
        } else {
            System.out.println("Usage: list_exposed_content <option>");
            System.out.println("Specify -api, -impl or -clash option");
        }
    }

    private void displayBundles(Set<Bundle> bundles) {
        if (bundles.size() == 0) {
            System.out.println("No service " + this.bundleType + " bundles available");
            return;
        }
        System.out.println();
        System.out.print("ID");
        System.out.print("\t");
        System.out.print("Bundle name");
        System.out.println();
        for (Bundle bundle : bundles) {
            System.out.print(bundle.getBundleId());
            System.out.print("\t");
            System.out.print(String.valueOf(bundle.getSymbolicName()) + "_" + bundle.getVersion());
            System.out.println();
        }
    }

    private void findClashes() {
        Map<String, List<Bundle>> bundlesWithSameBSNMap = this.webAppBundleTrackerCustomizer.getBundlesWithSameBSNMap();
        if (bundlesWithSameBSNMap == null || bundlesWithSameBSNMap.size() == 0) {
            System.out.println("There are no clashes");
            return;
        }
        Set<Bundle> apiBundles = this.wabClassLoaderDelegateHook.getApiBundles();
        this.handleClashes(apiBundles, bundlesWithSameBSNMap, API_BUNDLE_TYPE);
        Set<Bundle> implBundles = this.wabClassLoaderDelegateHook.getImplBundles();
        this.handleClashes(implBundles, bundlesWithSameBSNMap, IMPL_BUNDLE_TYPE);
    }

    private void handleClashes(Set<Bundle> bundles, Map<String, List<Bundle>> bundlesWithSameBSNMap, String type) {
        System.out.println("Clashing " + type + "s:");
        System.out.println();
        for (Bundle bundle : bundles) {
            List<Bundle> bundlesWithSameBSN = bundlesWithSameBSNMap.get(bundle.getSymbolicName());
            if (bundlesWithSameBSN.size() <= 1) continue;
            this.printClashing(bundlesWithSameBSN, bundle);
        }
    }

    private void printClashing(List<Bundle> bundlesWithSameBSN, Bundle chosenBundle) {
        System.out.println("Clashing bundles for BSN " + chosenBundle.getSymbolicName() + ":");
        for (Bundle bundle : bundlesWithSameBSN) {
            System.out.println(String.valueOf(bundle.getSymbolicName()) + "_" + bundle.getVersion());
        }
        System.out.println();
        System.out.println("Chosen bundle: " + chosenBundle.getSymbolicName() + "_" + chosenBundle.getVersion());
    }

    public void bindCustomizer(WebAppBundleClassloaderCustomizer customizer) {
        this.webAppBundleTrackerCustomizer = customizer.getWebAppBundleTrackerCustomizer();
        this.wabClassLoaderDelegateHook = customizer.getWebAppBundleClassLoaderDelegateHook();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unbindCustomizer(WebAppBundleClassloaderCustomizer customizer) {
        Object object = this.monitor;
        synchronized (object) {
            this.wabClassLoaderDelegateHook = null;
            this.webAppBundleTrackerCustomizer = null;
        }
    }
}

