/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jpa.jpql.model.query;

import java.io.IOException;
import java.util.List;
import org.eclipse.persistence.jpa.jpql.model.query.AbstractStateObject;
import org.eclipse.persistence.jpa.jpql.model.query.CollectionValuedPathExpressionStateObject;
import org.eclipse.persistence.jpa.jpql.model.query.EntityTypeLiteralStateObject;
import org.eclipse.persistence.jpa.jpql.model.query.JoinStateObject;
import org.eclipse.persistence.jpa.jpql.model.query.StateObject;
import org.eclipse.persistence.jpa.jpql.model.query.StateObjectVisitor;
import org.eclipse.persistence.jpa.jpql.parser.TreatExpression;
import org.eclipse.persistence.jpa.jpql.spi.IEntity;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TreatExpressionStateObject
extends AbstractStateObject {
    private boolean as;
    private EntityTypeLiteralStateObject entityTypeName;
    private JoinStateObject joinStateObject;
    public static final String AS_PROPERTY = "as";
    public static final String ENTITY_TYPE_NAME_PROPERTY = "entityTypeName";

    public TreatExpressionStateObject(JoinStateObject parent) {
        super(parent);
        this.joinStateObject = parent;
    }

    public TreatExpressionStateObject(JoinStateObject parent, boolean as, String entityTypeName) {
        super(parent);
        this.as = as;
        this.joinStateObject = parent;
        this.entityTypeName.setText(entityTypeName);
    }

    public TreatExpressionStateObject(JoinStateObject parent, String entityTypeName) {
        this(parent, false, entityTypeName);
    }

    @Override
    public void accept(StateObjectVisitor visitor) {
        this.acceptUnknownVisitor(visitor);
    }

    public TreatExpressionStateObject addAs() {
        if (!this.as) {
            this.setAs(true);
        }
        return this;
    }

    @Override
    protected void addChildren(List<StateObject> children) {
        super.addChildren(children);
        children.add(this.entityTypeName);
    }

    public void appendToEntityTypeName(String text) {
        if (text != null) {
            if (this.entityTypeName == null) {
                this.setEntityTypeName(text);
            } else {
                this.setEntityTypeName(this.entityTypeName + text);
            }
        }
    }

    public IEntity getEntity() {
        for (IEntity entity : this.getManagedTypeProvider().entities()) {
            if (!entity.getName().equals(this.entityTypeName)) continue;
            return entity;
        }
        return null;
    }

    public String getEntityTypeName() {
        return this.entityTypeName.getText();
    }

    @Override
    public TreatExpression getExpression() {
        return (TreatExpression)super.getExpression();
    }

    public JoinStateObject getJoin() {
        return this.joinStateObject;
    }

    public StateObject getJoinAssociationIdentificationVariable() {
        return this.joinStateObject.getJoinAssociationIdentificationVariable();
    }

    public CollectionValuedPathExpressionStateObject getJoinAssociationPathStateObject() {
        return this.joinStateObject.getJoinAssociationPathStateObject();
    }

    public boolean hasAs() {
        return this.as;
    }

    public boolean hasEntityTypeName() {
        return this.entityTypeName != null;
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.entityTypeName = new EntityTypeLiteralStateObject(this);
    }

    @Override
    public boolean isEquivalent(StateObject stateObject) {
        if (super.isEquivalent(stateObject)) {
            TreatExpressionStateObject treat = (TreatExpressionStateObject)stateObject;
            return this.as == treat.as && this.entityTypeName.isEquivalent(treat.entityTypeName);
        }
        return false;
    }

    public void removeAs() {
        if (this.as) {
            this.setAs(true);
        }
    }

    public void setAs(boolean as) {
        boolean oldAs = this.as;
        this.as = as;
        this.firePropertyChanged(AS_PROPERTY, oldAs, as);
    }

    public void setEntityTypeName(Class<?> entityType) {
        this.setEntityTypeName(entityType.getName());
    }

    public void setEntityTypeName(IEntity entityType) {
        this.setEntityTypeName(entityType.getName());
    }

    public void setEntityTypeName(String entityTypeName) {
        String oldEntityTypeName = this.getEntityTypeName();
        this.entityTypeName.setText(entityTypeName);
        this.firePropertyChanged(ENTITY_TYPE_NAME_PROPERTY, oldEntityTypeName, entityTypeName);
    }

    public void setExpression(TreatExpression expression) {
        super.setExpression(expression);
    }

    public void toggleAs() {
        this.setAs(!this.as);
    }

    @Override
    protected void toTextInternal(Appendable writer) throws IOException {
        writer.append("TREAT");
        writer.append('(');
        this.getJoinAssociationPathStateObject().toTextInternal(writer);
        if (this.as) {
            writer.append(' ');
            writer.append("AS");
        }
        if (this.entityTypeName.hasText()) {
            writer.append(' ');
            this.entityTypeName.toTextInternal(writer);
        }
        writer.append(')');
    }
}

