/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.kernel.userregion.internal.importexpansion;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.virgo.kernel.osgi.framework.ImportMergeException;
import org.eclipse.virgo.kernel.serviceability.Assert;
import org.eclipse.virgo.kernel.userregion.internal.importexpansion.TrackedPackageImports;
import org.eclipse.virgo.medic.log.EntryExitTrace;
import org.eclipse.virgo.util.osgi.manifest.ImportedPackage;
import org.eclipse.virgo.util.osgi.manifest.Resolution;
import org.eclipse.virgo.util.osgi.manifest.VersionRange;

abstract class AbstractTrackedPackageImports
implements TrackedPackageImports {
    protected static final String SOURCE_SEPARATOR = ", ";
    private static final String VERSION_ATTRIBUTE_NAME = "version";
    private static final String VERSION_ALTERNATE_ATTRIBUTE_NAME = "specification-version";
    private static final String BUNDLE_VERSION_ATTRIBUTE_NAME = "bundle-version";
    private static final Object tieMonitor;
    private final Object monitor = new Object();
    protected final Map<String, ImportedPackage> mergedPackageImports = new HashMap<String, ImportedPackage>();
    private ImportMergeException mergeException = null;
    protected final List<TrackedPackageImports> sources = new ArrayList<TrackedPackageImports>();
    private static transient /* synthetic */ EntryExitTrace ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance;

    static {
        ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance = EntryExitTrace.ajc$createAspectInstance((String)"org.eclipse.virgo.kernel.userregion.internal.importexpansion.AbstractTrackedPackageImports");
        tieMonitor = new Object();
    }

    AbstractTrackedPackageImports(Map<String, ImportedPackage> packageImports) {
        this.mergedPackageImports.putAll(packageImports);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void merge(TrackedPackageImports importsToMerge) throws ImportMergeException {
        Object object = this.monitor;
        synchronized (object) {
            this.checkMergeException();
            try {
                this.sources.add(importsToMerge);
                this.doMerge(importsToMerge);
            }
            catch (ImportMergeException e) {
                this.mergeException = e;
                throw e;
            }
        }
    }

    private void doMerge(TrackedPackageImports importsToMerge) throws ImportMergeException {
        List<ImportedPackage> mergedImportsToMerge = importsToMerge.getMergedImports();
        for (ImportedPackage packageImportToMerge : mergedImportsToMerge) {
            String pkg = packageImportToMerge.getPackageName();
            ImportedPackage mergedPackageImport = this.mergedPackageImports.get(pkg);
            if (mergedPackageImport == null) {
                this.mergedPackageImports.put(pkg, packageImportToMerge);
                continue;
            }
            this.mergePackageImport(mergedPackageImport, packageImportToMerge);
        }
    }

    private void mergePackageImport(ImportedPackage targetPackageImport, ImportedPackage sourceImportToMerge) throws ImportMergeException {
        this.mergeAttributes(targetPackageImport, sourceImportToMerge);
        this.mergeDirectives(targetPackageImport, sourceImportToMerge);
    }

    private void mergeAttributes(ImportedPackage targetPackageImport, ImportedPackage sourceImportToMerge) throws ImportMergeException {
        Map targetAttributes = targetPackageImport.getAttributes();
        Map sourceAttributes = sourceImportToMerge.getAttributes();
        for (Map.Entry sourceAttributeEntry : sourceAttributes.entrySet()) {
            String sourceAttributeName = (String)sourceAttributeEntry.getKey();
            if (this.isVersionAttribute(sourceAttributeName)) continue;
            String sourceAttributeValue = (String)sourceAttributeEntry.getValue();
            String targetAttributeValue = (String)targetAttributes.get(sourceAttributeName);
            if (targetAttributeValue != null) {
                if (targetAttributeValue.equals(sourceAttributeValue)) continue;
                throw new ImportMergeException(targetPackageImport.getPackageName(), this.getPackageSources(targetPackageImport), "conflicting values '" + sourceAttributeValue + "', '" + targetAttributeValue + "' of attribute '" + sourceAttributeName + "'");
            }
            targetAttributes.put(sourceAttributeName, sourceAttributeValue);
        }
        this.mergeVersionRanges(targetPackageImport, sourceImportToMerge);
        this.mergeBundleVersionRanges(targetPackageImport, sourceImportToMerge);
    }

    private void mergeVersionRanges(ImportedPackage targetPackageImport, ImportedPackage sourceImportToMerge) throws ImportMergeException {
        Map sourceAttributes = sourceImportToMerge.getAttributes();
        VersionRange sourceVersionRange = this.getVersionRange(sourceAttributes);
        if (sourceVersionRange != null) {
            VersionRange mergedVersionRange;
            Map targetAttributes = targetPackageImport.getAttributes();
            VersionRange targetVersionRange = this.getVersionRange(targetAttributes);
            if (targetVersionRange == null) {
                mergedVersionRange = sourceVersionRange;
            } else {
                mergedVersionRange = VersionRange.intersection((VersionRange)sourceVersionRange, (VersionRange)targetVersionRange);
                if (mergedVersionRange.isEmpty()) {
                    throw new ImportMergeException(targetPackageImport.getPackageName(), this.getPackageSources(targetPackageImport), "disjoint package version ranges");
                }
            }
            targetAttributes.put(VERSION_ATTRIBUTE_NAME, mergedVersionRange.toParseString());
        }
    }

    private VersionRange getVersionRange(Map<String, String> attributes) {
        String versionRangeString = attributes.get(VERSION_ATTRIBUTE_NAME);
        if (versionRangeString == null) {
            versionRangeString = attributes.get(VERSION_ALTERNATE_ATTRIBUTE_NAME);
        }
        return versionRangeString == null ? null : new VersionRange(versionRangeString);
    }

    private void mergeBundleVersionRanges(ImportedPackage targetPackageImport, ImportedPackage sourceImportToMerge) throws ImportMergeException {
        VersionRange mergedVersionRange;
        VersionRange sourceVersionRange = sourceImportToMerge.getBundleVersion();
        VersionRange targetVersionRange = targetPackageImport.getBundleVersion();
        if (targetVersionRange == null) {
            mergedVersionRange = sourceVersionRange;
        } else {
            mergedVersionRange = VersionRange.intersection((VersionRange)sourceVersionRange, (VersionRange)targetVersionRange);
            if (mergedVersionRange.isEmpty()) {
                throw new ImportMergeException(targetPackageImport.getPackageName(), this.getPackageSources(targetPackageImport), "disjoint bundle version ranges " + sourceVersionRange.toString() + " and " + targetVersionRange.toString());
            }
        }
        targetPackageImport.setBundleVersion(mergedVersionRange);
    }

    private boolean isVersionAttribute(String attributeName) {
        return VERSION_ATTRIBUTE_NAME.equals(attributeName) || VERSION_ALTERNATE_ATTRIBUTE_NAME.equals(attributeName) || BUNDLE_VERSION_ATTRIBUTE_NAME.equals(attributeName);
    }

    private void mergeDirectives(ImportedPackage targetPackageImport, ImportedPackage sourceImportToMerge) {
        if (targetPackageImport.getResolution() == Resolution.OPTIONAL && sourceImportToMerge.getResolution() == Resolution.MANDATORY) {
            targetPackageImport.setResolution(Resolution.MANDATORY);
        }
    }

    private String getPackageSources(ImportedPackage packageImport) {
        return this.getSources(packageImport.getPackageName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getSources(String pkg) {
        Object object = this.monitor;
        synchronized (object) {
            StringBuilder sourcesDescription = new StringBuilder();
            boolean first = true;
            String source = this.getSource(pkg);
            if (source != null) {
                sourcesDescription.append(source);
                first = false;
            }
            for (TrackedPackageImports trackedPackageImports : this.sources) {
                String sources = trackedPackageImports.getSources(pkg);
                if (sources == null) continue;
                if (!first) {
                    sourcesDescription.append(SOURCE_SEPARATOR);
                }
                sourcesDescription.append(sources);
                first = false;
            }
            return first ? null : sourcesDescription.toString();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final List<ImportedPackage> getMergedImports() throws ImportMergeException {
        Object object = this.monitor;
        synchronized (object) {
            this.checkMergeException();
            ArrayList<ImportedPackage> mergedImports = new ArrayList<ImportedPackage>();
            for (ImportedPackage packageImport : this.mergedPackageImports.values()) {
                mergedImports.add(packageImport);
            }
            return mergedImports;
        }
    }

    private void checkMergeException() throws ImportMergeException {
        if (this.mergeException != null) {
            throw this.mergeException;
        }
    }

    protected static Map<String, ImportedPackage> convertImportedPackageListToMap(List<ImportedPackage> importedPackages) {
        HashMap<String, ImportedPackage> initialPackageImports = new HashMap<String, ImportedPackage>();
        for (ImportedPackage importedPackage : importedPackages) {
            Assert.isNull((Object)initialPackageImports.put(importedPackage.getPackageName(), importedPackage), (String)"input packageImports must not contain duplicate items", (Object[])new Object[0]);
        }
        return initialPackageImports;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isEmpty() {
        Object object = this.monitor;
        synchronized (object) {
            return this.mergedPackageImports.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isEquivalent(TrackedPackageImports otherTrackedPackageImports) {
        if (otherTrackedPackageImports == null) {
            return this.isEmpty();
        }
        Assert.isInstanceOf(AbstractTrackedPackageImports.class, (Object)otherTrackedPackageImports, (String)"otherTrackedPackageImports must be of type AbstractTrackedPackageImports", (Object[])new Object[0]);
        AbstractTrackedPackageImports otherAbstractTrackedPackageImports = (AbstractTrackedPackageImports)otherTrackedPackageImports;
        int thisHash = System.identityHashCode(this);
        int otherHash = System.identityHashCode(otherTrackedPackageImports);
        if (thisHash > otherHash) {
            Object object = this.monitor;
            synchronized (object) {
                Object object2 = otherAbstractTrackedPackageImports.monitor;
                synchronized (object2) {
                    return this.mergedPackageImports.equals(otherAbstractTrackedPackageImports.mergedPackageImports);
                }
            }
        }
        if (thisHash < otherHash) {
            Object object = otherAbstractTrackedPackageImports.monitor;
            synchronized (object) {
                Object object3 = this.monitor;
                synchronized (object3) {
                    return this.mergedPackageImports.equals(otherAbstractTrackedPackageImports.mergedPackageImports);
                }
            }
        }
        Object object = tieMonitor;
        synchronized (object) {
            Object object4 = otherAbstractTrackedPackageImports.monitor;
            synchronized (object4) {
                Object object5 = this.monitor;
                synchronized (object5) {
                    return this.mergedPackageImports.equals(otherAbstractTrackedPackageImports.mergedPackageImports);
                }
            }
        }
    }

    public static /* synthetic */ EntryExitTrace ajc$org_eclipse_virgo_medic_log_EntryExitTrace$localAspectOf() {
        return ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance;
    }
}

