/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.medic.impl.config;

import java.io.IOException;
import java.util.Dictionary;
import java.util.HashSet;
import java.util.Hashtable;
import org.eclipse.virgo.medic.impl.config.ConfigurationChangeListener;
import org.eclipse.virgo.medic.impl.config.ConfigurationProvider;
import org.eclipse.virgo.medic.impl.config.DictionaryUtils;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.cm.ConfigurationEvent;
import org.osgi.service.cm.ConfigurationListener;

public final class ConfigurationAdminConfigurationProvider
implements ConfigurationProvider,
ConfigurationListener {
    private static final String CONFIG_ADMIN_PID = "org.eclipse.virgo.medic";
    private static final String CONFIG_ADMIN_SERVICE_NAME = "org.osgi.service.cm.ConfigurationAdmin";
    private static final Dictionary<String, String> DEFAULT_CONFIG = ConfigurationAdminConfigurationProvider.createDefaultConfiguration();
    private final BundleContext bundleContext;
    private volatile Dictionary<String, String> configuration = DEFAULT_CONFIG;
    private HashSet<ConfigurationChangeListener> listeners;

    public ConfigurationAdminConfigurationProvider(BundleContext context) {
        this.bundleContext = context;
        this.listeners = new HashSet();
        this.initialisePropertiesFromConfigurationAdmin();
    }

    @Override
    public Dictionary<String, String> getConfiguration() {
        return this.configuration;
    }

    private void initialisePropertiesFromConfigurationAdmin() {
        ServiceReference configAdminReference = this.bundleContext.getServiceReference(CONFIG_ADMIN_SERVICE_NAME);
        if (configAdminReference != null) {
            this.bundleContext.registerService(ConfigurationListener.class.getName(), (Object)new MedicConfigurationListener(), null);
            this.setPropertiesFromConfigurationAdmin((ServiceReference<ConfigurationAdmin>)configAdminReference);
        }
    }

    private void setPropertiesFromConfigurationAdmin(ServiceReference<ConfigurationAdmin> configAdminReference) {
        ConfigurationAdmin configurationAdmin = (ConfigurationAdmin)this.bundleContext.getService(configAdminReference);
        if (configurationAdmin != null) {
            try {
                Configuration configuration = configurationAdmin.getConfiguration(CONFIG_ADMIN_PID, null);
                Dictionary<String, String> properties = configuration.getProperties();
                if (properties == null) {
                    properties = DEFAULT_CONFIG;
                } else {
                    DictionaryUtils.mergeGeneral(properties, DEFAULT_CONFIG);
                }
                this.configuration = properties;
            }
            catch (IOException iOException) {}
        } else {
            this.configuration = DEFAULT_CONFIG;
        }
        this.notifyListeners();
    }

    private static Dictionary<String, String> createDefaultConfiguration() {
        Hashtable<String, String> configuration = new Hashtable<String, String>();
        ((Dictionary)configuration).put("dump.root.directory", ".");
        ((Dictionary)configuration).put("log.wrapSysOut", Boolean.toString(Boolean.TRUE));
        ((Dictionary)configuration).put("log.wrapSysErr", Boolean.toString(Boolean.TRUE));
        return configuration;
    }

    @Override
    public void addChangeListener(ConfigurationChangeListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public boolean removeChangeListener(ConfigurationChangeListener listener) {
        return this.listeners.remove(listener);
    }

    private void notifyListeners() {
        Object[] objectArray = this.listeners.toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            ((ConfigurationChangeListener)listener).configurationChanged(this);
            ++n2;
        }
    }

    public void configurationEvent(ConfigurationEvent event) {
        if (event.getType() == 1 && CONFIG_ADMIN_PID.equals(event.getPid())) {
            this.setPropertiesFromConfigurationAdmin((ServiceReference<ConfigurationAdmin>)event.getReference());
        }
    }

    private final class MedicConfigurationListener
    implements ConfigurationListener {
        private MedicConfigurationListener() {
        }

        public void configurationEvent(ConfigurationEvent configEvent) {
            if (ConfigurationAdminConfigurationProvider.CONFIG_ADMIN_PID.equals(configEvent.getPid()) && configEvent.getType() == 1) {
                ConfigurationAdminConfigurationProvider.this.setPropertiesFromConfigurationAdmin((ServiceReference<ConfigurationAdmin>)configEvent.getReference());
            }
        }
    }
}

