/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.snaps.core.internal.deployer;

import java.io.IOException;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.gemini.web.tomcat.spi.WebBundleClassLoaderFactory;
import org.eclipse.virgo.kernel.deployer.core.DeploymentException;
import org.eclipse.virgo.kernel.install.artifact.BundleInstallArtifact;
import org.eclipse.virgo.kernel.install.artifact.InstallArtifact;
import org.eclipse.virgo.kernel.install.artifact.InstallArtifactLifecycleListenerSupport;
import org.eclipse.virgo.medic.eventlog.EventLogger;
import org.eclipse.virgo.snaps.core.internal.SnapHostDefinition;
import org.eclipse.virgo.snaps.core.internal.SnapUtils;
import org.eclipse.virgo.snaps.core.internal.deployer.SnapFactory;
import org.eclipse.virgo.snaps.core.internal.webapp.WebAppSnapFactory;
import org.eclipse.virgo.util.osgi.ServiceRegistrationTracker;
import org.eclipse.virgo.util.osgi.manifest.BundleManifest;
import org.osgi.framework.Bundle;
import org.osgi.framework.ServiceRegistration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class SnapLifecycleListener
extends InstallArtifactLifecycleListenerSupport {
    private final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private final Map<InstallArtifact, ServiceRegistrationTracker> registrationTrackers = new ConcurrentHashMap<InstallArtifact, ServiceRegistrationTracker>();
    private final WebBundleClassLoaderFactory classLoaderFactory;
    private final EventLogger eventLogger;

    public SnapLifecycleListener(WebBundleClassLoaderFactory classLoaderFactory, EventLogger eventLogger) {
        this.classLoaderFactory = classLoaderFactory;
        this.eventLogger = eventLogger;
    }

    public void onStarted(InstallArtifact installArtifact) throws DeploymentException {
        if (SnapLifecycleListener.isSnap(installArtifact)) {
            Bundle bundle = ((BundleInstallArtifact)installArtifact).getBundle();
            BundleManifest bundleManifest = SnapLifecycleListener.getBundleManifest((BundleInstallArtifact)installArtifact);
            ServiceRegistration<SnapFactory> registration = this.createAndRegisterSnapFactoryService(bundle, bundleManifest);
            ServiceRegistrationTracker registrationTracker = new ServiceRegistrationTracker();
            registrationTracker.track(registration);
            this.registrationTrackers.put(installArtifact, registrationTracker);
        }
    }

    ServiceRegistration<SnapFactory> createAndRegisterSnapFactoryService(Bundle bundle, BundleManifest bundleManifest) {
        this.logger.info("Creating a SnapFactory for bundle '{}'", (Object)bundle);
        WebAppSnapFactory snapFactory = new WebAppSnapFactory(bundle, this.classLoaderFactory, this.eventLogger);
        SnapHostDefinition hostDefinition = SnapUtils.getSnapHostHeader(bundleManifest);
        Hashtable<String, String> serviceProperties = new Hashtable<String, String>();
        ((Dictionary)serviceProperties).put("snap.factory.host.name", hostDefinition.getSymbolicName());
        ((Dictionary)serviceProperties).put("snap.factory.host.range", hostDefinition.getVersionRange().toParseString());
        ServiceRegistration registration = bundle.getBundleContext().registerService(SnapFactory.class, (Object)snapFactory, serviceProperties);
        return registration;
    }

    static BundleManifest getBundleManifest(BundleInstallArtifact bundleInstallArtifact) throws DeploymentException {
        try {
            return bundleInstallArtifact.getBundleManifest();
        }
        catch (IOException ioe) {
            throw new DeploymentException("Failed to get bundle manifest from '" + bundleInstallArtifact + "'", (Throwable)ioe);
        }
    }

    static boolean isSnap(InstallArtifact installArtifact) throws DeploymentException {
        if (installArtifact instanceof BundleInstallArtifact) {
            return SnapUtils.hasSnapHostHeader(SnapLifecycleListener.getBundleManifest((BundleInstallArtifact)installArtifact));
        }
        return false;
    }

    public void onStopping(InstallArtifact installArtifact) {
        this.logger.info("Destroying SnapFactory for bundle '{}'", (Object)installArtifact.getName());
        ServiceRegistrationTracker serviceRegistrationTracker = this.registrationTrackers.remove(installArtifact);
        if (serviceRegistrationTracker != null) {
            serviceRegistrationTracker.unregisterAll();
        }
    }
}

