/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.ide.module.core;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.lang.ObjectUtils;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IClasspathAttribute;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.ui.statushandlers.StatusManager;
import org.eclipse.virgo.ide.facet.core.FacetUtils;
import org.eclipse.virgo.ide.manifest.core.BundleManifestCorePlugin;
import org.eclipse.virgo.ide.par.Bundle;
import org.eclipse.virgo.ide.par.Par;
import org.eclipse.virgo.util.osgi.manifest.BundleManifest;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.ServerUtil;
import org.eclipse.wst.server.core.internal.ModuleFolder;
import org.eclipse.wst.server.core.model.IModuleFile;
import org.eclipse.wst.server.core.model.IModuleFolder;
import org.eclipse.wst.server.core.model.IModuleResource;
import org.eclipse.wst.server.core.model.ModuleDelegate;
import org.eclipse.wst.server.core.util.ModuleFile;
import org.eclipse.wst.server.core.util.ProjectModule;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServerModuleDelegate
extends ProjectModule {
    public static final String TEST_CLASSPATH_ENTRY_ATTRIBUTE = "org.eclipse.virgo.ide.jdt.core.test.classpathentry";

    public ServerModuleDelegate(IProject project) {
        super(project);
    }

    public IModuleResource[] members() throws CoreException {
        IModule module = this.getModule();
        LinkedHashSet<IModuleResource> resources = new LinkedHashSet<IModuleResource>();
        this.deepGetMembers(module, resources);
        return resources.toArray(new IModuleResource[resources.size()]);
    }

    private void deepGetMembers(IModule module, final Set<IModuleResource> resources) throws CoreException, JavaModelException {
        block31: {
            Path moduleRelativePath;
            block32: {
                block30: {
                    moduleRelativePath = Path.EMPTY;
                    if (!module.getModuleType().getId().equals("org.eclipse.virgo.server.bundle")) break block30;
                    if (FacetUtils.hasProjectFacet((IResource)this.getProject(), (String)"jst.web")) {
                        IModule[] modules;
                        IModule[] iModuleArray = modules = ServerUtil.getModules((IProject)this.getProject());
                        int n = modules.length;
                        int n2 = 0;
                        while (n2 < n) {
                            IModule webModule = iModuleArray[n2];
                            if (webModule.getModuleType().getId().equals("jst.web")) {
                                ModuleDelegate delegate = (ModuleDelegate)webModule.loadAdapter(ModuleDelegate.class, null);
                                resources.addAll(Arrays.asList(delegate.members()));
                            }
                            ++n2;
                        }
                    }
                    resources.addAll(this.getMembers(this.getProject(), (IPath)moduleRelativePath));
                    break block31;
                }
                if (!module.getModuleType().getId().equals("org.eclipse.virgo.server.par")) break block32;
                IResource metaInfFolder = this.getProject().findMember("META-INF");
                if (metaInfFolder instanceof IContainer) {
                    String moduleFolderName = "META-INF";
                    moduleRelativePath = new Path(moduleFolderName);
                    org.eclipse.wst.server.core.util.ModuleFolder folder = new org.eclipse.wst.server.core.util.ModuleFolder(null, moduleFolderName, (IPath)Path.EMPTY);
                    folder.setMembers(this.getModuleResources((IPath)moduleRelativePath, (IContainer)metaInfFolder));
                    resources.add((IModuleResource)folder);
                } else {
                    StatusManager.getManager().handle((IStatus)new Status(4, "org.eclipse.virgo.ide.manifest.core", "Cannot find META-INF/MANIFEST.MF in project [" + this.getProject().getName() + "]"));
                }
                this.getProject().accept(new IResourceVisitor(){

                    public boolean visit(IResource resource) throws CoreException {
                        if (resource instanceof IFile && resource.getFileExtension().equals("jar")) {
                            resources.add(new ModuleFile((IFile)resource, resource.getName(), (IPath)Path.EMPTY));
                        }
                        return true;
                    }
                }, 1, false);
                IModule[] iModuleArray = this.getChildModules();
                int n = iModuleArray.length;
                int folder = 0;
                while (folder < n) {
                    IModule childModule = iModuleArray[folder];
                    if (FacetUtils.hasProjectFacet((IResource)childModule.getProject(), (String)"jst.web")) {
                        IModuleResource[] members;
                        moduleRelativePath = new Path(String.valueOf(childModule.getProject().getName()) + ".war");
                        ModuleDelegate delegate = (ModuleDelegate)childModule.loadAdapter(ModuleDelegate.class, null);
                        IModuleResource[] iModuleResourceArray = members = delegate.members();
                        int n3 = members.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            IModuleResource member = iModuleResourceArray[n4];
                            if (member instanceof IModuleFile) {
                                resources.add((IModuleResource)new ParModuleFile((IModuleFile)member, (IPath)moduleRelativePath));
                            } else if (member instanceof IModuleFolder) {
                                resources.add((IModuleResource)new ParModuleFolder((IModuleFolder)member, (IPath)moduleRelativePath));
                            }
                            ++n4;
                        }
                    } else if (FacetUtils.isBundleProject((IResource)childModule.getProject())) {
                        String moduleFolderName = String.valueOf(childModule.getProject().getName()) + ".jar";
                        moduleRelativePath = new Path(moduleFolderName);
                        org.eclipse.wst.server.core.util.ModuleFolder folder2 = new org.eclipse.wst.server.core.util.ModuleFolder(null, moduleFolderName, (IPath)Path.EMPTY);
                        folder2.setMembers(this.getMembers(childModule.getProject(), (IPath)moduleRelativePath).toArray(new IModuleResource[0]));
                        resources.add((IModuleResource)folder2);
                    }
                    ++folder;
                }
                break block31;
            }
            if (!module.getModuleType().getId().equals("org.eclipse.virgo.server.plan")) break block31;
            String fileName = module.getId();
            fileName = fileName.substring(fileName.indexOf(58) + 1);
            IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(fileName));
            if (!file.exists()) {
                return;
            }
            ModuleFile planFile = new ModuleFile(file, file.getName(), (IPath)moduleRelativePath);
            resources.add((IModuleResource)planFile);
            ModuleDelegate delegate0 = (ModuleDelegate)module.loadAdapter(ModuleDelegate.class, null);
            IModule[] iModuleArray = delegate0.getChildModules();
            int n = iModuleArray.length;
            int n5 = 0;
            while (n5 < n) {
                IModuleResource member;
                int n6;
                int n7;
                IModuleResource[] iModuleResourceArray;
                IModuleResource[] members;
                IModule childModule = iModuleArray[n5];
                if (FacetUtils.hasProjectFacet((IResource)childModule.getProject(), (String)"jst.web")) {
                    moduleRelativePath = new Path(String.valueOf(childModule.getProject().getName()) + ".war");
                    ModuleDelegate delegate1 = (ModuleDelegate)childModule.loadAdapter(ModuleDelegate.class, null);
                    iModuleResourceArray = members = delegate1.members();
                    n7 = members.length;
                    n6 = 0;
                    while (n6 < n7) {
                        member = iModuleResourceArray[n6];
                        if (member instanceof IModuleFile) {
                            resources.add((IModuleResource)new ParModuleFile((IModuleFile)member, (IPath)moduleRelativePath));
                        } else if (member instanceof IModuleFolder) {
                            resources.add((IModuleResource)new ParModuleFolder((IModuleFolder)member, (IPath)moduleRelativePath));
                        }
                        ++n6;
                    }
                } else if (FacetUtils.isBundleProject((IResource)childModule.getProject())) {
                    String moduleFolderName = String.valueOf(childModule.getProject().getName()) + ".jar";
                    moduleRelativePath = new Path(moduleFolderName);
                    org.eclipse.wst.server.core.util.ModuleFolder folder = new org.eclipse.wst.server.core.util.ModuleFolder(null, moduleFolderName, (IPath)Path.EMPTY);
                    folder.setMembers(this.getMembers(childModule.getProject(), (IPath)moduleRelativePath).toArray(new IModuleResource[0]));
                    resources.add((IModuleResource)folder);
                } else if (FacetUtils.isPlanProject((IResource)childModule.getProject())) {
                    this.deepGetMembers(childModule, resources);
                } else if (FacetUtils.isParProject((IResource)childModule.getProject())) {
                    moduleRelativePath = new Path(String.valueOf(childModule.getProject().getName()) + ".par");
                    ModuleDelegate delegate2 = (ModuleDelegate)childModule.loadAdapter(ModuleDelegate.class, null);
                    iModuleResourceArray = members = delegate2.members();
                    n7 = members.length;
                    n6 = 0;
                    while (n6 < n7) {
                        member = iModuleResourceArray[n6];
                        if (member instanceof IModuleFile) {
                            resources.add((IModuleResource)new ParModuleFile((IModuleFile)member, (IPath)moduleRelativePath));
                        } else if (member instanceof IModuleFolder) {
                            resources.add((IModuleResource)new ParModuleFolder((IModuleFolder)member, (IPath)moduleRelativePath));
                        }
                        ++n6;
                    }
                }
                ++n5;
            }
        }
    }

    private Set<IModuleResource> getMembers(IProject project, IPath moduleRelativePath) throws JavaModelException, CoreException {
        List bundleClassPathEntries;
        IJavaProject javaProject;
        LinkedHashSet<IModuleResource> resources = new LinkedHashSet<IModuleResource>();
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IResource defaultBinFolder = root.findMember((javaProject = JavaCore.create((IProject)project)).getOutputLocation());
        if (defaultBinFolder instanceof IContainer) {
            resources.addAll(Arrays.asList(this.getModuleResources(moduleRelativePath, (IContainer)defaultBinFolder)));
        }
        for (IClasspathEntry entry : ServerModuleDelegate.getSourceClasspathEntries(project, false)) {
            IResource binFolder = root.findMember(entry.getOutputLocation());
            if (!(binFolder instanceof IContainer) || binFolder instanceof IWorkspaceRoot) continue;
            resources.addAll(Arrays.asList(this.getModuleResources(moduleRelativePath, (IContainer)defaultBinFolder)));
        }
        BundleManifest manifest = BundleManifestCorePlugin.getBundleManifestManager().getBundleManifest(javaProject);
        if (manifest != null && (bundleClassPathEntries = manifest.getBundleClasspath()) != null) {
            bundleClassPathEntries.remove(".");
            resources.addAll(Arrays.asList(this.getModuleResources(moduleRelativePath, (IContainer)javaProject.getProject(), bundleClassPathEntries)));
        }
        return resources;
    }

    protected IModuleResource[] getModuleResources(IPath path, IContainer container, List<String> filters) throws CoreException {
        IResource[] resources = container.members();
        if (resources != null) {
            int size = resources.length;
            ArrayList<Object> list = new ArrayList<Object>(size);
            int i = 0;
            while (i < size) {
                IResource resource = resources[i];
                if (resource != null && resource.exists()) {
                    String name = resource.getName();
                    String relativePath = resource.getProjectRelativePath().toString();
                    if (resource instanceof IContainer) {
                        for (String filter : filters) {
                            if (!filter.trim().startsWith(relativePath)) continue;
                            IContainer container2 = (IContainer)resource;
                            ModuleFolder mf = new ModuleFolder(container2, name, path);
                            mf.setMembers(this.getModuleResources(path.append(name), container2, filters));
                            list.add(mf);
                            break;
                        }
                    } else if (resource instanceof IFile) {
                        for (String filter : filters) {
                            if (!relativePath.equals(filter.trim())) continue;
                            list.add(new ModuleFile((IFile)resource, name, path));
                            break;
                        }
                    }
                }
                ++i;
            }
            IModuleResource[] moduleResources = new IModuleResource[list.size()];
            list.toArray(moduleResources);
            return moduleResources;
        }
        return new IModuleResource[0];
    }

    public IModule[] getChildModules() {
        if (FacetUtils.isParProject((IResource)this.getProject())) {
            LinkedHashSet<IModule> modules = new LinkedHashSet<IModule>();
            Par par = FacetUtils.getParDefinition((IProject)this.getProject());
            if (par != null && par.getBundle() != null) {
                for (Bundle bundle : par.getBundle()) {
                    IProject bundleProject = ResourcesPlugin.getWorkspace().getRoot().getProject(bundle.getSymbolicName());
                    if (!FacetUtils.isBundleProject((IResource)bundleProject)) continue;
                    IModule[] iModuleArray = ServerUtil.getModules((IProject)bundleProject);
                    int n = iModuleArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IModule module = iModuleArray[n2];
                        if (module.getId().equals("org.eclipse.virgo.server.modulefactory:" + this.getProject().getName() + "$" + bundleProject.getName())) {
                            modules.add(module);
                        }
                        ++n2;
                    }
                }
            }
            return modules.toArray(new IModule[modules.size()]);
        }
        if (FacetUtils.isPlanProject((IResource)this.getProject())) {
            String fileName = this.getModule().getId();
            fileName = fileName.substring(fileName.indexOf(58) + 1);
            IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(fileName));
            if (!file.exists()) {
                return new IModule[0];
            }
            return this.getPlanDependencies(file).toArray(new IModule[0]);
        }
        return new IModule[0];
    }

    public static Set<IClasspathEntry> getSourceClasspathEntries(IProject project, boolean onlyTestFolders) {
        IJavaProject javaProject = JavaCore.create((IProject)project);
        if (javaProject == null) {
            return Collections.emptySet();
        }
        LinkedHashSet<IClasspathEntry> entries = new LinkedHashSet<IClasspathEntry>();
        try {
            IClasspathEntry[] iClasspathEntryArray = javaProject.getRawClasspath();
            int n = iClasspathEntryArray.length;
            int n2 = 0;
            while (n2 < n) {
                IClasspathEntry entry = iClasspathEntryArray[n2];
                if (entry.getEntryKind() == 3 && (onlyTestFolders && !ServerModuleDelegate.isSourceFolder(entry.getExtraAttributes()) || !onlyTestFolders && ServerModuleDelegate.isSourceFolder(entry.getExtraAttributes()))) {
                    entries.add(entry);
                }
                ++n2;
            }
        }
        catch (JavaModelException javaModelException) {
            // empty catch block
        }
        return entries;
    }

    private static boolean isSourceFolder(IClasspathAttribute[] extraAttributes) {
        IClasspathAttribute[] iClasspathAttributeArray = extraAttributes;
        int n = extraAttributes.length;
        int n2 = 0;
        while (n2 < n) {
            IClasspathAttribute attribute = iClasspathAttributeArray[n2];
            if (TEST_CLASSPATH_ENTRY_ATTRIBUTE.equals(attribute.getName())) {
                return Boolean.valueOf(attribute.getValue()) == false;
            }
            ++n2;
        }
        return true;
    }

    private Set<IModule> getPlanDependencies(IFile file) {
        if (file == null || !file.exists()) {
            return Collections.emptySet();
        }
        HashSet<IModule> modules = new HashSet<IModule>();
        this.getPlanDependencies0(file, modules);
        return modules;
    }

    private void getPlanDependencies0(IFile file, Set<IModule> modules) {
        if (file == null || !file.exists()) {
            return;
        }
        try {
            DocumentBuilder docBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document doc = docBuilder.parse(file.getContents(true));
            NodeList artifactNodes = doc.getDocumentElement().getElementsByTagName("artifact");
            int i = 0;
            while (i < artifactNodes.getLength()) {
                IProject candidate;
                int n;
                IProject[] iProjectArray;
                IProject[] projects;
                Element artifact = (Element)artifactNodes.item(i);
                String type = artifact.getAttribute("type");
                String name = artifact.getAttribute("name");
                if ("bundle".equals(type)) {
                    iProjectArray = projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
                    n = projects.length;
                    int n2 = 0;
                    while (n2 < n) {
                        BundleManifest manifest;
                        candidate = iProjectArray[n2];
                        if ((FacetUtils.isBundleProject((IResource)candidate) || FacetUtils.hasProjectFacet((IResource)candidate, (String)"jst.web")) && ((manifest = BundleManifestCorePlugin.getBundleManifestManager().getBundleManifest(JavaCore.create((IProject)candidate))) != null && manifest.getBundleSymbolicName() != null && manifest.getBundleSymbolicName().getSymbolicName() != null && manifest.getBundleSymbolicName().getSymbolicName().equals(name) || candidate.getName().equals(name))) {
                            IModule[] iModuleArray = ServerUtil.getModules((IProject)candidate);
                            int n3 = iModuleArray.length;
                            int n4 = 0;
                            while (n4 < n3) {
                                IModule module = iModuleArray[n4];
                                if (!module.getId().contains("$")) {
                                    modules.add(module);
                                    break;
                                }
                                ++n4;
                            }
                        }
                        ++n2;
                    }
                } else if ("plan".equals(type)) {
                    List nested = FacetUtils.getNestedPlanFiles((IFile)file, (boolean)false);
                    block8: for (IFile iFile : nested) {
                        IModule[] mmmm;
                        IModule[] iModuleArray = mmmm = ServerUtil.getModules((IProject)iFile.getProject());
                        int n5 = mmmm.length;
                        int manifest = 0;
                        while (manifest < n5) {
                            IModule iModule = iModuleArray[manifest];
                            String fileName = iModule.getId();
                            fileName = fileName.substring(fileName.indexOf(58) + 1);
                            IFile file2 = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(fileName));
                            if (iFile.equals((Object)file2)) {
                                modules.add(iModule);
                                continue block8;
                            }
                            ++manifest;
                        }
                    }
                } else if ("par".equals(type)) {
                    iProjectArray = projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
                    n = projects.length;
                    int n6 = 0;
                    while (n6 < n) {
                        IModule[] iModuleArray;
                        candidate = iProjectArray[n6];
                        if (FacetUtils.isParProject((IResource)candidate) && candidate.getName().equals(name) && (iModuleArray = ServerUtil.getModules((IProject)candidate)).length != 0) {
                            IModule module = iModuleArray[0];
                            modules.add(module);
                        }
                        ++n6;
                    }
                }
                ++i;
            }
        }
        catch (SAXException e) {
            StatusManager.getManager().handle((IStatus)new Status(4, "Problem while getting plan dependencies.", "org.eclipse.virgo.ide.manifest.core", (Throwable)e));
        }
        catch (IOException e) {
            StatusManager.getManager().handle((IStatus)new Status(4, "Problem while getting plan dependencies.", "org.eclipse.virgo.ide.manifest.core", (Throwable)e));
        }
        catch (CoreException e) {
            StatusManager.getManager().handle(e, "org.eclipse.virgo.ide.manifest.core");
        }
        catch (ParserConfigurationException e) {
            StatusManager.getManager().handle((IStatus)new Status(4, "Problem while getting plan dependencies.", "org.eclipse.virgo.ide.manifest.core", (Throwable)e));
        }
    }

    static class ParModuleFile
    implements IModuleFile {
        private final IModuleFile wrappedFile;
        private final IPath modulePath;

        public ParModuleFile(IModuleFile wrappedFile, IPath modulePath) {
            this.wrappedFile = wrappedFile;
            this.modulePath = modulePath;
        }

        public long getModificationStamp() {
            return this.wrappedFile.getModificationStamp();
        }

        public IPath getModuleRelativePath() {
            return this.modulePath.append(this.wrappedFile.getModuleRelativePath());
        }

        public String getName() {
            return this.wrappedFile.getName();
        }

        public Object getAdapter(Class adapter) {
            return this.wrappedFile.getAdapter(adapter);
        }

        public int hashCode() {
            return this.modulePath.hashCode() * 37 + this.wrappedFile.hashCode();
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof ParModuleFile)) {
                return false;
            }
            ParModuleFile other = (ParModuleFile)obj;
            if (!ObjectUtils.equals((Object)this.modulePath, (Object)other.modulePath)) {
                return false;
            }
            return ObjectUtils.equals((Object)this.wrappedFile, (Object)other.wrappedFile);
        }

        public String toString() {
            return "ModuleFile [" + this.modulePath + "/" + this.wrappedFile.getModuleRelativePath() + ", " + this.wrappedFile.getName() + ", " + this.wrappedFile.getModificationStamp() + "]";
        }
    }

    static class ParModuleFolder
    implements IModuleFolder {
        private final IModuleFolder wrappedFolder;
        private final IPath modulePath;

        public ParModuleFolder(IModuleFolder wrappedFolder, IPath modulePath) {
            this.wrappedFolder = wrappedFolder;
            this.modulePath = modulePath;
        }

        public IModuleResource[] members() {
            LinkedHashSet<Object> members = new LinkedHashSet<Object>();
            IModuleResource[] iModuleResourceArray = this.wrappedFolder.members();
            int n = iModuleResourceArray.length;
            int n2 = 0;
            while (n2 < n) {
                IModuleResource resource = iModuleResourceArray[n2];
                if (resource instanceof IModuleFile) {
                    members.add(new ParModuleFile((IModuleFile)resource, this.modulePath));
                } else if (resource instanceof IModuleFolder) {
                    members.add(new ParModuleFolder((IModuleFolder)resource, this.modulePath));
                }
                ++n2;
            }
            return members.toArray(new IModuleResource[members.size()]);
        }

        public IPath getModuleRelativePath() {
            return this.modulePath.append(this.wrappedFolder.getModuleRelativePath());
        }

        public String getName() {
            return this.wrappedFolder.getName();
        }

        public Object getAdapter(Class adapter) {
            return this.wrappedFolder.getAdapter(adapter);
        }

        public int hashCode() {
            return this.modulePath.hashCode() * 37 + this.wrappedFolder.hashCode();
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof ParModuleFolder)) {
                return false;
            }
            ParModuleFolder other = (ParModuleFolder)obj;
            if (!ObjectUtils.equals((Object)this.modulePath, (Object)other.modulePath)) {
                return false;
            }
            return ObjectUtils.equals((Object)this.wrappedFolder, (Object)other.wrappedFolder);
        }

        public String toString() {
            return "ModuleFile [" + this.modulePath + "/" + this.wrappedFolder.getModuleRelativePath() + ", " + this.wrappedFolder.getName() + "]";
        }
    }
}

