/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.bundlor.maven.plugin.internal.support;

import java.io.File;
import java.io.Reader;
import java.io.StringReader;
import java.util.Map;
import org.eclipse.virgo.bundlor.maven.plugin.internal.ManifestTemplateFactory;
import org.eclipse.virgo.bundlor.util.BundleManifestUtils;
import org.eclipse.virgo.bundlor.util.SimpleManifestContents;
import org.eclipse.virgo.bundlor.util.StringUtils;
import org.eclipse.virgo.util.parser.manifest.ManifestContents;

public final class StandardManifestTemplateFactory
implements ManifestTemplateFactory {
    private static final String BUNDLE_SYMBOLIC_NAME = "Bundle-SymbolicName";
    private static final String BUNDLE_VERSION = "Bundle-Version";

    @Override
    public ManifestContents create(String manifestTemplatePath, String manifestTemplate, String bundleSymbolicName, String defaultBundleSymbolicName, String bundleVersion, String defaultBundleVersion) {
        Object template = StringUtils.hasText((String)manifestTemplate) ? BundleManifestUtils.getManifest((Reader)new StringReader(manifestTemplate)) : (StringUtils.hasText((String)manifestTemplatePath) ? BundleManifestUtils.getManifest((File)new File(manifestTemplatePath)) : new SimpleManifestContents());
        Map attributes = template.getMainAttributes();
        if (StringUtils.hasText((String)bundleSymbolicName)) {
            attributes.put(BUNDLE_SYMBOLIC_NAME, bundleSymbolicName);
        } else if (!StringUtils.hasText((String)((String)attributes.get(BUNDLE_SYMBOLIC_NAME)))) {
            attributes.put(BUNDLE_SYMBOLIC_NAME, defaultBundleSymbolicName);
        }
        if (StringUtils.hasText((String)bundleVersion)) {
            attributes.put(BUNDLE_VERSION, bundleVersion);
        } else if (!StringUtils.hasText((String)((String)attributes.get(BUNDLE_VERSION)))) {
            attributes.put(BUNDLE_VERSION, defaultBundleVersion);
        }
        return template;
    }
}

