/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.rete.network.communication.timely;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.eclipse.viatra.query.runtime.base.itc.alg.misc.topsort.TopologicalSorting;
import org.eclipse.viatra.query.runtime.base.itc.graphimpl.Graph;
import org.eclipse.viatra.query.runtime.base.itc.igraph.IGraphDataSource;
import org.eclipse.viatra.query.runtime.matchers.util.CollectionsFactory;
import org.eclipse.viatra.query.runtime.rete.index.IndexerListener;
import org.eclipse.viatra.query.runtime.rete.index.SpecializedProjectionIndexer;
import org.eclipse.viatra.query.runtime.rete.index.StandardIndexer;
import org.eclipse.viatra.query.runtime.rete.matcher.TimelyConfiguration;
import org.eclipse.viatra.query.runtime.rete.network.NetworkStructureChangeSensitiveNode;
import org.eclipse.viatra.query.runtime.rete.network.Node;
import org.eclipse.viatra.query.runtime.rete.network.ProductionNode;
import org.eclipse.viatra.query.runtime.rete.network.StandardNode;
import org.eclipse.viatra.query.runtime.rete.network.communication.CommunicationGroup;
import org.eclipse.viatra.query.runtime.rete.network.communication.CommunicationTracker;
import org.eclipse.viatra.query.runtime.rete.network.communication.MessageSelector;
import org.eclipse.viatra.query.runtime.rete.network.communication.NodeComparator;
import org.eclipse.viatra.query.runtime.rete.network.communication.timely.TimelyCommunicationGroup;
import org.eclipse.viatra.query.runtime.rete.network.communication.timely.TimelyIndexerListenerProxy;
import org.eclipse.viatra.query.runtime.rete.network.communication.timely.TimelyMailboxProxy;
import org.eclipse.viatra.query.runtime.rete.network.communication.timely.TimestampTransformation;
import org.eclipse.viatra.query.runtime.rete.network.mailbox.Mailbox;
import org.eclipse.viatra.query.runtime.rete.single.DiscriminatorDispatcherNode;

public class TimelyCommunicationTracker
extends CommunicationTracker {
    protected final TimelyConfiguration configuration;
    public static final Function<Node, Function<Node, String>> EDGE_LABEL_FUNCTION = new Function<Node, Function<Node, String>>(){

        @Override
        public Function<Node, String> apply(final Node source) {
            return new Function<Node, String>(){

                @Override
                public String apply(Node target) {
                    Collection<Mailbox> mailboxes;
                    if (source instanceof SpecializedProjectionIndexer) {
                        List<SpecializedProjectionIndexer.ListenerSubscription> subscriptions = ((SpecializedProjectionIndexer)source).getSubscriptions();
                        for (SpecializedProjectionIndexer.ListenerSubscription subscription : subscriptions) {
                            if (subscription.getListener().getOwner() != target || !(subscription.getListener() instanceof TimelyIndexerListenerProxy)) continue;
                            return ((TimelyIndexerListenerProxy)subscription.getListener()).preprocessor.toString();
                        }
                    }
                    if (source instanceof StandardIndexer) {
                        Collection<IndexerListener> listeners = ((StandardIndexer)source).getListeners();
                        for (IndexerListener listener : listeners) {
                            if (listener.getOwner() != target || !(listener instanceof TimelyIndexerListenerProxy)) continue;
                            return ((TimelyIndexerListenerProxy)listener).preprocessor.toString();
                        }
                    }
                    if (source instanceof StandardNode) {
                        mailboxes = ((StandardNode)source).getChildMailboxes();
                        for (Mailbox mailbox : mailboxes) {
                            if (mailbox.getReceiver() != target || !(mailbox instanceof TimelyMailboxProxy)) continue;
                            return ((TimelyMailboxProxy)mailbox).preprocessor.toString();
                        }
                    }
                    if (source instanceof DiscriminatorDispatcherNode) {
                        mailboxes = ((DiscriminatorDispatcherNode)source).getBucketMailboxes().values();
                        for (Mailbox mailbox : mailboxes) {
                            if (mailbox.getReceiver() != target || !(mailbox instanceof TimelyMailboxProxy)) continue;
                            return ((TimelyMailboxProxy)mailbox).preprocessor.toString();
                        }
                    }
                    return null;
                }
            };
        }
    };

    public TimelyCommunicationTracker(TimelyConfiguration configuration) {
        this.configuration = configuration;
    }

    @Override
    protected CommunicationGroup createGroup(Node representative, int index) {
        boolean isSingleton = this.sccInformationProvider.sccs.getPartition((Object)representative).size() == 1;
        return new TimelyCommunicationGroup(this, representative, index, isSingleton);
    }

    @Override
    protected void reconstructQueueContents(Set<CommunicationGroup> oldActiveGroups) {
        for (CommunicationGroup oldGroup : oldActiveGroups) {
            for (Map.Entry<MessageSelector, Collection<Mailbox>> entry : oldGroup.getMailboxes().entrySet()) {
                for (Mailbox mailbox : entry.getValue()) {
                    CommunicationGroup newGroup = (CommunicationGroup)this.groupMap.get(mailbox.getReceiver());
                    newGroup.notifyHasMessage(mailbox, entry.getKey());
                }
            }
        }
    }

    @Override
    public Mailbox proxifyMailbox(Node requester, Mailbox original) {
        Mailbox mailboxToProxify = original instanceof TimelyMailboxProxy ? ((TimelyMailboxProxy)original).getWrappedMailbox() : original;
        TimestampTransformation preprocessor = this.getPreprocessor(requester, mailboxToProxify.getReceiver());
        if (preprocessor == null) {
            return mailboxToProxify;
        }
        return new TimelyMailboxProxy(mailboxToProxify, preprocessor);
    }

    @Override
    public IndexerListener proxifyIndexerListener(Node requester, IndexerListener original) {
        IndexerListener listenerToProxify = original instanceof TimelyIndexerListenerProxy ? ((TimelyIndexerListenerProxy)original).getWrappedIndexerListener() : original;
        TimestampTransformation preprocessor = this.getPreprocessor(requester, listenerToProxify.getOwner());
        if (preprocessor == null) {
            return listenerToProxify;
        }
        return new TimelyIndexerListenerProxy(listenerToProxify, preprocessor);
    }

    protected TimestampTransformation getPreprocessor(Node source, Node target) {
        Node effectiveSource = source instanceof SpecializedProjectionIndexer ? ((SpecializedProjectionIndexer)source).getActiveNode() : source;
        CommunicationGroup sourceGroup = this.getGroup(effectiveSource);
        CommunicationGroup targetGroup = this.getGroup(target);
        if (sourceGroup != null && targetGroup != null) {
            if (sourceGroup != targetGroup && sourceGroup.isRecursive()) {
                return TimestampTransformation.RESET;
            }
            if (sourceGroup == targetGroup && target instanceof ProductionNode) {
                return TimestampTransformation.INCREMENT;
            }
        }
        return null;
    }

    @Override
    protected void postProcessNode(Node node) {
        if (node instanceof NetworkStructureChangeSensitiveNode) {
            ((NetworkStructureChangeSensitiveNode)node).networkStructureChanged();
        }
    }

    @Override
    protected void postProcessGroup(CommunicationGroup group) {
        Node representative;
        Set groupMembers;
        if (this.configuration.getTimelineRepresentation() == TimelyConfiguration.TimelineRepresentation.FAITHFUL && (groupMembers = this.sccInformationProvider.sccs.getPartition((Object)(representative = group.getRepresentative()))).size() > 1) {
            Graph graph = new Graph();
            for (Node node : groupMembers) {
                graph.insertNode((Object)node);
            }
            for (Node source : groupMembers) {
                for (Node target : this.dependencyGraph.getTargetNodes((Object)source)) {
                    if (this.isRecursionCutPoint(source, target) || !groupMembers.contains(target)) continue;
                    graph.insertEdge((Object)source, (Object)target);
                }
            }
            List orderedNodes = TopologicalSorting.compute((IGraphDataSource)graph);
            Map nodeMap = CollectionsFactory.createMap();
            int identifier = 0;
            for (Node orderedNode : orderedNodes) {
                nodeMap.put(orderedNode, identifier++);
            }
            ((TimelyCommunicationGroup)group).setComparatorAndReorderMailboxes(new NodeComparator(nodeMap));
        }
    }
}

