/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.localsearch.planner;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.viatra.query.runtime.localsearch.matcher.integration.LocalSearchHints;
import org.eclipse.viatra.query.runtime.localsearch.operations.ISearchOperation;
import org.eclipse.viatra.query.runtime.localsearch.plan.SearchPlanForBody;
import org.eclipse.viatra.query.runtime.localsearch.planner.ILocalSearchPlanner;
import org.eclipse.viatra.query.runtime.localsearch.planner.LocalSearchRuntimeBasedStrategy;
import org.eclipse.viatra.query.runtime.localsearch.planner.PlanState;
import org.eclipse.viatra.query.runtime.localsearch.planner.compiler.IOperationCompiler;
import org.eclipse.viatra.query.runtime.matchers.backend.ResultProviderRequestor;
import org.eclipse.viatra.query.runtime.matchers.context.IQueryBackendContext;
import org.eclipse.viatra.query.runtime.matchers.context.IQueryRuntimeContext;
import org.eclipse.viatra.query.runtime.matchers.planning.SubPlan;
import org.eclipse.viatra.query.runtime.matchers.psystem.PBody;
import org.eclipse.viatra.query.runtime.matchers.psystem.PVariable;
import org.eclipse.viatra.query.runtime.matchers.psystem.basicdeferred.ExportedParameter;
import org.eclipse.viatra.query.runtime.matchers.psystem.queries.PParameter;
import org.eclipse.viatra.query.runtime.matchers.psystem.queries.PQuery;
import org.eclipse.viatra.query.runtime.matchers.psystem.rewriters.IdentityPDisjunctionRewriter;
import org.eclipse.viatra.query.runtime.matchers.psystem.rewriters.PBodyNormalizer;
import org.eclipse.viatra.query.runtime.matchers.psystem.rewriters.PDisjunctionRewriter;
import org.eclipse.viatra.query.runtime.matchers.psystem.rewriters.PDisjunctionRewriterCacher;
import org.eclipse.viatra.query.runtime.matchers.psystem.rewriters.PQueryFlattener;
import org.eclipse.viatra.query.runtime.matchers.psystem.rewriters.SurrogateQueryRewriter;

public class LocalSearchPlanner
implements ILocalSearchPlanner {
    private final PDisjunctionRewriter preprocessor;
    private final LocalSearchRuntimeBasedStrategy plannerStrategy;
    private final IQueryRuntimeContext runtimeContext;
    private final LocalSearchHints configuration;
    private final IOperationCompiler operationCompiler;
    private final IQueryBackendContext context;
    private final ResultProviderRequestor resultRequestor;

    public LocalSearchPlanner(IQueryBackendContext backendContext, IOperationCompiler compiler, Logger logger, LocalSearchHints configuration, ResultProviderRequestor resultRequestor) {
        this.runtimeContext = backendContext.getRuntimeContext();
        this.configuration = configuration;
        this.operationCompiler = compiler;
        this.resultRequestor = resultRequestor;
        SurrogateQueryRewriter surrogatesRewriter = configuration.isConsultSurrogates() != false ? new SurrogateQueryRewriter() : new IdentityPDisjunctionRewriter();
        PQueryFlattener flattener = new PQueryFlattener(configuration.getFlattenCallPredicate());
        PBodyNormalizer normalizer = new PBodyNormalizer(this.runtimeContext.getMetaContext()){

            protected boolean shouldCalculateImpliedTypes(PQuery query) {
                return false;
            }
        };
        this.preprocessor = new PDisjunctionRewriterCacher(new PDisjunctionRewriter[]{flattener, surrogatesRewriter, normalizer});
        this.plannerStrategy = new LocalSearchRuntimeBasedStrategy();
        this.context = backendContext;
    }

    @Override
    public Collection<SearchPlanForBody> plan(PQuery querySpec, Set<PParameter> boundParameters) {
        this.preprocessor.setTraceCollector(this.configuration.getTraceCollector());
        Set normalizedBodies = this.preprocessor.rewrite(querySpec.getDisjunctBodies()).getBodies();
        ArrayList<SearchPlanForBody> plansForBodies = new ArrayList<SearchPlanForBody>(normalizedBodies.size());
        for (PBody normalizedBody : normalizedBodies) {
            Set<PVariable> boundVariables = this.calculatePatternAdornmentForPlanner(boundParameters, normalizedBody);
            PlanState searchPlanInternal = this.plannerStrategy.plan(normalizedBody, boundVariables, this.context, this.resultRequestor, this.configuration);
            SubPlan plan = this.plannerStrategy.convertPlan(boundVariables, searchPlanInternal);
            List<ISearchOperation> compiledOperations = this.operationCompiler.compile(plan, boundParameters);
            SearchPlanForBody compiledPlan = new SearchPlanForBody(normalizedBody, this.operationCompiler.getVariableMappings(), plan, compiledOperations, this.operationCompiler.getDependencies(), searchPlanInternal, searchPlanInternal.getCost());
            plansForBodies.add(compiledPlan);
        }
        return plansForBodies;
    }

    private Set<PVariable> calculatePatternAdornmentForPlanner(Set<PParameter> boundParameters, PBody normalizedBody) {
        HashMap<PParameter, PVariable> parameterMapping = new HashMap<PParameter, PVariable>();
        for (ExportedParameter constraint : normalizedBody.getSymbolicParameters()) {
            parameterMapping.put(constraint.getPatternParameter(), constraint.getParameterVariable());
        }
        HashSet<PVariable> boundVariables = new HashSet<PVariable>();
        for (PParameter parameter : boundParameters) {
            PVariable mappedParameter = (PVariable)parameterMapping.get(parameter);
            boundVariables.add(mappedParameter);
        }
        return boundVariables;
    }
}

