/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.analysis.profiling.core.tests.callgraph2;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.analysis.profiling.core.tests.CallStackTestBase2;
import org.eclipse.tracecompass.analysis.profiling.core.tests.stubs2.CallStackAnalysisStub;
import org.eclipse.tracecompass.internal.analysis.profiling.core.callgraph2.AggregatedCallSite;
import org.eclipse.tracecompass.internal.analysis.profiling.core.callgraph2.AggregatedCalledFunction;
import org.eclipse.tracecompass.internal.analysis.profiling.core.callgraph2.CallGraphAnalysis;
import org.eclipse.tracecompass.internal.analysis.profiling.core.instrumented.InstrumentedCallStackElement;
import org.eclipse.tracecompass.internal.analysis.profiling.core.model.CompositeHostModel;
import org.eclipse.tracecompass.internal.analysis.profiling.core.model.ModelManager;
import org.eclipse.tracecompass.internal.provisional.analysis.profiling.core.base.ICallStackElement;
import org.eclipse.tracecompass.internal.provisional.analysis.profiling.core.callgraph.CallGraph;
import org.eclipse.tracecompass.internal.provisional.analysis.profiling.core.instrumented.IFlameChartProvider;
import org.eclipse.tracecompass.internal.provisional.analysis.profiling.core.model.ICpuTimeProvider;
import org.eclipse.tracecompass.internal.provisional.analysis.profiling.core.model.IHostModel;
import org.eclipse.tracecompass.tmf.core.exceptions.TmfAnalysisException;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimestamp;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

public class CallGraphWithCallStackAnalysisTest
extends CallStackTestBase2 {
    private static final String UNKNOWN = "Unknown process in callstack";
    private static final String UNKNOWN_PROCESS = "Unknown process in callstack: ";
    private static final String UNKNOWN_SYMBOL = "Unknown symbol for thread 2: ";

    @After
    public void cleanUp() {
        System.gc();
    }

    @Test
    public void testCallGraph() {
        CallStackAnalysisStub cga = this.getModule();
        CallGraph cg = cga.getCallGraph();
        try {
            Collection elements = cg.getElements();
            for (ICallStackElement group : elements) {
                String firstLevelName;
                switch (firstLevelName = group.getName()) {
                    case "1": {
                        CallGraphWithCallStackAnalysisTest.verifyProcess1(cg, group);
                        break;
                    }
                    case "5": {
                        CallGraphWithCallStackAnalysisTest.verifyProcess5(cg, group);
                        break;
                    }
                    default: {
                        Assert.fail((String)UNKNOWN);
                    }
                }
            }
        }
        finally {
            cga.dispose();
        }
    }

    private static void verifyProcess1(CallGraph cg, ICallStackElement element) {
        Collection secondLevels = element.getChildrenElements();
        Assert.assertEquals((long)2L, (long)secondLevels.size());
        block24: for (ICallStackElement secondLevel : secondLevels) {
            Assert.assertTrue((boolean)(secondLevel instanceof InstrumentedCallStackElement));
            Assert.assertTrue((boolean)secondLevel.isLeaf());
            String secondLevelName = secondLevel.getName();
            Collection children = cg.getCallingContextTree(secondLevel);
            switch (secondLevelName) {
                case "2": {
                    Assert.assertEquals((long)2L, (long)children.size());
                    for (AggregatedCallSite child : children) {
                        Assert.assertTrue((boolean)(child instanceof AggregatedCalledFunction));
                        AggregatedCalledFunction func = (AggregatedCalledFunction)child;
                        switch (CallGraphWithCallStackAnalysisTest.getCallSiteSymbol((AggregatedCallSite)func).resolve(Collections.emptySet())) {
                            case "op1": {
                                Assert.assertEquals((long)9L, (long)func.getDuration());
                                Assert.assertEquals((long)5L, (long)func.getSelfTime());
                                Assert.assertEquals((long)-1L, (long)func.getCpuTime());
                                Assert.assertEquals((long)1L, (long)func.getNbCalls());
                                Assert.assertEquals((long)1L, (long)func.getProcessId());
                                Assert.assertEquals((long)1L, (long)func.getCallees().size());
                                AggregatedCalledFunction next = (AggregatedCalledFunction)func.getCallees().iterator().next();
                                Assert.assertNotNull((Object)next);
                                Assert.assertEquals((long)4L, (long)next.getDuration());
                                Assert.assertEquals((long)3L, (long)next.getSelfTime());
                                Assert.assertEquals((long)-1L, (long)next.getCpuTime());
                                Assert.assertEquals((long)1L, (long)next.getNbCalls());
                                Assert.assertEquals((long)1L, (long)next.getProcessId());
                                Assert.assertEquals((Object)"op2", (Object)CallGraphWithCallStackAnalysisTest.getCallSiteSymbol((AggregatedCallSite)next).resolve(Collections.emptySet()));
                                Assert.assertEquals((long)1L, (long)next.getCallees().size());
                                AggregatedCalledFunction third = (AggregatedCalledFunction)next.getCallees().iterator().next();
                                Assert.assertNotNull((Object)third);
                                Assert.assertEquals((long)1L, (long)third.getDuration());
                                Assert.assertEquals((long)1L, (long)third.getSelfTime());
                                Assert.assertEquals((long)-1L, (long)third.getCpuTime());
                                Assert.assertEquals((long)1L, (long)third.getNbCalls());
                                Assert.assertEquals((long)1L, (long)third.getProcessId());
                                Assert.assertEquals((Object)"op3", (Object)CallGraphWithCallStackAnalysisTest.getCallSiteSymbol((AggregatedCallSite)third).resolve(Collections.emptySet()));
                                Assert.assertEquals((long)0L, (long)third.getCallees().size());
                                break;
                            }
                            case "op4": {
                                Assert.assertEquals((long)8L, (long)func.getDuration());
                                Assert.assertEquals((long)8L, (long)func.getSelfTime());
                                Assert.assertEquals((long)-1L, (long)func.getCpuTime());
                                Assert.assertEquals((long)1L, (long)func.getNbCalls());
                                Assert.assertEquals((long)1L, (long)func.getProcessId());
                                Assert.assertEquals((long)0L, (long)func.getCallees().size());
                                break;
                            }
                            default: {
                                Assert.fail((String)(UNKNOWN_SYMBOL + String.valueOf(CallGraphWithCallStackAnalysisTest.getCallSiteSymbol((AggregatedCallSite)func))));
                            }
                        }
                    }
                    continue block24;
                }
                case "3": {
                    Assert.assertEquals((long)1L, (long)children.size());
                    AggregatedCalledFunction func = (AggregatedCalledFunction)children.iterator().next();
                    Assert.assertEquals((Object)"op2", (Object)CallGraphWithCallStackAnalysisTest.getCallSiteSymbol((AggregatedCallSite)func).resolve(Collections.emptySet()));
                    Assert.assertEquals((long)17L, (long)func.getDuration());
                    Assert.assertEquals((long)10L, (long)func.getSelfTime());
                    Assert.assertEquals((long)-1L, (long)func.getCpuTime());
                    Assert.assertEquals((long)1L, (long)func.getNbCalls());
                    Assert.assertEquals((long)1L, (long)func.getProcessId());
                    Assert.assertEquals((long)2L, (long)func.getCallees().size());
                    for (AggregatedCallSite nextChild : func.getCallees()) {
                        Assert.assertTrue((boolean)(nextChild instanceof AggregatedCalledFunction));
                        AggregatedCalledFunction next = (AggregatedCalledFunction)nextChild;
                        switch (CallGraphWithCallStackAnalysisTest.getCallSiteSymbol((AggregatedCallSite)next).resolve(Collections.emptySet())) {
                            case "op3": {
                                Assert.assertEquals((long)1L, (long)next.getDuration());
                                Assert.assertEquals((long)1L, (long)next.getSelfTime());
                                Assert.assertEquals((long)-1L, (long)next.getCpuTime());
                                Assert.assertEquals((long)1L, (long)next.getNbCalls());
                                Assert.assertEquals((long)1L, (long)next.getProcessId());
                                Assert.assertEquals((long)0L, (long)next.getCallees().size());
                                break;
                            }
                            case "op2": {
                                Assert.assertEquals((long)6L, (long)next.getDuration());
                                Assert.assertEquals((long)6L, (long)next.getSelfTime());
                                Assert.assertEquals((long)-1L, (long)next.getCpuTime());
                                Assert.assertEquals((long)1L, (long)next.getNbCalls());
                                Assert.assertEquals((long)1L, (long)next.getProcessId());
                                Assert.assertEquals((long)0L, (long)next.getCallees().size());
                                break;
                            }
                            default: {
                                Assert.fail((String)(UNKNOWN_SYMBOL + String.valueOf(CallGraphWithCallStackAnalysisTest.getCallSiteSymbol((AggregatedCallSite)func))));
                            }
                        }
                    }
                    continue block24;
                }
                default: {
                    Assert.fail((String)(UNKNOWN_PROCESS + secondLevelName));
                }
            }
        }
    }

    private static void verifyProcess5(CallGraph cg, ICallStackElement element) {
        Collection secondLevels = element.getChildrenElements();
        Assert.assertEquals((long)2L, (long)secondLevels.size());
        block18: for (ICallStackElement secondLevel : secondLevels) {
            Assert.assertTrue((boolean)(secondLevel instanceof InstrumentedCallStackElement));
            Assert.assertTrue((boolean)secondLevel.isLeaf());
            String secondLevelName = secondLevel.getName();
            Collection children = cg.getCallingContextTree(secondLevel);
            switch (secondLevelName) {
                case "6": {
                    Assert.assertEquals((long)1L, (long)children.size());
                    AggregatedCalledFunction func = (AggregatedCalledFunction)children.iterator().next();
                    Assert.assertNotNull((Object)func);
                    Assert.assertEquals((Object)"op1", (Object)CallGraphWithCallStackAnalysisTest.getCallSiteSymbol((AggregatedCallSite)func).resolve(Collections.emptySet()));
                    Assert.assertEquals((long)19L, (long)func.getDuration());
                    Assert.assertEquals((long)3L, (long)func.getSelfTime());
                    Assert.assertEquals((long)-1L, (long)func.getCpuTime());
                    Assert.assertEquals((long)1L, (long)func.getNbCalls());
                    Assert.assertEquals((long)5L, (long)func.getProcessId());
                    Assert.assertEquals((long)3L, (long)func.getCallees().size());
                    for (AggregatedCallSite nextChild : func.getCallees()) {
                        Assert.assertTrue((boolean)(nextChild instanceof AggregatedCalledFunction));
                        AggregatedCalledFunction next = (AggregatedCalledFunction)nextChild;
                        switch (CallGraphWithCallStackAnalysisTest.getCallSiteSymbol((AggregatedCallSite)next).resolve(Collections.emptySet())) {
                            case "op2": {
                                Assert.assertEquals((long)3L, (long)next.getDuration());
                                Assert.assertEquals((long)2L, (long)next.getSelfTime());
                                Assert.assertEquals((long)-1L, (long)next.getCpuTime());
                                Assert.assertEquals((long)1L, (long)next.getNbCalls());
                                Assert.assertEquals((long)5L, (long)next.getProcessId());
                                Assert.assertEquals((Object)"op2", (Object)CallGraphWithCallStackAnalysisTest.getCallSiteSymbol((AggregatedCallSite)next).resolve(Collections.emptySet()));
                                Assert.assertEquals((long)1L, (long)next.getCallees().size());
                                AggregatedCalledFunction third = (AggregatedCalledFunction)next.getCallees().iterator().next();
                                Assert.assertNotNull((Object)third);
                                Assert.assertEquals((long)1L, (long)third.getDuration());
                                Assert.assertEquals((long)1L, (long)third.getSelfTime());
                                Assert.assertEquals((long)-1L, (long)third.getCpuTime());
                                Assert.assertEquals((long)1L, (long)third.getNbCalls());
                                Assert.assertEquals((long)5L, (long)third.getProcessId());
                                Assert.assertEquals((Object)"op3", (Object)CallGraphWithCallStackAnalysisTest.getCallSiteSymbol((AggregatedCallSite)third).resolve(Collections.emptySet()));
                                Assert.assertEquals((long)0L, (long)third.getCallees().size());
                                break;
                            }
                            case "op3": {
                                Assert.assertEquals((long)5L, (long)next.getDuration());
                                Assert.assertEquals((long)3L, (long)next.getSelfTime());
                                Assert.assertEquals((long)-1L, (long)next.getCpuTime());
                                Assert.assertEquals((long)1L, (long)next.getNbCalls());
                                Assert.assertEquals((long)5L, (long)next.getProcessId());
                                Assert.assertEquals((Object)"op3", (Object)CallGraphWithCallStackAnalysisTest.getCallSiteSymbol((AggregatedCallSite)next).resolve(Collections.emptySet()));
                                Assert.assertEquals((long)1L, (long)next.getCallees().size());
                                AggregatedCalledFunction third = (AggregatedCalledFunction)next.getCallees().iterator().next();
                                Assert.assertNotNull((Object)third);
                                Assert.assertEquals((long)2L, (long)third.getDuration());
                                Assert.assertEquals((long)2L, (long)third.getSelfTime());
                                Assert.assertEquals((long)-1L, (long)third.getCpuTime());
                                Assert.assertEquals((long)1L, (long)third.getNbCalls());
                                Assert.assertEquals((long)5L, (long)third.getProcessId());
                                Assert.assertEquals((Object)"op1", (Object)CallGraphWithCallStackAnalysisTest.getCallSiteSymbol((AggregatedCallSite)third).resolve(Collections.emptySet()));
                                Assert.assertEquals((long)0L, (long)third.getCallees().size());
                                break;
                            }
                            case "op4": {
                                Assert.assertEquals((long)8L, (long)next.getDuration());
                                Assert.assertEquals((long)8L, (long)next.getSelfTime());
                                Assert.assertEquals((long)-1L, (long)next.getCpuTime());
                                Assert.assertEquals((long)1L, (long)next.getNbCalls());
                                Assert.assertEquals((long)5L, (long)next.getProcessId());
                                Assert.assertEquals((Object)"op4", (Object)CallGraphWithCallStackAnalysisTest.getCallSiteSymbol((AggregatedCallSite)next).resolve(Collections.emptySet()));
                                Assert.assertEquals((long)0L, (long)next.getCallees().size());
                                break;
                            }
                            default: {
                                Assert.fail((String)"Unknown symbol for second level of tid 6");
                            }
                        }
                    }
                    continue block18;
                }
                case "7": {
                    Assert.assertEquals((long)1L, (long)children.size());
                    AggregatedCalledFunction func = (AggregatedCalledFunction)children.iterator().next();
                    Assert.assertNotNull((Object)func);
                    Assert.assertEquals((Object)"op5", (Object)CallGraphWithCallStackAnalysisTest.getCallSiteSymbol((AggregatedCallSite)func).resolve(Collections.emptySet()));
                    Assert.assertEquals((long)19L, (long)func.getDuration());
                    Assert.assertEquals((long)7L, (long)func.getSelfTime());
                    Assert.assertEquals((long)-1L, (long)func.getCpuTime());
                    Assert.assertEquals((long)1L, (long)func.getNbCalls());
                    Assert.assertEquals((long)5L, (long)func.getProcessId());
                    Assert.assertEquals((long)1L, (long)func.getCallees().size());
                    Iterator iterator = func.getCallees().iterator();
                    AggregatedCalledFunction next = (AggregatedCalledFunction)iterator.next();
                    Assert.assertNotNull((Object)next);
                    Assert.assertEquals((long)12L, (long)next.getDuration());
                    Assert.assertEquals((long)11L, (long)next.getSelfTime());
                    Assert.assertEquals((long)-1L, (long)next.getCpuTime());
                    Assert.assertEquals((long)3L, (long)next.getNbCalls());
                    Assert.assertEquals((long)5L, (long)next.getProcessId());
                    Assert.assertEquals((Object)"op2", (Object)CallGraphWithCallStackAnalysisTest.getCallSiteSymbol((AggregatedCallSite)next).resolve(Collections.emptySet()));
                    Assert.assertEquals((long)1L, (long)next.getCallees().size());
                    AggregatedCalledFunction third = (AggregatedCalledFunction)next.getCallees().iterator().next();
                    Assert.assertNotNull((Object)third);
                    Assert.assertEquals((long)1L, (long)third.getDuration());
                    Assert.assertEquals((long)1L, (long)third.getSelfTime());
                    Assert.assertEquals((long)-1L, (long)third.getCpuTime());
                    Assert.assertEquals((long)1L, (long)third.getNbCalls());
                    Assert.assertEquals((long)5L, (long)third.getProcessId());
                    Assert.assertEquals((Object)"op3", (Object)CallGraphWithCallStackAnalysisTest.getCallSiteSymbol((AggregatedCallSite)third).resolve(Collections.emptySet()));
                    Assert.assertEquals((long)0L, (long)third.getCallees().size());
                    break;
                }
                default: {
                    Assert.fail((String)(UNKNOWN_PROCESS + secondLevelName));
                }
            }
        }
    }

    private CallGraphAnalysis getCallGraphModule() throws TmfAnalysisException {
        CallGraphAnalysis cga = new CallGraphAnalysis((IFlameChartProvider)Objects.requireNonNull(this.getModule()));
        cga.setId(this.getModule().getId());
        cga.setTrace(this.getTrace());
        cga.schedule();
        cga.waitForCompletion();
        return cga;
    }

    @Test
    public void testCallGraphWithCpuTime() throws TmfAnalysisException {
        IHostModel model = ModelManager.getModelFor((String)this.getTrace().getHostId());
        ICpuTimeProvider cpuTimeProvider = new ICpuTimeProvider(){

            public long getCpuTime(int tid, long start, long end) {
                long endTime;
                long beginTime;
                if (tid == 7) {
                    beginTime = Math.max(start, 3L);
                    endTime = Math.min(end, 4L);
                    if (endTime - beginTime > 0L) {
                        return end - start - (endTime - beginTime);
                    }
                }
                if (tid == 3) {
                    beginTime = Math.max(start, 8L);
                    endTime = Math.min(end, 11L);
                    if (endTime - beginTime > 0L) {
                        return end - start - (endTime - beginTime);
                    }
                }
                if (tid == 2) {
                    beginTime = Math.max(start, 13L);
                    endTime = Math.min(end, 18L);
                    if (endTime - beginTime > 0L) {
                        return end - start - (endTime - beginTime);
                    }
                }
                return end - start;
            }

            public @NonNull Collection<@NonNull String> getHostIds() {
                return Collections.singleton("callstack.xml");
            }
        };
        ((CompositeHostModel)model).setCpuTimeProvider(cpuTimeProvider);
        CallGraphAnalysis cga = this.getCallGraphModule();
        CallGraph callGraph = cga.getCallGraph();
        try {
            Collection groups = callGraph.getElements();
            for (ICallStackElement group : groups) {
                String firstLevelName;
                switch (firstLevelName = group.getName()) {
                    case "1": {
                        CallGraphWithCallStackAnalysisTest.verifyProcess1CpuTime(callGraph, group);
                        break;
                    }
                    case "5": {
                        CallGraphWithCallStackAnalysisTest.verifyProcess5CpuTime(callGraph, group);
                        break;
                    }
                    default: {
                        Assert.fail((String)UNKNOWN);
                    }
                }
            }
        }
        finally {
            cga.dispose();
        }
    }

    private static void verifyProcess1CpuTime(CallGraph callGraph, ICallStackElement element) {
        Collection secondLevels = element.getChildrenElements();
        Assert.assertEquals((long)2L, (long)secondLevels.size());
        block24: for (ICallStackElement secondLevel : secondLevels) {
            Assert.assertTrue((boolean)(secondLevel instanceof InstrumentedCallStackElement));
            Assert.assertTrue((boolean)secondLevel.isLeaf());
            String secondLevelName = secondLevel.getName();
            Collection children = callGraph.getCallingContextTree(secondLevel);
            switch (secondLevelName) {
                case "2": {
                    Assert.assertEquals((long)2L, (long)children.size());
                    for (AggregatedCallSite child : children) {
                        Assert.assertTrue((boolean)(child instanceof AggregatedCalledFunction));
                        AggregatedCalledFunction func = (AggregatedCalledFunction)child;
                        switch (CallGraphWithCallStackAnalysisTest.getCallSiteSymbol((AggregatedCallSite)func).resolve(Collections.emptySet())) {
                            case "op1": {
                                Assert.assertEquals((long)9L, (long)func.getDuration());
                                Assert.assertEquals((long)5L, (long)func.getSelfTime());
                                Assert.assertEquals((long)9L, (long)func.getCpuTime());
                                Assert.assertEquals((long)1L, (long)func.getNbCalls());
                                Assert.assertEquals((long)1L, (long)func.getProcessId());
                                Assert.assertEquals((long)1L, (long)func.getCallees().size());
                                AggregatedCalledFunction next = (AggregatedCalledFunction)func.getCallees().iterator().next();
                                Assert.assertNotNull((Object)next);
                                Assert.assertEquals((long)4L, (long)next.getDuration());
                                Assert.assertEquals((long)3L, (long)next.getSelfTime());
                                Assert.assertEquals((long)4L, (long)next.getCpuTime());
                                Assert.assertEquals((long)1L, (long)next.getNbCalls());
                                Assert.assertEquals((long)1L, (long)next.getProcessId());
                                Assert.assertEquals((Object)"op2", (Object)CallGraphWithCallStackAnalysisTest.getCallSiteSymbol((AggregatedCallSite)next).resolve(Collections.emptySet()));
                                Assert.assertEquals((long)1L, (long)next.getCallees().size());
                                AggregatedCalledFunction third = (AggregatedCalledFunction)next.getCallees().iterator().next();
                                Assert.assertNotNull((Object)third);
                                Assert.assertEquals((long)1L, (long)third.getDuration());
                                Assert.assertEquals((long)1L, (long)third.getSelfTime());
                                Assert.assertEquals((long)1L, (long)third.getCpuTime());
                                Assert.assertEquals((long)1L, (long)third.getNbCalls());
                                Assert.assertEquals((long)1L, (long)third.getProcessId());
                                Assert.assertEquals((Object)"op3", (Object)CallGraphWithCallStackAnalysisTest.getCallSiteSymbol((AggregatedCallSite)third).resolve(Collections.emptySet()));
                                Assert.assertEquals((long)0L, (long)third.getCallees().size());
                                break;
                            }
                            case "op4": {
                                Assert.assertEquals((long)8L, (long)func.getDuration());
                                Assert.assertEquals((long)8L, (long)func.getSelfTime());
                                Assert.assertEquals((long)3L, (long)func.getCpuTime());
                                Assert.assertEquals((long)1L, (long)func.getNbCalls());
                                Assert.assertEquals((long)1L, (long)func.getProcessId());
                                Assert.assertEquals((long)0L, (long)func.getCallees().size());
                                break;
                            }
                            default: {
                                Assert.fail((String)(UNKNOWN_SYMBOL + String.valueOf(CallGraphWithCallStackAnalysisTest.getCallSiteSymbol((AggregatedCallSite)func))));
                            }
                        }
                    }
                    continue block24;
                }
                case "3": {
                    Assert.assertEquals((long)1L, (long)children.size());
                    AggregatedCalledFunction func = (AggregatedCalledFunction)children.iterator().next();
                    Assert.assertEquals((Object)"op2", (Object)CallGraphWithCallStackAnalysisTest.getCallSiteSymbol((AggregatedCallSite)func).resolve(Collections.emptySet()));
                    Assert.assertEquals((long)17L, (long)func.getDuration());
                    Assert.assertEquals((long)10L, (long)func.getSelfTime());
                    Assert.assertEquals((long)14L, (long)func.getCpuTime());
                    Assert.assertEquals((long)1L, (long)func.getNbCalls());
                    Assert.assertEquals((long)1L, (long)func.getProcessId());
                    Assert.assertEquals((long)2L, (long)func.getCallees().size());
                    for (AggregatedCallSite nextChild : func.getCallees()) {
                        Assert.assertTrue((boolean)(nextChild instanceof AggregatedCalledFunction));
                        AggregatedCalledFunction next = (AggregatedCalledFunction)nextChild;
                        switch (CallGraphWithCallStackAnalysisTest.getCallSiteSymbol((AggregatedCallSite)next).resolve(Collections.emptySet())) {
                            case "op3": {
                                Assert.assertEquals((long)1L, (long)next.getDuration());
                                Assert.assertEquals((long)1L, (long)next.getSelfTime());
                                Assert.assertEquals((long)1L, (long)next.getCpuTime());
                                Assert.assertEquals((long)1L, (long)next.getNbCalls());
                                Assert.assertEquals((long)1L, (long)next.getProcessId());
                                Assert.assertEquals((long)0L, (long)next.getCallees().size());
                                break;
                            }
                            case "op2": {
                                Assert.assertEquals((long)6L, (long)next.getDuration());
                                Assert.assertEquals((long)6L, (long)next.getSelfTime());
                                Assert.assertEquals((long)3L, (long)next.getCpuTime());
                                Assert.assertEquals((long)1L, (long)next.getNbCalls());
                                Assert.assertEquals((long)1L, (long)next.getProcessId());
                                Assert.assertEquals((long)0L, (long)next.getCallees().size());
                                break;
                            }
                            default: {
                                Assert.fail((String)("Unknown symbol for thread 3: " + String.valueOf(CallGraphWithCallStackAnalysisTest.getCallSiteSymbol((AggregatedCallSite)func))));
                            }
                        }
                    }
                    continue block24;
                }
                default: {
                    Assert.fail((String)(UNKNOWN_PROCESS + secondLevelName));
                }
            }
        }
    }

    private static void verifyProcess5CpuTime(CallGraph callGraph, ICallStackElement element) {
        Collection secondLevels = element.getChildrenElements();
        Assert.assertEquals((long)2L, (long)secondLevels.size());
        block18: for (ICallStackElement secondLevel : secondLevels) {
            Assert.assertTrue((boolean)(secondLevel instanceof InstrumentedCallStackElement));
            Assert.assertTrue((boolean)secondLevel.isLeaf());
            String secondLevelName = secondLevel.getName();
            Collection children = callGraph.getCallingContextTree(secondLevel);
            switch (secondLevelName) {
                case "6": {
                    Assert.assertEquals((long)1L, (long)children.size());
                    AggregatedCalledFunction func = (AggregatedCalledFunction)children.iterator().next();
                    Assert.assertNotNull((Object)func);
                    Assert.assertEquals((Object)"op1", (Object)CallGraphWithCallStackAnalysisTest.getCallSiteSymbol((AggregatedCallSite)func).resolve(Collections.emptySet()));
                    Assert.assertEquals((long)19L, (long)func.getDuration());
                    Assert.assertEquals((long)3L, (long)func.getSelfTime());
                    Assert.assertEquals((long)19L, (long)func.getCpuTime());
                    Assert.assertEquals((long)1L, (long)func.getNbCalls());
                    Assert.assertEquals((long)5L, (long)func.getProcessId());
                    Assert.assertEquals((long)3L, (long)func.getCallees().size());
                    for (AggregatedCallSite nextChild : func.getCallees()) {
                        Assert.assertTrue((boolean)(nextChild instanceof AggregatedCalledFunction));
                        AggregatedCalledFunction next = (AggregatedCalledFunction)nextChild;
                        switch (CallGraphWithCallStackAnalysisTest.getCallSiteSymbol((AggregatedCallSite)next).resolve(Collections.emptySet())) {
                            case "op2": {
                                Assert.assertEquals((long)3L, (long)next.getDuration());
                                Assert.assertEquals((long)2L, (long)next.getSelfTime());
                                Assert.assertEquals((long)3L, (long)next.getCpuTime());
                                Assert.assertEquals((long)1L, (long)next.getNbCalls());
                                Assert.assertEquals((long)5L, (long)next.getProcessId());
                                Assert.assertEquals((Object)"op2", (Object)CallGraphWithCallStackAnalysisTest.getCallSiteSymbol((AggregatedCallSite)next).resolve(Collections.emptySet()));
                                Assert.assertEquals((long)1L, (long)next.getCallees().size());
                                AggregatedCalledFunction third = (AggregatedCalledFunction)next.getCallees().iterator().next();
                                Assert.assertNotNull((Object)third);
                                Assert.assertEquals((long)1L, (long)third.getDuration());
                                Assert.assertEquals((long)1L, (long)third.getSelfTime());
                                Assert.assertEquals((long)1L, (long)third.getCpuTime());
                                Assert.assertEquals((long)1L, (long)third.getNbCalls());
                                Assert.assertEquals((long)5L, (long)third.getProcessId());
                                Assert.assertEquals((Object)"op3", (Object)CallGraphWithCallStackAnalysisTest.getCallSiteSymbol((AggregatedCallSite)third).resolve(Collections.emptySet()));
                                Assert.assertEquals((long)0L, (long)third.getCallees().size());
                                break;
                            }
                            case "op3": {
                                Assert.assertEquals((long)5L, (long)next.getDuration());
                                Assert.assertEquals((long)3L, (long)next.getSelfTime());
                                Assert.assertEquals((long)5L, (long)next.getCpuTime());
                                Assert.assertEquals((long)1L, (long)next.getNbCalls());
                                Assert.assertEquals((long)5L, (long)next.getProcessId());
                                Assert.assertEquals((Object)"op3", (Object)CallGraphWithCallStackAnalysisTest.getCallSiteSymbol((AggregatedCallSite)next).resolve(Collections.emptySet()));
                                Assert.assertEquals((long)1L, (long)next.getCallees().size());
                                AggregatedCalledFunction third = (AggregatedCalledFunction)next.getCallees().iterator().next();
                                Assert.assertNotNull((Object)third);
                                Assert.assertEquals((long)2L, (long)third.getDuration());
                                Assert.assertEquals((long)2L, (long)third.getSelfTime());
                                Assert.assertEquals((long)2L, (long)third.getCpuTime());
                                Assert.assertEquals((long)1L, (long)third.getNbCalls());
                                Assert.assertEquals((long)5L, (long)third.getProcessId());
                                Assert.assertEquals((Object)"op1", (Object)CallGraphWithCallStackAnalysisTest.getCallSiteSymbol((AggregatedCallSite)third).resolve(Collections.emptySet()));
                                Assert.assertEquals((long)0L, (long)third.getCallees().size());
                                break;
                            }
                            case "op4": {
                                Assert.assertEquals((long)8L, (long)next.getDuration());
                                Assert.assertEquals((long)8L, (long)next.getSelfTime());
                                Assert.assertEquals((long)8L, (long)next.getCpuTime());
                                Assert.assertEquals((long)1L, (long)next.getNbCalls());
                                Assert.assertEquals((long)5L, (long)next.getProcessId());
                                Assert.assertEquals((Object)"op4", (Object)CallGraphWithCallStackAnalysisTest.getCallSiteSymbol((AggregatedCallSite)next).resolve(Collections.emptySet()));
                                Assert.assertEquals((long)0L, (long)next.getCallees().size());
                                break;
                            }
                            default: {
                                Assert.fail((String)("Unknown symbol for second level of tid 6: " + String.valueOf(CallGraphWithCallStackAnalysisTest.getCallSiteSymbol((AggregatedCallSite)next))));
                            }
                        }
                    }
                    continue block18;
                }
                case "7": {
                    Assert.assertEquals((long)1L, (long)children.size());
                    AggregatedCalledFunction func = (AggregatedCalledFunction)children.iterator().next();
                    Assert.assertNotNull((Object)func);
                    Assert.assertEquals((Object)"op5", (Object)CallGraphWithCallStackAnalysisTest.getCallSiteSymbol((AggregatedCallSite)func).resolve(Collections.emptySet()));
                    Assert.assertEquals((long)19L, (long)func.getDuration());
                    Assert.assertEquals((long)7L, (long)func.getSelfTime());
                    Assert.assertEquals((long)18L, (long)func.getCpuTime());
                    Assert.assertEquals((long)1L, (long)func.getNbCalls());
                    Assert.assertEquals((long)5L, (long)func.getProcessId());
                    Assert.assertEquals((long)1L, (long)func.getCallees().size());
                    Iterator iterator = func.getCallees().iterator();
                    AggregatedCalledFunction next = (AggregatedCalledFunction)iterator.next();
                    Assert.assertNotNull((Object)next);
                    Assert.assertEquals((long)12L, (long)next.getDuration());
                    Assert.assertEquals((long)11L, (long)next.getSelfTime());
                    Assert.assertEquals((long)11L, (long)next.getCpuTime());
                    Assert.assertEquals((long)3L, (long)next.getNbCalls());
                    Assert.assertEquals((long)5L, (long)next.getProcessId());
                    Assert.assertEquals((Object)"op2", (Object)CallGraphWithCallStackAnalysisTest.getCallSiteSymbol((AggregatedCallSite)next).resolve(Collections.emptySet()));
                    Assert.assertEquals((long)1L, (long)next.getCallees().size());
                    AggregatedCalledFunction third = (AggregatedCalledFunction)next.getCallees().iterator().next();
                    Assert.assertNotNull((Object)third);
                    Assert.assertEquals((long)1L, (long)third.getDuration());
                    Assert.assertEquals((long)1L, (long)third.getSelfTime());
                    Assert.assertEquals((long)1L, (long)third.getCpuTime());
                    Assert.assertEquals((long)1L, (long)third.getNbCalls());
                    Assert.assertEquals((long)5L, (long)third.getProcessId());
                    Assert.assertEquals((Object)"op3", (Object)CallGraphWithCallStackAnalysisTest.getCallSiteSymbol((AggregatedCallSite)third).resolve(Collections.emptySet()));
                    Assert.assertEquals((long)0L, (long)third.getCallees().size());
                    break;
                }
                default: {
                    Assert.fail((String)(UNKNOWN_PROCESS + secondLevelName));
                }
            }
        }
    }

    @Test
    public void testSelectionCallGraph() {
        CallStackAnalysisStub cga = this.getModule();
        CallGraph cg = cga.getCallGraph(TmfTimestamp.fromNanos((long)1L), TmfTimestamp.fromNanos((long)10L));
        try {
            Collection elements = cg.getElements();
            for (ICallStackElement group : elements) {
                String firstLevelName;
                switch (firstLevelName = group.getName()) {
                    case "1": {
                        CallGraphWithCallStackAnalysisTest.verifyProcess1Selection(cg, group);
                        break;
                    }
                    case "5": {
                        CallGraphWithCallStackAnalysisTest.verifyProcess5Selection(cg, group);
                        break;
                    }
                    default: {
                        Assert.fail((String)UNKNOWN);
                    }
                }
            }
            CallGraph cg2 = cga.getCallGraph(TmfTimestamp.fromNanos((long)1L), TmfTimestamp.fromNanos((long)10L));
            Assert.assertTrue((cg == cg2 ? 1 : 0) != 0);
        }
        finally {
            cga.dispose();
        }
    }

    private static void verifyProcess1Selection(CallGraph cg, ICallStackElement element) {
        Collection secondLevels = element.getChildrenElements();
        Assert.assertEquals((long)2L, (long)secondLevels.size());
        block22: for (ICallStackElement secondLevel : secondLevels) {
            Assert.assertTrue((boolean)(secondLevel instanceof InstrumentedCallStackElement));
            Assert.assertTrue((boolean)secondLevel.isLeaf());
            String secondLevelName = secondLevel.getName();
            Collection children = cg.getCallingContextTree(secondLevel);
            switch (secondLevelName) {
                case "2": {
                    Assert.assertEquals((long)1L, (long)children.size());
                    for (AggregatedCallSite child : children) {
                        Assert.assertTrue((boolean)(child instanceof AggregatedCalledFunction));
                        AggregatedCalledFunction func = (AggregatedCalledFunction)child;
                        switch (CallGraphWithCallStackAnalysisTest.getCallSiteSymbol((AggregatedCallSite)func).resolve(Collections.emptySet())) {
                            case "op1": {
                                Assert.assertEquals((long)9L, (long)func.getDuration());
                                Assert.assertEquals((long)5L, (long)func.getSelfTime());
                                Assert.assertEquals((long)-1L, (long)func.getCpuTime());
                                Assert.assertEquals((long)1L, (long)func.getNbCalls());
                                Assert.assertEquals((long)1L, (long)func.getProcessId());
                                Assert.assertEquals((long)1L, (long)func.getCallees().size());
                                AggregatedCalledFunction next = (AggregatedCalledFunction)func.getCallees().iterator().next();
                                Assert.assertNotNull((Object)next);
                                Assert.assertEquals((long)4L, (long)next.getDuration());
                                Assert.assertEquals((long)3L, (long)next.getSelfTime());
                                Assert.assertEquals((long)-1L, (long)next.getCpuTime());
                                Assert.assertEquals((long)1L, (long)next.getNbCalls());
                                Assert.assertEquals((long)1L, (long)next.getProcessId());
                                Assert.assertEquals((Object)"op2", (Object)CallGraphWithCallStackAnalysisTest.getCallSiteSymbol((AggregatedCallSite)next).resolve(Collections.emptySet()));
                                Assert.assertEquals((long)1L, (long)next.getCallees().size());
                                AggregatedCalledFunction third = (AggregatedCalledFunction)next.getCallees().iterator().next();
                                Assert.assertNotNull((Object)third);
                                Assert.assertEquals((long)1L, (long)third.getDuration());
                                Assert.assertEquals((long)1L, (long)third.getSelfTime());
                                Assert.assertEquals((long)-1L, (long)third.getCpuTime());
                                Assert.assertEquals((long)1L, (long)third.getNbCalls());
                                Assert.assertEquals((long)1L, (long)third.getProcessId());
                                Assert.assertEquals((Object)"op3", (Object)CallGraphWithCallStackAnalysisTest.getCallSiteSymbol((AggregatedCallSite)third).resolve(Collections.emptySet()));
                                Assert.assertEquals((long)0L, (long)third.getCallees().size());
                                break;
                            }
                            default: {
                                Assert.fail((String)(UNKNOWN_SYMBOL + String.valueOf(CallGraphWithCallStackAnalysisTest.getCallSiteSymbol((AggregatedCallSite)func))));
                            }
                        }
                    }
                    continue block22;
                }
                case "3": {
                    Assert.assertEquals((long)1L, (long)children.size());
                    AggregatedCalledFunction func = (AggregatedCalledFunction)children.iterator().next();
                    Assert.assertEquals((Object)"op2", (Object)CallGraphWithCallStackAnalysisTest.getCallSiteSymbol((AggregatedCallSite)func).resolve(Collections.emptySet()));
                    Assert.assertEquals((long)7L, (long)func.getDuration());
                    Assert.assertEquals((long)3L, (long)func.getSelfTime());
                    Assert.assertEquals((long)-1L, (long)func.getCpuTime());
                    Assert.assertEquals((long)1L, (long)func.getNbCalls());
                    Assert.assertEquals((long)1L, (long)func.getProcessId());
                    Assert.assertEquals((long)2L, (long)func.getCallees().size());
                    for (AggregatedCallSite nextChild : func.getCallees()) {
                        Assert.assertTrue((boolean)(nextChild instanceof AggregatedCalledFunction));
                        AggregatedCalledFunction next = (AggregatedCalledFunction)nextChild;
                        switch (CallGraphWithCallStackAnalysisTest.getCallSiteSymbol((AggregatedCallSite)next).resolve(Collections.emptySet())) {
                            case "op3": {
                                Assert.assertEquals((long)1L, (long)next.getDuration());
                                Assert.assertEquals((long)1L, (long)next.getSelfTime());
                                Assert.assertEquals((long)-1L, (long)next.getCpuTime());
                                Assert.assertEquals((long)1L, (long)next.getNbCalls());
                                Assert.assertEquals((long)1L, (long)next.getProcessId());
                                Assert.assertEquals((long)0L, (long)next.getCallees().size());
                                break;
                            }
                            case "op2": {
                                Assert.assertEquals((long)3L, (long)next.getDuration());
                                Assert.assertEquals((long)3L, (long)next.getSelfTime());
                                Assert.assertEquals((long)-1L, (long)next.getCpuTime());
                                Assert.assertEquals((long)1L, (long)next.getNbCalls());
                                Assert.assertEquals((long)1L, (long)next.getProcessId());
                                Assert.assertEquals((long)0L, (long)next.getCallees().size());
                                break;
                            }
                            default: {
                                Assert.fail((String)(UNKNOWN_SYMBOL + String.valueOf(CallGraphWithCallStackAnalysisTest.getCallSiteSymbol((AggregatedCallSite)func))));
                            }
                        }
                    }
                    continue block22;
                }
                default: {
                    Assert.fail((String)(UNKNOWN_PROCESS + secondLevelName));
                }
            }
        }
    }

    private static void verifyProcess5Selection(CallGraph cg, ICallStackElement element) {
        Collection secondLevels = element.getChildrenElements();
        Assert.assertEquals((long)2L, (long)secondLevels.size());
        block16: for (ICallStackElement secondLevel : secondLevels) {
            Assert.assertTrue((boolean)(secondLevel instanceof InstrumentedCallStackElement));
            Assert.assertTrue((boolean)secondLevel.isLeaf());
            String secondLevelName = secondLevel.getName();
            Collection children = cg.getCallingContextTree(secondLevel);
            switch (secondLevelName) {
                case "6": {
                    Assert.assertEquals((long)1L, (long)children.size());
                    AggregatedCalledFunction func = (AggregatedCalledFunction)children.iterator().next();
                    Assert.assertNotNull((Object)func);
                    Assert.assertEquals((Object)"op1", (Object)CallGraphWithCallStackAnalysisTest.getCallSiteSymbol((AggregatedCallSite)func).resolve(Collections.emptySet()));
                    Assert.assertEquals((long)9L, (long)func.getDuration());
                    Assert.assertEquals((long)2L, (long)func.getSelfTime());
                    Assert.assertEquals((long)-1L, (long)func.getCpuTime());
                    Assert.assertEquals((long)1L, (long)func.getNbCalls());
                    Assert.assertEquals((long)5L, (long)func.getProcessId());
                    Assert.assertEquals((long)2L, (long)func.getCallees().size());
                    for (AggregatedCallSite nextChild : func.getCallees()) {
                        Assert.assertTrue((boolean)(nextChild instanceof AggregatedCalledFunction));
                        AggregatedCalledFunction next = (AggregatedCalledFunction)nextChild;
                        switch (CallGraphWithCallStackAnalysisTest.getCallSiteSymbol((AggregatedCallSite)next).resolve(Collections.emptySet())) {
                            case "op2": {
                                Assert.assertEquals((long)2L, (long)next.getDuration());
                                Assert.assertEquals((long)1L, (long)next.getSelfTime());
                                Assert.assertEquals((long)-1L, (long)next.getCpuTime());
                                Assert.assertEquals((long)1L, (long)next.getNbCalls());
                                Assert.assertEquals((long)5L, (long)next.getProcessId());
                                Assert.assertEquals((Object)"op2", (Object)CallGraphWithCallStackAnalysisTest.getCallSiteSymbol((AggregatedCallSite)next).resolve(Collections.emptySet()));
                                Assert.assertEquals((long)1L, (long)next.getCallees().size());
                                AggregatedCalledFunction third = (AggregatedCalledFunction)next.getCallees().iterator().next();
                                Assert.assertNotNull((Object)third);
                                Assert.assertEquals((long)1L, (long)third.getDuration());
                                Assert.assertEquals((long)1L, (long)third.getSelfTime());
                                Assert.assertEquals((long)-1L, (long)third.getCpuTime());
                                Assert.assertEquals((long)1L, (long)third.getNbCalls());
                                Assert.assertEquals((long)5L, (long)third.getProcessId());
                                Assert.assertEquals((Object)"op3", (Object)CallGraphWithCallStackAnalysisTest.getCallSiteSymbol((AggregatedCallSite)third).resolve(Collections.emptySet()));
                                Assert.assertEquals((long)0L, (long)third.getCallees().size());
                                break;
                            }
                            case "op3": {
                                Assert.assertEquals((long)5L, (long)next.getDuration());
                                Assert.assertEquals((long)3L, (long)next.getSelfTime());
                                Assert.assertEquals((long)-1L, (long)next.getCpuTime());
                                Assert.assertEquals((long)1L, (long)next.getNbCalls());
                                Assert.assertEquals((long)5L, (long)next.getProcessId());
                                Assert.assertEquals((Object)"op3", (Object)CallGraphWithCallStackAnalysisTest.getCallSiteSymbol((AggregatedCallSite)next).resolve(Collections.emptySet()));
                                Assert.assertEquals((long)1L, (long)next.getCallees().size());
                                AggregatedCalledFunction third = (AggregatedCalledFunction)next.getCallees().iterator().next();
                                Assert.assertNotNull((Object)third);
                                Assert.assertEquals((long)2L, (long)third.getDuration());
                                Assert.assertEquals((long)2L, (long)third.getSelfTime());
                                Assert.assertEquals((long)-1L, (long)third.getCpuTime());
                                Assert.assertEquals((long)1L, (long)third.getNbCalls());
                                Assert.assertEquals((long)5L, (long)third.getProcessId());
                                Assert.assertEquals((Object)"op1", (Object)CallGraphWithCallStackAnalysisTest.getCallSiteSymbol((AggregatedCallSite)third).resolve(Collections.emptySet()));
                                Assert.assertEquals((long)0L, (long)third.getCallees().size());
                                break;
                            }
                            default: {
                                Assert.fail((String)"Unknown symbol for second level of tid 6");
                            }
                        }
                    }
                    continue block16;
                }
                case "7": {
                    Assert.assertEquals((long)1L, (long)children.size());
                    AggregatedCalledFunction func = (AggregatedCalledFunction)children.iterator().next();
                    Assert.assertNotNull((Object)func);
                    Assert.assertEquals((Object)"op5", (Object)CallGraphWithCallStackAnalysisTest.getCallSiteSymbol((AggregatedCallSite)func).resolve(Collections.emptySet()));
                    Assert.assertEquals((long)9L, (long)func.getDuration());
                    Assert.assertEquals((long)4L, (long)func.getSelfTime());
                    Assert.assertEquals((long)-1L, (long)func.getCpuTime());
                    Assert.assertEquals((long)1L, (long)func.getNbCalls());
                    Assert.assertEquals((long)5L, (long)func.getProcessId());
                    Assert.assertEquals((long)1L, (long)func.getCallees().size());
                    Iterator iterator = func.getCallees().iterator();
                    AggregatedCalledFunction next = (AggregatedCalledFunction)iterator.next();
                    Assert.assertNotNull((Object)next);
                    Assert.assertEquals((long)5L, (long)next.getDuration());
                    Assert.assertEquals((long)5L, (long)next.getSelfTime());
                    Assert.assertEquals((long)-1L, (long)next.getCpuTime());
                    Assert.assertEquals((long)2L, (long)next.getNbCalls());
                    Assert.assertEquals((long)5L, (long)next.getProcessId());
                    Assert.assertEquals((Object)"op2", (Object)CallGraphWithCallStackAnalysisTest.getCallSiteSymbol((AggregatedCallSite)next).resolve(Collections.emptySet()));
                    Assert.assertEquals((long)0L, (long)next.getCallees().size());
                    break;
                }
                default: {
                    Assert.fail((String)(UNKNOWN_PROCESS + secondLevelName));
                }
            }
        }
    }
}

