/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.analysis.profiling.core.tests;

import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.analysis.profiling.core.tests.ActivatorTest;
import org.eclipse.tracecompass.analysis.profiling.core.tests.stubs2.CallStackAnalysisStub;
import org.eclipse.tracecompass.analysis.profiling.core.tests.stubs2.KernelAnalysisModuleStub;
import org.eclipse.tracecompass.internal.analysis.profiling.core.callgraph2.AggregatedCallSite;
import org.eclipse.tracecompass.internal.analysis.profiling.core.model.ModelManager;
import org.eclipse.tracecompass.internal.provisional.analysis.profiling.core.base.ICallStackSymbol;
import org.eclipse.tracecompass.tmf.core.event.TmfEvent;
import org.eclipse.tracecompass.tmf.core.exceptions.TmfTraceException;
import org.eclipse.tracecompass.tmf.core.signal.TmfTraceOpenedSignal;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceManager;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceUtils;
import org.eclipse.tracecompass.tmf.tests.stubs.trace.xml.TmfXmlTraceStubNs;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;

public class CallStackTestBase2 {
    private static final String CALLSTACK_FILE = "testfiles/traces/callstack2.xml";
    private ITmfTrace fTrace;
    private CallStackAnalysisStub fModule;
    private KernelAnalysisModuleStub fKernelModule;

    @Before
    public void setUp() {
        TmfXmlTraceStubNs trace = new TmfXmlTraceStubNs();
        IPath filePath = ActivatorTest.getAbsoluteFilePath(CALLSTACK_FILE);
        IStatus status = trace.validate(null, filePath.toOSString());
        if (!status.isOK()) {
            Assert.fail((String)status.getException().getMessage());
        }
        try {
            trace.initTrace(null, filePath.toOSString(), TmfEvent.class);
        }
        catch (TmfTraceException e) {
            Assert.fail((String)e.getMessage());
        }
        this.fTrace = trace;
        TmfTraceManager traceManager = TmfTraceManager.getInstance();
        traceManager.traceOpened(new TmfTraceOpenedSignal((Object)this, (ITmfTrace)trace, null));
        trace.traceOpened(new TmfTraceOpenedSignal((Object)this, (ITmfTrace)trace, null));
        KernelAnalysisModuleStub kernelModule = (KernelAnalysisModuleStub)TmfTraceUtils.getAnalysisModuleOfClass((ITmfTrace)trace, KernelAnalysisModuleStub.class, (String)"org.eclipse.tracecompass.analysis.profiling.core.tests.kernelanalysis.stub");
        Assert.assertNotNull((Object)((Object)kernelModule));
        kernelModule.schedule();
        Assert.assertTrue((boolean)kernelModule.waitForCompletion());
        this.fKernelModule = kernelModule;
        CallStackAnalysisStub module = (CallStackAnalysisStub)TmfTraceUtils.getAnalysisModuleOfClass((ITmfTrace)trace, CallStackAnalysisStub.class, (String)"org.eclipse.tracecompass.analysis.profiling.core.tests.stub");
        Assert.assertNotNull((Object)((Object)module));
        module.schedule();
        Assert.assertTrue((boolean)module.waitForCompletion());
        this.fModule = module;
    }

    @After
    public void tearDown() {
        CallStackAnalysisStub module;
        ITmfTrace trace = this.fTrace;
        if (trace != null) {
            trace.dispose();
        }
        if ((module = this.fModule) != null) {
            module.dispose();
        }
        ModelManager.disposeModels();
    }

    public CallStackAnalysisStub getModule() {
        return this.fModule;
    }

    public KernelAnalysisModuleStub getKernelModule() {
        return this.fKernelModule;
    }

    public @NonNull ITmfTrace getTrace() {
        ITmfTrace trace = this.fTrace;
        if (trace == null) {
            throw new IllegalArgumentException();
        }
        return trace;
    }

    public static ICallStackSymbol getCallSiteSymbol(AggregatedCallSite callsite) {
        Object object = callsite.getObject();
        if (object instanceof ICallStackSymbol) {
            return (ICallStackSymbol)object;
        }
        throw new IllegalArgumentException("The object is not of the right type");
    }
}

