/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.provisional.analysis.profiling.core.base;

import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.internal.analysis.profiling.core.callgraph2.AggregatedCallSite;
import org.eclipse.tracecompass.internal.provisional.analysis.profiling.core.base.ICallStackSymbol;
import org.eclipse.tracecompass.internal.provisional.analysis.profiling.core.base.IDataPalette;
import org.eclipse.tracecompass.internal.provisional.analysis.profiling.core.callgraph.ICalledFunction;
import org.eclipse.tracecompass.tmf.core.dataprovider.X11ColorUtils;
import org.eclipse.tracecompass.tmf.core.model.OutputElementStyle;
import org.eclipse.tracecompass.tmf.core.model.timegraph.TimeGraphState;
import org.eclipse.tracecompass.tmf.core.presentation.RGBAColor;
import org.eclipse.tracecompass.tmf.core.presentation.RotatingPaletteProvider;

public final class FlameDefaultPalette
implements IDataPalette {
    private static final int NUM_COLORS = 360;
    private static final String DEFAULT_STYLE = "0";
    private static final Map<String, OutputElementStyle> STYLES;
    private static final Map<String, OutputElementStyle> STYLE_MAP;
    private static @Nullable FlameDefaultPalette fInstance;

    static {
        STYLE_MAP = Collections.synchronizedMap(new HashMap());
        RotatingPaletteProvider palette = new RotatingPaletteProvider.Builder().setNbColors(360).build();
        int i = 0;
        ImmutableMap.Builder builder = new ImmutableMap.Builder();
        for (RGBAColor color : palette.get()) {
            builder.put((Object)String.valueOf(i), (Object)new OutputElementStyle(null, (Map)ImmutableMap.of((Object)"style-name", (Object)String.valueOf(i), (Object)"background-color", (Object)X11ColorUtils.toHexColor((int)color.getRed(), (int)color.getGreen(), (int)color.getBlue()), (Object)"opacity", (Object)Float.valueOf((float)color.getAlpha() / 255.0f))));
            ++i;
        }
        STYLES = builder.build();
        fInstance = null;
    }

    private FlameDefaultPalette() {
    }

    public static FlameDefaultPalette getInstance() {
        FlameDefaultPalette instance = fInstance;
        if (instance == null) {
            fInstance = instance = new FlameDefaultPalette();
        }
        return instance;
    }

    @Override
    public Map<String, OutputElementStyle> getStyles() {
        return STYLES;
    }

    @Override
    public OutputElementStyle getStyleFor(Object callsite) {
        if (callsite instanceof AggregatedCallSite) {
            ICallStackSymbol value = (ICallStackSymbol)((AggregatedCallSite)callsite).getObject();
            int hashCode = value.hashCode();
            return STYLE_MAP.computeIfAbsent(String.valueOf(Math.floorMod(hashCode, 360)), style -> new OutputElementStyle(style));
        }
        if (callsite instanceof ICalledFunction) {
            Object value = ((ICalledFunction)callsite).getSymbol();
            int hashCode = value.hashCode();
            return STYLE_MAP.computeIfAbsent(String.valueOf(Math.floorMod(hashCode, 360)), style -> new OutputElementStyle(style));
        }
        if (callsite instanceof TimeGraphState) {
            OutputElementStyle elStyle = ((TimeGraphState)callsite).getStyle();
            return elStyle == null ? STYLE_MAP.computeIfAbsent(DEFAULT_STYLE, style -> new OutputElementStyle(style)) : elStyle;
        }
        return STYLE_MAP.computeIfAbsent(DEFAULT_STYLE, style -> new OutputElementStyle(style));
    }
}

