/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.tmf.ui.editors;

import java.util.Arrays;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.tracecompass.internal.tmf.ui.Activator;

public final class TmfTableColumnUtils {
    private static final String ROOT_SECTION_NAME = "editor.eventstable.column";
    private static final String COLUMN_ORDER_SECTION_NAME = "order";
    private static final String COLUMN_WIDTH_SECTION_NAME = "width";
    private static final String COLUMN_RESIZABLE_SECTION_NAME = "resizable";

    private TmfTableColumnUtils() {
    }

    public static int[] loadColumnOrder(String traceTypeId) {
        return TmfTableColumnUtils.loadIntSection(traceTypeId, COLUMN_ORDER_SECTION_NAME);
    }

    public static int[] loadColumnWidth(String traceTypeId) {
        return TmfTableColumnUtils.loadIntSection(traceTypeId, COLUMN_WIDTH_SECTION_NAME);
    }

    public static boolean[] loadColumnResizable(String traceTypeId) {
        return TmfTableColumnUtils.loadBoolSection(traceTypeId, COLUMN_RESIZABLE_SECTION_NAME);
    }

    public static void saveColumnOrder(String traceTypeId, int[] columnOrder) {
        TmfTableColumnUtils.saveColumnElementInt(traceTypeId, COLUMN_ORDER_SECTION_NAME, columnOrder);
    }

    public static void saveColumnWidth(String traceTypeId, int[] columnWidth) {
        TmfTableColumnUtils.saveColumnElementInt(traceTypeId, COLUMN_WIDTH_SECTION_NAME, columnWidth);
    }

    public static void saveColumnResizability(String traceTypeId, boolean[] columnResizability) {
        TmfTableColumnUtils.saveColumnElementBoolean(traceTypeId, COLUMN_RESIZABLE_SECTION_NAME, columnResizability);
    }

    public static void clearColumnOrder(String traceTypeId) {
        TmfTableColumnUtils.clearColumnElement(traceTypeId, COLUMN_ORDER_SECTION_NAME);
    }

    public static void clearColumnWidth(String traceTypeId) {
        TmfTableColumnUtils.clearColumnElement(traceTypeId, COLUMN_WIDTH_SECTION_NAME);
    }

    public static void clearColumnResizable(String traceTypeId) {
        TmfTableColumnUtils.clearColumnElement(traceTypeId, COLUMN_RESIZABLE_SECTION_NAME);
    }

    private static boolean[] loadBoolSection(String traceTypeId, String sectionName) {
        String columnSection = TmfTableColumnUtils.loadSection(traceTypeId, sectionName);
        if (columnSection == null) {
            return null;
        }
        String[] array = columnSection.substring(1, columnSection.length() - 1).split(", ");
        boolean[] columnValue = new boolean[array.length];
        int i = 0;
        while (i < array.length) {
            columnValue[i] = Boolean.valueOf(array[i]);
            ++i;
        }
        return columnValue;
    }

    private static int[] loadIntSection(String traceTypeId, String sectionName) {
        String columnSection = TmfTableColumnUtils.loadSection(traceTypeId, sectionName);
        if (columnSection == null) {
            return null;
        }
        String[] array = columnSection.substring(1, columnSection.length() - 1).split(", ");
        int[] columnValue = new int[array.length];
        try {
            int i = 0;
            while (i < array.length) {
                columnValue[i] = Integer.valueOf(array[i]);
                ++i;
            }
            return columnValue;
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    private static void saveColumnElementBoolean(String traceTypeId, String sectionName, boolean[] data) {
        IDialogSettings columnSection;
        if (traceTypeId == null) {
            return;
        }
        if (data == null) {
            TmfTableColumnUtils.clearColumnElement(traceTypeId, sectionName);
            return;
        }
        IDialogSettings settings = Activator.getDefault().getDialogSettings();
        IDialogSettings section = settings.getSection(ROOT_SECTION_NAME);
        if (section == null) {
            section = settings.addNewSection(ROOT_SECTION_NAME);
        }
        if ((columnSection = section.getSection(sectionName)) == null) {
            columnSection = section.addNewSection(sectionName);
        }
        columnSection.put(traceTypeId, Arrays.toString(data));
    }

    private static void saveColumnElementInt(String traceTypeId, String sectionName, int[] data) {
        IDialogSettings columnSection;
        if (traceTypeId == null) {
            return;
        }
        if (data == null) {
            TmfTableColumnUtils.clearColumnElement(traceTypeId, sectionName);
            return;
        }
        IDialogSettings settings = Activator.getDefault().getDialogSettings();
        IDialogSettings section = settings.getSection(ROOT_SECTION_NAME);
        if (section == null) {
            section = settings.addNewSection(ROOT_SECTION_NAME);
        }
        if ((columnSection = section.getSection(sectionName)) == null) {
            columnSection = section.addNewSection(sectionName);
        }
        columnSection.put(traceTypeId, Arrays.toString(data));
    }

    private static void clearColumnElement(String traceTypeId, String sectionName) {
        if (traceTypeId == null) {
            return;
        }
        IDialogSettings settings = Activator.getDefault().getDialogSettings();
        IDialogSettings section = settings.getSection(ROOT_SECTION_NAME);
        if (section == null) {
            return;
        }
        IDialogSettings columnSection = section.getSection(sectionName);
        if (columnSection == null) {
            return;
        }
        columnSection.put(traceTypeId, null);
    }

    private static String loadSection(String traceTypeId, String sectionName) {
        if (traceTypeId == null) {
            return null;
        }
        IDialogSettings settings = Activator.getDefault().getDialogSettings();
        IDialogSettings section = settings.getSection(ROOT_SECTION_NAME);
        if (section == null) {
            return null;
        }
        IDialogSettings columnSection = section.getSection(sectionName);
        if (columnSection == null) {
            return null;
        }
        String string = columnSection.get(traceTypeId);
        if (string == null || string.length() < 3) {
            return null;
        }
        if (string.charAt(0) != '[' || string.charAt(string.length() - 1) != ']') {
            return null;
        }
        return string;
    }
}

