/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ui.swtbot.tests.viewers.events;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import org.apache.log4j.Appender;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Logger;
import org.apache.log4j.SimpleLayout;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swtbot.eclipse.finder.SWTWorkbenchBot;
import org.eclipse.swtbot.eclipse.finder.widgets.SWTBotEditor;
import org.eclipse.swtbot.swt.finder.finders.UIThreadRunnable;
import org.eclipse.swtbot.swt.finder.junit.SWTBotJunit4ClassRunner;
import org.eclipse.swtbot.swt.finder.results.ArrayResult;
import org.eclipse.swtbot.swt.finder.utils.SWTBotPreferences;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotTable;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotTableColumn;
import org.eclipse.tracecompass.tmf.core.tests.TmfCoreTestPlugin;
import org.eclipse.tracecompass.tmf.ui.swtbot.tests.shared.SWTBotUtils;
import org.eclipse.tracecompass.tmf.ui.tests.shared.WaitUtils;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.osgi.framework.Bundle;

@RunWith(value=SWTBotJunit4ClassRunner.class)
public class ColumnHeaderMenuTest {
    private static final String TRACE_PROJECT_NAME = "test";
    private static final String COLUMN_TRACE = "syslog_collapse";
    private static final String COLUMN_TRACE_PATH = "testfiles/syslog_collapse";
    private static final String COLUMN_TRACE_TYPE = "org.eclipse.linuxtools.tmf.tests.stubs.trace.text.testsyslog";
    private static File fTestFile = null;
    private static SWTWorkbenchBot fBot;
    private SWTBotEditor fEditorBot;
    private static final Logger fLogger;

    static {
        fLogger = Logger.getRootLogger();
    }

    @BeforeClass
    public static void beforeClass() {
        SWTBotUtils.initialize();
        URL location = FileLocator.find((Bundle)TmfCoreTestPlugin.getDefault().getBundle(), (IPath)new Path(COLUMN_TRACE_PATH), null);
        try {
            URI uri = FileLocator.toFileURL((URL)location).toURI();
            fTestFile = new File(uri);
        }
        catch (IOException | URISyntaxException e) {
            Assert.fail((String)e.getMessage());
        }
        Assume.assumeTrue((boolean)fTestFile.exists());
        SWTBotPreferences.TIMEOUT = 20000L;
        fLogger.removeAllAppenders();
        fLogger.addAppender((Appender)new ConsoleAppender((Layout)new SimpleLayout(), "System.out"));
        fBot = new SWTWorkbenchBot();
        WaitUtils.waitForJobs();
        SWTBotUtils.createProject(TRACE_PROJECT_NAME);
    }

    @AfterClass
    public static void afterClass() {
        SWTBotUtils.deleteProject(TRACE_PROJECT_NAME, fBot);
        fLogger.removeAllAppenders();
    }

    @Before
    public void before() {
        SWTBotUtils.openTrace(TRACE_PROJECT_NAME, fTestFile.getAbsolutePath(), COLUMN_TRACE_TYPE);
        this.fEditorBot = SWTBotUtils.activateEditor(fBot, fTestFile.getName());
    }

    @After
    public void after() {
        fBot.closeAllEditors();
        SWTBotUtils.closeSecondaryShells(fBot);
    }

    @Test
    public void testToggleColumns() {
        SWTBotTable tableBot = this.fEditorBot.bot().table();
        SWTBotTableColumn headerBot = tableBot.header("");
        ColumnHeaderMenuTest.assertVisibleColumns((Table)tableBot.widget, new String[]{"Timestamp", "Host", "Logger", "File", "Line", "Message"});
        headerBot.contextMenu("Message").click();
        ColumnHeaderMenuTest.assertVisibleColumns((Table)tableBot.widget, new String[]{"Timestamp", "Host", "Logger", "File", "Line"});
        headerBot.contextMenu("Line").click();
        ColumnHeaderMenuTest.assertVisibleColumns((Table)tableBot.widget, new String[]{"Timestamp", "Host", "Logger", "File"});
        headerBot.contextMenu("File").click();
        ColumnHeaderMenuTest.assertVisibleColumns((Table)tableBot.widget, new String[]{"Timestamp", "Host", "Logger"});
        headerBot.contextMenu("Logger").click();
        ColumnHeaderMenuTest.assertVisibleColumns((Table)tableBot.widget, new String[]{"Timestamp", "Host"});
        headerBot.contextMenu("Host").click();
        ColumnHeaderMenuTest.assertVisibleColumns((Table)tableBot.widget, new String[]{"Timestamp"});
        headerBot.contextMenu("Timestamp").click();
        ColumnHeaderMenuTest.assertVisibleColumns((Table)tableBot.widget, new String[0]);
        headerBot.contextMenu("Message").click();
        ColumnHeaderMenuTest.assertVisibleColumns((Table)tableBot.widget, new String[]{"Message"});
        headerBot.contextMenu("Timestamp").click();
        ColumnHeaderMenuTest.assertVisibleColumns((Table)tableBot.widget, new String[]{"Timestamp", "Message"});
        headerBot.contextMenu("Line").click();
        ColumnHeaderMenuTest.assertVisibleColumns((Table)tableBot.widget, new String[]{"Timestamp", "Line", "Message"});
        headerBot.contextMenu("Host").click();
        ColumnHeaderMenuTest.assertVisibleColumns((Table)tableBot.widget, new String[]{"Timestamp", "Host", "Line", "Message"});
        headerBot.contextMenu("File").click();
        ColumnHeaderMenuTest.assertVisibleColumns((Table)tableBot.widget, new String[]{"Timestamp", "Host", "File", "Line", "Message"});
        headerBot.contextMenu("Logger").click();
        ColumnHeaderMenuTest.assertVisibleColumns((Table)tableBot.widget, new String[]{"Timestamp", "Host", "Logger", "File", "Line", "Message"});
    }

    @Test
    public void testPersistHiding() {
        SWTBotTable tableBot = this.fEditorBot.bot().table();
        SWTBotTableColumn headerBot = tableBot.header("");
        ColumnHeaderMenuTest.assertVisibleColumns((Table)tableBot.widget, new String[]{"Timestamp", "Host", "Logger", "File", "Line", "Message"});
        headerBot.contextMenu("Timestamp").click();
        headerBot.contextMenu("Host").click();
        headerBot.contextMenu("Logger").click();
        headerBot.contextMenu("File").click();
        headerBot.contextMenu("Message").click();
        ColumnHeaderMenuTest.assertVisibleColumns((Table)tableBot.widget, new String[]{"Line"});
        this.after();
        this.before();
        tableBot = this.fEditorBot.bot().table();
        ColumnHeaderMenuTest.assertVisibleColumns((Table)tableBot.widget, new String[]{"Line"});
        headerBot = tableBot.header("");
        headerBot.contextMenu("Show All").click();
        ColumnHeaderMenuTest.assertVisibleColumns((Table)tableBot.widget, new String[]{"Timestamp", "Host", "Logger", "File", "Line", "Message"});
    }

    @Test
    public void testShowAll() {
        SWTBotTable tableBot = this.fEditorBot.bot().table();
        SWTBotTableColumn headerBot = tableBot.header("");
        ColumnHeaderMenuTest.assertVisibleColumns((Table)tableBot.widget, new String[]{"Timestamp", "Host", "Logger", "File", "Line", "Message"});
        headerBot.contextMenu("Timestamp").click();
        headerBot.contextMenu("Host").click();
        headerBot.contextMenu("Logger").click();
        headerBot.contextMenu("File").click();
        headerBot.contextMenu("Line").click();
        headerBot.contextMenu("Message").click();
        ColumnHeaderMenuTest.assertVisibleColumns((Table)tableBot.widget, new String[0]);
        headerBot.contextMenu("Show All").click();
        ColumnHeaderMenuTest.assertVisibleColumns((Table)tableBot.widget, new String[]{"Timestamp", "Host", "Logger", "File", "Line", "Message"});
    }

    private static void assertVisibleColumns(final Table table, String[] expected) {
        Object[] actual = (String[])UIThreadRunnable.syncExec((ArrayResult)new ArrayResult<String>(){

            public String[] run() {
                ArrayList<String> visible = new ArrayList<String>();
                int[] nArray = table.getColumnOrder();
                int n = nArray.length;
                int n2 = 0;
                while (n2 < n) {
                    int i = nArray[n2];
                    TableColumn column = table.getColumns()[i];
                    if (column.getResizable() && column.getWidth() > 0) {
                        visible.add(column.getText());
                    }
                    ++n2;
                }
                return visible.toArray(new String[0]);
            }
        });
        Assert.assertArrayEquals((Object[])expected, (Object[])actual);
    }
}

