/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.preference;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Function;
import org.eclipse.jface.preference.IPreferenceStore;

public class PreferenceMemento {
    private final Map<IPreferenceStore, Map<String, Object>> savedPreferences = new HashMap<IPreferenceStore, Map<String, Object>>();

    public synchronized <T> void setValue(IPreferenceStore store, String name, T value) {
        Objects.requireNonNull(store);
        if (value instanceof Double) {
            this.setValueInternal(store, name, (Double)value, store::getDouble, store::setValue);
        } else if (value instanceof Float) {
            this.setValueInternal(store, name, (Float)value, store::getFloat, store::setValue);
        } else if (value instanceof Integer) {
            this.setValueInternal(store, name, (Integer)value, store::getInt, store::setValue);
        } else if (value instanceof Long) {
            this.setValueInternal(store, name, (Long)value, store::getLong, store::setValue);
        } else if (value instanceof Boolean) {
            this.setValueInternal(store, name, (Boolean)value, store::getBoolean, store::setValue);
        } else {
            if (!(value instanceof String)) {
                if (value != null) {
                    throw new IllegalArgumentException("Unsupported value type " + value.getClass());
                }
            }
            this.setValueInternal(store, name, (String)value, store::getString, store::setValue);
        }
    }

    public synchronized void resetPreferences() {
        for (Map.Entry<IPreferenceStore, Map<String, Object>> backupedStore : this.savedPreferences.entrySet()) {
            IPreferenceStore store = backupedStore.getKey();
            for (Map.Entry<String, Object> preference : backupedStore.getValue().entrySet()) {
                String preferenceName = preference.getKey();
                Object preferenceValue = preference.getValue();
                if (preferenceValue instanceof Double) {
                    store.setValue(preferenceName, (Double)preferenceValue);
                    continue;
                }
                if (preferenceValue instanceof Float) {
                    store.setValue(preferenceName, ((Float)preferenceValue).floatValue());
                    continue;
                }
                if (preferenceValue instanceof Integer) {
                    store.setValue(preferenceName, (Integer)preferenceValue);
                    continue;
                }
                if (preferenceValue instanceof Long) {
                    store.setValue(preferenceName, (Long)preferenceValue);
                    continue;
                }
                if (preferenceValue instanceof Boolean) {
                    store.setValue(preferenceName, (Boolean)preferenceValue);
                    continue;
                }
                if (preferenceValue instanceof String || preferenceValue == null) {
                    store.setValue(preferenceName, (String)preferenceValue);
                    continue;
                }
                throw new RuntimeException("PreferenceUtil got an unsupported value of type " + preferenceValue.getClass());
            }
        }
        this.savedPreferences.clear();
    }

    private <T> void setValueInternal(IPreferenceStore store, String name, T value, Function<String, T> prefGetter, BiConsumer<String, T> prefSetter) {
        Map knownValues = this.savedPreferences.computeIfAbsent(store, key -> new HashMap());
        if (!knownValues.containsKey(name)) {
            knownValues.put(name, prefGetter.apply(name));
        }
        prefSetter.accept(name, (String)value);
    }
}

