/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.model;

import java.util.List;
import java.util.Objects;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.model.DataDrivenAction;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.model.DataDrivenCondition;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.model.IDataDrivenRuntimeObject;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.model.runtime.DataDrivenScenarioInfo;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.module.IAnalysisDataContainer;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;

public class DataDrivenFsmStateTransition
implements IDataDrivenRuntimeObject {
    private final DataDrivenCondition fEvents;
    private final String fTarget;
    private final DataDrivenCondition fCondition;
    private final List<DataDrivenAction> fActions;

    public DataDrivenFsmStateTransition(DataDrivenCondition eventCondition, DataDrivenCondition dataDrivenCondition, String target, List<DataDrivenAction> actions) {
        this.fEvents = eventCondition;
        this.fCondition = dataDrivenCondition;
        this.fTarget = target;
        this.fActions = actions;
    }

    public boolean canTake(ITmfEvent event, DataDrivenScenarioInfo scenarioInfo, IAnalysisDataContainer container) {
        return this.fEvents.test(event, scenarioInfo, container) && this.fCondition.test(event, scenarioInfo, container);
    }

    public String take(ITmfEvent event, DataDrivenScenarioInfo scenarioInfo, IAnalysisDataContainer container) {
        for (DataDrivenAction action : this.fActions) {
            action.eventHandle(event, scenarioInfo, container);
        }
        return this.fTarget;
    }

    public int hashCode() {
        return Objects.hash(this.fEvents, this.fTarget, this.fCondition, this.fActions);
    }

    public boolean equals(@Nullable Object obj) {
        if (!(obj instanceof DataDrivenFsmStateTransition)) {
            return false;
        }
        DataDrivenFsmStateTransition other = (DataDrivenFsmStateTransition)obj;
        return Objects.equals(this.fEvents, other.fEvents) && Objects.equals(this.fTarget, other.fTarget) && Objects.equals(this.fCondition, other.fCondition) && Objects.equals(this.fActions, other.fActions);
    }

    public String toString() {
        return "--> " + this.fTarget + ':' + this.fEvents + ' ' + this.fCondition + ' ' + this.fActions;
    }
}

