/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ui.viewers.tree;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IElementComparer;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ITableColorProvider;
import org.eclipse.jface.viewers.ITableFontProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.tracecompass.common.core.log.TraceCompassLog;
import org.eclipse.tracecompass.common.core.log.TraceCompassLogUtils;
import org.eclipse.tracecompass.internal.tmf.ui.viewers.tree.TreeUtil;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignalHandler;
import org.eclipse.tracecompass.tmf.core.signal.TmfTraceClosedSignal;
import org.eclipse.tracecompass.tmf.core.signal.TmfWindowRangeUpdatedSignal;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.ui.viewers.TmfTimeViewer;
import org.eclipse.tracecompass.tmf.ui.viewers.tree.ITmfTreeColumnDataProvider;
import org.eclipse.tracecompass.tmf.ui.viewers.tree.ITmfTreeViewerEntry;
import org.eclipse.tracecompass.tmf.ui.viewers.tree.TmfGenericTreeEntry;
import org.eclipse.tracecompass.tmf.ui.viewers.tree.TmfTreeColumnData;
import org.eclipse.tracecompass.tmf.ui.viewers.tree.TmfTreeViewerEntry;

public abstract class AbstractTmfTreeViewer
extends TmfTimeViewer {
    private static final @NonNull Logger LOGGER = TraceCompassLog.getLogger(AbstractTmfTreeViewer.class);
    private final TreeViewer fTreeViewer;
    private final Map<ITmfTrace, TmfTreeViewerEntry> fRoots = Collections.synchronizedMap(new HashMap());

    public AbstractTmfTreeViewer(Composite parent, boolean allowMultiSelect) {
        this(parent, new TreeViewer(parent, 0x10100 | (allowMultiSelect ? 2 : 0)));
    }

    public AbstractTmfTreeViewer(Composite parent, TreeViewer treeViewer) {
        super(parent);
        this.fTreeViewer = treeViewer;
        Tree tree = this.fTreeViewer.getTree();
        tree.setHeaderVisible(true);
        tree.setLinesVisible(true);
        this.fTreeViewer.setContentProvider((IContentProvider)new TreeContentProvider());
        this.fTreeViewer.setLabelProvider((IBaseLabelProvider)new TreeLabelProvider());
        this.fTreeViewer.setComparer((IElementComparer)new ElementComparer());
        List<TmfTreeColumnData> columns = this.getColumnDataProvider().getColumnData();
        this.setTreeColumns(columns);
    }

    protected abstract ITmfTreeColumnDataProvider getColumnDataProvider();

    public void setTreeColumns(List<TmfTreeColumnData> columns) {
        boolean hasPercentProvider = false;
        for (TmfTreeColumnData columnData : columns) {
            columnData.createColumn(this.fTreeViewer);
            hasPercentProvider |= columnData.getPercentageProvider() != null;
        }
        if (hasPercentProvider) {
            this.fTreeViewer.getTree().addListener(40, event -> {
                if (((TmfTreeColumnData)columns.get(event.index)).getPercentageProvider() != null) {
                    double percentage = ((TmfTreeColumnData)columns.get(event.index)).getPercentageProvider().getPercentage(event.item.getData());
                    if (percentage == 0.0) {
                        return;
                    }
                    if ((event.detail & 2) > 0) {
                        event.gc.fillRectangle(event.x, event.y, event.width, event.height);
                        event.detail &= 0xFFFFFFFD;
                    }
                    int barWidth = (int)((double)(this.fTreeViewer.getTree().getColumn(event.index).getWidth() - 8) * percentage);
                    int oldAlpha = event.gc.getAlpha();
                    Color oldForeground = event.gc.getForeground();
                    Color oldBackground = event.gc.getBackground();
                    event.gc.setAlpha(64);
                    event.gc.setForeground(event.item.getDisplay().getSystemColor(9));
                    event.gc.setBackground(event.item.getDisplay().getSystemColor(25));
                    event.gc.fillGradientRectangle(event.x, event.y, barWidth, event.height, true);
                    event.gc.drawRectangle(event.x, event.y, barWidth, event.height);
                    event.gc.setForeground(oldForeground);
                    event.gc.setBackground(oldBackground);
                    event.gc.setAlpha(oldAlpha);
                    event.detail &= 0xFFFFFFF7;
                }
            });
        }
    }

    protected void setLabelProvider(IBaseLabelProvider labelProvider) {
        this.fTreeViewer.setLabelProvider(labelProvider);
    }

    public TreeViewer getTreeViewer() {
        return this.fTreeViewer;
    }

    @Override
    public Control getControl() {
        return this.fTreeViewer.getControl();
    }

    @Override
    public void refresh() {
        Throwable throwable = null;
        Object var2_3 = null;
        try (TraceCompassLogUtils.ScopeLog refreshTree = new TraceCompassLogUtils.ScopeLog(LOGGER, Level.FINE, String.valueOf(this.getClass().getCanonicalName()) + "#refresh()", new Object[0]);){
            Tree tree = this.fTreeViewer.getTree();
            tree.setRedraw(false);
            this.fTreeViewer.refresh();
            tree.setRedraw(true);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public void loadTrace(final ITmfTrace trace) {
        super.loadTrace(trace);
        this.fRoots.computeIfAbsent(trace, t -> new TmfTreeViewerEntry(t.getName()));
        if (trace == null) {
            return;
        }
        Thread thread = new Thread(){

            @Override
            public void run() {
                AbstractTmfTreeViewer.this.initializeDataSource(trace);
                Display.getDefault().asyncExec(() -> {
                    if (!trace.equals(AbstractTmfTreeViewer.this.getTrace())) {
                        return;
                    }
                    AbstractTmfTreeViewer.this.clearContent();
                    AbstractTmfTreeViewer.this.updateContent(AbstractTmfTreeViewer.this.getWindowStartTime(), AbstractTmfTreeViewer.this.getWindowEndTime(), false);
                });
            }
        };
        thread.start();
    }

    public @Nullable TmfTreeViewerEntry getRoot(ITmfTrace trace) {
        return this.fRoots.get(trace);
    }

    public void setSelection(@NonNull List<ITmfTreeViewerEntry> selection) {
        StructuredSelection sel = new StructuredSelection(selection);
        this.fTreeViewer.setSelection((ISelection)sel, true);
    }

    public void addSelectionChangeListener(ISelectionChangedListener listener) {
        this.fTreeViewer.addSelectionChangedListener(listener);
    }

    protected void initializeDataSource(@NonNull ITmfTrace trace) {
    }

    protected void clearContent() {
        this.fTreeViewer.setInput(null);
    }

    protected void contentChanged(ITmfTreeViewerEntry rootEntry) {
    }

    protected void updateContent(final long start, final long end, final boolean isSelection) {
        final ITmfTrace trace = this.getTrace();
        if (trace == null) {
            return;
        }
        Job thread = new Job(""){

            public IStatus run(IProgressMonitor monitor) {
                ITmfTreeViewerEntry newRootEntry = AbstractTmfTreeViewer.this.updateElements(trace, start, end, isSelection);
                if (newRootEntry != null) {
                    Display.getDefault().asyncExec(() -> {
                        if (AbstractTmfTreeViewer.this.fTreeViewer.getControl().isDisposed()) {
                            return;
                        }
                        Object currentRootEntry = AbstractTmfTreeViewer.this.fTreeViewer.getInput();
                        AbstractTmfTreeViewer.this.updateTreeUI(AbstractTmfTreeViewer.this.fTreeViewer, newRootEntry);
                        if (newRootEntry != currentRootEntry) {
                            TreeColumn[] treeColumnArray = AbstractTmfTreeViewer.this.fTreeViewer.getTree().getColumns();
                            int n = treeColumnArray.length;
                            int n2 = 0;
                            while (n2 < n) {
                                TreeColumn column = treeColumnArray[n2];
                                column.pack();
                                ++n2;
                            }
                        }
                    });
                }
                return Status.OK_STATUS;
            }
        };
        thread.setSystem(true);
        thread.schedule();
    }

    protected final void updateTreeUI(TreeViewer treeViewer, @NonNull ITmfTreeViewerEntry newInput) {
        Throwable throwable = null;
        Object var4_5 = null;
        try (TraceCompassLogUtils.ScopeLog updateTreeUi = new TraceCompassLogUtils.ScopeLog(LOGGER, Level.FINE, String.valueOf(this.getClass().getSimpleName()) + "#updateTreeUI", new Object[0]);){
            TraceCompassLogUtils.ScopeLog updatePaths;
            Object element232;
            Object expandedElements;
            HashSet<String> expandedPaths = new HashSet<String>();
            Object input = this.fTreeViewer.getInput();
            ISelection selection = null;
            Throwable throwable2 = null;
            Object var10_14 = null;
            try (TraceCompassLogUtils.ScopeLog selection1 = new TraceCompassLogUtils.ScopeLog(LOGGER, Level.FINE, String.valueOf(this.getClass().getSimpleName()) + "#getSelection", new Object[0]);){
                selection = TreeUtil.getNewSelection(this.fTreeViewer.getSelection(), newInput);
            }
            catch (Throwable throwable3) {
                if (throwable2 == null) {
                    throwable2 = throwable3;
                } else if (throwable2 != throwable3) {
                    throwable2.addSuppressed(throwable3);
                }
                throw throwable2;
            }
            throwable2 = null;
            var10_14 = null;
            try (TraceCompassLogUtils.ScopeLog updatePaths2 = new TraceCompassLogUtils.ScopeLog(LOGGER, Level.FINE, String.valueOf(this.getClass().getSimpleName()) + "#updatePaths", new Object[0]);){
                Object object = expandedElements = this.fTreeViewer.getExpandedElements();
                int n = ((Object[])expandedElements).length;
                int n2 = 0;
                while (n2 < n) {
                    element232 = object[n2];
                    if (element232 instanceof ITmfTreeViewerEntry) {
                        expandedPaths.add(TreeUtil.getPath((ITmfTreeViewerEntry)element232).toString());
                    }
                    ++n2;
                }
            }
            catch (Throwable throwable4) {
                if (throwable2 == null) {
                    throwable2 = throwable4;
                } else if (throwable2 != throwable4) {
                    throwable2.addSuppressed(throwable4);
                }
                throw throwable2;
            }
            HashSet<@NonNull ITmfTreeViewerEntry> allLeafEntries = new HashSet<ITmfTreeViewerEntry>();
            HashSet<String> allPaths = new HashSet<String>();
            Set allChildren = Collections.emptySet();
            expandedElements = null;
            element232 = null;
            try (TraceCompassLogUtils.ScopeLog updatePaths3 = new TraceCompassLogUtils.ScopeLog(LOGGER, Level.FINE, String.valueOf(this.getClass().getSimpleName()) + "#fillAllLeaves", new Object[0]);){
                if (input instanceof ITmfTreeViewerEntry) {
                    TreeUtil.addIf(allLeafEntries, (ITmfTreeViewerEntry)input, entry -> !entry.hasChildren());
                    for (ITmfTreeViewerEntry iTmfTreeViewerEntry : ((ITmfTreeViewerEntry)input).getChildren()) {
                        TreeUtil.add(allPaths, iTmfTreeViewerEntry);
                    }
                }
                allChildren = allLeafEntries.stream().map(entry -> TreeUtil.getPath(entry)).map(Object::toString).collect(Collectors.toSet());
            }
            catch (Throwable element232) {
                if (expandedElements == null) {
                    expandedElements = element232;
                } else if (expandedElements != element232) {
                    ((Throwable)expandedElements).addSuppressed(element232);
                }
                throw expandedElements;
            }
            Set allLeaves = allChildren;
            HashSet<@NonNull ITmfTreeViewerEntry> newExpanded = new HashSet<ITmfTreeViewerEntry>();
            Throwable throwable3 = null;
            Object var15_23 = null;
            try {
                updatePaths = new TraceCompassLogUtils.ScopeLog(LOGGER, Level.FINE, String.valueOf(this.getClass().getSimpleName()) + "#addAllNonCollapsed", new Object[0]);
                try {
                    TreeUtil.addIf(newExpanded, newInput, entry -> {
                        String key = TreeUtil.getPath(entry).toString();
                        return expandedPaths.contains(key) || !allPaths.contains(key) || allLeaves.contains(key);
                    });
                }
                finally {
                    if (updatePaths != null) {
                        updatePaths.close();
                    }
                }
            }
            catch (Throwable throwable6) {
                if (throwable3 == null) {
                    throwable3 = throwable6;
                } else if (throwable3 != throwable6) {
                    throwable3.addSuppressed(throwable6);
                }
                throw throwable3;
            }
            throwable3 = null;
            Object throwable7 = null;
            try {
                updatePaths = new TraceCompassLogUtils.ScopeLog(LOGGER, Level.FINE, String.valueOf(this.getClass().getSimpleName()) + "#updateInput", new Object[0]);
                try {
                    if (newInput != input) {
                        this.fTreeViewer.setInput((Object)newInput);
                    } else {
                        this.fTreeViewer.refresh();
                    }
                }
                finally {
                    if (updatePaths != null) {
                        updatePaths.close();
                    }
                }
            }
            catch (Throwable throwable8) {
                if (throwable3 == null) {
                    throwable3 = throwable8;
                } else if (throwable3 != throwable8) {
                    throwable3.addSuppressed(throwable8);
                }
                throw throwable3;
            }
            throwable3 = null;
            Object throwable9 = null;
            try {
                updatePaths = new TraceCompassLogUtils.ScopeLog(LOGGER, Level.FINE, String.valueOf(this.getClass().getSimpleName()) + "#contentChanged", new Object[0]);
                try {
                    this.contentChanged(newInput);
                }
                finally {
                    if (updatePaths != null) {
                        updatePaths.close();
                    }
                }
            }
            catch (Throwable throwable10) {
                if (throwable3 == null) {
                    throwable3 = throwable10;
                } else if (throwable3 != throwable10) {
                    throwable3.addSuppressed(throwable10);
                }
                throw throwable3;
            }
            throwable3 = null;
            Object var15_29 = null;
            try {
                updatePaths = new TraceCompassLogUtils.ScopeLog(LOGGER, Level.FINE, String.valueOf(this.getClass().getSimpleName()) + "#resetSelection", new Object[0]);
                try {
                    if (!selection.isEmpty()) {
                        this.fTreeViewer.setSelection(selection, true);
                    }
                }
                finally {
                    if (updatePaths != null) {
                        updatePaths.close();
                    }
                }
            }
            catch (Throwable throwable4) {
                if (throwable3 == null) {
                    throwable3 = throwable4;
                } else if (throwable3 != throwable4) {
                    throwable3.addSuppressed(throwable4);
                }
                throw throwable3;
            }
            throwable3 = null;
            Object var15_31 = null;
            try {
                updatePaths = new TraceCompassLogUtils.ScopeLog(LOGGER, Level.FINE, String.valueOf(this.getClass().getSimpleName()) + "#expand", new Object[0]);
                try {
                    this.fTreeViewer.setExpandedElements(newExpanded.toArray());
                }
                finally {
                    if (updatePaths != null) {
                        updatePaths.close();
                    }
                }
            }
            catch (Throwable throwable5) {
                if (throwable3 == null) {
                    throwable3 = throwable5;
                } else if (throwable3 != throwable5) {
                    throwable3.addSuppressed(throwable5);
                }
                throw throwable3;
            }
        }
        catch (Throwable throwable11) {
            if (throwable == null) {
                throwable = throwable11;
            } else if (throwable != throwable11) {
                throwable.addSuppressed(throwable11);
            }
            throw throwable;
        }
    }

    protected abstract ITmfTreeViewerEntry updateElements(@NonNull ITmfTrace var1, long var2, long var4, boolean var6);

    protected ITmfTreeViewerEntry getInput() {
        return (ITmfTreeViewerEntry)this.fTreeViewer.getInput();
    }

    public void setAutoExpandLevel(int level) {
        if (this.fTreeViewer != null) {
            this.fTreeViewer.setAutoExpandLevel(level);
        }
    }

    @Override
    @TmfSignalHandler
    public void windowRangeUpdated(TmfWindowRangeUpdatedSignal signal) {
        super.windowRangeUpdated(signal);
        this.updateContent(this.getWindowStartTime(), this.getWindowEndTime(), false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @TmfSignalHandler
    public void traceClosed(@Nullable TmfTraceClosedSignal signal) {
        if (signal != null) {
            Map<ITmfTrace, TmfTreeViewerEntry> map = this.fRoots;
            synchronized (map) {
                this.fRoots.remove(signal.getTrace());
            }
        }
        super.traceClosed(signal);
    }

    @Override
    public void reset() {
        super.reset();
        this.clearContent();
    }

    protected static class ElementComparer
    implements IElementComparer {
        protected ElementComparer() {
        }

        public boolean equals(@Nullable Object a, @Nullable Object b) {
            if (a instanceof TmfGenericTreeEntry && b instanceof TmfGenericTreeEntry) {
                Object aModel = ((TmfGenericTreeEntry)a).getModel();
                Object bModel = ((TmfGenericTreeEntry)b).getModel();
                if (aModel != null && bModel != null) {
                    return aModel.getId() == bModel.getId();
                }
            }
            return Objects.equals(a, b);
        }

        public int hashCode(@Nullable Object element) {
            Object model;
            if (element instanceof TmfGenericTreeEntry && (model = ((TmfGenericTreeEntry)element).getModel()) != null) {
                return Long.hashCode(model.getId());
            }
            return Objects.hashCode(element);
        }
    }

    private class TreeContentProvider
    implements ITreeContentProvider {
        private TreeContentProvider() {
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof ITmfTreeViewerEntry) {
                return ((ITmfTreeViewerEntry)inputElement).getChildren().toArray(new ITmfTreeViewerEntry[0]);
            }
            return new ITmfTreeViewerEntry[0];
        }

        public Object[] getChildren(Object parentElement) {
            ITmfTreeViewerEntry entry = (ITmfTreeViewerEntry)parentElement;
            List<? extends ITmfTreeViewerEntry> children = entry.getChildren();
            return children.toArray(new ITmfTreeViewerEntry[children.size()]);
        }

        public Object getParent(Object element) {
            ITmfTreeViewerEntry entry = (ITmfTreeViewerEntry)element;
            return entry.getParent();
        }

        public boolean hasChildren(Object element) {
            ITmfTreeViewerEntry entry = (ITmfTreeViewerEntry)element;
            return entry.hasChildren();
        }
    }

    protected static class TreeLabelProvider
    implements ITableLabelProvider,
    ITableFontProvider,
    ITableColorProvider {
        protected TreeLabelProvider() {
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (element instanceof ITmfTreeViewerEntry && columnIndex == 0) {
                ITmfTreeViewerEntry entry = (ITmfTreeViewerEntry)element;
                return entry.getName();
            }
            return new String();
        }

        public Color getForeground(Object element, int columnIndex) {
            return null;
        }

        public Color getBackground(Object element, int columnIndex) {
            return null;
        }

        public Font getFont(Object element, int columnIndex) {
            return null;
        }
    }
}

