/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.lttng2.kernel.core.tests.event.matchandsync;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.LinkedList;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.internal.lttng2.kernel.core.event.matching.TcpEventMatching;
import org.eclipse.tracecompass.internal.lttng2.kernel.core.event.matching.TcpLttngEventMatching;
import org.eclipse.tracecompass.testtraces.ctf.CtfTestTrace;
import org.eclipse.tracecompass.tmf.core.event.matching.IMatchProcessingUnit;
import org.eclipse.tracecompass.tmf.core.event.matching.ITmfMatchEventDefinition;
import org.eclipse.tracecompass.tmf.core.event.matching.TmfEventMatching;
import org.eclipse.tracecompass.tmf.ctf.core.tests.shared.CtfTmfTestTraceUtils;
import org.eclipse.tracecompass.tmf.ctf.core.trace.CtfTmfTrace;
import org.junit.Assert;
import org.junit.Test;

public class MatchAndSyncTest {
    @Test
    public void testMatching() {
        CtfTmfTrace trace1 = CtfTmfTestTraceUtils.getTrace((CtfTestTrace)CtfTestTrace.SYNC_SRC);
        CtfTmfTrace trace2 = CtfTmfTestTraceUtils.getTrace((CtfTestTrace)CtfTestTrace.SYNC_DEST);
        LinkedList<@NonNull CtfTmfTrace> tracearr = new LinkedList<CtfTmfTrace>();
        tracearr.add(trace1);
        tracearr.add(trace2);
        TmfEventMatching.registerMatchObject((ITmfMatchEventDefinition)new TcpEventMatching());
        TmfEventMatching.registerMatchObject((ITmfMatchEventDefinition)new TcpLttngEventMatching());
        TmfEventMatching twoTraceMatch = new TmfEventMatching(tracearr);
        Assert.assertTrue((boolean)twoTraceMatch.matchEvents());
        try {
            try {
                Method method = TmfEventMatching.class.getDeclaredMethod("getProcessingUnit", new Class[0]);
                method.setAccessible(true);
                IMatchProcessingUnit procUnit = (IMatchProcessingUnit)method.invoke((Object)twoTraceMatch, new Object[0]);
                Assert.assertEquals((long)46L, (long)procUnit.countMatches());
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                Assert.fail((String)e.getMessage());
                trace1.dispose();
                trace2.dispose();
            }
        }
        finally {
            trace1.dispose();
            trace2.dispose();
        }
    }
}

