/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.analysis.xml.core.tests.module;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.compile.AnalysisCompilationData;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.compile.TmfXmlOutputEntryCu;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.compile.TmfXmlTimeGraphViewCu;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.module.XmlAnalysisModuleSource;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.module.XmlUtils;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.output.DataDrivenOutputEntry;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.output.DataDrivenPresentationState;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.output.DataDrivenTimeGraphProviderFactory;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.output.XmlDataProviderManager;
import org.eclipse.tracecompass.internal.tmf.core.model.filters.FetchParametersUtils;
import org.eclipse.tracecompass.tmf.analysis.xml.core.module.TmfXmlUtils;
import org.eclipse.tracecompass.tmf.analysis.xml.core.tests.common.TmfXmlTestFiles;
import org.eclipse.tracecompass.tmf.analysis.xml.core.tests.module.XmlUtilsTest;
import org.eclipse.tracecompass.tmf.core.analysis.IAnalysisModule;
import org.eclipse.tracecompass.tmf.core.model.filters.SelectionTimeQueryFilter;
import org.eclipse.tracecompass.tmf.core.model.filters.TimeQueryFilter;
import org.eclipse.tracecompass.tmf.core.model.timegraph.ITimeGraphDataProvider;
import org.eclipse.tracecompass.tmf.core.model.timegraph.ITimeGraphRowModel;
import org.eclipse.tracecompass.tmf.core.model.timegraph.ITimeGraphState;
import org.eclipse.tracecompass.tmf.core.model.timegraph.TimeGraphEntryModel;
import org.eclipse.tracecompass.tmf.core.model.timegraph.TimeGraphModel;
import org.eclipse.tracecompass.tmf.core.model.tree.TmfTreeDataModel;
import org.eclipse.tracecompass.tmf.core.model.tree.TmfTreeModel;
import org.eclipse.tracecompass.tmf.core.response.ITmfResponse;
import org.eclipse.tracecompass.tmf.core.response.TmfModelResponse;
import org.eclipse.tracecompass.tmf.core.signal.TmfTraceClosedSignal;
import org.eclipse.tracecompass.tmf.core.signal.TmfTraceOpenedSignal;
import org.eclipse.tracecompass.tmf.core.statesystem.ITmfAnalysisModuleWithStateSystems;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceManager;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.w3c.dom.Element;

public class XmlTimeGraphDataProviderTest {
    private static final @NonNull String TEST_TRACE = "test_traces/testTrace4.xml";
    private static final @NonNull String ANALYSIS_ID = "xml.core.tests.simple.pattern";
    private static final @NonNull String TIME_GRAPH_VIEW_ID = "xml.core.tests.simple.pattern.timegraph";
    private static final @NonNull String TIME_GRAPH_VIEW_ID2 = "xml.core.tests.simple.pattern.timegraph2";
    private static final @NonNull IProgressMonitor MONITOR = new NullProgressMonitor();

    @Before
    public void setUp() {
        XmlUtils.addXmlFile((File)TmfXmlTestFiles.VALID_PATTERN_SIMPLE_FILE.getFile());
        XmlUtils.addXmlFile((File)TmfXmlTestFiles.DATA_PROVIDER_SIMPLE_FILE.getFile());
        XmlAnalysisModuleSource.notifyModuleChange();
    }

    public void cleanUp() {
        XmlUtils.deleteFiles((Collection)ImmutableList.of((Object)TmfXmlTestFiles.VALID_PATTERN_SIMPLE_FILE.getFile().getName(), (Object)TmfXmlTestFiles.DATA_PROVIDER_SIMPLE_FILE.getFile().getName()));
        XmlAnalysisModuleSource.notifyModuleChange();
    }

    private ITmfTrace getTrace() {
        ITmfTrace trace = XmlUtilsTest.initializeTrace(TEST_TRACE);
        TmfTraceOpenedSignal signal = new TmfTraceOpenedSignal((Object)this, trace, null);
        ((TmfTrace)trace).traceOpened(signal);
        TmfTraceManager.getInstance().traceOpened(signal);
        return trace;
    }

    private static void runModule(ITmfTrace trace) {
        IAnalysisModule module = trace.getAnalysisModule(ANALYSIS_ID);
        Assert.assertNotNull((Object)module);
        module.schedule();
        Assert.assertTrue((boolean)module.waitForCompletion());
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Test
    public void testTwoLevels() throws IOException {
        ITmfTrace trace = this.getTrace();
        Assert.assertNotNull((Object)trace);
        try {
            XmlTimeGraphDataProviderTest.runModule(trace);
            Element viewElement = TmfXmlUtils.getElementInFile((String)TmfXmlTestFiles.DATA_PROVIDER_SIMPLE_FILE.getPath().toOSString(), (String)"timeGraphView", (String)TIME_GRAPH_VIEW_ID);
            Assert.assertNotNull((Object)viewElement);
            @NonNull ITimeGraphDataProvider timeGraphProvider = XmlDataProviderManager.getInstance().getTimeGraphProvider(trace, viewElement);
            Assert.assertNotNull((Object)timeGraphProvider);
            List<String> expectedStrings = Files.readAllLines(Paths.get("test_traces/simple_dataprovider/expectedTimeGraphTree", new String[0]));
            Map<Long, String> tree = XmlTimeGraphDataProviderTest.assertAndGetTree((ITimeGraphDataProvider<TimeGraphEntryModel>)timeGraphProvider, trace, expectedStrings);
            expectedStrings = Files.readAllLines(Paths.get("test_traces/simple_dataprovider/expectedTimeGraphRows", new String[0]));
            XmlTimeGraphDataProviderTest.assertRows((ITimeGraphDataProvider<TimeGraphEntryModel>)timeGraphProvider, tree, expectedStrings);
        }
        finally {
            trace.dispose();
            TmfTraceManager.getInstance().traceClosed(new TmfTraceClosedSignal((Object)this, trace));
        }
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private static void assertRows(ITimeGraphDataProvider<@NonNull TimeGraphEntryModel> provider, Map<Long, String> tree, List<String> expectedStrings) {
        @NonNull TmfModelResponse rowResponse = provider.fetchRowModel(FetchParametersUtils.selectionTimeQueryToMap((SelectionTimeQueryFilter)new SelectionTimeQueryFilter(1L, 20L, 20, tree.keySet())), null);
        Assert.assertNotNull((Object)rowResponse);
        Assert.assertEquals((Object)ITmfResponse.Status.COMPLETED, (Object)rowResponse.getStatus());
        TimeGraphModel timeGraphModel = (TimeGraphModel)rowResponse.getModel();
        Assert.assertNotNull((Object)timeGraphModel);
        @NonNull List rowModel = timeGraphModel.getRows();
        rowModel.sort(Comparator.comparingLong(ITimeGraphRowModel::getEntryID));
        Assert.assertEquals((long)expectedStrings.size(), (long)rowModel.size());
        int i = 0;
        while (i < expectedStrings.size()) {
            String expectedString = expectedStrings.get(i);
            String[] split = expectedString.split(":");
            ITimeGraphRowModel row = (ITimeGraphRowModel)rowModel.get(i);
            Assert.assertEquals((Object)split[0], (Object)tree.get(row.getEntryID()));
            XmlTimeGraphDataProviderTest.assertEqualsStates(split[0], split[1], row.getStates());
            ++i;
        }
    }

    private static void assertEqualsStates(String name, String string, @NonNull List<@NonNull ITimeGraphState> states) {
        String[] stringStates = string.split(",");
        int i = 0;
        while (i < stringStates.length / 4) {
            ITimeGraphState state = states.get(i);
            Assert.assertNotNull((String)("State " + i + " for " + name), (Object)state);
            Assert.assertEquals((String)("Start time of state " + i + " for " + name), (long)Long.parseLong(stringStates[i * 4]), (long)state.getStartTime());
            Assert.assertEquals((String)("Duration of state " + i + " for " + name), (long)Long.parseLong(stringStates[i * 4 + 1]), (long)state.getDuration());
            Assert.assertEquals((String)("Value of state " + i + " for " + name), (long)Long.parseLong(stringStates[i * 4 + 2]), (long)state.getValue());
            Assert.assertEquals((String)("Label of state " + i + " for " + name), (Object)stringStates[i * 4 + 3], (Object)String.valueOf(state.getLabel()));
            ++i;
        }
        Assert.assertEquals((String)"Expected number of states", (long)(stringStates.length / 4), (long)states.size());
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private static Map<Long, String> assertAndGetTree(ITimeGraphDataProvider<@NonNull TimeGraphEntryModel> timeGraphProvider, ITmfTrace trace, List<String> expectedStrings) {
        @NonNull @NonNull TmfModelResponse treeResponse = timeGraphProvider.fetchTree(FetchParametersUtils.timeQueryToMap((TimeQueryFilter)new TimeQueryFilter(0L, Long.MAX_VALUE, 2)), MONITOR);
        Assert.assertNotNull((Object)treeResponse);
        Assert.assertEquals((Object)ITmfResponse.Status.COMPLETED, (Object)treeResponse.getStatus());
        @NonNull TmfTreeModel treeModel = (TmfTreeModel)treeResponse.getModel();
        Assert.assertNotNull((Object)treeModel);
        @NonNull List xmlEntries = treeModel.getEntries();
        Collections.sort(xmlEntries, Comparator.comparingLong(TmfTreeDataModel::getId));
        HashMap<Long, String> map = new HashMap<Long, String>();
        int i = 0;
        while (i < expectedStrings.size()) {
            String expectedString = expectedStrings.get(i);
            Assert.assertTrue((String)("actual entry present at " + i + ": " + expectedString), (xmlEntries.size() > i ? 1 : 0) != 0);
            String[] split = expectedString.split(",");
            TimeGraphEntryModel xmlTgEntry = (TimeGraphEntryModel)xmlEntries.get(i);
            Assert.assertEquals((String)("Checking entry name at " + i), (Object)split[0], (Object)xmlTgEntry.getName());
            Assert.assertEquals((String)("Checking entry start time at " + i), (long)Long.parseLong(split[1]), (long)xmlTgEntry.getStartTime());
            Assert.assertEquals((String)("Checking entry end time at " + i), (long)Long.parseLong(split[2]), (long)xmlTgEntry.getEndTime());
            long parentId = xmlTgEntry.getParentId();
            if (parentId < 0L) {
                Assert.assertEquals((String)("Checking empty parent at " + i), (Object)split[3], (Object)"null");
            } else {
                String parentName = (String)map.get(parentId);
                Assert.assertEquals((String)("Checking parent at " + i), (Object)split[3], (Object)parentName);
            }
            map.put(xmlTgEntry.getId(), xmlTgEntry.getName());
            ++i;
        }
        Assert.assertEquals((String)"Extra actual entries", (long)expectedStrings.size(), (long)xmlEntries.size());
        return map;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Test
    public void testNoParentDisplay() throws IOException {
        ITmfTrace trace = this.getTrace();
        Assert.assertNotNull((Object)trace);
        try {
            XmlTimeGraphDataProviderTest.runModule(trace);
            Element viewElement = TmfXmlUtils.getElementInFile((String)TmfXmlTestFiles.DATA_PROVIDER_SIMPLE_FILE.getPath().toOSString(), (String)"timeGraphView", (String)TIME_GRAPH_VIEW_ID2);
            Assert.assertNotNull((Object)viewElement);
            @NonNull ITimeGraphDataProvider timeGraphProvider = XmlDataProviderManager.getInstance().getTimeGraphProvider(trace, viewElement);
            Assert.assertNotNull((Object)timeGraphProvider);
            List<String> expectedStrings = Files.readAllLines(Paths.get("test_traces/simple_dataprovider/expectedTimeGraphTree", new String[0]));
            Map<Long, String> tree = XmlTimeGraphDataProviderTest.assertAndGetTree((ITimeGraphDataProvider<TimeGraphEntryModel>)timeGraphProvider, trace, expectedStrings);
            expectedStrings = Files.readAllLines(Paths.get("test_traces/simple_dataprovider/expectedTimeGraphRows", new String[0]));
            expectedStrings.remove(0);
            XmlTimeGraphDataProviderTest.assertRows((ITimeGraphDataProvider<TimeGraphEntryModel>)timeGraphProvider, tree, expectedStrings);
        }
        finally {
            trace.dispose();
            TmfTraceManager.getInstance().traceClosed(new TmfTraceClosedSignal((Object)this, trace));
        }
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Test
    public void testFactory() {
        ITmfTrace trace = this.getTrace();
        Assert.assertNotNull((Object)trace);
        try {
            XmlTimeGraphDataProviderTest.runModule(trace);
            Element viewElement = TmfXmlUtils.getElementInFile((String)TmfXmlTestFiles.DATA_PROVIDER_SIMPLE_FILE.getPath().toOSString(), (String)"timeGraphView", (String)TIME_GRAPH_VIEW_ID);
            Assert.assertNotNull((Object)viewElement);
            TmfXmlTimeGraphViewCu tgViewCu = TmfXmlTimeGraphViewCu.compile((AnalysisCompilationData)new AnalysisCompilationData(), (Element)viewElement);
            Assert.assertNotNull((Object)tgViewCu);
            DataDrivenTimeGraphProviderFactory timeGraphFactory = tgViewCu.generate();
            @NonNull ITimeGraphDataProvider provider = timeGraphFactory.create(trace);
            Assert.assertNotNull((Object)provider);
            Assert.assertEquals((Object)"org.eclipse.tracecompass.tmf.analysis.xml.core.output.DataDrivenTimeGraphDataProvider", (Object)provider.getId());
            ITmfAnalysisModuleWithStateSystems module = (ITmfAnalysisModuleWithStateSystems)TmfTraceUtils.getAnalysisModuleOfClass((ITmfTrace)trace, ITmfAnalysisModuleWithStateSystems.class, (String)ANALYSIS_ID);
            Assert.assertNotNull((Object)module);
            @NonNull Iterable stateSystems = module.getStateSystems();
            Assert.assertNotNull((Object)stateSystems);
            provider = DataDrivenTimeGraphProviderFactory.create((ITmfTrace)trace, (List)Objects.requireNonNull(Lists.newArrayList((Iterable)stateSystems)), XmlTimeGraphDataProviderTest.getEntries(new AnalysisCompilationData(), viewElement), XmlTimeGraphDataProviderTest.getvalues(viewElement), (String)ANALYSIS_ID);
            Assert.assertNotNull((Object)provider);
            Assert.assertEquals((Object)ANALYSIS_ID, (Object)provider.getId());
        }
        finally {
            trace.dispose();
            TmfTraceManager.getInstance().traceClosed(new TmfTraceClosedSignal((Object)this, trace));
        }
    }

    private static List<DataDrivenOutputEntry> getEntries(AnalysisCompilationData compilationData, Element viewElement) {
        List entries = TmfXmlUtils.getChildElements((Element)viewElement, (String)"entry");
        ArrayList<TmfXmlOutputEntryCu> entriesCu = new ArrayList<TmfXmlOutputEntryCu>();
        for (Element entry : entries) {
            TmfXmlOutputEntryCu entryCu = TmfXmlOutputEntryCu.compile((AnalysisCompilationData)compilationData, (Element)entry);
            if (entryCu == null) continue;
            entriesCu.add(entryCu);
        }
        return entriesCu.stream().map(TmfXmlOutputEntryCu::generate).collect(Collectors.toList());
    }

    private static List<DataDrivenPresentationState> getvalues(Element viewElement) {
        ArrayList<DataDrivenPresentationState> values = new ArrayList<DataDrivenPresentationState>();
        List childElements = TmfXmlUtils.getChildElements((Element)viewElement, (String)"definedValue");
        for (Element element : childElements) {
            values.add(new DataDrivenPresentationState(element.getAttribute("value"), element.getAttribute("name"), element.getAttribute("color")));
        }
        return values;
    }
}

