/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.integration.swtbot.tests.projectexplorer;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.io.File;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.StringJoiner;
import org.apache.log4j.Appender;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Logger;
import org.apache.log4j.SimpleLayout;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.swtbot.eclipse.finder.SWTWorkbenchBot;
import org.eclipse.swtbot.swt.finder.SWTBot;
import org.eclipse.swtbot.swt.finder.junit.SWTBotJunit4ClassRunner;
import org.eclipse.swtbot.swt.finder.utils.SWTBotPreferences;
import org.eclipse.swtbot.swt.finder.waits.Conditions;
import org.eclipse.swtbot.swt.finder.widgets.AbstractSWTBot;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotShell;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotTree;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotTreeItem;
import org.eclipse.tracecompass.testtraces.ctf.CtfTestTrace;
import org.eclipse.tracecompass.tmf.ctf.core.tests.shared.CtfTmfTestTraceUtils;
import org.eclipse.tracecompass.tmf.ui.swtbot.tests.shared.ConditionHelpers;
import org.eclipse.tracecompass.tmf.ui.swtbot.tests.shared.SWTBotUtils;
import org.eclipse.tracecompass.tmf.ui.tests.shared.WaitUtils;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=SWTBotJunit4ClassRunner.class)
public class ProjectExplorerAnalysisTest {
    private static final @NonNull String EXPERIMENT_NAME = "TestExperiment";
    private static final @NonNull String IRQ_XML_ANALYSIS_NAME = "IRQ Analysis";
    private static final @NonNull String IRQ_XML_ANALYSIS_HT_FILE_NAME = "lttng.analysis.irq.ht";
    private static final @NonNull String FUTEX_XML_ANALYSIS_NAME = "Futex Contention Analysis";
    private static final @NonNull String FUTEX_XML_ANALYSIS_HT_FILE_NAME = "lttng.analysis.futex.ht";
    private static SWTWorkbenchBot fBot;
    private static String fUstTraceFile;
    private static String fKernelTraceFile;
    private static final String TRACE_PROJECT_NAME = "test";
    private static final Logger fLogger;
    private static final Set<AnalysisNode> KERNEL_ANALYSIS_NODES;
    private static final Set<AnalysisNode> UST_ANALYSIS_NODES;
    private static final Set<AnalysisNode> EXPERIMENT_NODES;

    static {
        fLogger = Logger.getRootLogger();
        KERNEL_ANALYSIS_NODES = ImmutableSet.of((Object)new AnalysisNode("Active Thread", true, true), (Object)new AnalysisNode("Context switch", true, true), (Object)new AnalysisNode("CPU usage", true, true), (Object)new AnalysisNode("Counters", true, true), (Object)new AnalysisNode(FUTEX_XML_ANALYSIS_NAME, true, true), (Object)new AnalysisNode("Input/Output", true, true), (Object[])new AnalysisNode[]{new AnalysisNode(IRQ_XML_ANALYSIS_NAME, true, true), new AnalysisNode("Kernel memory usage", true, true), new AnalysisNode("Linux Kernel", true, true), new AnalysisNode("OS Execution Graph", true, true), new AnalysisNode("Statistics", true, true), new AnalysisNode("System Call Latency", true, true)});
        UST_ANALYSIS_NODES = ImmutableSet.of((Object)new AnalysisNode("Counters", true, true), (Object)new AnalysisNode("Debug Info", true, true), (Object)new AnalysisNode("LTTng-UST CallStack", true, true), (Object)new AnalysisNode("Statistics", true, true), (Object)new AnalysisNode("Ust Memory", true, true));
        ImmutableSet.Builder builder = new ImmutableSet.Builder();
        builder.addAll(UST_ANALYSIS_NODES);
        builder.addAll(KERNEL_ANALYSIS_NODES);
        EXPERIMENT_NODES = builder.build();
    }

    @BeforeClass
    public static void init() {
        SWTBotUtils.initialize();
        SWTBotPreferences.TIMEOUT = 20000L;
        SWTBotPreferences.KEYBOARD_LAYOUT = "EN_US";
        fLogger.removeAllAppenders();
        fLogger.addAppender((Appender)new ConsoleAppender((Layout)new SimpleLayout(), "System.out"));
        fBot = new SWTWorkbenchBot();
        SWTBotUtils.closeView((String)"Welcome", (SWTWorkbenchBot)fBot);
        SWTBotUtils.switchToTracingPerspective();
        WaitUtils.waitForJobs();
        SWTBotUtils.createProject((String)TRACE_PROJECT_NAME);
        File kernelTraceFile = new File(CtfTmfTestTraceUtils.getTrace((CtfTestTrace)CtfTestTrace.ARM_64_BIT_HEADER).getPath());
        CtfTmfTestTraceUtils.dispose((CtfTestTrace)CtfTestTrace.ARM_64_BIT_HEADER);
        File ustTraceFile = new File(CtfTmfTestTraceUtils.getTrace((CtfTestTrace)CtfTestTrace.DEBUG_INFO_SYNTH_EXEC).getPath());
        CtfTmfTestTraceUtils.dispose((CtfTestTrace)CtfTestTrace.DEBUG_INFO_SYNTH_EXEC);
        fKernelTraceFile = kernelTraceFile.getName();
        fUstTraceFile = ustTraceFile.getName();
        SWTBotUtils.openTrace((String)TRACE_PROJECT_NAME, (String)kernelTraceFile.getAbsolutePath(), (String)"org.eclipse.linuxtools.lttng2.kernel.tracetype");
        fBot.waitUntil(ConditionHelpers.isEditorOpened((SWTWorkbenchBot)fBot, (String)fKernelTraceFile));
        SWTBotUtils.openTrace((String)TRACE_PROJECT_NAME, (String)ustTraceFile.getAbsolutePath(), (String)"org.eclipse.linuxtools.lttng2.ust.tracetype");
        fBot.waitUntil(ConditionHelpers.isEditorOpened((SWTWorkbenchBot)fBot, (String)fUstTraceFile));
        SWTBotUtils.createExperiment((SWTWorkbenchBot)fBot, (String)TRACE_PROJECT_NAME, (String)EXPERIMENT_NAME);
        SWTBotTreeItem project = SWTBotUtils.selectProject((SWTWorkbenchBot)fBot, (String)TRACE_PROJECT_NAME);
        SWTBotTreeItem tracesFolder = SWTBotUtils.getTraceProjectItem((SWTBot)fBot, (SWTBotTreeItem)project, (String)"Traces");
        tracesFolder.expand();
        SWTBotTreeItem ustTrace = tracesFolder.getNode(fUstTraceFile);
        SWTBotTreeItem kernelTrace = tracesFolder.getNode(fKernelTraceFile);
        SWTBotTreeItem experiment = SWTBotUtils.getTraceProjectItem((SWTBot)fBot, (SWTBotTreeItem)project, (String[])new String[]{"Experiments", EXPERIMENT_NAME});
        ustTrace.dragAndDrop((AbstractSWTBot)experiment);
        kernelTrace.dragAndDrop((AbstractSWTBot)experiment);
        experiment.doubleClick();
    }

    @AfterClass
    public static void tearDown() {
        fBot.closeAllEditors();
        SWTBotUtils.deleteProject((String)TRACE_PROJECT_NAME, (SWTWorkbenchBot)new SWTWorkbenchBot());
        fLogger.removeAllAppenders();
    }

    @After
    public void afterTest() {
        SWTBotUtils.closeSecondaryShells((SWTWorkbenchBot)new SWTWorkbenchBot());
    }

    @Test
    public void testKernelAnalyses() {
        Set<AnalysisNode> actualNodes = ProjectExplorerAnalysisTest.getAnalysisNodes(fBot, fKernelTraceFile, false);
        StringJoiner sj = new StringJoiner(", ", "{", "}");
        actualNodes.forEach(node -> {
            StringJoiner stringJoiner2 = sj.add(((AnalysisNode)node).fTitle);
        });
        Assert.assertTrue((String)sj.toString(), (boolean)actualNodes.containsAll(KERNEL_ANALYSIS_NODES));
        if (!KERNEL_ANALYSIS_NODES.containsAll(actualNodes)) {
            Sets.SetView diff = Sets.difference(KERNEL_ANALYSIS_NODES, actualNodes);
            diff.forEach(elem -> System.err.println("New untested analysis : " + elem));
        }
    }

    @Test
    public void testUstAnalyses() {
        Set<AnalysisNode> actualNodes = ProjectExplorerAnalysisTest.getAnalysisNodes(fBot, fUstTraceFile, false);
        StringJoiner sj = new StringJoiner(", ", "{", "}");
        actualNodes.forEach(node -> {
            StringJoiner stringJoiner2 = sj.add(((AnalysisNode)node).fTitle);
        });
        Assert.assertTrue((String)sj.toString(), (boolean)actualNodes.containsAll(UST_ANALYSIS_NODES));
        if (!UST_ANALYSIS_NODES.containsAll(actualNodes)) {
            Sets.SetView diff = Sets.difference(UST_ANALYSIS_NODES, actualNodes);
            diff.forEach(elem -> System.err.println("New untested analysis : " + elem));
        }
    }

    @Test
    public void testExperimentAnalyses() {
        Set<AnalysisNode> actualNodes = ProjectExplorerAnalysisTest.getAnalysisNodes(fBot, EXPERIMENT_NAME, true);
        StringJoiner sj = new StringJoiner(", ", "{", "}");
        actualNodes.forEach(node -> {
            StringJoiner stringJoiner2 = sj.add(((AnalysisNode)node).fTitle);
        });
        Assert.assertTrue((String)sj.toString(), (boolean)actualNodes.containsAll(EXPERIMENT_NODES));
        if (!EXPERIMENT_NODES.containsAll(actualNodes)) {
            Sets.SetView diff = Sets.difference(EXPERIMENT_NODES, actualNodes);
            diff.forEach(elem -> System.err.println("New untested analysis : " + elem));
        }
    }

    @Test
    public void testAnalysisRun() {
        SWTBotTreeItem traceNode = ProjectExplorerAnalysisTest.getExpandedTraceNode(fBot, fKernelTraceFile, false);
        SWTBotTreeItem viewNode = traceNode.getNode("Views");
        viewNode.expand();
        boolean supplExists = ProjectExplorerAnalysisTest.supplementaryFileExists(traceNode, IRQ_XML_ANALYSIS_HT_FILE_NAME);
        Assert.assertFalse((boolean)supplExists);
        SWTBotTreeItem irqAnalysisNode = viewNode.getNode(IRQ_XML_ANALYSIS_NAME);
        irqAnalysisNode.contextMenu().menu(new String[]{"Open"}).click();
        supplExists = ProjectExplorerAnalysisTest.supplementaryFileExists(traceNode, IRQ_XML_ANALYSIS_HT_FILE_NAME);
        Assert.assertTrue((boolean)supplExists);
        supplExists = ProjectExplorerAnalysisTest.supplementaryFileExists(traceNode, FUTEX_XML_ANALYSIS_HT_FILE_NAME);
        Assert.assertFalse((boolean)supplExists);
        SWTBotTreeItem futexAnalysisNode = viewNode.getNode(FUTEX_XML_ANALYSIS_NAME);
        futexAnalysisNode.doubleClick();
        supplExists = ProjectExplorerAnalysisTest.supplementaryFileExists(traceNode, FUTEX_XML_ANALYSIS_HT_FILE_NAME);
        Assert.assertTrue((boolean)supplExists);
    }

    private static Set<AnalysisNode> getAnalysisNodes(SWTWorkbenchBot bot, String name, boolean isExperiment) {
        SWTBotTreeItem traceNode = ProjectExplorerAnalysisTest.getExpandedTraceNode(bot, name, isExperiment);
        SWTBotTreeItem viewNode = traceNode.getNode("Views");
        viewNode.expand();
        SWTBotTreeItem[] analysisNodes = viewNode.getItems();
        Assert.assertNotNull((Object)analysisNodes);
        int length = analysisNodes.length;
        HashSet<AnalysisNode> actualNodes = new HashSet<AnalysisNode>();
        int i = 0;
        while (i < length) {
            SWTBotTreeItem analysisNode = analysisNodes[i];
            actualNodes.add(new AnalysisNode(analysisNode.getText(), analysisNode.isEnabled(), analysisNode.isVisible()));
            ++i;
        }
        return actualNodes;
    }

    private static SWTBotTreeItem getExpandedTraceNode(SWTWorkbenchBot bot, String name, boolean isExperiment) {
        SWTBotTreeItem traceNode;
        SWTBotTreeItem project = SWTBotUtils.selectProject((SWTWorkbenchBot)fBot, (String)TRACE_PROJECT_NAME);
        if (isExperiment) {
            SWTBotTreeItem tracesFolderItem = SWTBotUtils.getTraceProjectItem((SWTBot)fBot, (SWTBotTreeItem)project, (String)"Experiments");
            tracesFolderItem.select();
            tracesFolderItem.expand();
            traceNode = SWTBotUtils.getTraceProjectItem((SWTBot)fBot, (SWTBotTreeItem)tracesFolderItem, (String)name);
        } else {
            SWTBotTreeItem tracesFolderItem = SWTBotUtils.selectTracesFolder((SWTWorkbenchBot)bot, (String)TRACE_PROJECT_NAME);
            tracesFolderItem.expand();
            traceNode = SWTBotUtils.getTraceProjectItem((SWTBot)fBot, (SWTBotTreeItem)tracesFolderItem, (String)name);
        }
        traceNode.expand();
        return traceNode;
    }

    private static boolean supplementaryFileExists(SWTBotTreeItem traceNode, String filename) {
        WaitUtils.waitForJobs();
        try {
            ResourcesPlugin.getWorkspace().getRoot().getProject(TRACE_PROJECT_NAME).refreshLocal(2, null);
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        WaitUtils.waitForJobs();
        traceNode.contextMenu().menu(new String[]{"Delete Supplementary Files..."}).click();
        SWTBotShell shell = fBot.shell("Delete Resources");
        SWTBot bot = shell.bot();
        SWTBotTree tree = bot.tree();
        SWTBotTreeItem traceSupplNode = SWTBotUtils.getTreeItem((SWTBot)bot, (SWTBotTree)tree, (String[])new String[]{traceNode.getText()});
        SWTBotTreeItem[] supplFileNodes = traceSupplNode.getItems();
        boolean supplFound = false;
        SWTBotTreeItem[] sWTBotTreeItemArray = supplFileNodes;
        int n = supplFileNodes.length;
        int n2 = 0;
        while (n2 < n) {
            SWTBotTreeItem swtBotTreeItem = sWTBotTreeItemArray[n2];
            if (swtBotTreeItem.getText().equals(filename)) {
                supplFound = true;
                break;
            }
            ++n2;
        }
        bot.button("Cancel").click();
        fBot.waitUntil(Conditions.shellCloses((SWTBotShell)shell));
        return supplFound;
    }

    private static final class AnalysisNode {
        private final String fTitle;
        private final boolean fEnabled;
        private final boolean fVisible;

        public AnalysisNode(String title, boolean enabled, boolean visible) {
            this.fTitle = title;
            this.fEnabled = enabled;
            this.fVisible = visible;
        }

        public int hashCode() {
            return Objects.hash(this.fTitle, this.fEnabled, this.fVisible);
        }

        public boolean equals(Object obj) {
            if (obj instanceof AnalysisNode) {
                AnalysisNode analysisNode = (AnalysisNode)obj;
                return analysisNode.fEnabled == this.fEnabled && analysisNode.fVisible == this.fVisible && Objects.equals(analysisNode.fTitle, this.fTitle);
            }
            return false;
        }

        public String toString() {
            return "new AnalysisNode( \"" + this.fTitle + "\", " + this.fEnabled + " , " + this.fVisible + ")";
        }
    }
}

